/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.gpkiapi.crypto;

import com.gpki.gpkiapi.crypto.Algorithm;
import com.gpki.gpkiapi.crypto.Key;
import com.gpki.gpkiapi.crypto.PrivateKey;
import com.gpki.gpkiapi.crypto.SecretKey;
import com.gpki.gpkiapi.exception.GpkiApiException;
import com.gpki.gpkiapi_jni;

public class Cipher {
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    private static final int PAD_NONE = 1;
    private static final int PAD_PKCS5 = 2;
    private Key keySpec = null;
    private int algCode = 0;
    private int mode = 0;
    private static int padType = 0;
    private byte[] baReturnArray = null;
    private String errBuff = "";
    private gpkiapi_jni gpkiapi = new gpkiapi_jni();
    private int option = gpkiapi_jni.API_OPT_RSA_ENC_V20;

    protected Cipher() {
    }

    public static final Cipher getInstance(String string) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The algorithm is empty. You must input a value for it.");
        }
        Cipher cipher = new Cipher();
        String string2 = "";
        int n = string.length();
        if (n >= 4 && !string.equals("RSA")) {
            int n2 = 0;
            n2 = n;
            while (n2 > 0) {
                char c = string.charAt(n2 - 1);
                if (c == '/') break;
                --n2;
            }
            String string3 = string.substring(n2);
            if (string3.equals("NONE")) {
                padType = 1;
                string2 = string.substring(0, n2 - 1);
            } else if (string3.equals("PKCS5")) {
                padType = 2;
                string2 = string.substring(0, n2 - 1);
            } else {
                padType = 2;
                string2 = string;
            }
        } else {
            string2 = string;
        }
        cipher.algCode = Algorithm.getCipherAlg(string2);
        if (cipher.algCode == 0) {
            throw new GpkiApiException("Unknown algorithm. (input :" + string + ")");
        }
        if (string.toUpperCase() == "RSA/V1.5") {
            cipher.option = gpkiapi_jni.API_OPT_RSA_ENC_V15;
        }
        return cipher;
    }

    public final void init(int n, Key key) throws GpkiApiException {
        if (key == null) {
            throw new GpkiApiException("The key is empty. You must input a value for it.");
        }
        if (n != 1 && n != 2) {
            throw new GpkiApiException("The given opmode is unknown mode.");
        }
        this.mode = n;
        if (!Algorithm.isSame(key.getKeyAlg(), this.algCode)) {
            throw new GpkiApiException("The given key is inappropriate for initializing this cipher");
        }
        if (key.getKey() == null || key.getKey().length == 0) {
            throw new GpkiApiException("The key is empty.");
        }
        if (key instanceof SecretKey && (((SecretKey)key).getIv() == null || ((SecretKey)key).getIv().length == 0)) {
            throw new GpkiApiException("The iv is empty.");
        }
        this.keySpec = key;
    }

    public final byte[] doFinal(byte[] byArray) throws GpkiApiException {
        if (byArray == null) {
            throw new GpkiApiException("The input is null. You must input a value for it.");
        }
        int n = 0;
        if (this.keySpec instanceof SecretKey) {
            n = this.mode == 1 ? this._encrypt(Algorithm.code2id(this.algCode), this.keySpec.getKey(), ((SecretKey)this.keySpec).getIv(), padType, byArray) : this._decrypt(Algorithm.code2id(this.algCode), this.keySpec.getKey(), ((SecretKey)this.keySpec).getIv(), padType, byArray);
            if (n > 0) {
                throw new GpkiApiException(this.errBuff);
            }
        } else if (this.keySpec instanceof PrivateKey) {
            n = this.mode == 1 ? this.gpkiapi.CRYPT_AsymEncrypt(gpkiapi_jni.KEY_TYPE_PRIVATE, this.keySpec.getKey(), byArray) : this.gpkiapi.CRYPT_AsymDecrypt(gpkiapi_jni.KEY_TYPE_PRIVATE, this.keySpec.getKey(), byArray);
            if (n > 0) {
                throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
            }
            this.baReturnArray = this.gpkiapi.baReturnArray;
        } else {
            n = this.mode == 1 ? this._encrypt(this.keySpec.getKey(), byArray, this.option) : this._decrypt(this.keySpec.getKey(), byArray, this.option);
            if (n > 0) {
                throw new GpkiApiException(this.errBuff);
            }
        }
        return this.baReturnArray;
    }

    public final void doFinal_File(String string, String string2) throws GpkiApiException {
        int n = 0;
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The inputFilePath is empty. You must input a value for it.");
        }
        if (string2 == null || string2.length() == 0) {
            throw new GpkiApiException("The outputFilePath is empty. You must input a value for it.");
        }
        if (this.keySpec instanceof SecretKey) {
            n = this.gpkiapi.CRYPT_SetKeyAndIV(Algorithm.code2id(this.algCode), this.keySpec.getKey(), ((SecretKey)this.keySpec).getIv());
            if (n > 0) {
                throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
            }
            n = this.mode == 1 ? this._encrypt_File(Algorithm.code2id(this.algCode), this.keySpec.getKey(), ((SecretKey)this.keySpec).getIv(), padType, string, string2) : this._decrypt_File(Algorithm.code2id(this.algCode), this.keySpec.getKey(), ((SecretKey)this.keySpec).getIv(), padType, string, string2);
            if (n > 0) {
                throw new GpkiApiException(this.errBuff);
            }
        }
    }

    private native int _encrypt(byte[] var1, byte[] var2, int var3);

    private native int _decrypt(byte[] var1, byte[] var2, int var3);

    private native int _encrypt(int var1, byte[] var2, byte[] var3, int var4, byte[] var5);

    private native int _decrypt(int var1, byte[] var2, byte[] var3, int var4, byte[] var5);

    private native int _encrypt_File(int var1, byte[] var2, byte[] var3, int var4, String var5, String var6);

    private native int _decrypt_File(int var1, byte[] var2, byte[] var3, int var4, String var5, String var6);
}

