/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.gpkiapi.ocsp;

import com.gpki.gpkiapi.cert.X509Certificate;
import com.gpki.gpkiapi.crypto.PrivateKey;
import com.gpki.gpkiapi.exception.GpkiApiException;
import com.gpki.gpkiapi_jni;

public class OCSPRequest {
    private String errBuff = "";
    private byte[] myCert = null;
    private byte[] myPriKey = null;
    private byte[] reqMsg = null;
    private byte[] nonce = null;
    private gpkiapi_jni gpkiapi = new gpkiapi_jni();

    public void setMyCert(X509Certificate x509Certificate, PrivateKey privateKey) throws GpkiApiException {
        if (x509Certificate == null) {
            throw new GpkiApiException("The myCert is empty. You must input a value for it.");
        }
        if (privateKey == null) {
            throw new GpkiApiException("The myPriKey is empty. You must input a value for it.");
        }
        this.myCert = x509Certificate.getCert();
        this.myPriKey = privateKey.getKey();
    }

    public byte[] generateReqMsg(X509Certificate x509Certificate) throws GpkiApiException {
        if (x509Certificate == null) {
            throw new GpkiApiException("The cert is empty. You must input a value for it.");
        }
        if (this._generateReqMsg(x509Certificate.getCert(), this.myCert, this.myPriKey) > 0) {
            throw new GpkiApiException(this.errBuff);
        }
        return this.reqMsg;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    private native int _generateReqMsg(byte[] var1, byte[] var2, byte[] var3);
}

