/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.gpkiapi.storage;

import com.gpki.gpkiapi.cert.X509Certificate;
import com.gpki.gpkiapi.crypto.PrivateKey;
import com.gpki.gpkiapi.exception.GpkiApiException;
import com.gpki.gpkiapi.pkcs.Pkcs5;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.PrintWriter;

public class Disk {
    protected Disk() {
    }

    public static byte[] read(String string) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The path is empty. You must input a value for it.");
        }
        byte[] byArray = null;
        try {
            File file = new File(string);
            byArray = new byte[(int)file.length()];
            FileInputStream fileInputStream = new FileInputStream(string);
            fileInputStream.read(byArray);
            fileInputStream.close();
        }
        catch (Exception exception) {
            throw new GpkiApiException(exception.getMessage());
        }
        return byArray;
    }

    public static void write(String string, byte[] byArray) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The path is empty. You must input a value for it.");
        }
        if (byArray == null || byArray.length == 0) {
            throw new GpkiApiException("The data is empty. You must input a value for it.");
        }
        try {
            Object object;
            int n = string.lastIndexOf("/");
            if (n == -1) {
                n = string.lastIndexOf("\\");
            }
            if (n != -1) {
                object = string.substring(0, n);
                File file = new File((String)object);
                if (((String)object).compareTo("./") != 0 && string.compareTo(".\\") != 0 && !file.exists() && !file.mkdirs()) {
                    throw new GpkiApiException("The directory does not created.");
                }
            }
            object = new FileOutputStream(string);
            ((FileOutputStream)object).write(byArray);
            ((FileOutputStream)object).close();
        }
        catch (Exception exception) {
            throw new GpkiApiException(exception.getMessage());
        }
    }

    public static void write(String string, String string2, boolean bl) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The path is empty. You must input a value for it.");
        }
        if (string2 == null || string2.length() == 0) {
            throw new GpkiApiException("The data is empty. You must input a value for it.");
        }
        try {
            FileWriter fileWriter = new FileWriter(string, bl);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            printWriter.println(string2);
            printWriter.close();
            fileWriter.close();
        }
        catch (Exception exception) {
            throw new GpkiApiException(exception.getMessage());
        }
    }

    public static X509Certificate readCert(String string) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The path is empty. You must input a value for it.");
        }
        X509Certificate x509Certificate = new X509Certificate(Disk.read(string));
        return x509Certificate;
    }

    public static void writeCert(String string, X509Certificate x509Certificate) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The path is empty. You must input a value for it.");
        }
        if (x509Certificate == null) {
            throw new GpkiApiException("The cert is empty. You must input a value for it.");
        }
        Disk.write(string, x509Certificate.getCert());
    }

    public static PrivateKey readPriKey(String string, String string2) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The path is empty. You must input a value for it.");
        }
        if (string2 == null || string2.length() == 0) {
            throw new GpkiApiException("The passwd is empty. You must input a value for it.");
        }
        byte[] byArray = Disk.read(string);
        Pkcs5 pkcs5 = new Pkcs5();
        PrivateKey privateKey = pkcs5.decrypt(byArray, string2);
        return privateKey;
    }

    public static void writePriKey(String string, String string2, String string3, PrivateKey privateKey) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The path is empty. You must input a value for it.");
        }
        if (string2 == null || string2.length() == 0) {
            throw new GpkiApiException("The passwd is empty. You must input a value for it.");
        }
        if (string3 == null || string3.length() == 0) {
            throw new GpkiApiException("The algorithm is empty. You must input a value for it.");
        }
        if (privateKey == null) {
            throw new GpkiApiException("The priKey is empty. You must input a value for it.");
        }
        byte[] byArray = null;
        Pkcs5 pkcs5 = new Pkcs5();
        byArray = pkcs5.encrypt(privateKey, string2, string3);
        Disk.write(string, byArray);
    }
}

