/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport.http;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.spring.XFireConfigLoader;
import org.codehaus.xfire.transport.http.XFireServlet;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class XFireConfigurableServlet
extends XFireServlet {
    private static Log log = LogFactory.getLog((Class)XFireConfigurableServlet.class);
    private static final String CONFIG_FILE = "META-INF/xfire/services.xml";
    private static final String PARAM_CONFIG = "config";
    private String configPath;

    private String getConfigPath() {
        if (this.configPath == null || this.configPath.length() == 0) {
            return CONFIG_FILE;
        }
        return this.configPath;
    }

    public XFire createXFire() throws ServletException {
        XFire xfire;
        this.configPath = this.getInitParameter(PARAM_CONFIG);
        try {
            xfire = this.loadConfig(this.getConfigPath());
        }
        catch (XFireException e) {
            throw new ServletException((Throwable)e);
        }
        if (xfire == null || xfire.getServiceRegistry() == null || xfire.getServiceRegistry().getServices() == null || xfire.getServiceRegistry().getServices().size() == 0) {
            xfire = super.createXFire();
        }
        return xfire;
    }

    public XFire loadConfig(String configPath) throws XFireException {
        XFireConfigLoader loader = new XFireConfigLoader();
        loader.setBasedir(this.getWebappBase());
        log.debug((Object)("Loading configuration files relative to " + loader.getBasedir().getAbsolutePath()));
        ServletContext servletCtx = this.getServletContext();
        ApplicationContext parent = (ApplicationContext)servletCtx.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        ApplicationContext newCtx = loader.loadContext(configPath, parent);
        if (servletCtx.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE) == null) {
            servletCtx.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)newCtx);
        }
        return (XFire)newCtx.getBean("xfire");
    }
}

