/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipseCleanMojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

public class RadCleanMojo
extends EclipseCleanMojo {
    private MavenProject project;

    protected void cleanExtras() throws MojoExecutionException {
        this.delete(new File(this.getBasedir(), ".j2ee"));
        this.delete(new File(this.getBasedir(), ".websettings"));
        this.delete(new File(this.getBasedir(), ".website-config"));
        this.handleLibs();
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    private void handleEarLibs() throws MojoExecutionException {
        File targetDir = this.project.getBasedir();
        this.deleteJarArtifactsInDirectory(targetDir);
    }

    private void handleLibs() throws MojoExecutionException {
        String packaging = this.project.getPackaging();
        if ("ear".equals(packaging)) {
            this.handleEarLibs();
        } else if ("war".equals(packaging)) {
            this.handleWarLibs();
        }
    }

    private void handleWarLibs() throws MojoExecutionException {
        String srcMainWebappWebInfLibDirname = this.project.getBasedir().getAbsolutePath() + File.separatorChar + "src" + File.separatorChar + "main" + File.separatorChar + "webapp" + File.separatorChar + "WEB-INF" + File.separatorChar + "lib";
        File srcMainWebappWebInfLibDir = new File(srcMainWebappWebInfLibDirname);
        srcMainWebappWebInfLibDir.mkdirs();
        this.deleteJarArtifactsInDirectory(srcMainWebappWebInfLibDir);
    }

    protected void deleteJarArtifactsInDirectory(File directory) throws MojoExecutionException {
        String[] oldFiles = FileUtils.getFilesFromExtension((String)directory.getAbsolutePath(), (String[])new String[]{"jar"});
        for (int index = 0; index < oldFiles.length; ++index) {
            File f = new File(oldFiles[index]);
            this.delete(f);
        }
    }
}

