/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.osgiplugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.maven.plugin.eclipse.osgiplugin.AbstractEclipseOsgiPlugin;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;

public class ExplodedPlugin
extends AbstractEclipseOsgiPlugin {
    private File tempJarFile;

    public ExplodedPlugin(File folder) {
        super(folder);
    }

    private File getManifestFile() {
        return new File(this.getFile(), "META-INF/MANIFEST.MF");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Manifest getManifest() throws IOException {
        if (!this.getManifestFile().exists()) {
            return null;
        }
        FileInputStream is = new FileInputStream(this.getManifestFile());
        try {
            Manifest manifest = new Manifest(is);
            return manifest;
        }
        finally {
            is.close();
        }
    }

    public boolean hasManifest() {
        return this.getManifestFile().exists();
    }

    public File getJarFile() throws IOException {
        if (this.tempJarFile == null) {
            try {
                this.tempJarFile = File.createTempFile("mvn-eclipse", null);
                this.tempJarFile.deleteOnExit();
                JarArchiver jarArchiver = new JarArchiver();
                jarArchiver.setDestFile(this.tempJarFile);
                jarArchiver.addDirectory(this.getFile());
                jarArchiver.setManifest(this.getManifestFile());
                jarArchiver.createArchive();
                return this.tempJarFile;
            }
            catch (ArchiverException e) {
                throw new IOException(e.getMessage());
            }
        }
        return this.tempJarFile;
    }

    public JarFile getJar() throws IOException {
        return new JarFile(this.getJarFile(), false);
    }

    public Properties getPomProperties() {
        Properties properties = new Properties();
        properties.setProperty("eclipse.unpack", Boolean.TRUE.toString());
        return properties;
    }
}

