/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ide;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.plugin.ide.JeeUtils;
import org.apache.maven.plugin.ide.Messages;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class IdeUtils {
    public static final String JAVA_1_1 = "1.1";
    public static final String JAVA_1_2 = "1.2";
    public static final String JAVA_1_3 = "1.3";
    public static final String JAVA_1_4 = "1.4";
    public static final String JAVA_5_0 = "5.0";
    public static final String JAVA_6_0 = "6.0";
    public static final String PROJECT_NAME_DEFAULT_TEMPLATE = "[artifactId]";
    public static final String PROJECT_NAME_WITH_VERSION_TEMPLATE = "[artifactId]-[version]";
    public static final String PROJECT_NAME_WITH_GROUP_TEMPLATE = "[groupId].[artifactId]";
    public static final String PROJECT_NAME_WITH_GROUP_AND_VERSION_TEMPLATE = "[groupId].[artifactId]-[version]";
    private static final String ARTIFACT_MAVEN_COMPILER_PLUGIN = "maven-compiler-plugin";
    private static final String PROPERTY_SOURCE = "source";
    private static final String PROPERTY_TARGET = "target";

    public static String getCanonicalPath(File file) throws MojoExecutionException {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new MojoExecutionException(Messages.getString("cantcanonicalize", file.getAbsolutePath()), (Exception)e);
        }
    }

    public static String getCompilerPluginSetting(MavenProject project, String optionName) {
        String value = IdeUtils.findCompilerPluginSettingInPlugins(project.getModel().getBuild().getPlugins(), optionName);
        if (value == null && project.getModel().getBuild().getPluginManagement() != null) {
            value = IdeUtils.findCompilerPluginSettingInPlugins(project.getModel().getBuild().getPluginManagement().getPlugins(), optionName);
        }
        return value;
    }

    public static String getCompilerSourceVersion(MavenProject project) {
        return IdeUtils.getCompilerPluginSetting(project, PROPERTY_SOURCE);
    }

    public static String getCompilerTargetVersion(MavenProject project) {
        return IdeUtils.getCompilerPluginSetting(project, PROPERTY_TARGET);
    }

    public static String getDependencyVersion(String[] artifactIds, List dependencies, int len) {
        for (int j = 0; j < artifactIds.length; ++j) {
            String id = artifactIds[j];
            Iterator itr = dependencies.iterator();
            while (itr.hasNext()) {
                Dependency dependency = (Dependency)itr.next();
                if (!id.equals(dependency.getArtifactId())) continue;
                return StringUtils.substring((String)dependency.getVersion(), (int)0, (int)len);
            }
        }
        return null;
    }

    public static String getPluginSetting(MavenProject project, String artifactId, String optionName, String defaultValue) {
        Iterator it = project.getModel().getBuild().getPlugins().iterator();
        while (it.hasNext()) {
            Xpp3Dom o;
            Plugin plugin = (Plugin)it.next();
            if (!plugin.getArtifactId().equals(artifactId) || (o = (Xpp3Dom)plugin.getConfiguration()) == null || o.getChild(optionName) == null) continue;
            return o.getChild(optionName).getValue();
        }
        return defaultValue;
    }

    public static String getProjectName(String template, IdeDependency dep) {
        return IdeUtils.getProjectName(template, dep.getGroupId(), dep.getArtifactId(), dep.getVersion());
    }

    public static String getProjectName(String template, MavenProject project) {
        return IdeUtils.getProjectName(template, project.getGroupId(), project.getArtifactId(), project.getVersion());
    }

    public static String getProjectName(IdeDependency dep, boolean addVersionToProjectName) {
        return IdeUtils.getProjectName(addVersionToProjectName ? PROJECT_NAME_WITH_VERSION_TEMPLATE : PROJECT_NAME_DEFAULT_TEMPLATE, dep);
    }

    public static String getProjectName(MavenProject project, boolean addVersionToProjectName) {
        return IdeUtils.getProjectName(addVersionToProjectName ? PROJECT_NAME_WITH_VERSION_TEMPLATE : PROJECT_NAME_DEFAULT_TEMPLATE, project);
    }

    public static Artifact resolveArtifactWithClassifier(String groupId, String artifactId, String version, String classifier, ArtifactRepository localRepository, ArtifactResolver artifactResolver, ArtifactFactory artifactFactory, List remoteRepos, Log log) {
        String type = classifier;
        if ("sources".equals(type) || "test-sources".equals(type)) {
            type = "java-source";
        }
        Artifact resolvedArtifact = artifactFactory.createArtifactWithClassifier(groupId, artifactId, version, type, classifier);
        try {
            artifactResolver.resolve(resolvedArtifact, remoteRepos, localRepository);
        }
        catch (ArtifactNotFoundException e) {
        }
        catch (ArtifactResolutionException e) {
            String message = Messages.getString("errorresolving", new Object[]{classifier, resolvedArtifact.getId(), e.getMessage()});
            log.warn((CharSequence)message);
        }
        return resolvedArtifact;
    }

    public static String resolveEjbVersion(MavenProject project) {
        return JeeUtils.resolveEjbVersion(project);
    }

    public static String resolveJ2eeVersion(MavenProject project) {
        return JeeUtils.resolveJeeVersion(project);
    }

    public static String resolveJavaVersion(MavenProject project) {
        String version = IdeUtils.getCompilerTargetVersion(project);
        if (version == null) {
            version = IdeUtils.getCompilerSourceVersion(project);
        }
        if ("1.5".equals(version)) {
            version = JAVA_5_0;
        } else if ("1.6".equals(version)) {
            version = JAVA_6_0;
        } else if (version != null && version.length() == 1) {
            version = version + ".0";
        }
        return version == null ? JAVA_1_4 : version;
    }

    public static String resolveServletVersion(MavenProject project) {
        return JeeUtils.resolveServletVersion(project);
    }

    public static String toRelativeAndFixSeparator(File basedir, File fileToAdd, boolean replaceSlashesWithDashes) throws MojoExecutionException {
        String basedirpath = IdeUtils.getCanonicalPath(basedir);
        String absolutePath = IdeUtils.getCanonicalPath(fileToAdd);
        String relative = absolutePath.equals(basedirpath) ? "." : (absolutePath.startsWith(basedirpath) ? absolutePath.substring(basedirpath.length() + 1) : absolutePath);
        relative = StringUtils.replace((String)relative, (char)'\\', (char)'/');
        if (replaceSlashesWithDashes) {
            relative = StringUtils.replace((String)relative, (char)'/', (char)'-');
            relative = StringUtils.replace((String)relative, (char)':', (char)'-');
        }
        return relative;
    }

    private static String findCompilerPluginSettingInPlugins(List plugins, String optionName) {
        String value = null;
        Iterator it = plugins.iterator();
        while (it.hasNext()) {
            Plugin plugin = (Plugin)it.next();
            if (!plugin.getArtifactId().equals(ARTIFACT_MAVEN_COMPILER_PLUGIN)) continue;
            Xpp3Dom o = (Xpp3Dom)plugin.getConfiguration();
            if (o != null && o.getChild(optionName) != null) {
                value = o.getChild(optionName).getValue();
            }
            List executions = plugin.getExecutions();
            Iterator iter = executions.iterator();
            while (iter.hasNext()) {
                PluginExecution execution = (PluginExecution)iter.next();
                o = (Xpp3Dom)execution.getConfiguration();
                if (o == null || o.getChild(optionName) == null) continue;
                value = o.getChild(optionName).getValue();
            }
        }
        return value;
    }

    private static String getProjectName(String template, String groupId, String artifactId, String version) {
        String s = template;
        s = s.replaceAll("\\[groupId\\]", groupId);
        s = s.replaceAll("\\[artifactId\\]", artifactId);
        s = s.replaceAll("\\[version\\]", version);
        return s;
    }

    private IdeUtils() {
    }
}

