/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee.statistics;

import javax.management.j2ee.statistics.RangeStatistic;
import jeus.management.j2ee.statistics.StatisticImpl;
import jeus.util.StringUtil;

public class RangeStatisticImpl
extends StatisticImpl
implements RangeStatistic {
    protected long high;
    protected long low;
    protected long current;
    boolean isStarted;

    public RangeStatisticImpl(String pName, String pUnit, String pDesc) {
        super(pName, pUnit, pDesc);
    }

    public RangeStatisticImpl(String sName, String pName, String pUnit, String pDesc) {
        super(sName, pName, pUnit, pDesc);
    }

    public synchronized long getHighWaterMark() {
        return this.high;
    }

    public synchronized long getLowWaterMark() {
        return this.low;
    }

    public synchronized long getCurrent() {
        return this.current;
    }

    private void addData() {
        if (this.current > this.high) {
            this.high = this.current;
        } else if (this.current < this.low) {
            this.low = this.current;
        }
    }

    public synchronized void increase() {
        ++this.current;
        this.sampled();
        if (this.isStarted) {
            this.addData();
        } else {
            this.high = this.current;
        }
    }

    public synchronized void decrease() {
        --this.current;
        this.sampled();
        if (this.isStarted) {
            this.addData();
        } else {
            this.low = this.current;
            this.isStarted = true;
        }
    }

    public synchronized void set(long value) {
        this.sampled();
        this.current = value;
        if (this.isStarted) {
            this.addData();
        } else {
            this.low = this.high = value;
            this.isStarted = true;
        }
    }

    public String getShortStats() {
        return "R:" + this.high + ":" + this.current + ":" + this.low;
    }

    public String getStatisticName() {
        return "RangeStatistic";
    }

    public String toString() {
        String stat = super.toString();
        StringBuffer buffer = new StringBuffer(stat).append(StringUtil.lineSeparator);
        buffer.append('\t').append("High watermark : ").append(this.high).append(StringUtil.lineSeparator);
        buffer.append('\t').append("Current : ").append(this.current).append(StringUtil.lineSeparator);
        buffer.append('\t').append("Low watermark : ").append(this.low).append(StringUtil.lineSeparator);
        return buffer.toString();
    }
}

