/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.oscache.hibernate;

import com.opensymphony.oscache.base.Config;
import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import com.opensymphony.oscache.hibernate.OSCache;
import com.opensymphony.oscache.util.StringUtil;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.hibernate.cache.Timestamper;
import org.hibernate.util.StringHelper;

public class OSCacheProvider
implements CacheProvider {
    private static final Log LOG = LogFactory.getLog((Class)OSCacheProvider.class);
    public static final String OSCACHE_CONFIGURATION_RESOURCE_NAME = "com.opensymphony.oscache.configurationResourceName";
    public static final String OSCACHE_REFRESH_PERIOD = "refresh.period";
    public static final String OSCACHE_CRON = "cron";
    private static GeneralCacheAdministrator cache;

    public Cache buildCache(String region, Properties properties) throws CacheException {
        if (cache != null) {
            LOG.debug((Object)"building cache in OSCacheProvider...");
            String refreshPeriodString = cache.getProperty(StringHelper.qualify((String)region, (String)OSCACHE_REFRESH_PERIOD));
            int refreshPeriod = refreshPeriodString == null ? -1 : Integer.parseInt(refreshPeriodString.trim());
            String cron = cache.getProperty(StringHelper.qualify((String)region, (String)OSCACHE_CRON));
            return new OSCache(cache, refreshPeriod, cron, region);
        }
        throw new CacheException("OSCache was stopped or wasn't configured via method start.");
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return false;
    }

    public void stop() {
        if (cache != null) {
            LOG.debug((Object)"Stopping OSCacheProvider...");
            cache.destroy();
            cache = null;
            LOG.debug((Object)"OSCacheProvider stopped.");
        }
    }

    public void start(Properties hibernateSystemProperties) throws CacheException {
        if (cache == null) {
            LOG.debug((Object)"Starting OSCacheProvider...");
            String configResourceName = null;
            if (hibernateSystemProperties != null) {
                configResourceName = (String)hibernateSystemProperties.get(OSCACHE_CONFIGURATION_RESOURCE_NAME);
            }
            if (StringUtil.isEmpty(configResourceName)) {
                cache = new GeneralCacheAdministrator();
            } else {
                Properties propertiesOSCache = Config.loadProperties(configResourceName, this.getClass().getName());
                cache = new GeneralCacheAdministrator(propertiesOSCache);
            }
            LOG.debug((Object)"OSCacheProvider started.");
        } else {
            LOG.warn((Object)"Tried to restart OSCacheProvider, which is already running.");
        }
    }
}

