/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.surefire.report;

import java.io.File;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.maven.plugins.surefire.report.ReportTestCase;
import org.apache.maven.plugins.surefire.report.ReportTestSuite;
import org.apache.maven.plugins.surefire.report.SurefireReportParser;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;

public class SurefireReportGenerator {
    private SurefireReportParser report;
    private List testSuites;
    private boolean showSuccess;
    private String xrefLocation;

    public SurefireReportGenerator(File[] reportsDirectories, Locale locale, boolean showSuccess, String xrefLocation) {
        this.report = new SurefireReportParser(reportsDirectories, locale);
        this.xrefLocation = xrefLocation;
        this.showSuccess = showSuccess;
    }

    public void doGenerateReport(ResourceBundle bundle, Sink sink) throws MavenReportException {
        List failureList;
        this.testSuites = this.report.parseXMLReportFiles();
        sink.head();
        sink.title();
        sink.text(bundle.getString("report.surefire.header"));
        sink.title_();
        StringBuffer str = new StringBuffer();
        str.append("<script type=\"text/javascript\">\n");
        str.append("function toggleDisplay(elementId) {\n");
        str.append(" var elm = document.getElementById(elementId + 'error');\n");
        str.append(" if (elm && typeof elm.style != \"undefined\") {\n");
        str.append(" if (elm.style.display == \"none\") {\n");
        str.append(" elm.style.display = \"\";\n");
        str.append(" document.getElementById(elementId + 'off').style.display = \"none\";\n");
        str.append(" document.getElementById(elementId + 'on').style.display = \"inline\";\n");
        str.append(" }");
        str.append(" else if (elm.style.display == \"\") {");
        str.append(" elm.style.display = \"none\";\n");
        str.append(" document.getElementById(elementId + 'off').style.display = \"inline\";\n");
        str.append(" document.getElementById(elementId + 'on').style.display = \"none\";\n");
        str.append(" } \n");
        str.append(" } \n");
        str.append(" }\n");
        str.append("</script>");
        sink.rawText(str.toString());
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(bundle.getString("report.surefire.header"));
        sink.sectionTitle1_();
        sink.section1_();
        this.constructSummarySection(bundle, sink);
        Map suitePackages = this.report.getSuitesGroupByPackage(this.testSuites);
        if (!suitePackages.isEmpty()) {
            this.constructPackagesSection(bundle, sink, suitePackages);
        }
        if (!this.testSuites.isEmpty()) {
            this.constructTestCasesSection(bundle, sink);
        }
        if (!(failureList = this.report.getFailureDetails(this.testSuites)).isEmpty()) {
            this.constructFailureDetails(sink, bundle, failureList);
        }
        this.sinkLineBreak(sink);
        sink.body_();
        sink.flush();
        sink.close();
    }

    private void constructSummarySection(ResourceBundle bundle, Sink sink) {
        Map summary = this.report.getSummary(this.testSuites);
        sink.section1();
        sink.sectionTitle1();
        this.sinkAnchor(sink, "Summary");
        sink.text(bundle.getString("report.surefire.label.summary"));
        sink.sectionTitle1_();
        this.constructHotLinks(sink, bundle);
        this.sinkLineBreak(sink);
        sink.table();
        sink.tableRow();
        this.sinkHeader(sink, bundle.getString("report.surefire.label.tests"));
        this.sinkHeader(sink, bundle.getString("report.surefire.label.errors"));
        this.sinkHeader(sink, bundle.getString("report.surefire.label.failures"));
        this.sinkHeader(sink, bundle.getString("report.surefire.label.skipped"));
        this.sinkHeader(sink, bundle.getString("report.surefire.label.successrate"));
        this.sinkHeader(sink, bundle.getString("report.surefire.label.time"));
        sink.tableRow_();
        sink.tableRow();
        this.sinkCell(sink, (String)summary.get("totalTests"));
        this.sinkCell(sink, (String)summary.get("totalErrors"));
        this.sinkCell(sink, (String)summary.get("totalFailures"));
        this.sinkCell(sink, (String)summary.get("totalSkipped"));
        this.sinkCell(sink, summary.get("totalPercentage") + "%");
        this.sinkCell(sink, (String)summary.get("totalElapsedTime"));
        sink.tableRow_();
        sink.table_();
        sink.lineBreak();
        sink.rawText(bundle.getString("report.surefire.text.note1"));
        this.sinkLineBreak(sink);
        sink.section1_();
    }

    private void constructPackagesSection(ResourceBundle bundle, Sink sink, Map suitePackages) {
        List testSuiteList;
        String packageName;
        NumberFormat numberFormat = this.report.getNumberFormat();
        sink.section1();
        sink.sectionTitle1();
        this.sinkAnchor(sink, "Package_List");
        sink.text(bundle.getString("report.surefire.label.packagelist"));
        sink.sectionTitle1_();
        this.constructHotLinks(sink, bundle);
        this.sinkLineBreak(sink);
        sink.table();
        sink.tableRow();
        this.sinkHeader(sink, bundle.getString("report.surefire.label.package"));
        this.sinkHeader(sink, bundle.getString("report.surefire.label.tests"));
        this.sinkHeader(sink, bundle.getString("report.surefire.label.errors"));
        this.sinkHeader(sink, bundle.getString("report.surefire.label.failures"));
        this.sinkHeader(sink, bundle.getString("report.surefire.label.skipped"));
        this.sinkHeader(sink, bundle.getString("report.surefire.label.successrate"));
        this.sinkHeader(sink, bundle.getString("report.surefire.label.time"));
        sink.tableRow_();
        Iterator packIter = suitePackages.keySet().iterator();
        while (packIter.hasNext()) {
            sink.tableRow();
            packageName = (String)packIter.next();
            testSuiteList = (List)suitePackages.get(packageName);
            Map packageSummary = this.report.getSummary(testSuiteList);
            this.sinkCellLink(sink, packageName, "#" + packageName);
            this.sinkCell(sink, (String)packageSummary.get("totalTests"));
            this.sinkCell(sink, (String)packageSummary.get("totalErrors"));
            this.sinkCell(sink, (String)packageSummary.get("totalFailures"));
            this.sinkCell(sink, (String)packageSummary.get("totalSkipped"));
            this.sinkCell(sink, packageSummary.get("totalPercentage") + "%");
            this.sinkCell(sink, (String)packageSummary.get("totalElapsedTime"));
            sink.tableRow_();
        }
        sink.table_();
        sink.lineBreak();
        sink.rawText(bundle.getString("report.surefire.text.note2"));
        packIter = suitePackages.keySet().iterator();
        while (packIter.hasNext()) {
            packageName = (String)packIter.next();
            testSuiteList = (List)suitePackages.get(packageName);
            Iterator suiteIterator = testSuiteList.iterator();
            sink.section2();
            sink.sectionTitle2();
            this.sinkAnchor(sink, packageName);
            sink.text(packageName);
            sink.sectionTitle2_();
            sink.table();
            sink.tableRow();
            this.sinkHeader(sink, "");
            this.sinkHeader(sink, bundle.getString("report.surefire.label.class"));
            this.sinkHeader(sink, bundle.getString("report.surefire.label.tests"));
            this.sinkHeader(sink, bundle.getString("report.surefire.label.errors"));
            this.sinkHeader(sink, bundle.getString("report.surefire.label.failures"));
            this.sinkHeader(sink, bundle.getString("report.surefire.label.skipped"));
            this.sinkHeader(sink, bundle.getString("report.surefire.label.successrate"));
            this.sinkHeader(sink, bundle.getString("report.surefire.label.time"));
            sink.tableRow_();
            while (suiteIterator.hasNext()) {
                ReportTestSuite suite = (ReportTestSuite)suiteIterator.next();
                if (!this.showSuccess && suite.getNumberOfErrors() == 0 && suite.getNumberOfFailures() == 0) continue;
                sink.tableRow();
                sink.tableCell();
                sink.link("#" + suite.getPackageName() + suite.getName());
                if (suite.getNumberOfErrors() > 0) {
                    this.sinkIcon("error", sink);
                } else if (suite.getNumberOfFailures() > 0) {
                    this.sinkIcon("junit.framework", sink);
                } else if (suite.getNumberOfSkipped() > 0) {
                    this.sinkIcon("skipped", sink);
                } else {
                    this.sinkIcon("success", sink);
                }
                sink.link_();
                sink.tableCell_();
                this.sinkCellLink(sink, suite.getName(), "#" + suite.getPackageName() + suite.getName());
                this.sinkCell(sink, Integer.toString(suite.getNumberOfTests()));
                this.sinkCell(sink, Integer.toString(suite.getNumberOfErrors()));
                this.sinkCell(sink, Integer.toString(suite.getNumberOfFailures()));
                this.sinkCell(sink, Integer.toString(suite.getNumberOfSkipped()));
                String percentage = this.report.computePercentage(suite.getNumberOfTests(), suite.getNumberOfErrors(), suite.getNumberOfFailures(), suite.getNumberOfSkipped());
                this.sinkCell(sink, percentage + "%");
                this.sinkCell(sink, numberFormat.format(suite.getTimeElapsed()));
                sink.tableRow_();
            }
            sink.table_();
            sink.section2_();
        }
        this.sinkLineBreak(sink);
        sink.section1_();
    }

    private void constructTestCasesSection(ResourceBundle bundle, Sink sink) {
        NumberFormat numberFormat = this.report.getNumberFormat();
        sink.section1();
        sink.sectionTitle1();
        this.sinkAnchor(sink, "Test_Cases");
        sink.text(bundle.getString("report.surefire.label.testcases"));
        sink.sectionTitle1_();
        this.constructHotLinks(sink, bundle);
        ListIterator suiteIterator = this.testSuites.listIterator();
        while (suiteIterator.hasNext()) {
            ReportTestSuite suite = (ReportTestSuite)suiteIterator.next();
            List testCases = suite.getTestCases();
            if (testCases == null) continue;
            ListIterator caseIterator = testCases.listIterator();
            sink.section2();
            sink.sectionTitle2();
            this.sinkAnchor(sink, suite.getPackageName() + suite.getName());
            sink.text(suite.getName());
            sink.sectionTitle2_();
            sink.table();
            while (caseIterator.hasNext()) {
                ReportTestCase testCase = (ReportTestCase)caseIterator.next();
                if (testCase.getFailure() == null && !this.showSuccess) continue;
                sink.tableRow();
                sink.tableCell();
                Map failure = testCase.getFailure();
                if (failure != null) {
                    sink.link("#" + testCase.getFullName());
                    this.sinkIcon((String)failure.get("type"), sink);
                    sink.link_();
                } else {
                    this.sinkIcon("success", sink);
                }
                sink.tableCell_();
                if (failure != null) {
                    sink.tableCell();
                    this.sinkLink(sink, testCase.getName(), "#" + testCase.getFullName());
                    sink.rawText("  <div class=\"detailToggle\" style=\"display:inline\">");
                    sink.link("javascript:toggleDisplay('" + testCase.getName() + "');");
                    sink.rawText("<span style=\"display: inline;\" id=\"" + testCase.getName() + "off\">+</span><span id=\"" + testCase.getName() + "on\" " + "style=\"display: none;\">-</span> ");
                    sink.text("[ Detail ]");
                    sink.link_();
                    sink.rawText("</div>");
                    sink.tableCell_();
                } else {
                    this.sinkCell(sink, testCase.getName());
                }
                this.sinkCell(sink, numberFormat.format(testCase.getTime()));
                sink.tableRow_();
                if (failure == null) continue;
                sink.tableRow();
                this.sinkCell(sink, "");
                this.sinkCell(sink, (String)failure.get("message"));
                this.sinkCell(sink, "");
                sink.tableRow_();
                List detail = (List)failure.get("detail");
                if (detail == null) continue;
                sink.tableRow();
                this.sinkCell(sink, "");
                sink.tableCell();
                sink.rawText("  <div id=\"" + testCase.getName() + "error\" style=\"display:none;\">");
                Iterator it = detail.iterator();
                sink.verbatim(true);
                while (it.hasNext()) {
                    sink.text(it.next().toString());
                    sink.lineBreak();
                }
                sink.verbatim_();
                sink.rawText("</div>");
                sink.tableCell_();
                this.sinkCell(sink, "");
                sink.tableRow_();
            }
            sink.table_();
            sink.section2_();
        }
        this.sinkLineBreak(sink);
        sink.section1_();
    }

    private void constructFailureDetails(Sink sink, ResourceBundle bundle, List failureList) {
        Iterator failIter = failureList.iterator();
        if (failIter != null) {
            sink.section1();
            sink.sectionTitle1();
            this.sinkAnchor(sink, "Failure_Details");
            sink.text(bundle.getString("report.surefire.label.failuredetails"));
            sink.sectionTitle1_();
            this.constructHotLinks(sink, bundle);
            this.sinkLineBreak(sink);
            sink.table();
            while (failIter.hasNext()) {
                ReportTestCase tCase = (ReportTestCase)failIter.next();
                Map failure = tCase.getFailure();
                sink.tableRow();
                sink.tableCell();
                String type = (String)failure.get("type");
                this.sinkIcon(type, sink);
                sink.tableCell_();
                this.sinkCellAnchor(sink, tCase.getName(), tCase.getFullName());
                sink.tableRow_();
                String message = (String)failure.get("message");
                sink.tableRow();
                this.sinkCell(sink, "");
                StringBuffer sb = new StringBuffer();
                sb.append(type);
                if (message != null) {
                    sb.append(": ");
                    sb.append(message);
                }
                this.sinkCell(sink, sb.toString());
                sink.tableRow_();
                List detail = (List)failure.get("detail");
                if (detail == null) continue;
                Iterator it = detail.iterator();
                boolean firstLine = true;
                String techMessage = "";
                while (it.hasNext()) {
                    techMessage = it.next().toString();
                    if (firstLine) {
                        firstLine = false;
                        continue;
                    }
                    sink.text("    ");
                }
                sink.tableRow();
                this.sinkCell(sink, "");
                sink.tableCell();
                sink.rawText("  <div id=\"" + tCase.getName() + "error\" >");
                if (this.xrefLocation != null) {
                    String path = tCase.getFullClassName().replace('.', '/');
                    sink.link(this.xrefLocation + "/" + path + ".html#" + this.getErrorLineNumber(tCase.getFullName(), techMessage));
                }
                sink.text(tCase.getFullClassName() + ":" + this.getErrorLineNumber(tCase.getFullName(), techMessage));
                if (this.xrefLocation != null) {
                    sink.link_();
                }
                sink.rawText("</div>");
                sink.tableCell_();
                sink.tableRow_();
            }
            sink.table_();
        }
        this.sinkLineBreak(sink);
        sink.section1_();
    }

    private String getErrorLineNumber(String className, String source) {
        StringTokenizer tokenizer = new StringTokenizer(source);
        String lineNo = "";
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!token.startsWith(className)) continue;
            int idx = token.indexOf(":");
            lineNo = token.substring(idx + 1, token.indexOf(")"));
            break;
        }
        return lineNo;
    }

    private void constructHotLinks(Sink sink, ResourceBundle bundle) {
        if (!this.testSuites.isEmpty()) {
            sink.section2();
            sink.rawText("[");
            this.sinkLink(sink, bundle.getString("report.surefire.label.summary"), "#Summary");
            sink.rawText("]");
            sink.rawText(" [");
            this.sinkLink(sink, bundle.getString("report.surefire.label.packagelist"), "#Package_List");
            sink.rawText("]");
            sink.rawText(" [");
            this.sinkLink(sink, bundle.getString("report.surefire.label.testcases"), "#Test_Cases");
            sink.rawText("]");
            sink.section2_();
        }
    }

    private void sinkLineBreak(Sink sink) {
        sink.lineBreak();
    }

    private void sinkIcon(String type, Sink sink) {
        sink.figure();
        if (type.startsWith("junit.framework") || "skipped".equals(type)) {
            sink.figureGraphics("images/icon_warning_sml.gif");
        } else if (type.startsWith("success")) {
            sink.figureGraphics("images/icon_success_sml.gif");
        } else {
            sink.figureGraphics("images/icon_error_sml.gif");
        }
        sink.figure_();
    }

    private void sinkHeader(Sink sink, String header) {
        sink.tableHeaderCell();
        sink.text(header);
        sink.tableHeaderCell_();
    }

    private void sinkCell(Sink sink, String text) {
        sink.tableCell();
        sink.text(text);
        sink.tableCell_();
    }

    private void sinkLink(Sink sink, String text, String link) {
        sink.link(link);
        sink.text(text);
        sink.link_();
    }

    private void sinkCellLink(Sink sink, String text, String link) {
        sink.tableCell();
        this.sinkLink(sink, text, link);
        sink.tableCell_();
    }

    private void sinkCellAnchor(Sink sink, String text, String anchor) {
        sink.tableCell();
        this.sinkAnchor(sink, anchor);
        sink.text(text);
        sink.tableCell_();
    }

    private void sinkAnchor(Sink sink, String anchor) {
        sink.anchor(anchor);
        sink.anchor_();
    }
}

