/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type.basic;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.MessageReader;
import org.codehaus.xfire.aegis.MessageWriter;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.aegis.type.basic.BeanTypeInfo;
import org.codehaus.xfire.aegis.type.basic.InterfaceInvocationHandler;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.util.ClassLoaderUtils;
import org.codehaus.xfire.util.NamespaceHelper;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;

public class BeanType
extends Type {
    private BeanTypeInfo _info;
    private boolean isInterface = false;
    private boolean isException = false;

    public BeanType() {
    }

    public BeanType(BeanTypeInfo info) {
        this._info = info;
        this.setTypeClass(info.getTypeClass());
    }

    public Object readObject(MessageReader reader, MessageContext context) throws XFireFault {
        BeanTypeInfo info = this.getTypeInfo();
        try {
            Object writeObj;
            Type type;
            QName name;
            MessageReader childReader;
            Class clazz = this.getTypeClass();
            Object object = null;
            InterfaceInvocationHandler delegate = null;
            boolean isProxy = false;
            if (this.isInterface) {
                String impl = null;
                if (context.getService() != null) {
                    impl = (String)context.getService().getProperty(clazz.getName() + ".implementation");
                }
                if (impl == null) {
                    delegate = new InterfaceInvocationHandler();
                    object = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)delegate);
                    isProxy = true;
                } else {
                    try {
                        clazz = ClassLoaderUtils.loadClass(impl, this.getClass());
                        object = clazz.newInstance();
                    }
                    catch (ClassNotFoundException e) {
                        throw new XFireRuntimeException("Could not find implementation class " + impl + " for class " + clazz.getName());
                    }
                }
            } else {
                object = this.isException ? this.createFromFault(context) : (Object)clazz.newInstance();
            }
            while (reader.hasMoreAttributeReaders()) {
                childReader = reader.getNextAttributeReader();
                name = childReader.getName();
                type = info.getType(name);
                if (type == null) continue;
                writeObj = type.readObject(childReader, context);
                if (isProxy) {
                    delegate.writeProperty(name.getLocalPart(), writeObj);
                    continue;
                }
                this.writeProperty(name, object, writeObj, clazz);
            }
            while (reader.hasMoreElementReaders()) {
                childReader = reader.getNextElementReader();
                name = childReader.getName();
                type = info.getType(name);
                if (type != null) {
                    if (!childReader.isXsiNil()) {
                        writeObj = type.readObject(childReader, context);
                        if (isProxy) {
                            delegate.writeProperty(name.getLocalPart(), writeObj);
                            continue;
                        }
                        this.writeProperty(name, object, writeObj, clazz);
                        continue;
                    }
                    if (!info.isNillable(name)) {
                        throw new XFireFault(name.getLocalPart() + " is nil, but not nillable.", XFireFault.SENDER);
                    }
                    childReader.readToEnd();
                    continue;
                }
                childReader.readToEnd();
            }
            return object;
        }
        catch (IllegalAccessException e) {
            throw new XFireFault("Illegal access. " + e.getMessage(), (Throwable)e, XFireFault.RECEIVER);
        }
        catch (InstantiationException e) {
            throw new XFireFault("Couldn't instantiate class. " + e.getMessage(), (Throwable)e, XFireFault.SENDER);
        }
        catch (SecurityException e) {
            throw new XFireFault("Illegal access. " + e.getMessage(), (Throwable)e, XFireFault.RECEIVER);
        }
        catch (IllegalArgumentException e) {
            throw new XFireFault("Illegal argument. " + e.getMessage(), (Throwable)e, XFireFault.RECEIVER);
        }
        catch (InvocationTargetException e) {
            throw new XFireFault("Couldn't create class: " + e.getMessage(), (Throwable)e, XFireFault.RECEIVER);
        }
    }

    protected Object createFromFault(MessageContext context) throws SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object o;
        Class clazz = this.getTypeClass();
        Object body = context.getExchange().getFaultMessage().getBody();
        if (!(body instanceof XFireFault)) {
            return clazz.newInstance();
        }
        XFireFault fault = (XFireFault)body;
        try {
            Constructor ctr = clazz.getConstructor(String.class, Throwable.class);
            o = ctr.newInstance(fault.getMessage(), fault);
        }
        catch (NoSuchMethodException e) {
            try {
                Constructor ctr = clazz.getConstructor(String.class, Exception.class);
                o = ctr.newInstance(fault.getMessage(), fault);
            }
            catch (NoSuchMethodException e1) {
                try {
                    Constructor ctr = clazz.getConstructor(String.class);
                    o = ctr.newInstance(fault.getMessage());
                }
                catch (NoSuchMethodException e2) {
                    return clazz.newInstance();
                }
            }
        }
        return o;
    }

    protected void writeProperty(QName name, Object object, Object property, Class impl) throws XFireFault {
        try {
            PropertyDescriptor desc = this.getTypeInfo().getPropertyDescriptorFromMappedName(name);
            Method m = desc.getWriteMethod();
            if (m == null) {
                if (this.getTypeClass().isInterface()) {
                    m = this.getWriteMethodFromImplClass(impl, desc);
                }
                if (m == null) {
                    throw new XFireFault("No write method for property " + name + " in " + object.getClass(), XFireFault.SENDER);
                }
            }
            Class<?> propertyType = desc.getPropertyType();
            if (property == null && !propertyType.isPrimitive() || property != null) {
                m.invoke(object, property);
            }
        }
        catch (Exception e) {
            if (e instanceof XFireFault) {
                throw (XFireFault)e;
            }
            throw new XFireFault("Couldn't set property " + name + " on " + object + ". " + e.getMessage(), (Throwable)e, XFireFault.SENDER);
        }
    }

    private Method getWriteMethodFromImplClass(Class impl, PropertyDescriptor pd) throws Exception {
        String name = pd.getName();
        name = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
        return impl.getMethod(name, pd.getPropertyType());
    }

    public void writeObject(Object object, MessageWriter writer, MessageContext context) throws XFireFault {
        MessageWriter cwriter;
        Type type;
        Object value;
        QName name;
        if (object == null) {
            return;
        }
        BeanTypeInfo info = this.getTypeInfo();
        Iterator itr = info.getAttributes();
        while (itr.hasNext()) {
            name = (QName)itr.next();
            value = this.readProperty(object, name);
            if (value == null) continue;
            type = this.getType(info, name);
            if (type == null) {
                throw new XFireRuntimeException("Couldn't find type for " + value.getClass() + " for property " + name);
            }
            cwriter = writer.getAttributeWriter(name);
            type.writeObject(value, cwriter, context);
            cwriter.close();
        }
        itr = info.getElements();
        while (itr.hasNext()) {
            name = (QName)itr.next();
            value = this.readProperty(object, name);
            type = this.getType(info, name);
            if (value != null) {
                cwriter = this.getWriter(writer, name, type);
                if (type == null) {
                    throw new XFireRuntimeException("Couldn't find type for " + value.getClass() + " for property " + name);
                }
                type.writeObject(value, cwriter, context);
                cwriter.close();
                continue;
            }
            if (!info.isNillable(name)) continue;
            cwriter = this.getWriter(writer, name, type);
            cwriter.writeXsiNil();
            cwriter.close();
        }
    }

    private MessageWriter getWriter(MessageWriter writer, QName name, Type type) {
        MessageWriter cwriter = type.isAbstract() ? writer.getElementWriter(name) : writer.getElementWriter(name);
        return cwriter;
    }

    protected Object readProperty(Object object, QName name) {
        try {
            PropertyDescriptor desc = this.getTypeInfo().getPropertyDescriptorFromMappedName(name);
            Method m = desc.getReadMethod();
            if (m == null) {
                throw new XFireFault("No read method for property " + name + " in class " + object.getClass().getName(), XFireFault.SENDER);
            }
            return m.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new XFireRuntimeException("Couldn't get property " + name + " from bean " + object, (Throwable)e);
        }
    }

    public void writeSchema(Element root) {
        String prefix;
        String nameWithPrefix;
        String nameNS;
        Type type;
        Element element;
        QName name;
        BeanTypeInfo info = this.getTypeInfo();
        Element complex = new Element("complexType", "xsd", "http://www.w3.org/2001/XMLSchema");
        complex.setAttribute(new Attribute("name", this.getSchemaType().getLocalPart()));
        root.addContent((Content)complex);
        Element seq = null;
        Iterator itr = info.getElements();
        while (itr.hasNext()) {
            if (seq == null) {
                seq = new Element("sequence", "xsd", "http://www.w3.org/2001/XMLSchema");
                complex.addContent((Content)seq);
            }
            name = (QName)itr.next();
            element = new Element("element", "xsd", "http://www.w3.org/2001/XMLSchema");
            seq.addContent((Content)element);
            type = this.getType(info, name);
            nameNS = name.getNamespaceURI();
            nameWithPrefix = this.getNameWithPrefix(root, nameNS, name.getLocalPart());
            prefix = NamespaceHelper.getUniquePrefix((Element)((Element)root.getParent()), (String)type.getSchemaType().getNamespaceURI());
            this.writeTypeReference(name, nameWithPrefix, element, type, prefix);
        }
        if (info.isExtensibleElements()) {
            if (seq == null) {
                seq = new Element("sequence", "xsd", "http://www.w3.org/2001/XMLSchema");
                complex.addContent((Content)seq);
            }
            seq.addContent((Content)this.createAnyElement());
        }
        itr = info.getAttributes();
        while (itr.hasNext()) {
            name = (QName)itr.next();
            element = new Element("attribute", "xsd", "http://www.w3.org/2001/XMLSchema");
            complex.addContent((Content)element);
            type = this.getType(info, name);
            nameNS = name.getNamespaceURI();
            nameWithPrefix = this.getNameWithPrefix(root, nameNS, name.getLocalPart());
            prefix = NamespaceHelper.getUniquePrefix((Element)((Element)root.getParent()), (String)type.getSchemaType().getNamespaceURI());
            element.setAttribute(new Attribute("name", nameWithPrefix));
            element.setAttribute(new Attribute("type", prefix + ':' + type.getSchemaType().getLocalPart()));
        }
        if (info.isExtensibleAttributes()) {
            complex.addContent((Content)this.createAnyAttribute());
        }
    }

    private String getNameWithPrefix(Element root, String nameNS, String localName) {
        String prefix;
        if (!nameNS.equals(this.getSchemaType().getNamespaceURI()) && (prefix = NamespaceHelper.getUniquePrefix((Element)((Element)root.getParent()), (String)nameNS)) != null && prefix.length() > 0) {
            return prefix + ":" + localName;
        }
        return localName;
    }

    private Type getType(BeanTypeInfo info, QName name) {
        Type type = info.getType(name);
        if (type == null) {
            throw new NullPointerException("Couldn't find type for" + name + " in class " + this.getTypeClass().getName());
        }
        return type;
    }

    private void writeTypeReference(QName name, String nameWithPrefix, Element element, Type type, String prefix) {
        if (type.isAbstract()) {
            element.setAttribute(new Attribute("name", nameWithPrefix));
            element.setAttribute(new Attribute("type", prefix + ':' + type.getSchemaType().getLocalPart()));
            int minOccurs = this.getTypeInfo().getMinOccurs(name);
            if (minOccurs != 1) {
                element.setAttribute(new Attribute("minOccurs", new Integer(minOccurs).toString()));
            }
            if (this.getTypeInfo().isNillable(name)) {
                element.setAttribute(new Attribute("nillable", "true"));
            }
        } else {
            element.setAttribute(new Attribute("ref", prefix + ':' + type.getSchemaType().getLocalPart()));
        }
    }

    public void setTypeClass(Class typeClass) {
        super.setTypeClass(typeClass);
        this.isInterface = typeClass.isInterface();
        this.isException = Exception.class.isAssignableFrom(typeClass);
    }

    public boolean isComplex() {
        return true;
    }

    public Set getDependencies() {
        QName name;
        HashSet<Type> deps = new HashSet<Type>();
        BeanTypeInfo info = this.getTypeInfo();
        Iterator itr = info.getAttributes();
        while (itr.hasNext()) {
            name = (QName)itr.next();
            deps.add(info.getType(name));
        }
        itr = info.getElements();
        while (itr.hasNext()) {
            name = (QName)itr.next();
            deps.add(info.getType(name));
        }
        return deps;
    }

    public BeanTypeInfo getTypeInfo() {
        if (this._info == null) {
            this._info = this.createTypeInfo();
        }
        if (!this._info.isInitialized()) {
            this._info.initialize();
        }
        return this._info;
    }

    public BeanTypeInfo createTypeInfo() {
        BeanTypeInfo info = new BeanTypeInfo(this.getTypeClass(), this.getSchemaType().getNamespaceURI());
        info.setTypeMapping(this.getTypeMapping());
        return info;
    }

    private Element createAnyElement() {
        Element result = new Element("any", "xsd", "http://www.w3.org/2001/XMLSchema");
        result.setAttribute(new Attribute("minOccurs", "0"));
        result.setAttribute(new Attribute("maxOccurs", "unbounded"));
        return result;
    }

    private Element createAnyAttribute() {
        Element result = new Element("anyAttribute", "xsd", "http://www.w3.org/2001/XMLSchema");
        return result;
    }
}

