/*
 * Decompiled with CFR 0.152.
 */
package jeus.client.container;

import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import jeus.container.annotation.ClassAnnotationReader;
import jeus.container.namingenv.EnvironmentAnnotationProcessor;
import jeus.container.namingenv.EnvironmentDescriptorProcessor;
import jeus.container.namingenv.JndiEnvironmentRefsGroup;
import jeus.container.namingenv.NamingEnvironment;
import jeus.deploy.InvalidAnnotationException;
import jeus.deploy.InvalidDescriptorException;
import jeus.deploy.archivist.AbstractArchive;
import jeus.xml.binding.j2ee.ApplicationClientType;

public class AppClientHelper {
    public static String getMainClassAttribute(AbstractArchive archive) throws IOException {
        Manifest jarManifest = archive.getManifest();
        if (jarManifest != null) {
            return jarManifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
        }
        return null;
    }

    public static NamingEnvironment processEnvironmentAnnotations(Class mainClass) throws InvalidAnnotationException {
        EnvironmentAnnotationProcessor processor = new EnvironmentAnnotationProcessor();
        ClassAnnotationReader reader = new ClassAnnotationReader(mainClass);
        reader.setStaticMemberOnly(true);
        reader.addAnnotationProcessor(processor);
        reader.process();
        return processor.getNamingEnvironment();
    }

    public static NamingEnvironment processDescriptorEnvironmentEntries(NamingEnvironment env, ApplicationClientType stdDD, ClassLoader loader, String mainClass) throws InvalidDescriptorException {
        if (stdDD != null) {
            JndiEnvironmentRefsGroup envRefs = new JndiEnvironmentRefsGroup();
            envRefs.simpleEnvEntryList = stdDD.getEnvEntry();
            envRefs.ejbRefList = stdDD.getEjbRef();
            if (AppClientHelper.getVersion(stdDD) > 1.4) {
                envRefs.serviceRefList = stdDD.getServiceRef();
            }
            envRefs.resourceRefList = stdDD.getResourceRef();
            envRefs.resourceEnvRefList = stdDD.getResourceEnvRef();
            envRefs.messageDestinationRefList = stdDD.getMessageDestinationRef();
            envRefs.persistenceUnitRefList = stdDD.getPersistenceUnitRef();
            envRefs.postConstructList = stdDD.getPostConstruct();
            envRefs.preDestroyList = stdDD.getPreDestroy();
            envRefs.componentClassName = mainClass;
            EnvironmentDescriptorProcessor envProcessor = new EnvironmentDescriptorProcessor(env, loader);
            envProcessor.process(envRefs);
            return envProcessor.getNamingEnvironment();
        }
        return env;
    }

    public static double getVersion(ApplicationClientType stdDD) {
        return Double.parseDouble(stdDD.getVersion());
    }
}

