/*
 * Decompiled with CFR 0.152.
 */
package jeus.client.container;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import jeus.deploy.archivist.AbstractArchive;

public class AppClientProperties {
    static final String fileName = ".module.properties";
    private static final String STANDALONE = "standalone";
    private static final String EAR_PATH = "ear_path";
    private static final String MODULE_URI = "module_uri";
    private static final String EAR_PU_PATH = "ear_pu_path";
    private Properties properties = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AppClientProperties load(AbstractArchive archive) throws IOException {
        InputStream in = archive.getEntry(fileName);
        if (in == null) {
            return null;
        }
        AppClientProperties result = new AppClientProperties();
        try {
            result.properties.load(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            in.close();
        }
        return result;
    }

    public void store(AbstractArchive archive) throws IOException {
        OutputStream out = archive.addEntry(fileName);
        try {
            this.properties.store(out, "");
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            out.close();
        }
    }

    public boolean isStandalone() {
        return Boolean.parseBoolean(this.properties.getProperty(STANDALONE));
    }

    public void setStandalone(boolean standalone) {
        this.properties.setProperty(STANDALONE, Boolean.toString(standalone));
    }

    public String getEarPath() {
        return this.properties.getProperty(EAR_PATH);
    }

    public void setEarPath(String earPath) {
        this.properties.setProperty(EAR_PATH, earPath);
    }

    public String getModuleUri() {
        return this.properties.getProperty(MODULE_URI);
    }

    public void setModuleUri(String moduleUri) {
        this.properties.setProperty(MODULE_URI, moduleUri);
    }

    public void setEarPersistenceUnitPath(String puUriPath) {
        this.properties.setProperty(EAR_PU_PATH, puUriPath);
    }

    public String getEarPersistenceUnitPath() {
        return this.properties.getProperty(EAR_PU_PATH);
    }
}

