/*
 * Decompiled with CFR 0.152.
 */
package jeus.client.container;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.server.RMISocketFactory;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.naming.InitialContext;
import javax.xml.bind.JAXBException;
import jeus.client.container.AppClientClassLoader;
import jeus.client.container.AppClientHelper;
import jeus.client.container.AppClientProperties;
import jeus.client.container.AppClientSchedulerService;
import jeus.container.namingenv.EnvUtil;
import jeus.container.namingenv.EnvironmentContext;
import jeus.container.namingenv.JndiEnvironmentMappingGroup;
import jeus.container.namingenv.NamingEnvManager;
import jeus.container.namingenv.NamingEnvironment;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.FileArchive;
import jeus.deploy.archivist.FileArchiveFactory;
import jeus.deploy.archivist.JarArchiveFactory;
import jeus.deploy.io.AppClientDeploymentDescriptorFile;
import jeus.deploy.io.ApplicationDeploymentDescriptorFile;
import jeus.deploy.io.PersistenceDescriptorFile;
import jeus.deploy.io.runtime.AppClientRuntimeDDFile;
import jeus.ejb.util.EJBRMISocketFactory;
import jeus.management.j2ee.DeploymentException;
import jeus.persistence.container.PersistenceUnit;
import jeus.persistence.container.PersistenceUnitNotFoundException;
import jeus.persistence.container.PersistenceUnits;
import jeus.security.base.Subject;
import jeus.security.spi.LoginService;
import jeus.security.util.EncryptionUtil;
import jeus.security.util.LoginUtil;
import jeus.server.manager.JeusVersion;
import jeus.util.ExecutionContext;
import jeus.util.JeusBootstrapProperties;
import jeus.util.JeusRootClassLoader;
import jeus.util.JeusRuntimeException;
import jeus.util.SecurityUtil;
import jeus.util.file.FileUtils;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.JeusLoggerConfiguration;
import jeus.util.message.JeusMessage_Client;
import jeus.util.message.JeusMessage_JPA;
import jeus.webservices.api.EWSProvider;
import jeus.xml.binding.appclientHelper.AppClientPair;
import jeus.xml.binding.j2ee.ApplicationClientType;
import jeus.xml.binding.j2ee.ApplicationType;
import jeus.xml.binding.j2ee.ModuleType;
import jeus.xml.binding.j2ee.PathType;
import jeus.xml.binding.j2ee.Persistence;
import jeus.xml.binding.jeusDD.JeusClientDdType;
import jeus.xml.binding.jeusDD.JeusWebservicesClientDdType;
import jeus.xml.binding.jeusDD.SystemLoggingType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClientContainer {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus");
    private static long startTime;
    private static final String CLIENT = "-client";
    private static final String STUB = "-cp";
    private static final String MAIN_CLASS = "-main";
    private static final String TEXT_AUTH = "-textauth";
    private static final String USER = "-user";
    private static final String PASSWORD = "-password";
    private static AppClientSchedulerService scheduler;
    private static ApplicationClientType appClientDD;
    private static JeusClientDdType runtimeDD;
    private static AppClientPair appClientPair;
    private static AppClientProperties properties;
    private static File appClientFile;
    private static AbstractArchive appClientArchive;
    private static AppClientClassLoader classLoader;
    private static String mainClassName;
    private static Class mainClass;
    private static final double VERSION_5 = 5.0;
    private static final double DEFAULT_VERSION = 5.0;
    private static double appClientVersion;
    private static boolean metadataComplete;
    private static boolean isStandalone;
    private static String earPath;
    private static ApplicationType appDescriptor;
    private static String moduleUri;
    private static final String DEFAULT_LIBRARY_DIRECTORY_PATH = "lib";
    private static NamingEnvManager namingEnvManager;
    private static String clientPath;
    private static String ejbJarPath;
    private static String USER_VALUE;
    private static String PASSWORD_VALUE;
    private static boolean isTextAuth;
    private static Vector appArgs;
    protected static Map<String, PersistenceUnits> persistenceUnits;
    private static String PROPERTY_JWSMODE;

    public static void main(String[] args) throws ClassNotFoundException {
        Class<?> classpathIndicatorClass = null;
        if (logger.isLoggable(JeusMessage_Client._50_LEVEL)) {
            logger.log(JeusMessage_Client._50_LEVEL, JeusMessage_Client._50, (Object)JeusVersion.getVersion());
        }
        startTime = System.currentTimeMillis();
        boolean jwsMode = Boolean.getBoolean(PROPERTY_JWSMODE);
        int i = 0;
        if (args.length < 1) {
            ClientContainer.usage();
        } else {
            while (i < args.length) {
                String arg;
                if ((arg = args[i++]).equals(CLIENT)) {
                    if (i < args.length) {
                        clientPath = args[i++];
                        continue;
                    }
                    ClientContainer.usage();
                    continue;
                }
                if (arg.equals(MAIN_CLASS)) {
                    if (i < args.length) {
                        mainClassName = args[i++];
                        continue;
                    }
                    ClientContainer.usage();
                    continue;
                }
                if (arg.equals(STUB)) {
                    if (i < args.length) {
                        ejbJarPath = args[i++];
                        continue;
                    }
                    ClientContainer.usage();
                    continue;
                }
                if (arg.equals(TEXT_AUTH)) {
                    isTextAuth = true;
                    continue;
                }
                if (arg.equals(USER)) {
                    if (i < args.length) {
                        USER_VALUE = args[i++];
                        continue;
                    }
                    ClientContainer.usage();
                    continue;
                }
                if (arg.equals(PASSWORD)) {
                    if (i < args.length) {
                        PASSWORD_VALUE = args[i++];
                        continue;
                    }
                    ClientContainer.usage();
                    continue;
                }
                appArgs.add(arg);
            }
        }
        try {
            if (!jwsMode) {
                if (clientPath == null) {
                    clientPath = ".";
                }
                if (!(appClientFile = new File(clientPath)).exists()) {
                    System.err.println("Error: the appclient module path does not exist - " + clientPath);
                    return;
                }
                if (!appClientFile.isAbsolute()) {
                    appClientFile = appClientFile.getAbsoluteFile();
                    clientPath = appClientFile.getPath();
                }
            } else {
                classpathIndicatorClass = Class.forName(mainClassName);
                URL currentURL = classpathIndicatorClass.getProtectionDomain().getCodeSource().getLocation();
                URI currentURI = currentURL.toURI();
                clientPath = currentURI.getSchemeSpecificPart();
                appClientFile = new File(clientPath);
            }
            appClientArchive = appClientFile.isDirectory() ? FileArchiveFactory.openArchiveStatic((String)clientPath) : JarArchiveFactory.openArchiveStatic((String)clientPath);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
        if (!jwsMode) {
            try {
                properties = AppClientProperties.load(appClientArchive);
                if (logger.isLoggable(JeusMessage_Client._43_LEVEL)) {
                    logger.log(JeusMessage_Client._43_LEVEL, JeusMessage_Client._43);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (properties != null && !(isStandalone = properties.isStandalone())) {
            earPath = properties.getEarPath();
            moduleUri = properties.getModuleUri();
        }
        try {
            ClientContainer.readDeploymentDescriptors();
            URI[] uris = ClientContainer.composeClasspathURIs();
            if (logger.isLoggable(JeusMessage_Client._18_LEVEL)) {
                String classpath = "";
                for (URI uri : uris) {
                    classpath = classpath + uri + ":";
                }
                logger.log(JeusMessage_Client._18_LEVEL, JeusMessage_Client._18, (Object)classpath);
            }
            AbstractArchive[] archives = new AbstractArchive[uris.length];
            for (int j = 0; j < uris.length; ++j) {
                archives[j] = new File(uris[j].getPath()).isDirectory() ? FileArchiveFactory.openArchiveStatic((String)uris[j].getPath()) : JarArchiveFactory.openArchiveStatic((String)uris[j].getPath());
                if (!jwsMode) {
                    archives[j].setCodeSource(ClientContainer.class.getProtectionDomain().getCodeSource());
                    archives[j].setPermissionCollection(ClientContainer.class.getProtectionDomain().getPermissions());
                    continue;
                }
                archives[j].setCodeSource(classpathIndicatorClass.getProtectionDomain().getCodeSource());
                archives[j].setPermissionCollection(classpathIndicatorClass.getProtectionDomain().getPermissions());
            }
            classLoader = new AppClientClassLoader(archives, ClientContainer.class.getClassLoader());
            JeusRootClassLoader.loader = classLoader;
        }
        catch (Throwable e) {
            System.err.println("Internal error occurred");
            e.printStackTrace();
            return;
        }
        Thread.currentThread().setContextClassLoader(classLoader);
        ClientContainer.preInvoke();
        ShutdownHook shutdown = new ShutdownHook();
        Runtime.getRuntime().addShutdownHook(shutdown);
        ClientContainer.invokeMain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URI[] composeClasspathURIs() throws IOException, JAXBException {
        LinkedHashSet<URI> uriList = new LinkedHashSet<URI>();
        URI uri = appClientFile.toURI();
        uriList.add(uri);
        if (logger.isLoggable(JeusMessage_Client._8_LEVEL)) {
            logger.log(JeusMessage_Client._8_LEVEL, JeusMessage_Client._8, (Object)uri);
        }
        if (JeusBootstrapProperties.JEUS_HOME != null) {
            // empty if block
        }
        ClientContainer.addClasspathURIs(appClientArchive, uriList);
        if (!isStandalone) {
            String[] earModules;
            String libDirPath;
            File earPathFile = new File(earPath);
            FileArchive earArchive = (FileArchive)FileArchiveFactory.openArchiveStatic((String)earPath);
            try {
                if (earArchive.contains("APP-INF")) {
                    FileArchive appInfArchive = (FileArchive)earArchive.getEmbeddedArchive("APP-INF");
                    FileArchive classesArchive = (FileArchive)appInfArchive.getEmbeddedArchive("classes");
                    try {
                        uriList.add(classesArchive.getArchiveURI());
                    }
                    finally {
                        classesArchive.close();
                    }
                    FileArchive libArchive = (FileArchive)appInfArchive.getEmbeddedArchive(DEFAULT_LIBRARY_DIRECTORY_PATH);
                    ClientContainer.addJarFilesToUriList(libArchive, uriList);
                    libArchive.close();
                }
                if (!(libDirPath = appDescriptor.isSetLibraryDirectory() ? appDescriptor.getLibraryDirectory().getValue() : DEFAULT_LIBRARY_DIRECTORY_PATH).equals("") && earArchive.contains(libDirPath)) {
                    FileArchive libArchive = (FileArchive)earArchive.getEmbeddedArchive(libDirPath);
                    ClientContainer.addJarFilesToUriList(libArchive, uriList);
                    libArchive.close();
                }
                for (File file : earPathFile.listFiles()) {
                    if (file.isDirectory() || !file.getName().endsWith(".jar")) continue;
                    uriList.add(file.toURI());
                }
            }
            finally {
                earArchive.close();
            }
            for (String module : earModules = earPathFile.list()) {
                String earModuleDirName;
                File earModuelDir;
                if (module.equals("APP-INF") || module.equals("META-INF") || module.equals(libDirPath) || !(earModuelDir = new File(earModuleDirName = earPath + File.separator + module)).isDirectory()) continue;
                uriList.add(earModuelDir.toURI());
            }
        }
        if (ejbJarPath != null) {
            ClientContainer.addEjbClassesToClasspathForCTS(uriList);
        }
        return uriList.toArray(new URI[0]);
    }

    private static void addEjbClassesToClasspathForCTS(LinkedHashSet<URI> uriList) throws IOException, JAXBException {
        StringTokenizer tokenizer = new StringTokenizer(ejbJarPath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String ejbJarPath = tokenizer.nextToken();
            File pathFile = new File(ejbJarPath);
            if (pathFile.exists()) {
                if (ejbJarPath.endsWith(".ear")) {
                    if (logger.isLoggable(JeusMessage_Client._13_LEVEL)) {
                        logger.log(JeusMessage_Client._13_LEVEL, JeusMessage_Client._13, (Object)ejbJarPath);
                    }
                    AbstractArchive earArchive2 = JarArchiveFactory.openArchiveStatic((String)ejbJarPath);
                    int index = ejbJarPath.lastIndexOf(".ear");
                    String ejbPath = ejbJarPath.substring(0, index);
                    ApplicationDeploymentDescriptorFile file = new ApplicationDeploymentDescriptorFile();
                    ApplicationType app = (ApplicationType)file.getDeploymentDescriptor(earArchive2);
                    List modules = app.getModule();
                    earArchive2.close();
                    for (ModuleType moduleInfo : modules) {
                        PathType moduleName = moduleInfo.getEjb();
                        if (moduleName == null) continue;
                        String moduleFile = ejbPath + File.separator + moduleName.getValue();
                        File module = new File(moduleFile);
                        if (logger.isLoggable(JeusMessage_Client._14_LEVEL)) {
                            logger.log(JeusMessage_Client._14_LEVEL, JeusMessage_Client._14, (Object)moduleFile);
                        }
                        uriList.add(module.toURI());
                        module = new File(moduleFile = FileUtils.getPathWithoutExtension((String)moduleFile, (String)".jar") + "_client");
                        if (!module.exists()) continue;
                        if (logger.isLoggable(JeusMessage_Client._15_LEVEL)) {
                            logger.log(JeusMessage_Client._15_LEVEL, JeusMessage_Client._15, (Object)moduleFile);
                        }
                        uriList.add(module.toURI());
                    }
                    continue;
                }
                uriList.add(new File(ejbJarPath).toURI());
                continue;
            }
            if (!logger.isLoggable(JeusMessage_Client._16_LEVEL)) continue;
            logger.log(JeusMessage_Client._16_LEVEL, JeusMessage_Client._16, (Object)ejbJarPath);
        }
    }

    private static void addJarFilesToUriList(FileArchive libArchive, Set<URI> uriList) throws IOException {
        Enumeration e = libArchive.entries();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (FileUtils.isExploded((String)libArchive.getArchiveUri(), (String)s) || !s.endsWith(".jar")) continue;
            uriList.add(new File(libArchive.getArchiveUri(), s).toURI());
        }
    }

    private static void addClasspathURIs(AbstractArchive archive, Set<URI> uriList) throws IOException {
        Attributes attribs;
        String classpathStr;
        Manifest manifest = archive.getManifest();
        if (manifest != null && (classpathStr = (attribs = manifest.getMainAttributes()).getValue(Attributes.Name.CLASS_PATH)) != null) {
            String archivePath = archive.getArchiveUri();
            File archiveFile = new File(archivePath);
            assert (archiveFile.isAbsolute());
            File parentFile = archiveFile.getParentFile();
            StringTokenizer st = new StringTokenizer(classpathStr, " " + File.pathSeparatorChar);
            while (st.hasMoreTokens()) {
                String path = st.nextToken();
                if (path.trim().equals("")) continue;
                File classpath = new File(parentFile, path);
                if (logger.isLoggable(JeusMessage_Client._22_LEVEL)) {
                    logger.log(JeusMessage_Client._22_LEVEL, JeusMessage_Client._22, (Object)classpath);
                }
                uriList.add(classpath.toURI());
                if (!classpath.exists()) continue;
                AbstractArchive jarArchive = JarArchiveFactory.openArchiveStatic((File)classpath);
                ClientContainer.addClasspathURIs(jarArchive, uriList);
            }
        }
    }

    private static void preInvoke() throws JeusRuntimeException, ClassNotFoundException {
        String envRoot;
        block21: {
            String moduleName;
            System.setProperty("java.naming.factory.initial", "jeus.jndi.JNSContextFactory");
            try {
                SystemLoggingType systemLog = appClientPair.getSystemLog();
                if (systemLog != null) {
                    JeusLoggerConfiguration.setDefaultConsoleHandler(systemLog);
                    JeusLoggerConfiguration.configLogger(logger, systemLog);
                }
            }
            catch (Throwable ex) {
                throw new JeusRuntimeException("a problem in client container initialization(1)", ex);
            }
            if (appClientVersion >= 5.0) {
                try {
                    ClientContainer.scanPersistenceUnits();
                    ClientContainer.loadPersistenceUnits();
                }
                catch (Throwable e) {
                    throw new JeusRuntimeException("Error loading JPA persistence units", e);
                }
            }
            if ((moduleName = appClientPair.getModuleInfoModuleName()) == null) {
                moduleName = "client";
            }
            envRoot = "_" + moduleName;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("jeus.app.name", moduleName);
            map.put("jeus.jndi.enc.prefix", envRoot);
            ExecutionContext.push(map);
            try {
                RMISocketFactory.setSocketFactory(new EJBRMISocketFactory());
                if (isTextAuth) {
                    SecurityUtil.installClientSecurity("localhost");
                    if (USER_VALUE != null && PASSWORD_VALUE != null) {
                        LoginUtil.loginWithRuntimeException(Subject.makeSubject(USER_VALUE, PASSWORD_VALUE));
                    }
                } else if (appClientPair.getSecurityInfo() != null) {
                    String hostname = appClientPair.getSecurityProviderNodeName();
                    SecurityUtil.installClientSecurity(hostname);
                    String username = appClientPair.getSecurityInfoUser();
                    String passwd = appClientPair.getSecurityInfoPasswd();
                    if (username != null && passwd != null) {
                        LoginUtil.loginWithRuntimeException(Subject.makeSubject(username, EncryptionUtil.decryptPasswordForClientContainer(passwd)));
                    }
                }
                if (!appClientPair.isScheduler()) break block21;
                try {
                    scheduler = new AppClientSchedulerService();
                    scheduler.startService(appClientPair);
                }
                catch (Throwable ex) {
                    throw new JeusRuntimeException(1351, ex);
                }
            }
            catch (Throwable ex) {
                block22: {
                    try {
                        if (scheduler != null) {
                            scheduler.stopService();
                        }
                    }
                    catch (Throwable t) {
                        if (!logger.isLoggable(JeusMessage_Client._23_LEVEL)) break block22;
                        logger.log(JeusMessage_Client._23_LEVEL, JeusMessage_Client._23, t);
                    }
                }
                throw new JeusRuntimeException("a problem in client container initialization(2)", ex);
            }
        }
        ClientContainer.loadAppMainClass();
        try {
            ClientContainer.setupJNDIEnviroment(envRoot);
        }
        catch (Throwable t) {
            throw new JeusRuntimeException("a problem in client container initialization(3)", t);
        }
    }

    private static void setupJNDIEnviroment(String envRoot) throws Throwable {
        EWSProvider provider;
        boolean isJaxWsServiceRef;
        Hashtable<String, String> envs = new Hashtable<String, String>();
        envs.put("java.naming.factory.initial", "jeus.jndi.JNSContextFactory");
        envs.put("java.naming.factory.url.pkgs", "jeus.jndi.jns.url");
        envs.put("jeus.jndi.jns.localbindings", "true");
        envs.put("jeus.jndi.jns.forcedbindings", "true");
        InitialContext ctx = new InitialContext(envs);
        if (logger.isLoggable(JeusMessage_Client._26_LEVEL)) {
            logger.log(JeusMessage_Client._26_LEVEL, JeusMessage_Client._26, (Object)envRoot);
        }
        NamingEnvironment environment = null;
        if (!metadataComplete) {
            environment = AppClientHelper.processEnvironmentAnnotations(mainClass);
        }
        environment = AppClientHelper.processDescriptorEnvironmentEntries(environment, appClientDD, classLoader, mainClass.getName());
        namingEnvManager = new NamingEnvManager();
        namingEnvManager.setEnvRoot(envRoot);
        if (environment != null) {
            namingEnvManager.setNamingEnvironment(environment);
        }
        JndiEnvironmentMappingGroup mapping = new JndiEnvironmentMappingGroup();
        mapping.setSimpleEnvMapping(runtimeDD.getEnv());
        mapping.setEjbRefMapping(runtimeDD.getEjbRef());
        mapping.setResRefMapping(runtimeDD.getResRef());
        mapping.setResEnvMapping(runtimeDD.getResEnvRef());
        mapping.setMessageDistinationMapping(runtimeDD.getMessageDestinationRef());
        boolean bl = isJaxWsServiceRef = appClientVersion >= 5.0;
        if (isJaxWsServiceRef) {
            mapping.setServiceRefMapping(runtimeDD.getServiceRef());
        }
        EnvironmentContext envContext = new EnvironmentContext(mapping);
        envContext.setRootArchiveUri(appClientArchive.getArchiveUri());
        namingEnvManager.bindAllEntries(envContext);
        if (!isJaxWsServiceRef && (provider = EWSProvider.getProvider()) != null) {
            provider.bindServiceRefs(ctx, envRoot, appClientPair.getServiceRefPairs(), JeusRootClassLoader.loader);
        }
        if (appClientVersion >= 5.0) {
            namingEnvManager.resolveInjections(mainClass, null);
            namingEnvManager.invokePostConstructCallbacks(mainClass, null);
        }
        if (logger.isLoggable(JeusMessage_Client._27_LEVEL)) {
            logger.log(JeusMessage_Client._27_LEVEL, JeusMessage_Client._27);
        }
    }

    private static void readDeploymentDescriptors() throws Throwable {
        FileArchive earArchive;
        ApplicationDeploymentDescriptorFile file;
        Manifest jarManifest;
        AppClientRuntimeDDFile appClientRuntimeDDFile;
        AppClientDeploymentDescriptorFile appClientDeploymentDescriptorFile = new AppClientDeploymentDescriptorFile();
        if (appClientDeploymentDescriptorFile.existsDescriptorFile(appClientArchive)) {
            appClientDD = (ApplicationClientType)appClientDeploymentDescriptorFile.deserializeDescriptor(appClientArchive);
            if (appClientDD == null) {
                appClientDD = (ApplicationClientType)appClientDeploymentDescriptorFile.getDeploymentDescriptor(appClientArchive);
            }
            if ((appClientVersion = AppClientHelper.getVersion(appClientDD)) < 5.0) {
                metadataComplete = true;
            } else {
                boolean bl = metadataComplete = appClientDD.isSetMetadataComplete() && appClientDD.isMetadataComplete();
            }
            if (logger.isLoggable(JeusMessage_Client._44_LEVEL)) {
                logger.log(JeusMessage_Client._44_LEVEL, JeusMessage_Client._44, (Object)appClientVersion);
            }
        }
        if ((appClientRuntimeDDFile = new AppClientRuntimeDDFile()).existsDescriptorFile(appClientArchive)) {
            runtimeDD = (JeusClientDdType)appClientRuntimeDDFile.deserializeDescriptor(appClientArchive);
            if (runtimeDD == null) {
                runtimeDD = (JeusClientDdType)appClientRuntimeDDFile.getDeploymentDescriptor(appClientArchive);
            }
        } else {
            runtimeDD = (JeusClientDdType)appClientRuntimeDDFile.newDeploymentDescriptor();
        }
        if ((jarManifest = appClientArchive.getManifest()) != null) {
            String mainClass = jarManifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            if (logger.isLoggable(JeusMessage_Client._31_LEVEL)) {
                logger.log(JeusMessage_Client._31_LEVEL, JeusMessage_Client._31, (Object)mainClass);
            }
            if (mainClass != null && !mainClass.equals("")) {
                runtimeDD.getModuleInfo().setAppMainClass(mainClass);
            }
        }
        if (appArgs.size() > 0) {
            StringBuffer appArgStr = new StringBuffer();
            for (int i = 0; i < appArgs.size(); ++i) {
                appArgStr.append((String)appArgs.get(i));
                if (i >= appArgs.size() - 1) continue;
                appArgStr.append(" ");
            }
            runtimeDD.getModuleInfo().setAppArgument(appArgStr.toString());
        }
        appClientPair = new AppClientPair(appClientDD, runtimeDD);
        JeusWebservicesClientDdType jeusWsClientDD = runtimeDD.getServiceRef();
        if (jeusWsClientDD != null) {
            if (logger.isLoggable(JeusMessage_Client._34_LEVEL)) {
                logger.log(JeusMessage_Client._34_LEVEL, JeusMessage_Client._34, (Object)appClientArchive.getArchiveUri());
            }
            if (logger.isLoggable(JeusMessage_Client._35_LEVEL)) {
                logger.log(JeusMessage_Client._35_LEVEL, JeusMessage_Client._35, (Object)jeusWsClientDD);
            }
            appClientPair.setJeusWebservicesClientDD(jeusWsClientDD);
        }
        if (!isStandalone && (file = new ApplicationDeploymentDescriptorFile()).existsDescriptorFile((AbstractArchive)(earArchive = (FileArchive)FileArchiveFactory.openArchiveStatic((String)earPath))) && (appDescriptor = (ApplicationType)file.deserializeDescriptor((AbstractArchive)earArchive)) == null) {
            appDescriptor = (ApplicationType)file.getDeploymentDescriptor((AbstractArchive)earArchive);
        }
    }

    private static void invokeMain() {
        block10: {
            try {
                String[] args = appClientPair.getMoudleInfoAppArgument();
                if (logger.isLoggable(JeusMessage_Client._38_LEVEL)) {
                    StringBuffer buf = new StringBuffer(128);
                    buf.append("[").append(mainClass.getName()).append(":");
                    for (int i = 0; i < args.length; ++i) {
                        if (i != 0) {
                            buf.append(",");
                        }
                        buf.append(args[i]);
                    }
                    buf.append("]");
                    logger.log(JeusMessage_Client._38_LEVEL, JeusMessage_Client._38, (Object)buf.toString());
                }
                if (logger.isLoggable(JeusMessage_Client._39_LEVEL)) {
                    logger.log(JeusMessage_Client._39_LEVEL, JeusMessage_Client._39);
                }
                if (logger.isLoggable(JeusMessage_Client._25_LEVEL)) {
                    logger.log(JeusMessage_Client._25_LEVEL, JeusMessage_Client._25, new Object[]{LoginService.getCurrentPrincipal(), Thread.currentThread().toString()});
                }
                if (logger.isLoggable(JeusMessage_Client._45_LEVEL)) {
                    long now = System.currentTimeMillis();
                    long time = now - startTime;
                    logger.log(JeusMessage_Client._45_LEVEL, JeusMessage_Client._45, (Object)time);
                }
                Class[] argTypes = new Class[]{new String[0].getClass()};
                Method mainMethod = mainClass.getDeclaredMethod("main", argTypes);
                mainMethod.invoke(null, new Object[]{args});
            }
            catch (InvocationTargetException ex) {
                Throwable t = ex.getTargetException();
                if (logger.isLoggable(JeusMessage_Client._46_LEVEL)) {
                    logger.log(JeusMessage_Client._46_LEVEL, JeusMessage_Client._46, t);
                }
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_Client._46_LEVEL)) break block10;
                logger.log(JeusMessage_Client._46_LEVEL, JeusMessage_Client._46, t);
            }
        }
    }

    private static void loadAppMainClass() throws ClassNotFoundException {
        if (mainClassName == null) {
            mainClassName = appClientPair.getModuleInfoAppMainClass();
        }
        if (logger.isLoggable(JeusMessage_Client._36_LEVEL)) {
            logger.log(JeusMessage_Client._36_LEVEL, JeusMessage_Client._36, (Object)mainClassName);
        }
        if (mainClassName == null) {
            throw new ClassNotFoundException("There is no main class");
        }
        if (logger.isLoggable(JeusMessage_Client._37_LEVEL)) {
            logger.log(JeusMessage_Client._37_LEVEL, JeusMessage_Client._37, (Object)classLoader);
        }
        if (logger.isLoggable(JeusMessage_Client._47_LEVEL)) {
            String out = "";
            for (URL u : ((URLClassLoader)ClientContainer.class.getClassLoader()).getURLs()) {
                out = out + u + ":";
            }
            logger.log(JeusMessage_Client._47_LEVEL, JeusMessage_Client._47, (Object)out);
            String clsFile = mainClassName.replace(".", "/") + ".class";
            URL url = classLoader.getResource(clsFile);
            logger.log(JeusMessage_Client._48_LEVEL, JeusMessage_Client._48, (Object)url);
        }
        mainClass = classLoader.loadClassWithoutDelegation(mainClassName, true);
    }

    private static void postInvoke() {
        block7: {
            block6: {
                try {
                    namingEnvManager.invokePreDestroyCallbacks(mainClass, null);
                }
                catch (Throwable ex) {
                    if (!logger.isLoggable(JeusMessage_Client._49_LEVEL)) break block6;
                    logger.log(JeusMessage_Client._49_LEVEL, JeusMessage_Client._49, ex);
                }
            }
            if (scheduler != null) {
                try {
                    scheduler.stopService();
                    scheduler = null;
                }
                catch (Throwable ex) {
                    if (!logger.isLoggable(JeusMessage_Client._41_LEVEL)) break block7;
                    logger.log(JeusMessage_Client._41_LEVEL, JeusMessage_Client._41, ex);
                }
            }
        }
        ClientContainer.unloadPersistenceUnits();
        if (logger.isLoggable(JeusMessage_Client._42_LEVEL)) {
            logger.log(JeusMessage_Client._42_LEVEL, JeusMessage_Client._42);
        }
        logger.flush();
        logger.close();
    }

    private static void usage() {
        if (logger.isLoggable(JeusMessage_Client._51_LEVEL)) {
            logger.log(JeusMessage_Client._51_LEVEL, JeusMessage_Client._51);
        }
        System.exit(1);
    }

    private static void scanPersistenceUnits() throws IOException, DeploymentException {
        Persistence puDescriptor;
        String puPath;
        if (!isStandalone && !(puPath = properties.getEarPersistenceUnitPath()).equals("")) {
            FileArchive earArchive = (FileArchive)FileArchiveFactory.openArchiveStatic((String)earPath);
            StringTokenizer tokens = new StringTokenizer(puPath, ":");
            while (tokens.hasMoreTokens()) {
                String puUri = tokens.nextToken();
                if (puUri.equals("")) continue;
                AbstractArchive subArchive = null;
                try {
                    subArchive = earArchive.getEmbeddedArchive(puUri);
                    Persistence puDescriptor2 = ClientContainer.getPersistenceDescriptor(subArchive);
                    if (puDescriptor2 == null) continue;
                    if (logger.isLoggable(JeusMessage_JPA._1_LEVEL)) {
                        logger.log(JeusMessage_JPA._1_LEVEL, JeusMessage_JPA._1, (Object)puUri);
                    }
                    File puFile = new File(earArchive.getArchiveUri(), puUri.replace('/', File.separatorChar));
                    PersistenceUnits pu = new PersistenceUnits(puUri, puFile, puDescriptor2);
                    persistenceUnits.put(puUri, pu);
                }
                catch (IOException ex) {
                    throw new DeploymentException(ex);
                }
                finally {
                    try {
                        if (subArchive == null) continue;
                        subArchive.close();
                    }
                    catch (IOException ex) {}
                }
            }
            earArchive.close();
        }
        if ((puDescriptor = ClientContainer.getPersistenceDescriptor(appClientArchive)) != null) {
            File puFile = new File(appClientArchive.getArchiveUri());
            PersistenceUnits pu = new PersistenceUnits("", puFile, puDescriptor);
            persistenceUnits.put("", pu);
        }
    }

    private static Persistence getPersistenceDescriptor(AbstractArchive puRootArchive) throws DeploymentException {
        Persistence persistence;
        try {
            PersistenceDescriptorFile descFile = new PersistenceDescriptorFile();
            if (!descFile.existsDescriptorFile(puRootArchive)) {
                return null;
            }
            if (logger.isLoggable(JeusMessage_JPA._2_LEVEL)) {
                logger.log(JeusMessage_JPA._2_LEVEL, JeusMessage_JPA._2);
            }
            persistence = (Persistence)descFile.getDeploymentDescriptor(puRootArchive);
            if (logger.isLoggable(JeusMessage_JPA._3_LEVEL)) {
                logger.log(JeusMessage_JPA._3_LEVEL, JeusMessage_JPA._3);
            }
        }
        catch (Exception ex) {
            logger.log(JeusMessage_JPA._4_LEVEL, JeusMessage_JPA._4);
            throw new DeploymentException(ex);
        }
        return persistence;
    }

    private static void loadPersistenceUnits() throws DeploymentException {
        try {
            for (String puUri : persistenceUnits.keySet()) {
                PersistenceUnits pu = persistenceUnits.get(puUri);
                String puPath = pu.getPersistenceUnitRootFile().getAbsolutePath();
                if (logger.isLoggable(JeusMessage_JPA._5_LEVEL)) {
                    logger.log(JeusMessage_JPA._5_LEVEL, JeusMessage_JPA._5, (Object)puPath);
                }
                pu.load(classLoader);
                if (!logger.isLoggable(JeusMessage_JPA._6_LEVEL)) continue;
                logger.log(JeusMessage_JPA._6_LEVEL, JeusMessage_JPA._6, (Object)puPath);
            }
        }
        catch (DeploymentException ex) {
            if (logger.isLoggable(JeusMessage_JPA._7_LEVEL)) {
                logger.log(JeusMessage_JPA._7_LEVEL, JeusMessage_JPA._7, (Throwable)ex);
            }
            throw ex;
        }
    }

    private static void unloadPersistenceUnits() {
        for (PersistenceUnits pu : persistenceUnits.values()) {
            pu.close();
        }
    }

    public static PersistenceUnit lookupPersistenceUnit(String qualifiedUnitName) throws PersistenceUnitNotFoundException {
        String[] str = EnvUtil.getUriAndName(qualifiedUnitName);
        String puUri = str[0];
        String unitName = str[1];
        PersistenceUnit pu = null;
        if (!puUri.equals("")) {
            if (isStandalone) {
                throw new PersistenceUnitNotFoundException("standalone module cannot use absolute URI pathname");
            }
            try {
                puUri = EnvUtil.getCanonicalPath(moduleUri, puUri);
            }
            catch (IllegalArgumentException e) {
                throw new PersistenceUnitNotFoundException();
            }
            PersistenceUnits pus = persistenceUnits.get(puUri);
            if (pus == null) {
                throw new PersistenceUnitNotFoundException();
            }
            pu = pus.getPersistenceUnit(unitName);
            if (pu == null) {
                throw new PersistenceUnitNotFoundException();
            }
            return pu;
        }
        if (persistenceUnits.containsKey("")) {
            PersistenceUnits pus = persistenceUnits.get("");
            if (unitName == null || unitName.trim().equals("")) {
                Collection<PersistenceUnit> managers = pus.getPersistenceUnitCollection();
                if (managers.size() > 1) {
                    throw new PersistenceUnitNotFoundException("There are more than one persistence unit. So unitName should be given");
                }
                if (managers.size() == 1) {
                    return managers.iterator().next();
                }
            } else {
                pu = pus.getPersistenceUnit(unitName);
            }
            if (pu != null) {
                return pu;
            }
        }
        for (PersistenceUnits pus : persistenceUnits.values()) {
            if (pus.getPersistenceUnitUri().equals("")) continue;
            if (unitName == null || unitName.trim().equals("")) {
                Collection<PersistenceUnit> managers = pus.getPersistenceUnitCollection();
                if (managers.size() > 1) {
                    throw new PersistenceUnitNotFoundException("There are more than one persistence unit. So unitName should be given");
                }
                if (managers.size() == 1) {
                    return managers.iterator().next();
                }
            } else {
                pu = pus.getPersistenceUnit(unitName);
            }
            if (pu == null) continue;
            return pu;
        }
        throw new PersistenceUnitNotFoundException();
    }

    static {
        appClientDD = null;
        runtimeDD = null;
        appClientPair = null;
        appClientVersion = 5.0;
        isStandalone = true;
        clientPath = null;
        ejbJarPath = null;
        appArgs = new Vector();
        persistenceUnits = new HashMap<String, PersistenceUnits>();
        PROPERTY_JWSMODE = "jeus.client.container.jws";
    }

    private static class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        public void run() {
            ClientContainer.postInvoke();
        }
    }
}

