/*
 * Decompiled with CFR 0.152.
 */
package jeus.connector;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import jeus.util.logging.JeusLogger;

public class CodeGenerator {
    private static final JeusLogger logger = (JeusLogger)Logger.getLogger("jeus.connector");
    private static final String superclassName = "java/lang/reflect/Proxy";
    private static final String handlerFieldName = "h";
    private static Method hashCodeMethod;
    private static Method equalsMethod;
    private static Method toStringMethod;
    private String className;
    private Class interfaces;
    private Class handler;
    private ConstantPool cp = new ConstantPool();
    private List fields = new ArrayList();
    private List methods = new ArrayList();
    private Map proxyMethods = new HashMap(11);
    public String implName;

    private byte[] generateClassFile(Class implClass) {
        this.implName = implClass.getName();
        Method[] intMethods = this.interfaces.getMethods();
        for (int k = 0; k < intMethods.length; ++k) {
            this.addProxyMethod(intMethods[k]);
        }
        try {
            this.fields.add(new FieldInfo("_mch", "Ljeus/connector/ManagedConnectionHandler;", 2));
            this.fields.add(new FieldInfo("_connection", "L" + CodeGenerator.dotToSlash(this.implName) + ";", 2));
            this.fields.add(new FieldInfo("_lastAccessTime", "J", 2));
            this.fields.add(new FieldInfo("_dissociated", "Z", 2));
            this.methods.add(this.generateConstructor());
            this.methods.add(this.generateAccessTimeSetterMethod());
            this.methods.add(this.generateAccessTimeGetterMethod());
            this.methods.add(this.generateAssociationMethod());
            this.methods.add(this.generateMarkerMethod());
            this.methods.add(this.generateReturnWrappedMethod());
            for (ProxyMethod proxymethod : this.proxyMethods.values()) {
                this.methods.add(proxymethod.generateMethod());
            }
        }
        catch (IOException ioexception) {
            throw new InternalError("unexpected I/O Exception");
        }
        this.cp.getClass(CodeGenerator.dotToSlash(this.className));
        this.cp.getClass("java/lang/Object");
        this.cp.getClass(CodeGenerator.dotToSlash(this.interfaces.getName()));
        this.cp.getClass(CodeGenerator.dotToSlash(this.interfaces.getName()));
        this.cp.getClass(CodeGenerator.dotToSlash(this.handler.getName()));
        this.cp.setReadOnly();
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        DataOutputStream dataoutputstream = new DataOutputStream(bytearrayoutputstream);
        try {
            dataoutputstream.writeInt(-889275714);
            dataoutputstream.writeShort(3);
            dataoutputstream.writeShort(45);
            this.cp.write(dataoutputstream);
            dataoutputstream.writeShort(49);
            dataoutputstream.writeShort(this.cp.getClass(CodeGenerator.dotToSlash(this.className)));
            dataoutputstream.writeShort(this.cp.getClass("java/lang/Object"));
            dataoutputstream.writeShort(2);
            dataoutputstream.writeShort(this.cp.getClass(CodeGenerator.dotToSlash(this.interfaces.getName())));
            dataoutputstream.writeShort(this.cp.getClass(CodeGenerator.dotToSlash(this.handler.getName())));
            dataoutputstream.writeShort(this.fields.size());
            for (FieldInfo fieldinfo : this.fields) {
                fieldinfo.write(dataoutputstream);
            }
            dataoutputstream.writeShort(this.methods.size());
            for (MethodInfo methodinfo : this.methods) {
                methodinfo.write(dataoutputstream);
            }
            dataoutputstream.writeShort(0);
        }
        catch (IOException ioexception1) {
            throw new InternalError("unexpected I/O Exception");
        }
        return bytearrayoutputstream.toByteArray();
    }

    private static void _assert(boolean flag) {
        if (!flag) {
            throw new Error("assertion failure");
        }
    }

    private void codeLocalLoadStore(int localVar, int j, int k, DataOutputStream dataoutputstream) throws IOException {
        CodeGenerator._assert(localVar >= 0 && localVar <= 65535);
        if (localVar <= 3) {
            dataoutputstream.writeByte(k + localVar);
        } else if (localVar <= 255) {
            dataoutputstream.writeByte(j);
            dataoutputstream.writeByte(localVar & 0xFF);
        } else {
            dataoutputstream.writeByte(196);
            dataoutputstream.writeByte(j);
            dataoutputstream.writeShort(localVar & 0xFFFF);
        }
    }

    private void code_aload(int localVar, DataOutputStream dataoutputstream) throws IOException {
        this.codeLocalLoadStore(localVar, 25, 42, dataoutputstream);
    }

    private void code_astore(int i, DataOutputStream dataoutputstream) throws IOException {
        this.codeLocalLoadStore(i, 58, 75, dataoutputstream);
    }

    private void code_dload(int i, DataOutputStream dataoutputstream) throws IOException {
        this.codeLocalLoadStore(i, 24, 38, dataoutputstream);
    }

    private void code_dstore(int i, DataOutputStream dataoutputstream) throws IOException {
        this.codeLocalLoadStore(i, 57, 71, dataoutputstream);
    }

    private void code_fload(int i, DataOutputStream dataoutputstream) throws IOException {
        this.codeLocalLoadStore(i, 23, 34, dataoutputstream);
    }

    private void code_fstore(int i, DataOutputStream dataoutputstream) throws IOException {
        this.codeLocalLoadStore(i, 56, 67, dataoutputstream);
    }

    private void code_iload(int i, DataOutputStream dataoutputstream) throws IOException {
        this.codeLocalLoadStore(i, 21, 26, dataoutputstream);
    }

    private void code_ipush(int i, DataOutputStream dataoutputstream) throws IOException {
        if (i >= -1 && i <= 5) {
            dataoutputstream.writeByte(3 + i);
        } else if (i >= -128 && i <= 127) {
            dataoutputstream.writeByte(16);
            dataoutputstream.writeByte(i & 0xFF);
        } else if (i >= Short.MIN_VALUE && i <= Short.MAX_VALUE) {
            dataoutputstream.writeByte(17);
            dataoutputstream.writeShort(i & 0xFFFF);
        } else {
            CodeGenerator._assert(false);
        }
    }

    private void code_istore(int i, DataOutputStream dataoutputstream) throws IOException {
        this.codeLocalLoadStore(i, 54, 59, dataoutputstream);
    }

    private void code_ldc(int i, DataOutputStream dataoutputstream) throws IOException {
        CodeGenerator._assert(i >= 0 && i <= 65535);
        if (i <= 255) {
            dataoutputstream.writeByte(18);
            dataoutputstream.writeByte(i & 0xFF);
        } else {
            dataoutputstream.writeByte(19);
            dataoutputstream.writeShort(i & 0xFFFF);
        }
    }

    private void code_lload(int i, DataOutputStream dataoutputstream) throws IOException {
        this.codeLocalLoadStore(i, 22, 30, dataoutputstream);
    }

    private void code_lstore(int i, DataOutputStream dataoutputstream) throws IOException {
        this.codeLocalLoadStore(i, 55, 63, dataoutputstream);
    }

    private static int getWordsPerType(Class class1) {
        return class1 != Long.TYPE && class1 != Double.TYPE ? 1 : 2;
    }

    private MethodInfo generateConstructor() throws IOException {
        MethodInfo methodinfo = new MethodInfo("<init>", "(Ljeus/connector/ManagedConnectionHandler;L" + CodeGenerator.dotToSlash(this.implName) + ";)V", 1);
        DataOutputStream dataoutputstream = new DataOutputStream(methodinfo.code);
        this.code_aload(0, dataoutputstream);
        dataoutputstream.writeByte(183);
        dataoutputstream.writeShort(this.cp.getMethodRef("java/lang/Object", "<init>", "()V"));
        this.code_aload(0, dataoutputstream);
        this.code_aload(1, dataoutputstream);
        dataoutputstream.writeByte(181);
        dataoutputstream.writeShort(this.cp.getFieldRef(CodeGenerator.dotToSlash(this.className), "_mch", "Ljeus/connector/ManagedConnectionHandler;"));
        this.code_aload(0, dataoutputstream);
        this.code_aload(2, dataoutputstream);
        dataoutputstream.writeByte(181);
        dataoutputstream.writeShort(this.cp.getFieldRef(CodeGenerator.dotToSlash(this.className), "_connection", "L" + CodeGenerator.dotToSlash(this.implName) + ";"));
        dataoutputstream.writeByte(177);
        methodinfo.maxStack = (short)10;
        methodinfo.maxLocals = (short)3;
        methodinfo.declaredExceptions = new short[0];
        return methodinfo;
    }

    private MethodInfo generateReturnWrappedMethod() throws IOException {
        String signature = "()Ljava/lang/Object;";
        MethodInfo methodinfo = new MethodInfo("getConnection", signature, 17);
        DataOutputStream dataoutputstream = new DataOutputStream(methodinfo.code);
        this.code_aload(0, dataoutputstream);
        dataoutputstream.writeByte(180);
        dataoutputstream.writeShort(this.cp.getFieldRef(CodeGenerator.dotToSlash(this.className), "_connection", "L" + CodeGenerator.dotToSlash(this.implName) + ";"));
        dataoutputstream.writeByte(176);
        methodinfo.maxStack = (short)2;
        methodinfo.maxLocals = 1;
        methodinfo.declaredExceptions = new short[0];
        return methodinfo;
    }

    private MethodInfo generateAccessTimeSetterMethod() throws IOException {
        String signature = "(J)V";
        MethodInfo methodinfo = new MethodInfo("setLastAccessTime", signature, 17);
        DataOutputStream dataoutputstream = new DataOutputStream(methodinfo.code);
        this.code_aload(0, dataoutputstream);
        this.code_lload(1, dataoutputstream);
        dataoutputstream.writeByte(181);
        dataoutputstream.writeShort(this.cp.getFieldRef(CodeGenerator.dotToSlash(this.className), "_lastAccessTime", "J"));
        dataoutputstream.writeByte(177);
        methodinfo.maxStack = (short)3;
        methodinfo.maxLocals = (short)3;
        methodinfo.declaredExceptions = new short[0];
        return methodinfo;
    }

    private MethodInfo generateAccessTimeGetterMethod() throws IOException {
        String signature = "()J";
        MethodInfo methodinfo = new MethodInfo("getLastAccessTime", signature, 17);
        DataOutputStream dataoutputstream = new DataOutputStream(methodinfo.code);
        this.code_aload(0, dataoutputstream);
        dataoutputstream.writeByte(180);
        dataoutputstream.writeShort(this.cp.getFieldRef(CodeGenerator.dotToSlash(this.className), "_lastAccessTime", "J"));
        dataoutputstream.writeByte(173);
        methodinfo.maxStack = (short)2;
        methodinfo.maxLocals = 1;
        methodinfo.declaredExceptions = new short[0];
        return methodinfo;
    }

    private MethodInfo generateMarkerMethod() throws IOException {
        String signature = "()Z";
        MethodInfo methodinfo = new MethodInfo("setDissociated", signature, 17);
        DataOutputStream dataoutputstream = new DataOutputStream(methodinfo.code);
        this.code_aload(0, dataoutputstream);
        dataoutputstream.writeByte(180);
        dataoutputstream.writeShort(this.cp.getFieldRef(CodeGenerator.dotToSlash(this.className), "_dissociated", "Z"));
        dataoutputstream.writeByte(172);
        methodinfo.maxStack = (short)2;
        methodinfo.maxLocals = 1;
        methodinfo.declaredExceptions = new short[0];
        return methodinfo;
    }

    private MethodInfo generateAssociationMethod() throws IOException {
        String signature = "(Ljeus/connector/ManagedConnectionHandler;)V";
        MethodInfo methodinfo = new MethodInfo("associateManagedConnectionHandler", signature, 17);
        DataOutputStream dataoutputstream = new DataOutputStream(methodinfo.code);
        this.code_aload(0, dataoutputstream);
        this.code_aload(1, dataoutputstream);
        dataoutputstream.writeByte(181);
        dataoutputstream.writeShort(this.cp.getFieldRef(CodeGenerator.dotToSlash(this.className), "_mch", "Ljeus/connector/ManagedConnectionHandler;"));
        dataoutputstream.writeByte(177);
        methodinfo.maxStack = (short)3;
        methodinfo.maxLocals = (short)2;
        methodinfo.declaredExceptions = new short[0];
        return methodinfo;
    }

    private void codeClassForName(Class class1, DataOutputStream dataoutputstream) throws IOException {
        this.code_ldc(this.cp.getString(class1.getName()), dataoutputstream);
        dataoutputstream.writeByte(184);
        dataoutputstream.writeShort(this.cp.getMethodRef("java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;"));
    }

    private CodeGenerator(String s, Class aclass, Class bclass) {
        this.className = s;
        this.interfaces = aclass;
        this.handler = bclass;
    }

    public static byte[] generateProxyClass(String name, Class[] interfaces, Class implClass) {
        CodeGenerator proxygenerator = new CodeGenerator(name, interfaces[0], interfaces[1]);
        byte[] byteForm = proxygenerator.generateClassFile(implClass);
        return byteForm;
    }

    private void addProxyMethod(Method method) {
        String methodName = method.getName();
        Class[] parameterTypes = method.getParameterTypes();
        Class<?> returnType = method.getReturnType();
        Class[] exceptions = method.getExceptionTypes();
        String methodExpression = methodName + CodeGenerator.getParameterDescriptors(parameterTypes);
        ProxyMethod proxymethod = (ProxyMethod)this.proxyMethods.get(methodExpression);
        if (proxymethod != null) {
            if (returnType != proxymethod.returnType) {
                throw new IllegalArgumentException("methods with same name and parameter signature but different return type in " + proxymethod.fromClass);
            }
            ArrayList arraylist = new ArrayList();
            CodeGenerator.collectCompatibleTypes(exceptions, proxymethod.exceptionTypes, arraylist);
            CodeGenerator.collectCompatibleTypes(proxymethod.exceptionTypes, exceptions, arraylist);
            proxymethod.exceptionTypes = new Class[arraylist.size()];
            proxymethod.exceptionTypes = arraylist.toArray(proxymethod.exceptionTypes);
        } else {
            ProxyMethod proxymethod1 = new ProxyMethod(methodName, parameterTypes, returnType, exceptions);
            this.proxyMethods.put(methodExpression, proxymethod1);
        }
    }

    private static String getFieldType(Class class1) {
        if (class1.isPrimitive()) {
            return PrimitiveTypeInfo.get((Class)class1).baseTypeString;
        }
        if (class1.isArray()) {
            return class1.getName().replace('.', '/');
        }
        return "L" + CodeGenerator.dotToSlash(class1.getName()) + ";";
    }

    private static String getParameterDescriptors(Class[] aclass) {
        StringBuffer stringbuffer = new StringBuffer("(");
        for (int i = 0; i < aclass.length; ++i) {
            stringbuffer.append(CodeGenerator.getFieldType(aclass[i]));
        }
        stringbuffer.append(')');
        return stringbuffer.toString();
    }

    private static String dotToSlash(String s) {
        return s.replace('.', '/');
    }

    private static List computeUniqueCatchList(Class[] aclass) {
        ArrayList<Class> arraylist = new ArrayList<Class>();
        arraylist.add(Error.class);
        arraylist.add(RuntimeException.class);
        block0: for (int i = 0; i < aclass.length; ++i) {
            Class class1 = aclass[i];
            if (class1.isAssignableFrom(Throwable.class)) {
                arraylist.clear();
                break;
            }
            if (!Throwable.class.isAssignableFrom(class1)) continue;
            int j = 0;
            while (j < arraylist.size()) {
                Class class2 = (Class)arraylist.get(j);
                if (class2.isAssignableFrom(class1)) continue block0;
                if (class1.isAssignableFrom(class2)) {
                    arraylist.remove(j);
                    continue;
                }
                ++j;
            }
            arraylist.add(class1);
        }
        return arraylist;
    }

    private static String getMethodDescriptor(Class[] aclass, Class class1) {
        return CodeGenerator.getParameterDescriptors(aclass) + (class1 != Void.TYPE ? CodeGenerator.getFieldType(class1) : "V");
    }

    private static void collectCompatibleTypes(Class[] aclass, Class[] aclass1, List list) {
        block0: for (int i = 0; i < aclass.length; ++i) {
            if (list.contains(aclass[i])) continue;
            for (int j = 0; j < aclass1.length; ++j) {
                if (!aclass1[j].isAssignableFrom(aclass[i])) continue;
                list.add(aclass[i]);
                continue block0;
            }
        }
    }

    static {
        try {
            hashCodeMethod = Object.class.getMethod("hashCode", null);
            equalsMethod = Object.class.getMethod("equals", Object.class);
            toStringMethod = Object.class.getMethod("toString", null);
        }
        catch (NoSuchMethodException nosuchmethodexception) {
            throw new NoSuchMethodError(nosuchmethodexception.getMessage());
        }
    }

    private class ProxyMethod {
        public String methodName;
        public Class[] parameterTypes;
        public Class[] exceptionTypes;
        public Class returnType;
        public Class fromClass;

        private MethodInfo generateMethod() throws IOException {
            String signature = CodeGenerator.getMethodDescriptor(this.parameterTypes, this.returnType);
            MethodInfo methodinfo = new MethodInfo(this.methodName, signature, 17);
            int[] parameterWords = new int[this.parameterTypes.length];
            int totalWords = 0;
            for (int i = 0; i < parameterWords.length; ++i) {
                parameterWords[i] = totalWords;
                totalWords += CodeGenerator.getWordsPerType(this.parameterTypes[i]);
            }
            DataOutputStream dataoutputstream = new DataOutputStream(methodinfo.code);
            CodeGenerator.this.code_aload(0, dataoutputstream);
            dataoutputstream.writeByte(180);
            dataoutputstream.writeShort(CodeGenerator.this.cp.getFieldRef(CodeGenerator.dotToSlash(CodeGenerator.this.className), "_mch", "Ljeus/connector/ManagedConnectionHandler;"));
            dataoutputstream.writeByte(89);
            CodeGenerator.this.code_astore(1 + totalWords, dataoutputstream);
            dataoutputstream.writeByte(194);
            short startGlobal = (short)methodinfo.code.size();
            CodeGenerator.this.code_aload(0, dataoutputstream);
            dataoutputstream.writeByte(180);
            dataoutputstream.writeShort(CodeGenerator.this.cp.getFieldRef(CodeGenerator.dotToSlash(CodeGenerator.this.className), "_dissociated", "Z"));
            dataoutputstream.writeByte(154);
            int jump = 31;
            if (totalWords > 1) {
                jump = (short)(jump + 3);
            }
            dataoutputstream.writeShort(jump);
            short start = (short)methodinfo.code.size();
            dataoutputstream.writeByte(42);
            dataoutputstream.writeByte(180);
            dataoutputstream.writeShort(CodeGenerator.this.cp.getFieldRef(CodeGenerator.dotToSlash(CodeGenerator.this.className), "_mch", "Ljeus/connector/ManagedConnectionHandler;"));
            dataoutputstream.writeByte(42);
            dataoutputstream.writeByte(182);
            dataoutputstream.writeShort(CodeGenerator.this.cp.getMethodRef("jeus/connector/ManagedConnectionHandler", "checkStatus", "(Ljava/lang/Object;)V"));
            short end = (short)methodinfo.code.size();
            dataoutputstream.writeByte(167);
            dataoutputstream.writeByte(0);
            jump = 20;
            if (totalWords > 1) {
                jump = (short)(jump + 3);
            }
            dataoutputstream.writeByte(jump);
            short handler = (short)methodinfo.code.size();
            methodinfo.exceptionTable.add(new ExceptionTableEntry(start, end, handler, CodeGenerator.this.cp.getClass("java/lang/Throwable")));
            CodeGenerator.this.code_astore(2 + totalWords, dataoutputstream);
            CodeGenerator.this.code_aload(2 + totalWords, dataoutputstream);
            dataoutputstream.writeByte(182);
            dataoutputstream.writeShort(CodeGenerator.this.cp.getMethodRef("java/lang/Throwable", "printStackTrace", "()V"));
            dataoutputstream.writeByte(187);
            dataoutputstream.writeShort(CodeGenerator.this.cp.getClass("java/lang/RuntimeException"));
            dataoutputstream.writeByte(89);
            CodeGenerator.this.code_aload(2 + totalWords, dataoutputstream);
            dataoutputstream.writeByte(182);
            dataoutputstream.writeShort(CodeGenerator.this.cp.getMethodRef("java/lang/Throwable", "getMessage", "()Ljava/lang/String;"));
            dataoutputstream.writeByte(183);
            dataoutputstream.writeShort(CodeGenerator.this.cp.getMethodRef("java/lang/RuntimeException", "<init>", "(Ljava/lang/String;)V"));
            dataoutputstream.writeByte(191);
            CodeGenerator.this.code_aload(0, dataoutputstream);
            dataoutputstream.writeByte(180);
            dataoutputstream.writeShort(CodeGenerator.this.cp.getFieldRef(CodeGenerator.dotToSlash(CodeGenerator.this.className), "_connection", "L" + CodeGenerator.dotToSlash(CodeGenerator.this.implName) + ";"));
            for (int i = 1; i <= this.parameterTypes.length; ++i) {
                this.loadArgument(i, this.parameterTypes[i - 1], dataoutputstream);
            }
            dataoutputstream.writeByte(182);
            dataoutputstream.writeShort(CodeGenerator.this.cp.getMethodRef(CodeGenerator.dotToSlash(CodeGenerator.this.implName), this.methodName, signature));
            CodeGenerator.this.code_aload(1 + totalWords, dataoutputstream);
            dataoutputstream.writeByte(195);
            if (this.returnType == Void.TYPE) {
                dataoutputstream.writeByte(177);
            } else {
                this.codeUnwrapReturnValue(this.returnType, dataoutputstream);
            }
            methodinfo.exceptionTable.add(new ExceptionTableEntry(startGlobal, (short)(methodinfo.code.size() - 1), (short)methodinfo.code.size(), 0));
            start = (short)methodinfo.code.size();
            CodeGenerator.this.code_astore(3 + totalWords, dataoutputstream);
            CodeGenerator.this.code_aload(1 + totalWords, dataoutputstream);
            dataoutputstream.writeByte(195);
            end = (short)methodinfo.code.size();
            methodinfo.exceptionTable.add(new ExceptionTableEntry(start, end, start, 0));
            CodeGenerator.this.code_aload(3 + totalWords, dataoutputstream);
            dataoutputstream.writeByte(191);
            methodinfo.maxStack = (short)10;
            methodinfo.maxLocals = (short)(totalWords + 3 + 1);
            methodinfo.declaredExceptions = new short[this.exceptionTypes.length];
            for (int i1 = 0; i1 < this.exceptionTypes.length; ++i1) {
                String s = CodeGenerator.dotToSlash(this.exceptionTypes[i1].getName());
                methodinfo.declaredExceptions[i1] = CodeGenerator.this.cp.getClass(s);
            }
            return methodinfo;
        }

        private void codeWrapArgument(Class class1, int i, DataOutputStream dataoutputstream) throws IOException {
            if (class1.isPrimitive()) {
                PrimitiveTypeInfo primitivetypeinfo = PrimitiveTypeInfo.get(class1);
                dataoutputstream.writeByte(187);
                dataoutputstream.writeShort(CodeGenerator.this.cp.getClass(primitivetypeinfo.wrapperClassName));
                dataoutputstream.writeByte(89);
                if (class1 == Integer.TYPE || class1 == Boolean.TYPE || class1 == Byte.TYPE || class1 == Character.TYPE || class1 == Short.TYPE) {
                    CodeGenerator.this.code_iload(i, dataoutputstream);
                } else if (class1 == Long.TYPE) {
                    CodeGenerator.this.code_lload(i, dataoutputstream);
                } else if (class1 == Float.TYPE) {
                    CodeGenerator.this.code_fload(i, dataoutputstream);
                } else if (class1 == Double.TYPE) {
                    CodeGenerator.this.code_dload(i, dataoutputstream);
                } else {
                    CodeGenerator._assert(false);
                }
                dataoutputstream.writeByte(183);
                dataoutputstream.writeShort(CodeGenerator.this.cp.getMethodRef(primitivetypeinfo.wrapperClassName, "<init>", primitivetypeinfo.wrapperConstructorDesc));
            } else {
                CodeGenerator.this.code_aload(i, dataoutputstream);
            }
        }

        private void codeUnwrapReturnValue(Class class1, DataOutputStream dataoutputstream) throws IOException {
            if (class1.isPrimitive()) {
                if (class1 == Integer.TYPE || class1 == Boolean.TYPE || class1 == Byte.TYPE || class1 == Character.TYPE || class1 == Short.TYPE) {
                    dataoutputstream.writeByte(172);
                } else if (class1 == Long.TYPE) {
                    dataoutputstream.writeByte(173);
                } else if (class1 == Float.TYPE) {
                    dataoutputstream.writeByte(174);
                } else if (class1 == Double.TYPE) {
                    dataoutputstream.writeByte(175);
                } else {
                    CodeGenerator._assert(false);
                }
            } else {
                dataoutputstream.writeByte(176);
            }
        }

        private void loadArgument(int index, Class type, DataOutputStream dataoutputstream) throws IOException {
            if (type.isPrimitive()) {
                if (type == Integer.TYPE || type == Boolean.TYPE || type == Byte.TYPE || type == Character.TYPE || type == Short.TYPE) {
                    CodeGenerator.this.code_iload(index, dataoutputstream);
                } else if (type == Long.TYPE) {
                    CodeGenerator.this.code_lload(index, dataoutputstream);
                } else if (type == Float.TYPE) {
                    CodeGenerator.this.code_fload(index, dataoutputstream);
                } else if (type == Double.TYPE) {
                    CodeGenerator.this.code_dload(index, dataoutputstream);
                } else {
                    CodeGenerator._assert(false);
                }
            } else {
                CodeGenerator.this.code_aload(index, dataoutputstream);
            }
        }

        private ProxyMethod(String methodName, Class[] parameters, Class returnType, Class[] exceptions) {
            this.methodName = methodName;
            this.parameterTypes = parameters;
            this.returnType = returnType;
            this.exceptionTypes = exceptions;
        }
    }

    private static class PrimitiveTypeInfo {
        public String baseTypeString;
        public String wrapperClassName;
        public String wrapperConstructorDesc;
        public String unwrapMethodName;
        public String unwrapMethodDesc;
        private static Map table = new HashMap(11);

        public static PrimitiveTypeInfo get(Class class1) {
            return (PrimitiveTypeInfo)table.get(class1);
        }

        private PrimitiveTypeInfo(String s, String s1, String s2, String s3, String s4) {
            this.baseTypeString = s;
            this.wrapperClassName = s1;
            this.wrapperConstructorDesc = s2;
            this.unwrapMethodName = s3;
            this.unwrapMethodDesc = s4;
        }

        static {
            table.put(Integer.TYPE, new PrimitiveTypeInfo("I", "java/lang/Integer", "(I)V", "intValue", "()I"));
            table.put(Boolean.TYPE, new PrimitiveTypeInfo("Z", "java/lang/Boolean", "(Z)V", "booleanValue", "()Z"));
            table.put(Byte.TYPE, new PrimitiveTypeInfo("B", "java/lang/Byte", "(B)V", "byteValue", "()B"));
            table.put(Character.TYPE, new PrimitiveTypeInfo("C", "java/lang/Character", "(C)V", "charValue", "()C"));
            table.put(Short.TYPE, new PrimitiveTypeInfo("S", "java/lang/Short", "(S)V", "shortValue", "()S"));
            table.put(Long.TYPE, new PrimitiveTypeInfo("J", "java/lang/Long", "(J)V", "longValue", "()J"));
            table.put(Float.TYPE, new PrimitiveTypeInfo("F", "java/lang/Float", "(F)V", "floatValue", "()F"));
            table.put(Double.TYPE, new PrimitiveTypeInfo("D", "java/lang/Double", "(D)V", "doubleValue", "()D"));
        }
    }

    private class MethodInfo {
        public int accessFlags;
        public String name;
        public String descriptor;
        public short maxStack;
        public short maxLocals;
        public ByteArrayOutputStream code = new ByteArrayOutputStream();
        public List exceptionTable = new ArrayList();
        public short[] declaredExceptions;

        public void write(DataOutputStream dataoutputstream) throws IOException {
            dataoutputstream.writeShort(this.accessFlags);
            dataoutputstream.writeShort(CodeGenerator.this.cp.getUtf8(this.name));
            dataoutputstream.writeShort(CodeGenerator.this.cp.getUtf8(this.descriptor));
            dataoutputstream.writeShort(2);
            dataoutputstream.writeShort(CodeGenerator.this.cp.getUtf8("Code"));
            dataoutputstream.writeInt(12 + this.code.size() + 8 * this.exceptionTable.size());
            dataoutputstream.writeShort(this.maxStack);
            dataoutputstream.writeShort(this.maxLocals);
            dataoutputstream.writeInt(this.code.size());
            this.code.writeTo(dataoutputstream);
            dataoutputstream.writeShort(this.exceptionTable.size());
            for (ExceptionTableEntry exceptiontableentry : this.exceptionTable) {
                dataoutputstream.writeShort(exceptiontableentry.startPc);
                dataoutputstream.writeShort(exceptiontableentry.endPc);
                dataoutputstream.writeShort(exceptiontableentry.handlerPc);
                dataoutputstream.writeShort(exceptiontableentry.catchType);
            }
            dataoutputstream.writeShort(0);
            dataoutputstream.writeShort(CodeGenerator.this.cp.getUtf8("Exceptions"));
            dataoutputstream.writeInt(2 + 2 * this.declaredExceptions.length);
            dataoutputstream.writeShort(this.declaredExceptions.length);
            for (int i = 0; i < this.declaredExceptions.length; ++i) {
                dataoutputstream.writeShort(this.declaredExceptions[i]);
            }
        }

        public MethodInfo(String methodName, String signature, int access) {
            this.name = methodName;
            this.descriptor = signature;
            this.accessFlags = access;
            CodeGenerator.this.cp.getUtf8(methodName);
            CodeGenerator.this.cp.getUtf8(signature);
            CodeGenerator.this.cp.getUtf8("Code");
            CodeGenerator.this.cp.getUtf8("Exceptions");
        }
    }

    private class FieldInfo {
        public int accessFlags;
        public String name;
        public String descriptor;

        public void write(DataOutputStream dataoutputstream) throws IOException {
            dataoutputstream.writeShort(this.accessFlags);
            dataoutputstream.writeShort(CodeGenerator.this.cp.getUtf8(this.name));
            dataoutputstream.writeShort(CodeGenerator.this.cp.getUtf8(this.descriptor));
            dataoutputstream.writeShort(0);
        }

        public FieldInfo(String s, String s1, int i) {
            this.name = s;
            this.descriptor = s1;
            this.accessFlags = i;
            CodeGenerator.this.cp.getUtf8(s);
            CodeGenerator.this.cp.getUtf8(s1);
        }
    }

    private static class ExceptionTableEntry {
        public short startPc;
        public short endPc;
        public short handlerPc;
        public short catchType;

        public ExceptionTableEntry(short word0, short word1, short word2, short word3) {
            this.startPc = word0;
            this.endPc = word1;
            this.handlerPc = word2;
            this.catchType = word3;
        }
    }

    private static class ConstantPool {
        private List pool = new ArrayList(32);
        private Map map = new HashMap(16);
        private boolean readOnly = false;

        public void setReadOnly() {
            this.readOnly = true;
        }

        public short getFloat(float f) {
            return this.getValue(new Float(f));
        }

        public short getInteger(int i) {
            return this.getValue(new Integer(i));
        }

        public void write(OutputStream outputstream) throws IOException {
            DataOutputStream dataoutputstream = new DataOutputStream(outputstream);
            dataoutputstream.writeShort(this.pool.size() + 1);
            for (Entry entry : this.pool) {
                entry.write(dataoutputstream);
            }
        }

        private short getValue(Object obj) {
            Short short1 = (Short)this.map.get(obj);
            if (short1 != null) {
                return short1;
            }
            if (this.readOnly) {
                throw new InternalError("late constant pool addition: " + obj);
            }
            short word0 = this.addEntry(new ValueEntry(obj));
            this.map.put(obj, new Short(word0));
            return word0;
        }

        public short getClass(String s) {
            short word0 = this.getUtf8(s);
            return this.getIndirect(new IndirectEntry(7, word0));
        }

        public short getString(String s) {
            short word0 = this.getUtf8(s);
            return this.getIndirect(new IndirectEntry(8, word0));
        }

        public short getUtf8(String s) {
            if (s == null) {
                throw new NullPointerException();
            }
            return this.getValue(s);
        }

        private short addEntry(Entry entry) {
            this.pool.add(entry);
            return (short)this.pool.size();
        }

        private short getIndirect(IndirectEntry indirectentry) {
            Short short1 = (Short)this.map.get(indirectentry);
            if (short1 != null) {
                return short1;
            }
            if (this.readOnly) {
                throw new InternalError("late constant pool addition");
            }
            short word0 = this.addEntry(indirectentry);
            this.map.put(indirectentry, new Short(word0));
            return word0;
        }

        public short getNameAndType(String s, String s1) {
            short word0 = this.getUtf8(s);
            short word1 = this.getUtf8(s1);
            return this.getIndirect(new IndirectEntry(12, word0, word1));
        }

        public short getFieldRef(String clazz, String refName, String type) {
            short index1 = this.getClass(clazz);
            short index2 = this.getNameAndType(refName, type);
            return this.getIndirect(new IndirectEntry(9, index1, index2));
        }

        public short getInterfaceMethodRef(String s, String s1, String s2) {
            short word0 = this.getClass(s);
            short word1 = this.getNameAndType(s1, s2);
            return this.getIndirect(new IndirectEntry(11, word0, word1));
        }

        public short getMethodRef(String s, String s1, String s2) {
            short word0 = this.getClass(s);
            short word1 = this.getNameAndType(s1, s2);
            return this.getIndirect(new IndirectEntry(10, word0, word1));
        }

        private ConstantPool() {
        }

        private static class ValueEntry
        extends Entry {
            private Object value;

            public void write(DataOutputStream dataoutputstream) throws IOException {
                if (this.value instanceof String) {
                    dataoutputstream.writeByte(1);
                    dataoutputstream.writeUTF((String)this.value);
                } else if (this.value instanceof Integer) {
                    dataoutputstream.writeByte(3);
                    dataoutputstream.writeInt((Integer)this.value);
                } else if (this.value instanceof Float) {
                    dataoutputstream.writeByte(4);
                    dataoutputstream.writeFloat(((Float)this.value).floatValue());
                } else if (this.value instanceof Long) {
                    dataoutputstream.writeByte(5);
                    dataoutputstream.writeLong((Long)this.value);
                } else if (this.value instanceof Double) {
                    dataoutputstream.writeDouble(6.0);
                    dataoutputstream.writeDouble((Double)this.value);
                } else {
                    throw new InternalError("bogus value entry: " + this.value);
                }
            }

            public ValueEntry(Object obj) {
                this.value = obj;
            }
        }

        private static class IndirectEntry
        extends Entry {
            private int tag;
            private short index0;
            private short index1;

            public int hashCode() {
                return this.tag + this.index0 + this.index1;
            }

            public void write(DataOutputStream dataoutputstream) throws IOException {
                dataoutputstream.writeByte(this.tag);
                dataoutputstream.writeShort(this.index0);
                if (this.tag == 9 || this.tag == 10 || this.tag == 11 || this.tag == 12) {
                    dataoutputstream.writeShort(this.index1);
                }
            }

            public boolean equals(Object obj) {
                if (obj instanceof IndirectEntry) {
                    IndirectEntry indirectentry = (IndirectEntry)obj;
                    if (this.tag == indirectentry.tag && this.index0 == indirectentry.index0 && this.index1 == indirectentry.index1) {
                        return true;
                    }
                }
                return false;
            }

            public IndirectEntry(int i, short word0) {
                this.tag = i;
                this.index0 = word0;
                this.index1 = 0;
            }

            public IndirectEntry(int i, short word0, short word1) {
                this.tag = i;
                this.index0 = word0;
                this.index1 = word1;
            }
        }

        private static abstract class Entry {
            public abstract void write(DataOutputStream var1) throws IOException;

            private Entry() {
            }
        }
    }
}

