/*
 * Decompiled with CFR 0.152.
 */
package jeus.connector;

import javax.management.j2ee.statistics.JCAConnectionPoolStats;
import javax.management.j2ee.statistics.Statistic;
import jeus.connector.ConnectionPoolInfo;
import jeus.management.j2ee.statistics.BoundedRangeStatisticImpl;
import jeus.management.j2ee.statistics.CountStatisticImpl;
import jeus.management.j2ee.statistics.JCAConnectionPoolStatsImpl;
import jeus.management.j2ee.statistics.RangeStatisticImpl;
import jeus.management.j2ee.statistics.TimeStatisticImpl;

public final class ConnectionPoolStats {
    private final ConnectionPoolInfo poolInfo;
    private JCAConnectionPoolStatsImpl poolStats;
    private TimeStatisticImpl waitTime;
    private TimeStatisticImpl useTime;
    private CountStatisticImpl createCount;
    private CountStatisticImpl destroyCount;
    private CountStatisticImpl shrinkCount;
    private CountStatisticImpl invalidateCount;
    private CountStatisticImpl dissociationCount;
    private CountStatisticImpl matchFailCount;
    private CountStatisticImpl matchSuccessCount;
    private CountStatisticImpl acquireFailCount;
    private BoundedRangeStatisticImpl freeConnections;
    private BoundedRangeStatisticImpl pooledConnections;
    private BoundedRangeStatisticImpl disposableConnections;
    private RangeStatisticImpl waitingThreadCount;

    ConnectionPoolStats(ConnectionPoolInfo poolInfo) {
        this.poolInfo = poolInfo;
    }

    public void initStatsMonitor(JCAConnectionPoolStatsImpl stats) {
        this.poolStats = stats;
        this.waitTime = new TimeStatisticImpl("WaitTime", "millisecond", "waiting time for acquiring available connection");
        this.useTime = new TimeStatisticImpl("UseTime", "millisecond", "the time spent using a connection");
        this.createCount = new CountStatisticImpl("CreateCount", "connection", "the number of creating managed connection");
        this.destroyCount = new CountStatisticImpl("CloseCount", "connection", "the number of destroying managed connection");
        this.shrinkCount = new CountStatisticImpl("ShrinkCount", "connection", "the number of shrinked managed connection by pooled timeout");
        this.invalidateCount = new CountStatisticImpl("InvalidationCount", "connection", "the number of invalidated managed connection by invalidation timeout");
        this.dissociationCount = new CountStatisticImpl("DissociationCount", "connection", "the number of dissociated managed connection by dissociation timeout");
        this.matchFailCount = new CountStatisticImpl("MatchFailCount", "count", "the number of failure of matching connection");
        this.matchSuccessCount = new CountStatisticImpl("MatchSuccessCount", "count", "the number of success of matching connection");
        this.acquireFailCount = new CountStatisticImpl("AcquireFailCount", "count", "the number of failure of acquirng connection");
        this.freeConnections = new BoundedRangeStatisticImpl("FreePoolSize", "connection", "the number of free connections in the pool", (long)this.poolInfo.getMax(), 0L);
        this.pooledConnections = new BoundedRangeStatisticImpl("PoolSize", "connection", "the size of the connection pool", (long)this.poolInfo.getMax(), 0L);
        this.disposableConnections = new BoundedRangeStatisticImpl("DisposableConnections", "connection", "the size of the disposable connection curretly active", (long)this.poolInfo.getMaxDisposableCount(), 0L);
        this.waitingThreadCount = new RangeStatisticImpl("WaitingThreadCount", "thread", "the number of threads waiting for a connection");
        this.freeConnections.set(0L);
        this.pooledConnections.set(0L);
        this.disposableConnections.set(0L);
        stats.setStatistic((Statistic)this.waitTime);
        stats.setStatistic((Statistic)this.useTime);
        stats.setStatistic((Statistic)this.destroyCount);
        stats.setStatistic((Statistic)this.createCount);
        stats.setStatistic((Statistic)this.shrinkCount);
        stats.setStatistic((Statistic)this.invalidateCount);
        stats.setStatistic((Statistic)this.dissociationCount);
        stats.setStatistic((Statistic)this.matchFailCount);
        stats.setStatistic((Statistic)this.matchSuccessCount);
        stats.setStatistic((Statistic)this.waitingThreadCount);
        stats.setStatistic((Statistic)this.acquireFailCount);
        stats.setStatistic((Statistic)this.pooledConnections);
        stats.setStatistic((Statistic)this.disposableConnections);
        stats.setStatistic((Statistic)this.freeConnections);
    }

    public JCAConnectionPoolStats getStats() {
        return this.poolStats;
    }

    TimeStatisticImpl getWaitTime() {
        return this.waitTime;
    }

    TimeStatisticImpl getUseTime() {
        return this.useTime;
    }

    CountStatisticImpl getCreateCount() {
        return this.createCount;
    }

    CountStatisticImpl getDestroyCount() {
        return this.destroyCount;
    }

    CountStatisticImpl getShrinkCount() {
        return this.shrinkCount;
    }

    CountStatisticImpl getInvalidateCount() {
        return this.invalidateCount;
    }

    CountStatisticImpl getDissociationCount() {
        return this.dissociationCount;
    }

    CountStatisticImpl getMatchFailCount() {
        return this.matchFailCount;
    }

    CountStatisticImpl getMatchSuccessCount() {
        return this.matchSuccessCount;
    }

    CountStatisticImpl getAcquireFailCount() {
        return this.acquireFailCount;
    }

    BoundedRangeStatisticImpl getFreeConnections() {
        return this.freeConnections;
    }

    BoundedRangeStatisticImpl getPooledConnections() {
        return this.pooledConnections;
    }

    BoundedRangeStatisticImpl getDisposableConnections() {
        return this.disposableConnections;
    }

    RangeStatisticImpl getWaitingThreadCount() {
        return this.waitingThreadCount;
    }
}

