/*
 * Decompiled with CFR 0.152.
 */
package jeus.connector;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import jeus.connector.ConnectionPool;
import jeus.connector.ManagedConnectionHandler;
import jeus.connector.ManagedConnectionPool;
import jeus.util.logging.JeusLevel;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JCA1;

final class ConnectionPoolTable {
    private static final ConnectionRequestInfo NULL_REQUEST_INFO = new ConnectionRequestInfo(){};
    private static final ConnectionPool[] EMPTY_CONNECTION_POOL_ARRAY = new ConnectionPool[0];
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.connector");
    private final ManagedConnectionPool mcp;
    private final Hashtable table;

    ConnectionPoolTable(int initialCapacity, ManagedConnectionPool mcp) {
        this.mcp = mcp;
        this.table = new Hashtable(initialCapacity);
    }

    void putConnectionHandler(ManagedConnectionHandler mch) {
        ConnectionPool pool;
        if (logger.isLoggable(JeusMessage_JCA1._1701_LEVEL)) {
            logger.log(JeusMessage_JCA1._1701_LEVEL, JeusMessage_JCA1._1701, (Object)mch.getIdentity());
        }
        if ((pool = this.acquireConnectionPool(mch.getResuestInfo())).returnConnection(mch)) {
            if (logger.isLoggable(JeusMessage_JCA1._1702_LEVEL)) {
                logger.log(JeusMessage_JCA1._1702_LEVEL, JeusMessage_JCA1._1702, (Object)mch.getIdentity());
            }
            if (logger.isLoggable(JeusLevel.DEV)) {
                logger.dev("-----managed connection " + mch.getIdentity() + " is returned to pool");
            }
            return;
        }
        if (logger.isLoggable(JeusMessage_JCA1._1703_LEVEL)) {
            logger.log(JeusMessage_JCA1._1703_LEVEL, JeusMessage_JCA1._1703, (Object)mch.getIdentity());
        }
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("-----managed connection " + mch.getIdentity() + " is not returned to pool");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionPool acquireConnectionPool(ConnectionRequestInfo info) {
        ConnectionPool pool = this.getConnectionPool(info);
        if (pool == null) {
            Hashtable hashtable = this.table;
            synchronized (hashtable) {
                pool = this.getConnectionPool(info);
                if (pool == null) {
                    if (logger.isLoggable(JeusLevel.DEV)) {
                        logger.dev("-----new pool is created for " + info);
                    }
                    pool = new ConnectionPool(this.mcp, ConnectionPoolTable.nullMask(info));
                    if (logger.isLoggable(JeusMessage_JCA1._1704_LEVEL)) {
                        logger.log(JeusMessage_JCA1._1704_LEVEL, JeusMessage_JCA1._1704, new Object[]{pool.getIdentity(), info});
                    }
                    this.putConnectionPool(info, pool);
                }
            }
        }
        return pool;
    }

    void destroyPools() {
        int len;
        if (logger.isLoggable(JeusMessage_JCA1._1706_LEVEL)) {
            logger.log(JeusMessage_JCA1._1706_LEVEL, JeusMessage_JCA1._1706);
        }
        if ((len = this.table.size()) > 0) {
            ConnectionPool[] pools = this.getConnectionPools();
            for (int i = 0; i < len; ++i) {
                pools[i].destoy();
            }
        }
        this.table.clear();
        if (logger.isLoggable(JeusMessage_JCA1._1707_LEVEL)) {
            logger.log(JeusMessage_JCA1._1707_LEVEL, JeusMessage_JCA1._1707);
        }
    }

    private ConnectionPool putConnectionPool(ConnectionRequestInfo key, ConnectionPool value) {
        return this.table.put(ConnectionPoolTable.nullMask(key), value);
    }

    ConnectionPool getConnectionPool(ConnectionRequestInfo key) {
        return (ConnectionPool)this.table.get(ConnectionPoolTable.nullMask(key));
    }

    ConnectionPool[] getConnectionPools() {
        return this.table.values().toArray(EMPTY_CONNECTION_POOL_ARRAY);
    }

    void printPools() {
        ConnectionPool[] pools = this.getConnectionPools();
        for (int i = 0; i < pools.length; ++i) {
            logger.dev(pools[i] == null ? "NULL" : pools[i].toString());
        }
    }

    void shrinkPools() {
        ConnectionPool[] pools = this.getConnectionPools();
        for (int i = 0; i < pools.length; ++i) {
            pools[i].shrink();
        }
    }

    void dissociatePools() {
        ConnectionPool[] pools = this.getConnectionPools();
        for (int i = 0; i < pools.length; ++i) {
            pools[i].dissociate();
        }
    }

    void invalidatePools() {
        ConnectionPool[] pools = this.getConnectionPools();
        for (int i = 0; i < pools.length; ++i) {
            pools[i].invalidate();
        }
    }

    void validatePools() {
        ConnectionPool[] pools = this.getConnectionPools();
        HashSet<ManagedConnection> pooledSet = new HashSet<ManagedConnection>();
        for (int poolIndex = 0; poolIndex < pools.length; ++poolIndex) {
            ManagedConnectionHandler[] handlers = pools[poolIndex].retrieveConnectionHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                ManagedConnection manCon = handlers[i].getRealConnection();
                if (manCon == null) continue;
                pooledSet.add(manCon);
            }
        }
        try {
            ValidatingManagedConnectionFactory mcf = (ValidatingManagedConnectionFactory)this.mcp.getManagedConnectionFactory();
            Set invalidSet = mcf.getInvalidConnections(pooledSet);
            for (int poolIndex = 0; poolIndex < pools.length; ++poolIndex) {
                pools[poolIndex].invalidate(invalidSet);
            }
        }
        catch (ResourceException e) {
            logger.directLog((Throwable)e);
        }
    }

    private static ConnectionRequestInfo nullMask(ConnectionRequestInfo key) {
        return key == null ? NULL_REQUEST_INFO : key;
    }

    int getNumOfIdleConnections() {
        int size = 0;
        ConnectionPool[] pools = this.getConnectionPools();
        for (int i = 0; i < pools.length; ++i) {
            size += pools[i].size();
        }
        if (logger.isLoggable(JeusMessage_JCA1._1709_LEVEL)) {
            logger.log(JeusMessage_JCA1._1709_LEVEL, JeusMessage_JCA1._1709, (Object)String.valueOf(size));
        }
        return size;
    }
}

