/*
 * Decompiled with CFR 0.152.
 */
package jeus.connector;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import javax.resource.spi.ActivationSpec;
import jeus.util.JeusBootstrapProperties;
import jeus.util.properties.JeusManagerPropertyValues;

public class ConnectorLogger {
    public static final String fs = System.getProperty("file.separator");
    private static final String dirName;
    private static final String LOGFILE_PREFIX;
    private String fileName;
    private File file;
    private ObjectOutputStream oos;
    private HashSet as = new HashSet();
    private boolean inited = false;

    public ConnectorLogger(String moduleName) {
        this.fileName = LOGFILE_PREFIX + "_" + moduleName;
        File logPath = new File(dirName);
        logPath.mkdirs();
        this.file = new File(dirName + fs + this.fileName);
        if (this.file.exists()) {
            this.getRecoveryInfo();
        }
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.file));
            this.oos = new ObjectOutputStream(os);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.close();
            this.inited = false;
            return;
        }
        this.inited = true;
    }

    private void getRecoveryInfo() {
        ObjectInputStream ois;
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.file));
            ois = new ObjectInputStream(in);
        }
        catch (Exception e) {
            return;
        }
        try {
            while (true) {
                Object obj;
                if (!((obj = ois.readObject()) instanceof ActivationSpec)) {
                    continue;
                }
                this.as.add(obj);
            }
        }
        catch (EOFException cnfe) {
            return;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            return;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
    }

    public synchronized void logActivationSpec(ActivationSpec spec) {
        if (!this.inited) {
            return;
        }
        try {
            this.oos.writeObject(spec);
            this.oos.flush();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public ActivationSpec[] checkRecovered() {
        if (!this.inited) {
            return null;
        }
        int size = this.as.size();
        return this.as.toArray(new ActivationSpec[size]);
    }

    public void removeActivationSpec(ActivationSpec spec) {
        this.as.remove(spec);
    }

    private synchronized void close() {
        this.inited = false;
        if (this.oos != null) {
            try {
                this.oos.flush();
                this.oos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void removeAll() {
        this.as.clear();
    }

    static {
        String s = JeusBootstrapProperties.JEUS_HOME;
        dirName = s != null ? s + fs + "logs" + fs + "JCA" : System.getProperty("user.dir") + fs + "logs" + fs + "JCA";
        LOGFILE_PREFIX = "jca_" + JeusManagerPropertyValues.containerName;
    }
}

