/*
 * Decompiled with CFR 0.152.
 */
package jeus.connector;

import java.lang.reflect.Method;
import javax.resource.ResourceException;
import javax.resource.spi.InvalidPropertyException;
import jeus.xml.binding.j2ee.ConfigPropertyType;

public class ConnectorUtility {
    public static Class getPropertyType(String type) {
        if (type.equals("java.lang.Boolean")) {
            return Boolean.TYPE;
        }
        if (type.equals("java.lang.String")) {
            return String.class;
        }
        if (type.equals("java.lang.Integer")) {
            return Integer.TYPE;
        }
        if (type.equals("java.lang.Double")) {
            return Double.TYPE;
        }
        if (type.equals("java.lang.Byte")) {
            return Byte.TYPE;
        }
        if (type.equals("java.lang.Short")) {
            return Short.TYPE;
        }
        if (type.equals("java.lang.Long")) {
            return Long.TYPE;
        }
        if (type.equals("java.lang.Float")) {
            return Float.TYPE;
        }
        return Character.TYPE;
    }

    public static Class getWrapperClass(Class type) {
        if (type.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (type.equals(String.class)) {
            return String.class;
        }
        if (type.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (type.equals(Double.TYPE)) {
            return Double.class;
        }
        if (type.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (type.equals(Short.TYPE)) {
            return Short.class;
        }
        if (type.equals(Long.TYPE)) {
            return Long.class;
        }
        if (type.equals(Float.TYPE)) {
            return Float.class;
        }
        return Character.class;
    }

    public static Object getPropertyValue(Class type, String value) {
        if (type.equals(Boolean.TYPE)) {
            return Boolean.valueOf(value);
        }
        if (type.equals(String.class)) {
            return value;
        }
        if (type.equals(Integer.TYPE)) {
            return new Integer(value);
        }
        if (type.equals(Double.TYPE)) {
            return new Double(value);
        }
        if (type.equals(Byte.TYPE)) {
            return new Byte(value);
        }
        if (type.equals(Short.TYPE)) {
            return new Short(value);
        }
        if (type.equals(Long.TYPE)) {
            return new Long(value);
        }
        if (type.equals(Float.TYPE)) {
            return new Float(value);
        }
        return new Character(value.charAt(0));
    }

    public static void invokeMethod(Class cl, String methodName, Class[] argTypes, Object instance, Object[] args) throws ResourceException {
        try {
            Method m = cl.getMethod(methodName, argTypes);
            m.invoke(instance, args);
        }
        catch (Throwable t) {
            throw new InvalidPropertyException("cannot find property setter " + methodName + " from " + cl);
        }
    }

    public static String getPropertyName(ConfigPropertyType property) {
        String propertyName = property.getConfigPropertyName().getValue();
        propertyName = propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        return propertyName;
    }
}

