/*
 * Decompiled with CFR 0.152.
 */
package jeus.connector;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import jeus.connector.ManagedConnectionHandler;
import jeus.transaction.JeusXAException;
import jeus.transaction.resources.XAResourceWrapper;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JCA0;

public class ConnectorXAResource
extends XAResourceWrapper {
    private ManagedConnectionHandler mch;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.connector");

    public ConnectorXAResource(ManagedConnectionHandler handle, XAResource resource) {
        super(resource);
        this.mch = handle;
        if (logger.isLoggable(JeusMessage_JCA0._1351_LEVEL)) {
            logger.log(JeusMessage_JCA0._1351_LEVEL, JeusMessage_JCA0._1351, (Object)this.mch.getIdentity());
        }
    }

    public void start(Xid xid, int flags) throws XAException {
        if (logger.isLoggable(JeusMessage_JCA0._1352_LEVEL)) {
            logger.log(JeusMessage_JCA0._1352_LEVEL, JeusMessage_JCA0._1352, (Object)this.mch.getIdentity());
        }
        super.start(xid, flags);
        this.mch.globalTransactionStarted(xid);
        if (logger.isLoggable(JeusMessage_JCA0._1353_LEVEL)) {
            logger.log(JeusMessage_JCA0._1353_LEVEL, JeusMessage_JCA0._1353);
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (logger.isLoggable(JeusMessage_JCA0._1354_LEVEL)) {
            logger.log(JeusMessage_JCA0._1354_LEVEL, JeusMessage_JCA0._1354, (Object)this.mch.getIdentity());
        }
        try {
            this.resource.commit(xid, onePhase);
        }
        catch (Throwable t) {
            logger.log(JeusMessage_JCA0._1365_LEVEL, JeusMessage_JCA0._1365, (Object)this.mch.getIdentity(), t);
            throw new JeusXAException(14040, t);
        }
        finally {
            this.mch.globalTransactionCompleted();
        }
        if (logger.isLoggable(JeusMessage_JCA0._1355_LEVEL)) {
            logger.log(JeusMessage_JCA0._1355_LEVEL, JeusMessage_JCA0._1355);
        }
    }

    public void enforceEnd() {
        if (!this.inTx) {
            return;
        }
        try {
            if (logger.isLoggable(JeusMessage_JCA0._1356_LEVEL)) {
                logger.log(JeusMessage_JCA0._1356_LEVEL, JeusMessage_JCA0._1356, (Object)this.mch.getIdentity());
            }
            this.end(this.xid, 0x4000000);
            if (logger.isLoggable(JeusMessage_JCA0._1357_LEVEL)) {
                logger.log(JeusMessage_JCA0._1357_LEVEL, JeusMessage_JCA0._1357);
            }
        }
        catch (Throwable t) {
            logger.log(JeusMessage_JCA0._1362_LEVEL, JeusMessage_JCA0._1362, (Object)this.mch.getIdentity(), t);
        }
    }

    public int prepare(Xid xid) throws XAException {
        if (logger.isLoggable(JeusMessage_JCA0._1358_LEVEL)) {
            logger.log(JeusMessage_JCA0._1358_LEVEL, JeusMessage_JCA0._1358, (Object)this.mch.getIdentity());
        }
        try {
            int result = this.resource.prepare(xid);
            if (logger.isLoggable(JeusMessage_JCA0._1359_LEVEL)) {
                logger.log(JeusMessage_JCA0._1359_LEVEL, JeusMessage_JCA0._1359);
            }
            return result;
        }
        catch (Throwable t) {
            logger.log(JeusMessage_JCA0._1363_LEVEL, JeusMessage_JCA0._1363, (Object)this.mch.getIdentity(), t);
            throw new JeusXAException(14042, t);
        }
    }

    public void rollback(Xid xid) throws XAException {
        if (logger.isLoggable(JeusMessage_JCA0._1360_LEVEL)) {
            logger.log(JeusMessage_JCA0._1360_LEVEL, JeusMessage_JCA0._1360, (Object)this.mch.getIdentity());
        }
        try {
            this.resource.rollback(xid);
        }
        catch (Throwable t) {
            logger.log(JeusMessage_JCA0._1364_LEVEL, JeusMessage_JCA0._1364, (Object)this.mch.getIdentity(), t);
            throw new JeusXAException(14043, t);
        }
        finally {
            this.mch.globalTransactionCompleted();
        }
        if (logger.isLoggable(JeusMessage_JCA0._1361_LEVEL)) {
            logger.log(JeusMessage_JCA0._1361_LEVEL, JeusMessage_JCA0._1361);
        }
    }
}

