/*
 * Decompiled with CFR 0.152.
 */
package jeus.connector;

import java.util.Hashtable;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.security.auth.Subject;
import jeus.connector.CMInfo;
import jeus.connector.ConnectionHandler;
import jeus.connector.ConnectionPool;
import jeus.connector.ConnectionPoolInfo;
import jeus.connector.ConnectionPoolStats;
import jeus.connector.ConnectionPoolTable;
import jeus.connector.ConnectorTimer;
import jeus.connector.ManagedConnectionHandler;
import jeus.util.ObjectBaseHashMap;
import jeus.util.logging.JeusLevel;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JCA0;
import jeus.util.message.JeusMessage_JCA1;
import jeus.xml.binding.connectorHelper.ConnectionDefinitionsDescriptor;

public final class ManagedConnectionPool {
    private static final ManagedConnectionHandler[] EMPTY_MANAGED_CONNECTION_HANDLER_ARRAY = new ManagedConnectionHandler[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.connector");
    private final ConnectionPoolTable poolTable;
    private final ConnectionPoolInfo poolInfo;
    private final ConnectionPoolStats poolStats;
    private final ManagedConnectionFactory managedConnectionFactory;
    private final ClassLoader classLoader;
    private final Class connectionInterface;
    private Class handleInterface;
    private final Hashtable validMap;
    private final Hashtable disposableMap;
    private final ObjectBaseHashMap usingHandles;
    private ConnectorTimer timer;

    public ManagedConnectionPool(String moduleName, String appName, ConnectionDefinitionsDescriptor desc, ManagedConnectionFactory factory, ClassLoader cl) throws ClassNotFoundException {
        if (logger.isLoggable(JeusMessage_JCA0._1101_LEVEL)) {
            logger.log(JeusMessage_JCA0._1101_LEVEL, JeusMessage_JCA0._1101);
        }
        this.managedConnectionFactory = factory;
        this.classLoader = cl;
        this.connectionInterface = this.classLoader.loadClass(desc.getConnectionIntClassName());
        this.poolInfo = new ConnectionPoolInfo(moduleName, appName, desc);
        this.poolStats = new ConnectionPoolStats(this.poolInfo);
        this.poolTable = new ConnectionPoolTable(Math.max(this.poolInfo.getMax() / 3, 11), this);
        this.validMap = new Hashtable();
        this.disposableMap = new Hashtable();
        this.usingHandles = new ObjectBaseHashMap();
        if (this.poolInfo.isUseWrapper()) {
            this.initHandleInterface();
        }
        if (this.isUseShrink() || this.isUseDissociation() || this.isUseInvalidation() || this.isUseValidation()) {
            this.startTimer();
        }
        this.setEnabled();
        if (logger.isLoggable(JeusMessage_JCA0._1102_LEVEL)) {
            logger.log(JeusMessage_JCA0._1102_LEVEL, JeusMessage_JCA0._1102);
        }
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("[ManagedConnectionPool.ManagedConnectionPool][OUT] " + this);
        }
    }

    public void returnConnection(ManagedConnectionHandler mch) {
        if (logger.isLoggable(JeusMessage_JCA1._1661_LEVEL)) {
            logger.log(JeusMessage_JCA1._1661_LEVEL, JeusMessage_JCA1._1661, (Object)mch.getIdentity());
        }
        this.poolTable.putConnectionHandler(mch);
    }

    void removeConnection(ManagedConnectionHandler mch) {
        ConnectionPool pool;
        if (logger.isLoggable(JeusMessage_JCA1._1662_LEVEL)) {
            logger.log(JeusMessage_JCA1._1662_LEVEL, JeusMessage_JCA1._1662, (Object)mch.getIdentity());
        }
        if (logger.isLoggable(JeusMessage_JCA1._1705_LEVEL)) {
            logger.log(JeusMessage_JCA1._1705_LEVEL, JeusMessage_JCA1._1705, (Object)mch.getIdentity());
        }
        ConnectionRequestInfo info = mch.getResuestInfo();
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("---[NAVIS/removeConnection] " + mch.getIdentity() + " : " + info);
        }
        if ((pool = this.poolTable.getConnectionPool(info)) != null) {
            pool.removeConnection(true, mch);
        }
    }

    void clearMapping(ManagedConnectionHandler mch) {
        if (logger.isLoggable(JeusMessage_JCA1._1664_LEVEL)) {
            logger.log(JeusMessage_JCA1._1664_LEVEL, JeusMessage_JCA1._1664, (Object)mch.getIdentity());
        }
        ManagedConnection mc = mch.getRealConnection();
        if (mch.isDisposable()) {
            this.disposableMap.remove(mc);
            this.poolStats.getDisposableConnections().decrease();
        } else {
            this.validMap.remove(mc);
            this.poolStats.getPooledConnections().decrease();
        }
    }

    public void destroy() {
        if (logger.isLoggable(JeusMessage_JCA1._1665_LEVEL)) {
            logger.log(JeusMessage_JCA1._1665_LEVEL, JeusMessage_JCA1._1665);
        }
        this.poolInfo.setWorking(false);
        this.timer.stopTimer();
        this.invalidateAllConnectionHandlers();
        this.poolTable.destroyPools();
        this.validMap.clear();
    }

    private void invalidateAllConnectionHandlers() {
        if (logger.isLoggable(JeusMessage_JCA1._1708_LEVEL)) {
            logger.log(JeusMessage_JCA1._1708_LEVEL, JeusMessage_JCA1._1708);
        }
        if (this.validMap.size() > 0) {
            ManagedConnectionHandler[] handlers = this.validMap.values().toArray(EMPTY_MANAGED_CONNECTION_HANDLER_ARRAY);
            for (int i = 0; i < handlers.length; ++i) {
                ManagedConnectionHandler handler = handlers[i];
                handler.setDisposable(true);
            }
        }
    }

    public void lazyEnlist(ManagedConnection mc) throws ResourceException {
        ManagedConnectionHandler mch = (ManagedConnectionHandler)this.validMap.get(mc);
        if (mch == null) {
            throw new ResourceAdapterInternalException("Invalid ManagedConnection");
        }
        mch.lazyEnlist();
    }

    public void registerConnection(Object con, ManagedConnectionHandler mch) {
        if (logger.isLoggable(JeusMessage_JCA1._1666_LEVEL)) {
            logger.log(JeusMessage_JCA1._1666_LEVEL, JeusMessage_JCA1._1666);
        }
        this.usingHandles.put(con, mch);
    }

    public void unregisterConnection(Object con) {
        if (logger.isLoggable(JeusMessage_JCA1._1667_LEVEL)) {
            logger.log(JeusMessage_JCA1._1667_LEVEL, JeusMessage_JCA1._1667);
        }
        this.usingHandles.remove(con);
    }

    public void unregisterConnection(Set cons) {
        if (logger.isLoggable(JeusMessage_JCA1._1668_LEVEL)) {
            logger.log(JeusMessage_JCA1._1668_LEVEL, JeusMessage_JCA1._1668);
        }
        Object[] conArr = cons.toArray(EMPTY_OBJECT_ARRAY);
        for (int i = 0; i < conArr.length; ++i) {
            this.usingHandles.remove(conArr[i]);
        }
    }

    public ConnectionHandler checkoutRegisteredConnection(Object con) throws ResourceException {
        ManagedConnectionHandler mch;
        if (logger.isLoggable(JeusMessage_JCA1._1669_LEVEL)) {
            logger.log(JeusMessage_JCA1._1669_LEVEL, JeusMessage_JCA1._1669, con);
        }
        if ((mch = (ManagedConnectionHandler)this.usingHandles.get(con)) == null) {
            logger.log(JeusMessage_JCA1._1670_LEVEL, JeusMessage_JCA1._1670, con);
            throw new IllegalStateException("invalid connection handle : " + con);
        }
        ConnectionHandler wrapper = mch.checkRegisteredConnection(con);
        if (wrapper != null) {
            if (logger.isLoggable(JeusMessage_JCA1._1672_LEVEL)) {
                logger.log(JeusMessage_JCA1._1672_LEVEL, JeusMessage_JCA1._1672);
            }
            return wrapper;
        }
        logger.log(JeusMessage_JCA1._1671_LEVEL, JeusMessage_JCA1._1671, new Object[]{con, mch.getIdentity()});
        throw new IllegalStateException("invalid connection handle : " + con);
    }

    public synchronized void shrink() {
        if (logger.isLoggable(JeusMessage_JCA1._1673_LEVEL)) {
            logger.log(JeusMessage_JCA1._1673_LEVEL, JeusMessage_JCA1._1673);
        }
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("shrink managed connection pool by request");
        }
        if (this.checkShrinkAllowed()) {
            this.poolTable.shrinkPools();
        }
    }

    public synchronized void dissociate() {
        if (logger.isLoggable(JeusMessage_JCA1._1674_LEVEL)) {
            logger.log(JeusMessage_JCA1._1674_LEVEL, JeusMessage_JCA1._1674);
        }
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("dissociate managed connection pool by request");
        }
        if (this.isUseDissociation()) {
            this.poolTable.dissociatePools();
        }
    }

    public synchronized void invalidate() {
        if (logger.isLoggable(JeusMessage_JCA1._1675_LEVEL)) {
            logger.log(JeusMessage_JCA1._1675_LEVEL, JeusMessage_JCA1._1675);
        }
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("invalidate managed connection pool by request");
        }
        if (this.isUseInvalidation()) {
            this.poolTable.invalidatePools();
        }
    }

    public synchronized void validate() {
        if (logger.isLoggable(JeusMessage_JCA1._1710_LEVEL)) {
            logger.log(JeusMessage_JCA1._1710_LEVEL, JeusMessage_JCA1._1710);
        }
        if (this.managedConnectionFactory instanceof ValidatingManagedConnectionFactory) {
            this.poolTable.validatePools();
        } else if (logger.isLoggable(JeusMessage_JCA1._1711_LEVEL)) {
            logger.log(JeusMessage_JCA1._1711_LEVEL, JeusMessage_JCA1._1711);
        }
    }

    public synchronized void updatePooledTimeout(long pooledTimeout) {
        if (logger.isLoggable(JeusMessage_JCA1._1676_LEVEL)) {
            logger.log(JeusMessage_JCA1._1676_LEVEL, JeusMessage_JCA1._1676, (Object)String.valueOf(pooledTimeout));
        }
        if (pooledTimeout >= 0L) {
            this.poolInfo.setPooledTimeout(pooledTimeout);
            this.startTimer();
        }
    }

    public synchronized void updateDissociationTimeout(long dissociationTimeout) {
        if (logger.isLoggable(JeusMessage_JCA1._1677_LEVEL)) {
            logger.log(JeusMessage_JCA1._1677_LEVEL, JeusMessage_JCA1._1677, (Object)String.valueOf(dissociationTimeout));
        }
        if (dissociationTimeout >= 0L) {
            this.poolInfo.setDissociationTimeout(dissociationTimeout);
            this.startTimer();
        }
    }

    public synchronized void updateInvalidationTimeout(long invalidationTimeout) {
        if (logger.isLoggable(JeusMessage_JCA1._1678_LEVEL)) {
            logger.log(JeusMessage_JCA1._1678_LEVEL, JeusMessage_JCA1._1678, (Object)String.valueOf(invalidationTimeout));
        }
        if (invalidationTimeout >= 0L) {
            this.poolInfo.setInvalidationTimeout(invalidationTimeout);
            this.startTimer();
        }
    }

    public synchronized void updateValidationTimeout(long validationTimeout) {
        if (logger.isLoggable(JeusMessage_JCA1._1712_LEVEL)) {
            logger.log(JeusMessage_JCA1._1712_LEVEL, JeusMessage_JCA1._1712, (Object)new Long(validationTimeout));
        }
        if (!(this.managedConnectionFactory instanceof ValidatingManagedConnectionFactory) && logger.isLoggable(JeusMessage_JCA1._1713_LEVEL)) {
            logger.log(JeusMessage_JCA1._1713_LEVEL, JeusMessage_JCA1._1713);
        }
        if (validationTimeout >= 0L) {
            this.poolInfo.setValidationTimeout(validationTimeout);
            this.startTimer();
        }
    }

    private void startTimer() {
        if (this.timer == null) {
            if (logger.isLoggable(JeusMessage_JCA1._1679_LEVEL)) {
                logger.log(JeusMessage_JCA1._1679_LEVEL, JeusMessage_JCA1._1679);
            }
            this.timer = new ConnectorTimer(this);
            this.timer.startTimer();
        } else {
            this.timer.change();
        }
    }

    boolean checkShrinkAllowed() {
        boolean allowed;
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("checkShrinkAllowed : " + this.validMap.size() + ", " + this.poolInfo.getMin());
        }
        boolean bl = allowed = this.validMap.size() > this.poolInfo.getMin();
        if (logger.isLoggable(JeusMessage_JCA1._1680_LEVEL)) {
            logger.log(JeusMessage_JCA1._1680_LEVEL, JeusMessage_JCA1._1680, (Object)(allowed ? "" : "not "));
        }
        return allowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ManagedConnectionHandler createManagedConnectionHandlerBelowMinSize(ConnectionRequestInfo reqInfo, Subject subject) throws ResourceException {
        if (this.validMap.size() < this.poolInfo.getMin()) {
            Hashtable hashtable = this.validMap;
            synchronized (hashtable) {
                if (this.validMap.size() < this.poolInfo.getMin()) {
                    ManagedConnectionHandler mch = this.createManagedConnectionHandler(reqInfo, subject, false);
                    if (logger.isLoggable(JeusLevel.DEV)) {
                        logger.dev("-----new connection created for below minimum size");
                    }
                    return mch;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ManagedConnectionHandler createManagedConnectionHandler(ConnectionRequestInfo reqInfo, Subject subject) throws ResourceException {
        if (this.validMap.size() < this.poolInfo.getMax()) {
            Hashtable hashtable = this.validMap;
            synchronized (hashtable) {
                if (this.validMap.size() < this.poolInfo.getMax()) {
                    ManagedConnectionHandler mch = this.createManagedConnectionHandler(reqInfo, subject, false);
                    if (logger.isLoggable(JeusLevel.DEV)) {
                        logger.dev("-----new connection created for below maximum size");
                    }
                    return mch;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ManagedConnectionHandler createDisposableManagedConnectionHandler(ConnectionRequestInfo reqInfo, Subject subject) {
        if (this.disposableMap.size() < this.poolInfo.getMaxDisposableCount()) {
            Hashtable hashtable = this.disposableMap;
            synchronized (hashtable) {
                if (this.disposableMap.size() < this.poolInfo.getMaxDisposableCount()) {
                    try {
                        ManagedConnectionHandler mch = this.createManagedConnectionHandler(reqInfo, subject, true);
                        if (logger.isLoggable(JeusLevel.DEV)) {
                            logger.dev("-----disposable connection created");
                        }
                        return mch;
                    }
                    catch (ResourceException re) {
                        return null;
                    }
                }
            }
        }
        return null;
    }

    private ManagedConnectionHandler createManagedConnectionHandler(ConnectionRequestInfo reqInfo, Subject subject, boolean disposable) throws ResourceException {
        if (logger.isLoggable(JeusMessage_JCA1._1682_LEVEL)) {
            logger.log(JeusMessage_JCA1._1682_LEVEL, JeusMessage_JCA1._1682, new Object[]{disposable ? "disposable " : "", reqInfo, subject});
        }
        ManagedConnection mc = this.managedConnectionFactory.createManagedConnection(subject, reqInfo);
        ManagedConnectionHandler mch = new ManagedConnectionHandler(this, mc, disposable, reqInfo, subject);
        if (disposable) {
            this.disposableMap.put(mc, mch);
        } else {
            this.validMap.put(mc, mch);
            this.poolStats.getPooledConnections().increase();
        }
        if (logger.isLoggable(JeusMessage_JCA1._1683_LEVEL)) {
            logger.log(JeusMessage_JCA1._1683_LEVEL, JeusMessage_JCA1._1683);
        }
        return mch;
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this.managedConnectionFactory;
    }

    private void initHandleInterface() throws ClassNotFoundException {
        if (this.handleInterface == null) {
            this.handleInterface = this.classLoader.loadClass("jeus.connector.ConnectionHandler");
        }
    }

    public void setUseWrapper(boolean useWrapper) throws ClassNotFoundException {
        this.poolInfo.setUseWrapper(useWrapper);
        if (useWrapper) {
            this.initHandleInterface();
        }
    }

    Class[] getInterfaces() {
        return new Class[]{this.connectionInterface, this.handleInterface};
    }

    public void setEnabled() {
        if (logger.isLoggable(JeusMessage_JCA0._1103_LEVEL)) {
            logger.log(JeusMessage_JCA0._1103_LEVEL, JeusMessage_JCA0._1103);
        }
        this.poolInfo.setWorking(true);
    }

    public void setDisabled() {
        this.poolInfo.setWorking(false);
        if (logger.isLoggable(JeusMessage_JCA0._1104_LEVEL)) {
            logger.log(JeusMessage_JCA0._1104_LEVEL, JeusMessage_JCA0._1104);
        }
    }

    public ConnectionPoolStats getPoolStats() {
        return this.poolStats;
    }

    public ConnectionPoolInfo getPoolInfo() {
        return this.poolInfo;
    }

    boolean isUseShrink() {
        return this.poolInfo.getPooledTimeout() > 0L;
    }

    boolean isUseDissociation() {
        return this.poolInfo.getDissociationTimeout() != 0L;
    }

    boolean isUseInvalidation() {
        return this.poolInfo.getInvalidationTimeout() != 0L;
    }

    boolean isUseValidation() {
        return this.poolInfo.getValidationTimeout() != 0L && this.managedConnectionFactory instanceof ValidatingManagedConnectionFactory;
    }

    ConnectionPoolTable getPoolTable() {
        return this.poolTable;
    }

    public void printPools() {
        this.poolTable.printPools();
    }

    public CMInfo getCMInfo() {
        CMInfo cmInfo = new CMInfo();
        cmInfo.setMax(this.poolInfo.getMax());
        cmInfo.setIdle(this.poolTable.getNumOfIdleConnections());
        cmInfo.setName(this.poolInfo.getExportName());
        cmInfo.setResizingPeriod(this.poolInfo.getPooledTimeout());
        cmInfo.setSize(this.validMap.size());
        cmInfo.setWaiting(this.poolInfo.isWaitConnection());
        cmInfo.setWaitingTime(this.poolInfo.getWaitingTime());
        cmInfo.setWorking(this.poolInfo.isWorking());
        return cmInfo;
    }
}

