/*
 * Decompiled with CFR 0.152.
 */
package jeus.connector;

import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import jeus.connector.ConnectorLogger;
import jeus.connector.work.WorkManager;
import jeus.util.ObjectBaseHashMap;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JCA1;
import jeus.xml.binding.connectorHelper.ConnectorPair;
import jeus.xml.binding.j2ee.MessagelistenerType;

public class ManagedResourceAdapter
implements ResourceAdapter {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.connector");
    private ConnectorPair desc;
    private ResourceAdapter adapter;
    private BootstrapContext ctx;
    private ConnectorLogger clogger;
    private WorkManager workManager;
    private ObjectBaseHashMap map;
    private ClassLoader loader;

    public ManagedResourceAdapter(ConnectorPair desc, ResourceAdapter ra, ClassLoader loader) {
        this.desc = desc;
        this.adapter = ra;
        this.loader = loader;
        this.map = new ObjectBaseHashMap();
        if (logger.isLoggable(JeusMessage_JCA1._1801_LEVEL)) {
            logger.log(JeusMessage_JCA1._1801_LEVEL, JeusMessage_JCA1._1801);
        }
    }

    public void stop() {
        if (logger.isLoggable(JeusMessage_JCA1._1802_LEVEL)) {
            logger.log(JeusMessage_JCA1._1802_LEVEL, JeusMessage_JCA1._1802);
        }
        Vector v = new Vector(this.map.entrySet());
        for (int i = 0; i < v.size(); ++i) {
            Map.Entry entry = (Map.Entry)v.get(i);
            this.endpointDeactivation((MessageEndpointFactory)entry.getValue(), (ActivationSpec)entry.getKey());
        }
        this.adapter.stop();
        if (this.workManager != null) {
            this.workManager.shutdown();
        }
        if (logger.isLoggable(JeusMessage_JCA1._1803_LEVEL)) {
            logger.log(JeusMessage_JCA1._1803_LEVEL, JeusMessage_JCA1._1803);
        }
    }

    public void start(BootstrapContext context) throws ResourceAdapterInternalException {
        if (logger.isLoggable(JeusMessage_JCA1._1804_LEVEL)) {
            logger.log(JeusMessage_JCA1._1804_LEVEL, JeusMessage_JCA1._1804);
        }
        this.ctx = context;
        this.workManager = (WorkManager)context.getWorkManager();
        this.adapter.start(this.ctx);
        if (logger.isLoggable(JeusMessage_JCA1._1805_LEVEL)) {
            logger.log(JeusMessage_JCA1._1805_LEVEL, JeusMessage_JCA1._1805);
        }
    }

    public void endpointActivation(MessageEndpointFactory mef, ActivationSpec spec) throws ResourceException {
        if (logger.isLoggable(JeusMessage_JCA1._1806_LEVEL)) {
            logger.log(JeusMessage_JCA1._1806_LEVEL, JeusMessage_JCA1._1806, new Object[]{mef, spec});
        }
        this.clogger.logActivationSpec(spec);
        this.map.put(spec, mef);
        spec.setResourceAdapter(this.adapter);
        this.adapter.endpointActivation(mef, spec);
    }

    public void endpointDeactivation(MessageEndpointFactory mef, ActivationSpec spec) {
        if (logger.isLoggable(JeusMessage_JCA1._1807_LEVEL)) {
            logger.log(JeusMessage_JCA1._1807_LEVEL, JeusMessage_JCA1._1807, new Object[]{mef, spec});
        }
        this.map.remove(spec);
        this.adapter.endpointDeactivation(mef, spec);
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        if (logger.isLoggable(JeusMessage_JCA1._1808_LEVEL)) {
            logger.log(JeusMessage_JCA1._1808_LEVEL, JeusMessage_JCA1._1808);
        }
        try {
            return this.adapter.getXAResources(specs);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Class getActivationSpecClass(String listenerType) throws ResourceException {
        if (logger.isLoggable(JeusMessage_JCA1._1809_LEVEL)) {
            logger.log(JeusMessage_JCA1._1809_LEVEL, JeusMessage_JCA1._1809, (Object)listenerType);
        }
        try {
            MessagelistenerType msgDesc2 = null;
            List msgListenerDescs = this.desc.getMessageListenerDescriptor();
            for (MessagelistenerType msgDesc2 : msgListenerDescs) {
                if (!msgDesc2.getMessagelistenerType().getValue().equals(listenerType)) continue;
                String value = msgDesc2.getActivationspec().getActivationspecClass().getValue();
                if (logger.isLoggable(JeusMessage_JCA1._1810_LEVEL)) {
                    logger.log(JeusMessage_JCA1._1810_LEVEL, JeusMessage_JCA1._1810, (Object)value);
                }
                return this.loader.loadClass(value);
            }
            if (logger.isLoggable(JeusMessage_JCA1._1811_LEVEL)) {
                logger.log(JeusMessage_JCA1._1811_LEVEL, JeusMessage_JCA1._1811);
            }
            return null;
        }
        catch (Throwable e) {
            if (logger.isLoggable(JeusMessage_JCA1._1812_LEVEL)) {
                logger.log(JeusMessage_JCA1._1812_LEVEL, JeusMessage_JCA1._1812, (Object)listenerType);
            }
            throw new ResourceException("[ConnectorBinder] fail to initiate ActivationSpec", e);
        }
    }

    public ResourceAdapter getRealResourceAdapter() {
        if (logger.isLoggable(JeusMessage_JCA1._1813_LEVEL)) {
            logger.log(JeusMessage_JCA1._1813_LEVEL, JeusMessage_JCA1._1813, (Object)this.adapter);
        }
        return this.adapter;
    }

    public void setLogger(ConnectorLogger clogger) {
        if (logger.isLoggable(JeusMessage_JCA1._1814_LEVEL)) {
            logger.log(JeusMessage_JCA1._1814_LEVEL, JeusMessage_JCA1._1814);
        }
        this.clogger = clogger;
    }

    public void completeRecovery() {
        if (logger.isLoggable(JeusMessage_JCA1._1815_LEVEL)) {
            logger.log(JeusMessage_JCA1._1815_LEVEL, JeusMessage_JCA1._1815);
        }
        this.clogger.removeAll();
    }
}

