/*
 * Decompiled with CFR 0.152.
 */
package jeus.container.namingenv;

import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import jeus.container.namingenv.EnvironmentContext;
import jeus.container.namingenv.EnvironmentException;
import jeus.container.namingenv.NamingEnvManager;
import jeus.util.StringUtil;
import jeus.util.logging.JeusLogger;
import jeus.xml.binding.jeusDD.JndiInfoType;
import jeus.xml.binding.jeusDD.JndiRefType;

public abstract class EnvRef {
    protected static final JeusLogger logger = NamingEnvManager.logger;
    protected static final String ENC = "java:comp/env";
    protected String description;
    protected String name;
    protected String mappedName;
    protected boolean isInjectable = true;
    protected boolean globalScope;

    public EnvRef(String name) {
        assert (name != null && !name.equals(""));
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return "java:comp/env/" + this.name;
    }

    public boolean isInjectable() {
        return this.isInjectable;
    }

    public void setInjectable(boolean injectable) {
        this.isInjectable = injectable;
    }

    public void setGlobalScope(boolean globalScope) {
        this.globalScope = globalScope;
    }

    public boolean isGlobalScope() {
        return this.globalScope;
    }

    public String getMappedName() {
        return this.mappedName;
    }

    public void setMappedName(String mappedName) {
        if (!StringUtil.isNullOrEmpty((String)mappedName)) {
            this.mappedName = mappedName;
        }
    }

    public void setType(Class type) {
    }

    public abstract Object getBindingObject(EnvironmentContext var1) throws EnvironmentException;

    public Object getBoundObject(InitialContext ctx) throws NamingException {
        String jndiName = this.getFullName();
        Object value = ctx.lookup(jndiName);
        return value;
    }

    protected String getMatchingJndiName(JndiRefType jndiRef) {
        if (jndiRef != null) {
            List jndiInfoList = jndiRef.getJndiInfo();
            for (JndiInfoType jndiInfo : jndiInfoList) {
                String exportName;
                if (!this.name.equals(jndiInfo.getRefName().trim()) || (exportName = jndiInfo.getExportName()) == null || exportName.trim().equals("")) continue;
                return exportName.trim();
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnvRef envRef = (EnvRef)o;
        return !(this.name != null ? !this.name.equals(envRef.name) : envRef.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }
}

