/*
 * Decompiled with CFR 0.152.
 */
package jeus.container.namingenv;

import java.beans.IntrospectionException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.annotation.Resources;
import javax.ejb.EJB;
import javax.ejb.EJBs;
import javax.jws.HandlerChain;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContexts;
import javax.persistence.PersistenceProperty;
import javax.persistence.PersistenceUnit;
import javax.persistence.PersistenceUnits;
import javax.xml.ws.WebServiceRef;
import javax.xml.ws.WebServiceRefs;
import jeus.container.annotation.AnnotationProcessor;
import jeus.container.namingenv.EjbRef;
import jeus.container.namingenv.EnvRef;
import jeus.container.namingenv.InjectionInfo;
import jeus.container.namingenv.NamingEnvironment;
import jeus.container.namingenv.PersistenceContextRef;
import jeus.container.namingenv.PersistenceUnitRef;
import jeus.container.namingenv.ResourceRef;
import jeus.container.namingenv.ServiceRef;
import jeus.container.namingenv.SimpleEnvEntry;
import jeus.container.util.IntrospectionUtil;
import jeus.deploy.InvalidAnnotationException;

public class EnvironmentAnnotationProcessor
implements AnnotationProcessor {
    protected NamingEnvironment env;

    public EnvironmentAnnotationProcessor() {
        this(null);
    }

    public EnvironmentAnnotationProcessor(NamingEnvironment env) {
        this.env = env == null ? new NamingEnvironment() : env;
    }

    public static String getDefaultEntryName(Member member) {
        if (member instanceof Field) {
            return member.getDeclaringClass().getName() + "/" + member.getName();
        }
        if (member instanceof Method) {
            try {
                return member.getDeclaringClass().getName() + "/" + IntrospectionUtil.getPropertyName((Method)member);
            }
            catch (IntrospectionException e) {
                throw new IllegalArgumentException(member + " is not property method");
            }
        }
        throw new IllegalArgumentException(member + " is not field nor method");
    }

    public static Class getMemberType(Member member) {
        if (member instanceof Field) {
            return ((Field)member).getType();
        }
        if (member instanceof Method) {
            try {
                return IntrospectionUtil.getPropertyType((Method)member);
            }
            catch (IntrospectionException e) {
                throw new IllegalArgumentException(member + " is not property method", e);
            }
        }
        throw new IllegalArgumentException(member + " is not field nor method");
    }

    public NamingEnvironment getNamingEnvironment() {
        return this.env;
    }

    public void processClass(Class cls) throws InvalidAnnotationException {
        this.env.initClassInfo(cls);
        this.processResource(cls);
        this.processResources(cls);
        this.processEJB(cls);
        this.processEJBs(cls);
        this.processPersistenceContext(cls);
        this.processPersistenceContexts(cls);
        this.processPersistenceUnit(cls);
        this.processPersistenceUnits(cls);
        this.processServiceRef(cls);
        this.processServiceRefs(cls);
    }

    public void processField(Field field) throws InvalidAnnotationException {
        this.processMemberInjection(field);
    }

    public void processConstructor(Constructor constructor) throws InvalidAnnotationException {
    }

    public void processMethod(Method method) throws InvalidAnnotationException {
        this.processMemberInjection(method);
        if (method.isAnnotationPresent(PostConstruct.class)) {
            this.env.addPostConstructMethod(method);
        }
        if (method.isAnnotationPresent(PreDestroy.class)) {
            this.env.addPreDestroyMethod(method);
        }
    }

    public void processFinished() {
    }

    private void processMemberInjection(Member member) throws InvalidAnnotationException {
        AnnotatedElement m = (AnnotatedElement)((Object)member);
        this.processResource(m);
        this.processEJB(m);
        this.processPersistenceContext(m);
        this.processPersistenceUnit(m);
        this.processServiceRef(m);
    }

    private static boolean isNullOrEmpty(String name) {
        return name == null || name.trim().equals("");
    }

    private static boolean isNullOrObject(Class type) {
        return type == null || type == Object.class;
    }

    private void throwDuplicateEntryNameException(AnnotatedElement element, String name) throws InvalidAnnotationException {
        throw new InvalidAnnotationException(name + " on the " + element + " is duplicate - this is already defined");
    }

    private void processResource(AnnotatedElement element, Resource resource) throws InvalidAnnotationException {
        if (resource != null) {
            Class<?> declaringClass;
            String name = resource.name();
            Class type = resource.type();
            String mappedName = resource.mappedName();
            InjectionInfo injection = null;
            if (element instanceof Class) {
                if (EnvironmentAnnotationProcessor.isNullOrEmpty(name)) {
                    throw new InvalidAnnotationException("name should be given");
                }
                if (EnvironmentAnnotationProcessor.isNullOrObject(type)) {
                    throw new InvalidAnnotationException("type should be given");
                }
                declaringClass = (Class<?>)element;
            } else if (element instanceof Field || element instanceof Method) {
                Member member = (Member)((Object)element);
                declaringClass = member.getDeclaringClass();
                if (EnvironmentAnnotationProcessor.isNullOrEmpty(name)) {
                    name = EnvironmentAnnotationProcessor.getDefaultEntryName(member);
                }
                if (EnvironmentAnnotationProcessor.isNullOrObject(type)) {
                    type = EnvironmentAnnotationProcessor.getMemberType(member);
                }
                if (type.getName().equals("javax.xml.ws.WebServiceContext")) {
                    return;
                }
                injection = new InjectionInfo(name, member);
                this.env.addInjectionInfo(injection);
            } else {
                throw new InvalidAnnotationException(element + " cannot have @Resource annotation");
            }
            EnvRef entry = SimpleEnvEntry.isSimpleEnvEntryType(type) ? new SimpleEnvEntry(name, type, null) : new ResourceRef(name, type, resource.authenticationType(), resource.shareable());
            entry.setMappedName(mappedName);
            this.env.addEntry(declaringClass, entry);
        }
    }

    private void processResource(AnnotatedElement element) throws InvalidAnnotationException {
        Resource resource = element.getAnnotation(Resource.class);
        this.processResource(element, resource);
    }

    private void processResources(AnnotatedElement element) throws InvalidAnnotationException {
        Resources resources = element.getAnnotation(Resources.class);
        if (resources != null) {
            if (element instanceof Class) {
                for (Resource resource : resources.value()) {
                    this.processResource(element, resource);
                }
            } else {
                throw new InvalidAnnotationException(element + " cannot have @Resources annotation");
            }
        }
    }

    private void processEJB(AnnotatedElement element, EJB ejb) throws InvalidAnnotationException {
        if (ejb != null) {
            Class<?> declaringClass;
            String name = ejb.name();
            String beanName = ejb.beanName();
            Class beanInterface = ejb.beanInterface();
            String mappedName = ejb.mappedName();
            InjectionInfo injection = null;
            if (element instanceof Class) {
                if (EnvironmentAnnotationProcessor.isNullOrEmpty(name)) {
                    throw new InvalidAnnotationException("name should be given");
                }
                if (EnvironmentAnnotationProcessor.isNullOrObject(beanInterface)) {
                    throw new InvalidAnnotationException("beanInterface should be given");
                }
                declaringClass = (Class<?>)element;
            } else if (element instanceof Field || element instanceof Method) {
                Member member = (Member)((Object)element);
                declaringClass = member.getDeclaringClass();
                if (EnvironmentAnnotationProcessor.isNullOrEmpty(name)) {
                    name = EnvironmentAnnotationProcessor.getDefaultEntryName(member);
                }
                if (EnvironmentAnnotationProcessor.isNullOrObject(beanInterface)) {
                    beanInterface = EnvironmentAnnotationProcessor.getMemberType(member);
                }
                injection = new InjectionInfo(name, member);
                this.env.addInjectionInfo(injection);
            } else {
                throw new InvalidAnnotationException(element + " cannot have @EJB annotation");
            }
            EjbRef entry = new EjbRef(name, beanName, beanInterface);
            entry.setMappedName(mappedName);
            this.env.addEntry(declaringClass, entry);
        }
    }

    private void processEJB(AnnotatedElement element) throws InvalidAnnotationException {
        EJB ejb = element.getAnnotation(EJB.class);
        this.processEJB(element, ejb);
    }

    private void processEJBs(AnnotatedElement element) throws InvalidAnnotationException {
        EJBs ejbs = element.getAnnotation(EJBs.class);
        if (ejbs != null) {
            if (element instanceof Class) {
                for (EJB ejb : ejbs.value()) {
                    this.processEJB(element, ejb);
                }
            } else {
                throw new InvalidAnnotationException(element + " cannot have @EJB annotation");
            }
        }
    }

    private void processPersistenceUnit(AnnotatedElement element, PersistenceUnit pu) throws InvalidAnnotationException {
        if (pu != null) {
            Class<?> declaringClass;
            String name = pu.name();
            String unitName = pu.unitName();
            InjectionInfo injection = null;
            if (element instanceof Class) {
                if (EnvironmentAnnotationProcessor.isNullOrEmpty(name)) {
                    throw new InvalidAnnotationException("name should be given");
                }
                declaringClass = (Class<?>)element;
            } else if (element instanceof Field || element instanceof Method) {
                Member member = (Member)((Object)element);
                declaringClass = member.getDeclaringClass();
                if (EnvironmentAnnotationProcessor.isNullOrEmpty(name)) {
                    name = EnvironmentAnnotationProcessor.getDefaultEntryName(member);
                }
                injection = new InjectionInfo(name, member);
                this.env.addInjectionInfo(injection);
            } else {
                throw new InvalidAnnotationException(element + " cannot have @PersistenceUnit annotation");
            }
            PersistenceUnitRef entry = new PersistenceUnitRef(name, unitName);
            this.env.addEntry(declaringClass, entry);
        }
    }

    private void processPersistenceUnit(AnnotatedElement element) throws InvalidAnnotationException {
        this.processPersistenceUnit(element, element.getAnnotation(PersistenceUnit.class));
    }

    private void processPersistenceUnits(AnnotatedElement element) throws InvalidAnnotationException {
        PersistenceUnits pus = element.getAnnotation(PersistenceUnits.class);
        if (pus != null) {
            if (element instanceof Class) {
                for (PersistenceUnit pu : pus.value()) {
                    this.processPersistenceUnit(element, pu);
                }
            } else {
                throw new InvalidAnnotationException(element + " cannot have @PersistenceUnit annotation");
            }
        }
    }

    private void processPersistenceContext(AnnotatedElement element, PersistenceContext pc) throws InvalidAnnotationException {
        if (pc != null) {
            Class<?> declaringClass;
            String name = pc.name();
            InjectionInfo injection = null;
            if (element instanceof Class) {
                if (EnvironmentAnnotationProcessor.isNullOrEmpty(name)) {
                    throw new InvalidAnnotationException("name should be given");
                }
                declaringClass = (Class<?>)element;
            } else if (element instanceof Field || element instanceof Method) {
                Member member = (Member)((Object)element);
                declaringClass = member.getDeclaringClass();
                if (EnvironmentAnnotationProcessor.isNullOrEmpty(name)) {
                    name = EnvironmentAnnotationProcessor.getDefaultEntryName(member);
                }
                injection = new InjectionInfo(name, member);
                this.env.addInjectionInfo(injection);
            } else {
                throw new InvalidAnnotationException(element + " cannot have @PersistenceContext annotation");
            }
            PersistenceProperty[] properties = pc.properties();
            HashMap<String, String> map = properties.length == 0 ? null : new HashMap<String, String>();
            for (PersistenceProperty property : properties) {
                map.put(property.name(), property.value());
            }
            PersistenceContextRef entry = new PersistenceContextRef(name, pc.unitName(), pc.type(), map);
            this.env.addEntry(declaringClass, entry);
        }
    }

    private void processPersistenceContext(AnnotatedElement element) throws InvalidAnnotationException {
        this.processPersistenceContext(element, element.getAnnotation(PersistenceContext.class));
    }

    private void processPersistenceContexts(AnnotatedElement element) throws InvalidAnnotationException {
        PersistenceContexts pcs = element.getAnnotation(PersistenceContexts.class);
        if (pcs != null) {
            if (element instanceof Class) {
                for (PersistenceContext pc : pcs.value()) {
                    this.processPersistenceContext(element, pc);
                }
            } else {
                throw new InvalidAnnotationException(element + " cannot have @PersistenceContext annotation");
            }
        }
    }

    private void processServiceRef(AnnotatedElement element) throws InvalidAnnotationException {
        WebServiceRef serviceRef = element.getAnnotation(WebServiceRef.class);
        this.processServiceRef(element, serviceRef);
    }

    private void processServiceRefs(AnnotatedElement element) throws InvalidAnnotationException {
        WebServiceRefs serviceRefs = element.getAnnotation(WebServiceRefs.class);
        if (serviceRefs != null) {
            if (element instanceof Class) {
                for (WebServiceRef serviceRef : serviceRefs.value()) {
                    this.processServiceRef(element, serviceRef);
                }
            } else {
                throw new InvalidAnnotationException(element + " cannot have @WebServiceRefs annotation");
            }
        }
    }

    private void processServiceRef(AnnotatedElement element, WebServiceRef serviceRef) throws InvalidAnnotationException {
        if (serviceRef != null) {
            Class<?> declaringClass;
            String name = serviceRef.name();
            Class type = serviceRef.type();
            Class value = serviceRef.value();
            String wsdlLocation = serviceRef.wsdlLocation();
            String mappedName = serviceRef.mappedName();
            InjectionInfo injection = null;
            if (element instanceof Class) {
                if (EnvironmentAnnotationProcessor.isNullOrEmpty(name)) {
                    throw new InvalidAnnotationException("name should be given");
                }
                if (EnvironmentAnnotationProcessor.isNullOrObject(type)) {
                    throw new InvalidAnnotationException("type should be given");
                }
                declaringClass = (Class<?>)element;
            } else if (element instanceof Field || element instanceof Method) {
                Member member = (Member)((Object)element);
                declaringClass = member.getDeclaringClass();
                if (EnvironmentAnnotationProcessor.isNullOrEmpty(name)) {
                    name = EnvironmentAnnotationProcessor.getDefaultEntryName(member);
                }
                if (EnvironmentAnnotationProcessor.isNullOrObject(type)) {
                    type = EnvironmentAnnotationProcessor.getMemberType(member);
                }
                if (EnvironmentAnnotationProcessor.isNullOrObject(value)) {
                    value = EnvironmentAnnotationProcessor.getMemberType(member);
                }
                injection = new InjectionInfo(name, member);
                this.env.addInjectionInfo(injection);
            } else {
                throw new InvalidAnnotationException(element + " cannot have @WebServiceRef annotation");
            }
            HandlerChain handlerChain = element.getAnnotation(HandlerChain.class);
            ServiceRef entry = new ServiceRef(name, declaringClass, type, value, wsdlLocation);
            if (handlerChain != null) {
                try {
                    entry.processHandlerFile(handlerChain.file(), this.env);
                }
                catch (Exception e) {
                    throw new InvalidAnnotationException(e);
                }
            }
            entry.setMappedName(mappedName);
            this.env.addEntry(declaringClass, entry);
        }
    }
}

