/*
 * Decompiled with CFR 0.152.
 */
package jeus.container.namingenv;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import jeus.container.namingenv.ClassEnvInfo;
import jeus.container.namingenv.EnvRef;
import jeus.container.namingenv.EnvironmentContext;
import jeus.container.namingenv.EnvironmentException;
import jeus.container.namingenv.InjectionException;
import jeus.container.namingenv.InjectionInfo;
import jeus.container.namingenv.NamingEnvironment;
import jeus.security.spi.LoginService;
import jeus.util.ReflectionUtils;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Client;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamingEnvManager {
    public static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jndi.enc");
    protected String envRoot;
    protected boolean isEnvRootUsed;
    protected NamingEnvironment namingEnvironment;

    public EnvRef getEntry(String name) {
        if (this.namingEnvironment == null) {
            return null;
        }
        return this.namingEnvironment.getEntry(name);
    }

    public Collection<EnvRef> entries() {
        if (this.namingEnvironment == null) {
            return null;
        }
        return this.namingEnvironment.entries();
    }

    public String getEnvRoot() {
        return this.envRoot;
    }

    public void setEnvRoot(String envRoot) {
        if (envRoot == null || envRoot.trim().length() == 0) {
            throw new IllegalArgumentException("Internal Error: argument should not be null or empty string");
        }
        this.envRoot = envRoot;
    }

    public NamingEnvironment getNamingEnvironment() {
        return this.namingEnvironment;
    }

    public void setNamingEnvironment(NamingEnvironment namingEnvironment) {
        this.namingEnvironment = namingEnvironment;
    }

    public void bindAllEntries(EnvironmentContext envContext) throws NamingException, EnvironmentException {
        if (this.namingEnvironment == null) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Binding all ENC entries; envRoot={0}", (Object)this.envRoot);
        }
        this.bindEntries(this.entries(), envContext, false);
    }

    public void rebindClassEntries(Class cls, EnvironmentContext envContext) throws NamingException, EnvironmentException {
        ClassEnvInfo clsInfo;
        if (this.namingEnvironment == null) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Rebinding Class ENC entries; envRoot={0}, class={1}", new Object[]{this.envRoot, cls.getName()});
        }
        if ((clsInfo = this.namingEnvironment.getClassEnvInfo(cls)) == null) {
            return;
        }
        Collection<EnvRef> entries = clsInfo.entries();
        this.bindEntries(entries, envContext, true);
    }

    /*
     * Exception decompiling
     */
    private void bindEntries(Collection<EnvRef> entries, EnvironmentContext envContext, boolean rebind) throws NamingException, EnvironmentException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindAllEntries() throws NamingException {
        if (this.isEnvRootUsed) {
            try {
                LoginService.loginCodeSubject();
            }
            catch (Exception ex) {
                throw new RuntimeException("System exception", ex);
            }
            InitialContext ctx = null;
            try {
                ctx = this.getInitialContext();
                ctx.destroySubcontext(this.envRoot);
            }
            finally {
                try {
                    LoginService.logout();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException namingException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveInjections(Class cls, Object instance) throws InjectionException {
        assert (cls != null);
        if (this.namingEnvironment == null) {
            return;
        }
        try {
            LoginService.loginCodeSubject();
        }
        catch (Exception ex) {
            throw new InjectionException("System exception", ex);
        }
        InitialContext ctx = null;
        try {
            ctx = this.getInitialContext();
            this.resolveInjectionsInternal(ctx, cls, instance);
        }
        finally {
            try {
                LoginService.logout();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException ex) {}
        }
    }

    public void invokePostConstructCallbacks(Class cls, Object instance) throws Throwable {
        Method method;
        ClassEnvInfo classInjectionInfo;
        if (this.namingEnvironment == null) {
            return;
        }
        Class superClass = cls.getSuperclass();
        if (superClass != Object.class) {
            this.invokePostConstructCallbacks(superClass, instance);
        }
        if ((classInjectionInfo = this.namingEnvironment.getClassEnvInfo(cls)) != null && (method = classInjectionInfo.getPostConstructMethod()) != null) {
            this.invokeCallbackMethod(method, instance);
        }
    }

    public void invokePreDestroyCallbacks(Class cls, Object instance) throws Throwable {
        Method method;
        ClassEnvInfo classInjectionInfo;
        if (this.namingEnvironment == null) {
            return;
        }
        Class superClass = cls.getSuperclass();
        if (superClass != Object.class) {
            this.invokePostConstructCallbacks(superClass, instance);
        }
        if ((classInjectionInfo = this.namingEnvironment.getClassEnvInfo(cls)) != null && (method = classInjectionInfo.getPreDestroyMethod()) != null) {
            this.invokeCallbackMethod(method, instance);
        }
    }

    private void resolveInjectionsInternal(InitialContext context, Class cls, Object instance) throws InjectionException {
        ClassEnvInfo classInjectionInfo;
        assert (context != null && cls != null);
        Class superClass = cls.getSuperclass();
        if (superClass != Object.class) {
            this.resolveInjectionsInternal(context, superClass, instance);
        }
        if ((classInjectionInfo = this.namingEnvironment.getClassEnvInfo(cls)) != null) {
            Iterator<InjectionInfo> iterator = classInjectionInfo.getInjectionInfoIterator();
            while (iterator.hasNext()) {
                InjectionInfo injection = iterator.next();
                EnvRef entry = this.getEntry(injection.getEnvName());
                assert (entry != null);
                if (!entry.isInjectable()) continue;
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Trying to inject {0}", (Object)injection.toString());
                    }
                    Object value = entry.getBoundObject(context);
                    injection.inject(instance, value);
                }
                catch (Exception ex) {
                    if (!logger.isLoggable(JeusMessage_Client._52_LEVEL)) continue;
                    logger.log(JeusMessage_Client._52_LEVEL, JeusMessage_Client._52, (Object)injection.getMember(), (Throwable)ex);
                }
            }
        }
    }

    private void invokeCallbackMethod(Method method, Object instance) throws Throwable {
        boolean turnedOn = false;
        try {
            if (!method.isAccessible()) {
                ReflectionUtils.setAccessible(method, true);
                turnedOn = true;
            }
            method.invoke(instance, new Object[0]);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
        catch (Exception ex) {
            throw new RuntimeException("System exception in calling callback method", ex);
        }
        finally {
            if (turnedOn) {
                ReflectionUtils.setAccessible(method, false);
            }
        }
    }

    InitialContext getInitialContext() throws RuntimeException {
        Hashtable<String, String> envs = new Hashtable<String, String>();
        envs.put("java.naming.factory.initial", "jeus.jndi.JNSContextFactory");
        envs.put("java.naming.factory.url.pkgs", "jeus.jndi.jns.url");
        envs.put("jeus.jndi.jns.localbindings", "true");
        envs.put("jeus.jndi.jns.forcedbindings", "true");
        try {
            return new InitialContext(envs);
        }
        catch (NamingException ex) {
            throw new RuntimeException(ex);
        }
    }
}

