/*
 * Decompiled with CFR 0.152.
 */
package jeus.container.namingenv;

import java.util.Map;
import javax.naming.Reference;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContextType;
import jeus.container.ExecutionModule;
import jeus.container.namingenv.EnvRef;
import jeus.container.namingenv.EnvironmentContext;
import jeus.container.namingenv.EnvironmentException;
import jeus.container.namingenv.PersistenceContextRefFactory;
import jeus.jndi.objectfactory.ObjectRefAddr;
import jeus.persistence.container.PersistenceUnit;
import jeus.persistence.container.PersistenceUnitNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceContextRef
extends EnvRef {
    protected String unitName = "";
    protected PersistenceContextType type = PersistenceContextType.TRANSACTION;
    protected Map properties;
    protected PersistenceUnit pu;

    public PersistenceContextRef(String name) {
        super(name);
    }

    public PersistenceContextRef(String name, String unitName, PersistenceContextType type, Map properties) {
        super(name);
        this.unitName = unitName;
        this.type = type;
        this.properties = properties;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public PersistenceContextType getType() {
        return this.type;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void overrideUnitName(String unitName) {
        this.unitName = unitName;
    }

    public void overrideType(PersistenceContextType type) {
        this.type = type;
    }

    public void overrideProperties(Map<String, String> properties) {
        if (this.properties == null) {
            this.properties = properties;
        } else {
            this.properties.putAll(properties);
        }
    }

    public PersistenceUnit getPersistenceUnit() {
        return this.pu;
    }

    @Override
    public Object getBindingObject(EnvironmentContext context) throws EnvironmentException {
        String className = EntityManager.class.getName();
        String factory = PersistenceContextRefFactory.class.getName();
        String factoryLocation = null;
        if (context.isServerMode()) {
            ExecutionModule module = context.getModule();
            try {
                this.pu = module.lookupPersistenceUnit(this.unitName);
            }
            catch (PersistenceUnitNotFoundException ex) {
                throw new EnvironmentException("Could not find persistence unit '" + this.unitName + "'.", ex);
            }
            Reference ref = new Reference(className, factory, factoryLocation);
            ref.add(0, new ObjectRefAddr("PersistenceContextRef", this));
            return ref;
        }
        return null;
    }
}

