/*
 * Decompiled with CFR 0.152.
 */
package jeus.container.namingenv;

import java.util.List;
import jeus.container.namingenv.EnvRef;
import jeus.container.namingenv.EnvironmentContext;
import jeus.container.namingenv.EnvironmentDescriptorProcessor;
import jeus.container.namingenv.EnvironmentException;
import jeus.container.namingenv.JndiEnvironmentMappingGroup;
import jeus.deploy.InvalidDescriptorException;
import jeus.xml.binding.jeusDD.EnvType;

public class SimpleEnvEntry
extends EnvRef {
    protected Class type;
    protected Object value;

    public SimpleEnvEntry(String name) {
        super(name);
    }

    public SimpleEnvEntry(String name, Class type, Object value) {
        super(name);
        this.type = type;
        this.value = value;
    }

    public Object getBindingObject(EnvironmentContext context) throws EnvironmentException {
        Object mappedValue = this.getMappedValue(context.getEnvironmentMapping());
        if (mappedValue != null) {
            return mappedValue;
        }
        if (this.value != null) {
            return this.value;
        }
        return null;
    }

    private Object getMappedValue(JndiEnvironmentMappingGroup context) throws EnvironmentException {
        List<EnvType> envList = context.getSimpleEnvMapping();
        if (envList != null) {
            for (EnvType envtype : envList) {
                try {
                    String name = envtype.getName().trim();
                    if (!this.name.equals(name)) continue;
                    Class type = this.type;
                    if (envtype.isSetType()) {
                        String typeName = envtype.getType().trim();
                        type = EnvironmentDescriptorProcessor.getSimpleEnvType(typeName);
                    }
                    String value1 = envtype.getValue().trim();
                    Object value2 = EnvironmentDescriptorProcessor.getSimpleEnvValue(type, value1);
                    return value2;
                }
                catch (InvalidDescriptorException e) {
                    throw new EnvironmentException("Invalid value in <env> element of runtime DD", e);
                }
            }
        }
        return null;
    }

    public static boolean isSimpleEnvEntryType(Class type) {
        if (type.isPrimitive()) {
            return true;
        }
        return type == String.class || type == Character.class || type == Byte.class || type == Short.class || type == Integer.class || type == Long.class || type == Boolean.class || type == Double.class || type == Float.class;
    }

    public Class getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public Class overrideType(Class type) {
        if (this.type == null) {
            this.type = type;
        }
        return this.type;
    }

    public Object setValue(Object value) {
        this.value = value;
        return value;
    }
}

