/*
 * Decompiled with CFR 0.152.
 */
package jeus.container.resource;

import java.util.Properties;
import javax.annotation.Resource;
import jeus.jndi.jns.common.PropertyLinkRef;

public class ResourceRefHelper {
    public static final boolean DEFAULT_SHAREABLE = true;
    public static final Resource.AuthenticationType DEFAULT_AUTH_TYPE = Resource.AuthenticationType.CONTAINER;
    private static final String SHARING_SCOPE_PROPERTY_NAME = "res-sharing-scope";
    private static final String AUTH_PROPERTY_NAME = "res-auth";
    private static final String UNSHARABLE_PROPERTY_VALUE = "Unshareable";
    private static final String APP_AUTH_PROPERTY_VALUE = "application";

    public static PropertyLinkRef createPropertyLinkRef(String jndiName, boolean shareable, Resource.AuthenticationType authType) {
        Properties p = new Properties();
        p.setProperty(SHARING_SCOPE_PROPERTY_NAME, shareable ? "Shareable" : UNSHARABLE_PROPERTY_VALUE);
        p.setProperty(AUTH_PROPERTY_NAME, authType.name());
        return new PropertyLinkRef(jndiName, p);
    }

    public static boolean fetchShareable(Properties props) {
        if (props == null) {
            return true;
        }
        String value = props.getProperty(SHARING_SCOPE_PROPERTY_NAME);
        if (value == null) {
            return true;
        }
        boolean result = !UNSHARABLE_PROPERTY_VALUE.equals(value);
        return result;
    }

    public static Resource.AuthenticationType fetchAppAuth(Properties props) {
        if (props == null) {
            return DEFAULT_AUTH_TYPE;
        }
        String auth = props.getProperty(AUTH_PROPERTY_NAME);
        if (auth == null) {
            return DEFAULT_AUTH_TYPE;
        }
        return Resource.AuthenticationType.valueOf((String)auth);
    }
}

