/*
 * Decompiled with CFR 0.152.
 */
package jeus.container.security;

import java.lang.reflect.Method;

public class MethodSecurityInfo {
    protected Method method;
    protected boolean isSecuritySpecified;
    protected String[] rolesAllowed;
    protected boolean permitAll = false;
    protected boolean denyAll = false;

    public static MethodSecurityInfo createUnspecified(Method method) {
        MethodSecurityInfo one = new MethodSecurityInfo(method);
        one.isSecuritySpecified = false;
        return one;
    }

    public static MethodSecurityInfo createRoleAllowed(Method method, String[] roles) {
        MethodSecurityInfo one = new MethodSecurityInfo(method);
        one.isSecuritySpecified = true;
        one.rolesAllowed = roles;
        return one;
    }

    public static MethodSecurityInfo createPermittedAll(Method method) {
        MethodSecurityInfo one = new MethodSecurityInfo(method);
        one.isSecuritySpecified = true;
        one.permitAll = true;
        return one;
    }

    public static MethodSecurityInfo createDeniedAll(Method method) {
        MethodSecurityInfo one = new MethodSecurityInfo(method);
        one.isSecuritySpecified = true;
        one.denyAll = true;
        return one;
    }

    private MethodSecurityInfo(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean isSecuritySpecified() {
        return this.isSecuritySpecified;
    }

    public String[] getRolesAllowed() {
        return this.rolesAllowed;
    }

    public boolean isPermitAll() {
        return this.permitAll;
    }

    public boolean isDenyAll() {
        return this.denyAll;
    }
}

