/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import jeus.deploy.ApplicationNameToRemove;
import jeus.deploy.JeusDeploymentException;
import jeus.deploy.ModuleTypeSerializable;
import jeus.deploy.TargetImpl;
import jeus.deploy.TargetModuleIDImpl;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.ArchiveHelper;
import jeus.deploy.archivist.FileArchive;
import jeus.deploy.archivist.JarArchiveFactory;
import jeus.deploy.archivist.MemoryMappedArchive;
import jeus.deploy.command.DeploymentCommander;
import jeus.deploy.config.DConfigBeanSpecificationSource;
import jeus.deploy.config.JeusDeploymentConfiguration;
import jeus.deploy.io.AppClientDeploymentDescriptorFile;
import jeus.deploy.io.ApplicationDeploymentDescriptorFile;
import jeus.deploy.io.ConnectorDeploymentDescriptorFile;
import jeus.deploy.io.DeploymentDescriptorFile;
import jeus.deploy.io.EjbDeploymentDescriptorFile;
import jeus.deploy.io.WebDeploymentDescriptorFile;
import jeus.deploy.io.runtime.ApplicationRuntimeDDFile;
import jeus.deploy.status.DeploymentStatusImpl;
import jeus.deploy.status.JeusProgressObject;
import jeus.deploy.util.ModuleTypeResolver;
import jeus.descriptor.bind.JeusMainDescriptorJB;
import jeus.management.JMXUtility;
import jeus.management.enterprise.agent.MEJBUtility;
import jeus.management.j2ee.Targetable;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.spi.LoginService;
import jeus.server.NodeControllerStub;
import jeus.tool.xmlui.engine.XMLUIEngine;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusProperties;
import jeus.util.JeusRuntimeException;
import jeus.util.SecurityUtil;
import jeus.util.VirtualDNS;
import jeus.util.file.FileUtils;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Deploy;
import jeus.util.regex.CharSequence;
import jeus.util.regex.Matcher;
import jeus.util.regex.Pattern;
import jeus.util.regex.StringCharSequence;
import jeus.xml.binding.ObjectFactoryHelper;
import jeus.xml.binding.j2ee.ObjectFactory;
import jeus.xml.binding.j2ee.PathType;
import jeus.xml.binding.j2ee.String;
import jeus.xml.binding.j2ee.WebType;
import jeus.xml.binding.jeusDD.ApplicationType;
import jeus.xml.binding.jeusDD.ClientComponentType;
import jeus.xml.binding.jeusDD.ConnectorComponentType;
import jeus.xml.binding.jeusDD.DeploymentTypeType;
import jeus.xml.binding.jeusDD.EjbComponentType;
import jeus.xml.binding.jeusDD.WebComponentType;
import jeus.xml.binding.jeusDDHelper.JeusMainHelper;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JeusDeploymentManager
implements DeploymentManager {
    private static final java.lang.String UI_RESOURCE_PACKAGE = "/jeus/tool/resource/ui";
    private static final java.lang.String DEPLOY_URI = "deployer:Jeus:";
    private static final java.lang.String URL_PKG_PREFIX = "jeus.jndi.jns.url";
    boolean isConnected;
    MEJBUtility jmxUtil;
    private static HashMap runtimeDescriptorMap = new HashMap();
    private static HashMap j2eeDescriptorMap = new HashMap();
    jeus.xml.binding.jeusDD.ObjectFactory objectFactory;
    private byte[] serializedSubject;
    DeploymentCommander commander;
    private java.lang.String hostName = VirtualDNS.LOCAL_VIRTUALNAME;
    private java.lang.String jndiProtocol = "client";
    private java.lang.String securityDomain = "SYSTEM_DOMAIN";
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((java.lang.String)"jeus.deploy");
    private Map settingMap = Collections.EMPTY_MAP;
    private DConfigBeanSpecificationSource dConfigBeanSpecificationSource;
    private XMLUIEngine uiengine;
    public static final java.lang.String DEPLOY_FROM_CONTAINER_DIRECTORY = "DEPLOY_FROM_CONTAINER_DIRECTORY";

    public JeusDeploymentManager(java.lang.String uri, java.lang.String username, java.lang.String password) throws DeploymentManagerCreationException {
        try {
            this.parseURI(uri);
            SecurityUtil.installClientSecurity(this.hostName);
            this.initializeConnection(username, password);
            this.commander = new DeploymentCommander();
            Subject subj = Subject.makeSubject(this.securityDomain, username, password);
            this.commander.setCurrentSubject(subj);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new DeploymentManagerCreationException(t.getMessage());
        }
    }

    public JeusDeploymentManager(java.lang.String uri) throws DeploymentManagerCreationException {
        if (uri == null || !uri.startsWith(DEPLOY_URI)) {
            throw new DeploymentManagerCreationException("Invalid URI Format :" + uri + ".");
        }
    }

    private void parseURI(java.lang.String uri) {
        if (uri == null) {
            return;
        }
        java.lang.String[] components = JeusDeploymentManager.decomposeUri(uri);
        if (components[0] != null) {
            this.hostName = components[0];
        }
        if (components[1] != null) {
            this.securityDomain = components[1];
        }
        if (components[2] != null) {
            this.jndiProtocol = components[2];
        }
        if (logger.isLoggable(JeusMessage_Deploy._4_LEVEL)) {
            logger.log(JeusMessage_Deploy._4_LEVEL, JeusMessage_Deploy._4, (Object[])new java.lang.String[]{this.hostName, this.securityDomain, this.jndiProtocol});
        }
    }

    public static java.lang.String[] decomposeUri(java.lang.String uri) {
        java.lang.String[] result = new java.lang.String[3];
        if (uri == null) {
            return result;
        }
        Pattern pattern = Pattern.compile((java.lang.String)"deployer:Jeus:([^:]+(:[0-9]+)?)(::([^:]+)(:(client))?)?");
        Matcher matcher = pattern.matcher((CharSequence)new StringCharSequence(uri));
        if (matcher.find()) {
            int grpcnt = matcher.groupCount();
            if (grpcnt >= 1) {
                result[0] = matcher.group(1);
            }
            if (grpcnt >= 4) {
                result[1] = matcher.group(4);
            }
            if (grpcnt == 6) {
                result[2] = matcher.group(6);
            }
        } else {
            throw new IllegalArgumentException("Invalid URI format " + uri + ".");
        }
        return result;
    }

    private void initializeConnection(java.lang.String username, java.lang.String password) throws Exception {
        Subject subj = Subject.makeSubject(this.securityDomain, username, password);
        try {
            LoginService.login(subj);
        }
        catch (ServiceException e) {
            if (logger.isLoggable(JeusMessage_Deploy._5_LEVEL)) {
                logger.logp(JeusMessage_Deploy._5_LEVEL, "JeusDeploymentManager", "initializeConnection", JeusMessage_Deploy._5);
            }
            throw new JeusRuntimeException(JeusMessage_Deploy._5, (Throwable)e);
        }
        catch (SecurityException e) {
            if (logger.isLoggable(JeusMessage_Deploy._6_LEVEL)) {
                logger.logp(JeusMessage_Deploy._6_LEVEL, "JeusDeploymentManager", "initializeConnection", JeusMessage_Deploy._6, (Object[])new java.lang.String[]{username, password});
            }
            throw new RuntimeException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Deploy._6, (Object[])new java.lang.String[]{username, password}));
        }
        try {
            this.serializedSubject = LoginService.getCurrentSubject().serialize();
            Hashtable<java.lang.String, java.lang.String> env = new Hashtable<java.lang.String, java.lang.String>();
            if (this.jndiProtocol.equals("client")) {
                env.put("java.naming.factory.initial", "jeus.jndi.JNSContextFactory");
                env.put("java.naming.factory.url.pkgs", URL_PKG_PREFIX);
                env.put("java.naming.provider.url", this.hostName);
            }
            if (logger.isLoggable(JeusMessage_Deploy._7_LEVEL)) {
                logger.log(JeusMessage_Deploy._7_LEVEL, JeusMessage_Deploy._7, env);
            }
            this.jmxUtil = MEJBUtility.getMEJBUtility(env);
            this.objectFactory = new jeus.xml.binding.jeusDD.ObjectFactory();
            if (this.serializedSubject != null) {
                this.isConnected = true;
            }
        }
        catch (Exception e) {
            this.isConnected = false;
            throw e;
        }
        finally {
            try {
                LoginService.logout();
            }
            catch (Throwable e) {
                throw new JeusRuntimeException("Exception occurred", e);
            }
        }
    }

    public MEJBUtility getJMXUtility() {
        return this.jmxUtil;
    }

    public Target[] getTargets() throws IllegalStateException {
        if (!this.isConnected) {
            if (logger.isLoggable(JeusMessage_Deploy._3_LEVEL)) {
                logger.logp(JeusMessage_Deploy._3_LEVEL, "JeusDeploymentManager", "getTargets", JeusMessage_Deploy._3);
            }
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Deploy._3));
        }
        Target[] targetArray = null;
        Vector<TargetImpl> targets = new Vector<TargetImpl>();
        try {
            ObjectName queryName = new ObjectName("JEUS:isTargetable=true,*");
            Set targetList = this.jmxUtil.queryNames(queryName, null);
            for (ObjectName targetItem : targetList) {
                targets.add(new TargetImpl(targetItem));
            }
            targetArray = targets.toArray(new Target[targets.size()]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return targetArray;
    }

    public TargetModuleID[] getTargetModuleIDsFromModuleName(TargetImpl[] targetList, java.lang.String moduleName, java.lang.String moduleTypeString) throws Exception {
        Vector<TargetModuleIDImpl> tmpStore = new Vector<TargetModuleIDImpl>();
        for (TargetImpl target : targetList) {
            Set targetModuleList;
            java.lang.String containerName = target.getContainerName();
            ObjectName queryName = new ObjectName("JEUS:name=" + moduleName + "," + "j2eeType" + "=" + moduleTypeString + "," + "J2EEServer" + "=" + containerName + ",*");
            if (logger.isLoggable(JeusMessage_Deploy._8_LEVEL)) {
                logger.log(JeusMessage_Deploy._8_LEVEL, JeusMessage_Deploy._8, (Object)queryName);
            }
            if ((targetModuleList = this.jmxUtil.queryNames(queryName, null)) == null || targetModuleList.size() == 0) {
                throw new Exception("There is no module corresponding to " + moduleName);
            }
            for (Object aTargetModuleList : targetModuleList) {
                ObjectName itemName = (ObjectName)aTargetModuleList;
                tmpStore.add(new TargetModuleIDImpl(itemName, target));
            }
        }
        TargetModuleID[] resultModuleIDs = tmpStore.toArray(new TargetModuleID[0]);
        return resultModuleIDs;
    }

    public TargetModuleID[] getTargetModuleIDsFromModuleName(java.lang.String[] containerNames, java.lang.String moduleName, java.lang.String moduleTypeString) throws Exception {
        TargetImpl[] targets = new TargetImpl[containerNames.length];
        for (int i = 0; i < containerNames.length; ++i) {
            java.lang.String containerName = containerNames[i];
            targets[i] = new TargetImpl(JMXUtility.queryJ2EEServer((MBeanServerConnection)this.jmxUtil, containerName));
        }
        return this.getTargetModuleIDsFromModuleName(targets, moduleName, moduleTypeString);
    }

    private TargetModuleID[] handleCommonModules(ModuleType moduleType, Target[] targets, java.lang.String opName) throws IllegalStateException {
        if (!this.isConnected) {
            throw new IllegalStateException("The deployment manager is disconnected");
        }
        if (targets == null || targets.length == 0) {
            throw new IllegalStateException("The target is not specified");
        }
        Vector<TargetModuleID> targetList = new Vector<TargetModuleID>();
        ModuleTypeSerializable typeSerializable = ModuleTypeSerializable.getModuleTypeSerializable(moduleType);
        try {
            for (Target target : targets) {
                ObjectName targetName = ((TargetImpl)target).getObjectName();
                TargetModuleID[] tmList = (TargetModuleID[])this.jmxUtil.invoke(targetName, opName, new Object[]{typeSerializable}, new java.lang.String[]{"jeus.deploy.ModuleTypeSerializable"});
                targetList.addAll(Arrays.asList(tmList));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (targetList.size() == 0) {
            return null;
        }
        return targetList.toArray(new TargetModuleID[0]);
    }

    public TargetModuleID[] getRunningModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        return this.handleCommonModules(moduleType, targetList, "getRunningModules");
    }

    public TargetModuleID[] getNonRunningModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        return this.handleCommonModules(moduleType, targetList, "getNonRunningModules");
    }

    public TargetModuleID[] getAvailableModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        return this.handleCommonModules(moduleType, targetList, "getAvailableModules");
    }

    public DeploymentConfiguration createConfiguration(DeployableObject deployableObject) throws InvalidModuleException {
        try {
            return new JeusDeploymentConfiguration(deployableObject, this);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
            throw new InvalidModuleException(e.getMessage());
        }
    }

    public ProgressObject distribute(Target[] atarget, File moduleArchive, File deploymentPlan) throws IllegalStateException {
        if (!this.isConnected) {
            throw new IllegalStateException("The deployment manager is disconnected");
        }
        Object archiveIn = null;
        try {
            ApplicationType applicationDDInfo;
            FileInputStream planIn = null;
            if (deploymentPlan != null) {
                planIn = new FileInputStream(deploymentPlan);
            }
            archiveIn = moduleArchive.isDirectory() ? new FileArchive(moduleArchive.getAbsolutePath()) : JarArchiveFactory.openArchiveStatic((File)moduleArchive);
            ModuleType moduleType = ModuleTypeResolver.getModuleType(archiveIn);
            java.lang.String archiveUri = archiveIn.getArchiveUri();
            java.lang.String mName = archiveUri.substring(archiveUri.lastIndexOf(File.separator) + 1);
            if (!moduleArchive.isDirectory() && mName.lastIndexOf(46) > 0) {
                mName = mName.substring(0, mName.lastIndexOf(46));
            }
            java.lang.String moduleExtension = moduleType.getModuleExtension();
            java.lang.String fileFullPath = moduleArchive.getAbsolutePath();
            if (planIn != null) {
                File tmpFile = File.createTempFile("deploy", moduleExtension);
                applicationDDInfo = this.mergeDeploymentPlan((AbstractArchive)archiveIn, planIn, new BufferedOutputStream(new FileOutputStream(tmpFile)), moduleType, mName);
                fileFullPath = tmpFile.getAbsolutePath();
            } else {
                applicationDDInfo = JeusDeploymentManager.fillApplicationDDInfoFromArchive(archiveIn, this.settingMap);
            }
            if (archiveIn != null) {
                archiveIn.close();
            }
            JeusProgressObject distProgress = new JeusProgressObject(CommandType.DISTRIBUTE, atarget.length);
            DThread runThread = new DThread(atarget, fileFullPath, applicationDDInfo, distProgress, true, false, false);
            runThread.start();
            JeusProgressObject jeusProgressObject = distProgress;
            return jeusProgressObject;
        }
        catch (IOException ex) {
            throw new RuntimeException("The deployment plan file is not exists");
        }
        catch (Exception ee) {
            ee.printStackTrace();
            throw new RuntimeException("Distribution File Error");
        }
        finally {
            try {
                if (archiveIn != null) {
                    archiveIn.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public ProgressObject deploy(Target[] atarget, File moduleArchive, File deploymentPlan, boolean fastDeploy, boolean onlyDistribute, boolean atomic, boolean autoSourceDistribute) throws IllegalStateException {
        if (!this.isConnected) {
            throw new IllegalStateException("The deployment manager is disconnected");
        }
        if (!moduleArchive.exists()) {
            throw new RuntimeException("The module file does not exists : " + moduleArchive.getAbsolutePath());
        }
        Object archiveIn = null;
        try {
            ApplicationType applicationDDInfo;
            ModuleType moduleType;
            FileInputStream planIn = null;
            archiveIn = moduleArchive.isDirectory() ? new FileArchive(moduleArchive.getAbsolutePath()) : JarArchiveFactory.openArchiveStatic((File)moduleArchive);
            if (deploymentPlan != null && deploymentPlan.exists()) {
                planIn = new FileInputStream(deploymentPlan);
            }
            java.lang.String archiveUri = archiveIn.getArchiveUri();
            java.lang.String mName = archiveUri.substring(archiveUri.lastIndexOf(File.separator) + 1);
            if (!moduleArchive.isDirectory() && mName.lastIndexOf(46) > 0) {
                mName = mName.substring(0, mName.lastIndexOf(46));
            }
            if ((moduleType = ModuleTypeResolver.getModuleType(archiveIn)) == null) {
                throw new RuntimeException("Unable to determine module type of '" + archiveUri + "'.");
            }
            java.lang.String moduleExtension = moduleType.getModuleExtension();
            java.lang.String fileFullPath = moduleArchive.getAbsolutePath();
            if (planIn != null) {
                File tmpFile = File.createTempFile("deploy", moduleExtension);
                applicationDDInfo = this.mergeDeploymentPlan((AbstractArchive)archiveIn, planIn, new BufferedOutputStream(new FileOutputStream(tmpFile)), moduleType, mName);
                fileFullPath = tmpFile.getAbsolutePath();
            } else {
                applicationDDInfo = JeusDeploymentManager.fillApplicationDDInfoFromArchive(archiveIn, this.settingMap);
            }
            if (archiveIn != null) {
                archiveIn.close();
            }
            JeusProgressObject deployProgress = new JeusProgressObject("deploy", atarget.length);
            DThread runThread = new DThread(atarget, fileFullPath, applicationDDInfo, deployProgress, autoSourceDistribute, atomic, onlyDistribute);
            runThread.start();
            JeusProgressObject jeusProgressObject = deployProgress;
            return jeusProgressObject;
        }
        catch (IOException ex) {
            throw new RuntimeException("The deployment plan file does not exists");
        }
        catch (Exception ee) {
            ee.printStackTrace();
            throw new RuntimeException("Distribution File Error");
        }
        finally {
            try {
                if (archiveIn != null) {
                    archiveIn.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public ProgressObject deploy(Target[] atarget, File moduleArchive, File deploymentPlan, boolean onlyDistribute, boolean atomic) throws IllegalStateException {
        return this.deploy(atarget, moduleArchive, deploymentPlan, false, onlyDistribute, atomic, true);
    }

    private void deployCommand(Target[] targets, ApplicationType applicationDDInfo, JeusProgressObject deployProgress, boolean autoSrcDistribute, boolean onlyDistribute, boolean atomic) {
        JeusProgressObject distProgress = new JeusProgressObject(deployProgress);
        this.commander.distribute(targets, applicationDDInfo, (MBeanServerConnection)this.jmxUtil, distProgress, autoSrcDistribute);
        TargetModuleID[] moduleIDs = distProgress.getResultTargetModuleIDs();
        if (atomic && moduleIDs.length < distProgress.getTargetNumber()) {
            JeusProgressObject undeployProgress = new JeusProgressObject(deployProgress);
            this.commander.undeploy(moduleIDs, (MBeanServerConnection)this.jmxUtil, undeployProgress);
            DeploymentStatusImpl status = new DeploymentStatusImpl(StateType.FAILED, "deploy");
            ProgressEvent event = new ProgressEvent((Object)this, moduleIDs[0], (DeploymentStatus)status);
            deployProgress.fireProgressEvent(event);
            return;
        }
        if (onlyDistribute) {
            return;
        }
        JeusProgressObject startProgress = new JeusProgressObject(deployProgress);
        this.commander.start(moduleIDs, (MBeanServerConnection)this.jmxUtil, startProgress);
        if (atomic && startProgress.getResultTargetModuleIDs().length < startProgress.getTargetNumber()) {
            JeusProgressObject undeployProgress = new JeusProgressObject(deployProgress);
            this.commander.undeploy(moduleIDs, (MBeanServerConnection)this.jmxUtil, undeployProgress);
            DeploymentStatusImpl status = new DeploymentStatusImpl(StateType.FAILED, "deploy");
            ProgressEvent event = new ProgressEvent((Object)this, moduleIDs[0], (DeploymentStatus)status);
            deployProgress.fireProgressEvent(event);
            return;
        }
        deployProgress.setResultTargetModuleIDs(Arrays.asList(startProgress.getResultTargetModuleIDs()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationType fillApplicationDDInfoFromArchive(AbstractArchive archiveIn, Map settingMap) throws IOException, JAXBException, JeusDeploymentException {
        ApplicationType applicationInfo = null;
        if (archiveIn == null) {
            return null;
        }
        java.lang.String ddFileName = "META-INF/jeus-application-dd.xml";
        InputStream is = archiveIn.getEntry(ddFileName);
        if (is != null) {
            try {
                applicationInfo = JeusDeploymentManager.getApplicationDDInfo(is);
            }
            finally {
                is.close();
            }
        }
        ddFileName = "META-INF\\jeus-application-dd.xml";
        is = archiveIn.getEntry(ddFileName);
        if (is != null) {
            try {
                applicationInfo = JeusDeploymentManager.getApplicationDDInfo(is);
            }
            finally {
                is.close();
            }
        }
        if (applicationInfo == null || applicationInfo.getNameAndPathAndDeploymentType() == null || applicationInfo.getNameAndPathAndDeploymentType().isEmpty()) {
            ModuleType moduleType = ModuleTypeResolver.getModuleType(archiveIn);
            if (moduleType == null) {
                throw new JeusDeploymentException("The archive is not J2EE module archive");
            }
            java.lang.String archiveUri = archiveIn.getArchiveUri();
            jeus.xml.binding.j2ee.ApplicationType j2eeApplicationInfo = null;
            if (moduleType.equals(ModuleType.EAR)) {
                j2eeApplicationInfo = JeusDeploymentManager.getApplicationInfo(archiveIn);
            }
            applicationInfo = JeusDeploymentManager.fillApplicationDDFromModuleType(moduleType, archiveUri, j2eeApplicationInfo, settingMap);
        }
        if (logger.isLoggable(JeusMessage_Deploy._9_LEVEL)) {
            logger.log(JeusMessage_Deploy._9_LEVEL, JeusMessage_Deploy._9, (Object)applicationInfo.strip2());
        }
        return applicationInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject distribute(Target[] targetList, InputStream moduleArchive, InputStream deploymentPlan) throws IllegalStateException {
        ProgressObject progressObject;
        if (!this.isConnected) {
            throw new IllegalStateException("The deployment manager is disconnected");
        }
        MemoryMappedArchive mmArchive = new MemoryMappedArchive(moduleArchive);
        ModuleType type = ModuleTypeResolver.getModuleType((AbstractArchive)mmArchive);
        try {
            progressObject = this.distribute0(targetList, type, (AbstractArchive)mmArchive, deploymentPlan);
        }
        catch (Throwable throwable) {
            try {
                try {
                    mmArchive.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException("Exception occured", ex);
            }
        }
        try {
            mmArchive.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return progressObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject distribute(Target[] targetList, ModuleType type, InputStream moduleArchive, InputStream deploymentPlan) throws IllegalStateException {
        ProgressObject progressObject;
        if (!this.isConnected) {
            throw new IllegalStateException("The deployment manager is disconnected");
        }
        MemoryMappedArchive mmArchive = new MemoryMappedArchive(moduleArchive);
        try {
            progressObject = this.distribute0(targetList, type, (AbstractArchive)mmArchive, deploymentPlan);
        }
        catch (Throwable throwable) {
            try {
                try {
                    mmArchive.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException("Exception occured", ex);
            }
        }
        try {
            mmArchive.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return progressObject;
    }

    private ProgressObject distribute0(Target[] targetList, ModuleType type, AbstractArchive moduleArchive, InputStream deploymentPlan) throws IllegalStateException {
        try {
            java.lang.String moduleExtension = type.getModuleExtension();
            File tmpFile = File.createTempFile("deploy", moduleExtension);
            ApplicationType applicationDDInfo = this.mergeDeploymentPlan(moduleArchive, deploymentPlan, new BufferedOutputStream(new FileOutputStream(tmpFile)), type, null);
            java.lang.String fileFullPath = tmpFile.getAbsolutePath();
            JeusProgressObject distProgress = new JeusProgressObject(CommandType.DISTRIBUTE, targetList.length);
            DThread runThread = new DThread(targetList, fileFullPath, applicationDDInfo, distProgress, true, false, false);
            runThread.start();
            return distProgress;
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception occured", ex);
        }
    }

    private List getModuleList(AbstractArchive jar) throws Exception {
        jeus.xml.binding.j2ee.ApplicationType clientJar = JeusDeploymentManager.getApplicationInfo(jar);
        return clientJar.getModule();
    }

    public static jeus.xml.binding.j2ee.ApplicationType getApplicationInfo(AbstractArchive archive) throws IOException, JAXBException {
        return JeusDeploymentManager.getApplicationInfo(archive, false);
    }

    public static jeus.xml.binding.j2ee.ApplicationType getApplicationInfo(AbstractArchive archive, boolean writeIfNone) throws IOException, JAXBException {
        jeus.xml.binding.j2ee.ApplicationType app;
        ApplicationDeploymentDescriptorFile file = new ApplicationDeploymentDescriptorFile();
        if (file.existsDescriptorFile(archive)) {
            app = (jeus.xml.binding.j2ee.ApplicationType)file.getDeploymentDescriptor(archive);
        } else {
            app = JeusDeploymentManager.makeApplicationInfo(archive);
            if (writeIfNone) {
                try {
                    ObjectFactory of = ObjectFactoryHelper.getJ2EEObjectFactory();
                    file.marshalDescriptor((Object)of.createApplication(app), archive);
                }
                catch (SAXException ex) {
                    IOException newex = new IOException();
                    newex.initCause(ex);
                    throw newex;
                }
            }
        }
        return app;
    }

    private java.lang.String getRuntimeFile(ArrayList dpEntries, java.lang.String mangledName) {
        for (Object dpEntry : dpEntries) {
            java.lang.String s = (java.lang.String)dpEntry;
            if (!s.startsWith(mangledName)) continue;
            return s;
        }
        return null;
    }

    public static ModuleType getModuleType(AbstractArchive archive) {
        ModuleType type;
        try {
            type = ModuleTypeResolver.getModuleType(archive);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to determine module type of '" + archive.getArchiveUri() + "'.", e);
        }
        if (type != null) {
            return type;
        }
        throw new RuntimeException("Unable to determine module type of '" + archive.getArchiveUri() + "'.");
    }

    public static ModuleTypeSerializable getModuleTypeSerializable(AbstractArchive archive) {
        ModuleType type;
        try {
            type = ModuleTypeResolver.getModuleType(archive);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to determine module type of '" + archive.getArchiveUri() + "'.", e);
        }
        if (type != null) {
            return ModuleTypeSerializable.getModuleTypeSerializable(type);
        }
        throw new RuntimeException("Unable to determine module type of '" + archive.getArchiveUri() + "'.");
    }

    private static ApplicationType getApplicationDDInfo(InputStream appInfoIS) throws JAXBException, IOException {
        return (ApplicationType)new ApplicationRuntimeDDFile().getDeploymentDescriptor(appInfoIS);
    }

    /*
     * WARNING - void declaration
     */
    private ApplicationType mergeDeploymentPlan(AbstractArchive archive, InputStream deploymentPlan, OutputStream out, ModuleType moduleType, java.lang.String mName) throws Exception {
        ApplicationType applicationInfo = null;
        try {
            Object lib;
            ArrayList<java.lang.String> dpEntries = new ArrayList<java.lang.String>();
            ArrayList<Object> appLibraries = new ArrayList<Object>();
            MemoryMappedArchive dpArchive = new MemoryMappedArchive(deploymentPlan);
            Enumeration e = dpArchive.entries();
            while (e.hasMoreElements()) {
                java.lang.String entry = (java.lang.String)e.nextElement();
                int n = entry.indexOf("jeus-application-dd");
                if (n >= 0) {
                    applicationInfo = JeusDeploymentManager.getApplicationDDInfo(dpArchive.getEntry(entry));
                    if (mName == null) {
                        mName = JeusDeploymentManager.getNameFromPath(applicationInfo);
                    }
                    if (mName != null) continue;
                    throw new Exception("module name is not set");
                }
                if (entry.equals("APPINF_Libraries")) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(dpArchive.getEntry(entry)));
                    lib = reader.readLine();
                    while (lib != null) {
                        appLibraries.add(lib);
                        lib = reader.readLine();
                    }
                    reader.close();
                    continue;
                }
                dpEntries.add(entry);
            }
            if (applicationInfo == null) {
                jeus.xml.binding.j2ee.ApplicationType j2eeApplicationInfo = null;
                if (moduleType.equals(ModuleType.EAR)) {
                    j2eeApplicationInfo = JeusDeploymentManager.getApplicationInfo(archive);
                }
                applicationInfo = JeusDeploymentManager.fillApplicationDDFromModuleType(moduleType, archive.getArchiveUri(), j2eeApplicationInfo, this.settingMap);
            }
            JarOutputStream jos = new JarOutputStream(out);
            if (moduleType.equals(ModuleType.EAR)) {
                for (Object e2 : appLibraries) {
                    java.lang.String appLib = (java.lang.String)e2;
                    lib = new File(appLib);
                    if (!((File)lib).exists()) {
                        throw new RuntimeException("The library does not exist : " + appLib);
                    }
                    appLib = appLib.substring(appLib.lastIndexOf(File.separator) + 1);
                    ArchiveHelper.copy((InputStream)new FileInputStream((File)lib), (java.lang.String)("APP-INF" + File.separator + "lib" + File.separator + appLib), (ZipOutputStream)jos);
                }
                List modules = this.getModuleList(archive);
                Object var12_15 = null;
                for (jeus.xml.binding.j2ee.ModuleType moduleInfo : modules) {
                    java.lang.String[] runtimeDDPaths;
                    void var17_32;
                    void var12_16;
                    DeploymentDescriptorFile descFile;
                    java.lang.String moduleName;
                    block43: {
                        moduleName = null;
                        descFile = null;
                        Object var17_33 = null;
                        if (moduleInfo.getConnector() != null) {
                            moduleName = moduleInfo.getConnector().getValue();
                            descFile = new ConnectorDeploymentDescriptorFile();
                            ModuleType moduleType2 = ModuleType.RAR;
                        } else if (moduleInfo.getEjb() != null) {
                            moduleName = moduleInfo.getEjb().getValue();
                            descFile = new EjbDeploymentDescriptorFile();
                            ModuleType moduleType3 = ModuleType.EJB;
                        } else if (moduleInfo.getJava() != null) {
                            moduleName = moduleInfo.getJava().getValue();
                            descFile = new AppClientDeploymentDescriptorFile();
                            ModuleType moduleType4 = ModuleType.CAR;
                        } else if (moduleInfo.getWeb() != null) {
                            moduleName = moduleInfo.getWeb().getWebUri().getValue();
                            descFile = new WebDeploymentDescriptorFile();
                            ModuleType moduleType5 = ModuleType.WAR;
                        }
                        try {
                            AbstractArchive abstractArchive = archive.getEmbeddedArchive(moduleName);
                        }
                        catch (Exception e2) {
                            if (!logger.isLoggable(JeusMessage_Deploy._14_LEVEL)) break block43;
                            logger.log(JeusMessage_Deploy._14_LEVEL, JeusMessage_Deploy._14, (Object)moduleName);
                        }
                    }
                    if (var12_16 == null) {
                        throw new Exception("SUB module is not readable from ear file");
                    }
                    if (var17_32 == null) {
                        throw new Exception("Module Type is not descernible.");
                    }
                    jos.putNextEntry(new ZipEntry(moduleName));
                    JarOutputStream subOut = new JarOutputStream(jos);
                    ArrayList<java.lang.String> insertedEntries = new ArrayList<java.lang.String>();
                    PathType pathType = moduleInfo.getAltDd();
                    if (pathType != null) {
                        InputStream altDDStream = archive.getEntry(pathType.getValue());
                        java.lang.String entryName = descFile.setAltDD(altDDStream, subOut);
                        altDDStream.close();
                        insertedEntries.add(entryName);
                    }
                    java.lang.String extension = moduleName.substring(moduleName.length() - 3);
                    for (java.lang.String runtimeDDPath : runtimeDDPaths = (java.lang.String[])runtimeDescriptorMap.get(var17_32)) {
                        java.lang.String mangledName;
                        java.lang.String existingName;
                        if (dpArchive == null || (existingName = this.getRuntimeFile(dpEntries, mangledName = moduleName + "." + runtimeDDPath)) == null) continue;
                        runtimeDDPath = existingName.substring(moduleName.length() + 1);
                        java.lang.String entryName = (extension.equals("war") ? "WEB-INF" : "META-INF") + File.separator + runtimeDDPath;
                        ArchiveHelper.copy((InputStream)dpArchive.getEntry(existingName), (java.lang.String)entryName, (ZipOutputStream)subOut);
                        insertedEntries.add(entryName);
                    }
                    if (var12_16 == null) {
                        throw new Exception("SUB module is not readable from ear file");
                    }
                    try {
                        Manifest m = var12_16.getManifest();
                        if (m != null) {
                            subOut.putNextEntry(new ZipEntry("META-INF" + File.separator + "MANIFEST.MF"));
                            m.write(subOut);
                            subOut.closeEntry();
                        }
                    }
                    catch (Exception e3) {
                        // empty catch block
                    }
                    if (var12_16 == null) {
                        throw new Exception("SUB module is not readable from ear file");
                    }
                    Enumeration entries = var12_16.entries();
                    while (entries.hasMoreElements()) {
                        java.lang.String entryName = (java.lang.String)entries.nextElement();
                        try {
                            if (insertedEntries.contains(entryName)) continue;
                            ArchiveHelper.copy((InputStream)var12_16.getEntry(entryName), (java.lang.String)entryName, (ZipOutputStream)subOut);
                        }
                        catch (Exception e4) {}
                    }
                    subOut.finish();
                    jos.closeEntry();
                    var12_16.close();
                }
                Enumeration entries = archive.entries();
                while (entries.hasMoreElements()) {
                    java.lang.String entryName = (java.lang.String)entries.nextElement();
                    if (modules.contains(entryName)) continue;
                    try {
                        ArchiveHelper.copy((InputStream)archive.getEntry(entryName), (java.lang.String)entryName, (ZipOutputStream)jos);
                    }
                    catch (Exception e5) {}
                }
                ArchiveHelper.copyManifest((AbstractArchive)archive, (ZipOutputStream)jos);
            } else {
                java.lang.String[] runtimeDDPaths;
                block19: for (java.lang.String runtimeDDPath : runtimeDDPaths = (java.lang.String[])runtimeDescriptorMap.get(moduleType)) {
                    for (Object e3 : dpEntries) {
                        java.lang.String runtimeFile = (java.lang.String)e3;
                        int index = runtimeFile.indexOf(runtimeDDPath);
                        if (index < 0) continue;
                        ArchiveHelper.copy((InputStream)dpArchive.getEntry(runtimeFile), (java.lang.String)((moduleType.equals(ModuleType.WAR) ? "WEB-INF" : "META-INF") + File.separator + runtimeFile.substring(index)), (ZipOutputStream)jos);
                        continue block19;
                    }
                }
                Enumeration enumeration = archive.entries();
                while (enumeration.hasMoreElements()) {
                    java.lang.String entryName = (java.lang.String)enumeration.nextElement();
                    try {
                        ArchiveHelper.copy((InputStream)archive.getEntry(entryName), (java.lang.String)entryName, (ZipOutputStream)jos);
                    }
                    catch (Exception e6) {
                        e6.printStackTrace();
                    }
                }
                ArchiveHelper.copyManifest((AbstractArchive)archive, (ZipOutputStream)jos);
            }
            jos.flush();
            jos.close();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new Exception(ex);
        }
        return applicationInfo;
    }

    public static ModuleType getModuleType(ApplicationType appType) {
        List appList = appType.getNameAndPathAndDeploymentType();
        for (JAXBElement anAppList : appList) {
            java.lang.String deploymentType;
            Object obj = anAppList.getValue();
            if (obj instanceof DeploymentTypeType && ((deploymentType = ((DeploymentTypeType)obj).value()).equals("EAR") || deploymentType.equals("EXPLODED_EAR"))) {
                return ModuleType.EAR;
            }
            if (obj instanceof EjbComponentType) {
                return ModuleType.EJB;
            }
            if (obj instanceof WebComponentType) {
                return ModuleType.WAR;
            }
            if (obj instanceof ClientComponentType) {
                return ModuleType.CAR;
            }
            if (!(obj instanceof ConnectorComponentType)) continue;
            return ModuleType.RAR;
        }
        throw new JeusRuntimeException("The application information does not have any component");
    }

    public static List getNamesToRemove(ApplicationType applicationInfo) {
        List nameAndPathList = applicationInfo.getNameAndPathAndDeploymentType();
        ArrayList<ApplicationNameToRemove> namesToRemove = new ArrayList<ApplicationNameToRemove>();
        java.lang.String appName = null;
        int beginIndex = 0;
        boolean isExistName = false;
        for (int i = 0; i < nameAndPathList.size(); ++i) {
            JAXBElement element = (JAXBElement)nameAndPathList.get(i);
            java.lang.String elementName = element.getName().getLocalPart();
            if (elementName != null && elementName.equals("name")) {
                appName = (java.lang.String)element.getValue();
                isExistName = true;
                beginIndex = i;
                continue;
            }
            if (elementName == null || !elementName.equals("path")) continue;
            if (!isExistName) {
                java.lang.String filePath = JeusDeploymentManager.getApplicationPath(applicationInfo);
                File file = new File(filePath);
                if (!file.isAbsolute()) {
                    filePath = JeusProperties.JEUS_APP_HOME + File.separator + filePath;
                }
                appName = FileUtils.isExploded((java.lang.String)filePath) ? FileUtils.getFileNameWithExtension((java.lang.String)((java.lang.String)element.getValue())) : FileUtils.getFileNameWithoutExtension((java.lang.String)((java.lang.String)element.getValue()));
                beginIndex = i;
            }
            if (JeusDeploymentManager.isNextDeployType(nameAndPathList, i)) {
                ++i;
            }
            while (JeusDeploymentManager.isNextComponentType(nameAndPathList, i)) {
                ++i;
            }
            int lastIndex = i;
            namesToRemove.add(new ApplicationNameToRemove(appName, beginIndex, lastIndex));
            isExistName = false;
        }
        return namesToRemove;
    }

    private static boolean isNextDeployType(List<JAXBElement<?>> namePathList, int j) {
        if (j + 1 < namePathList.size()) {
            JAXBElement<?> nextNameAndPath = namePathList.get(j + 1);
            return nextNameAndPath.getValue() instanceof DeploymentTypeType;
        }
        return false;
    }

    private static boolean isNextComponentType(List<JAXBElement<?>> namePathList, int j) {
        if (j + 1 < namePathList.size()) {
            Object nextNameAndPath = namePathList.get(j + 1).getValue();
            return nextNameAndPath instanceof EjbComponentType || nextNameAndPath instanceof WebComponentType || nextNameAndPath instanceof ClientComponentType || nextNameAndPath instanceof ConnectorComponentType;
        }
        return false;
    }

    public static java.lang.String getNameFromPath(ApplicationType applicationInfo) {
        ApplicationType applicationClone = null;
        try {
            applicationClone = applicationInfo.cloneApplicationType();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        assert (applicationClone != null);
        List nameAndPathList = applicationClone.getNameAndPathAndDeploymentType();
        java.lang.String appName = null;
        java.lang.String path = "";
        jeus.xml.binding.jeusDD.ObjectFactory objFact = new jeus.xml.binding.jeusDD.ObjectFactory();
        JeusMainDescriptorJB.setDeploymentType(applicationClone);
        for (JAXBElement aNameAndPathList : nameAndPathList) {
            Object obj = aNameAndPathList.getValue();
            java.lang.String elementName = aNameAndPathList.getName().getLocalPart();
            if (elementName.equals("name")) {
                appName = (java.lang.String)obj;
                return appName;
            }
            if (elementName.equals("path")) {
                appName = path = FileUtils.getFileNameWithoutExtension((java.lang.String)((java.lang.String)obj));
                continue;
            }
            if (!(obj instanceof DeploymentTypeType)) continue;
            java.lang.String deploymentType = ((DeploymentTypeType)obj).value();
            appName = JeusDeploymentManager.getAppName(deploymentType, path, applicationClone);
            applicationClone.getNameAndPathAndDeploymentType().add(1, applicationClone.getNameAndPathAndDeploymentType().get(0));
            applicationClone.getNameAndPathAndDeploymentType().remove(0);
            applicationClone.getNameAndPathAndDeploymentType().add(0, objFact.createApplicationTypeName(appName));
            return appName;
        }
        return appName;
    }

    public static List<java.lang.String> getNamesFromPaths(ApplicationType applicationInfo) {
        ApplicationType applicationClone = null;
        try {
            applicationClone = applicationInfo.cloneApplicationType();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        assert (applicationClone != null);
        List nameAndPathList = applicationClone.getNameAndPathAndDeploymentType();
        ArrayList<java.lang.String> appNameList = new ArrayList<java.lang.String>();
        boolean isNameAdded = false;
        java.lang.String path = "";
        JeusMainDescriptorJB.setDeploymentType(applicationClone);
        for (JAXBElement aNameAndPathList : nameAndPathList) {
            java.lang.String appName;
            Object obj = aNameAndPathList.getValue();
            java.lang.String elementName = aNameAndPathList.getName().getLocalPart();
            if (elementName.equals("name")) {
                appName = (java.lang.String)obj;
                appNameList.add(appName);
                isNameAdded = true;
                continue;
            }
            if (elementName.equals("path")) {
                path = FileUtils.getFileNameWithExtension((java.lang.String)((java.lang.String)obj));
                continue;
            }
            if (!isNameAdded && obj instanceof DeploymentTypeType) {
                java.lang.String deploymentType = ((DeploymentTypeType)obj).value();
                appName = JeusDeploymentManager.getAppName(deploymentType, path, applicationClone);
                appNameList.add(appName);
            }
            isNameAdded = false;
        }
        return appNameList;
    }

    public static java.lang.String getAppName(java.lang.String deploymentType, java.lang.String path, ApplicationType application) {
        java.lang.String appName;
        if (deploymentType.equals("EAR")) {
            appName = FileUtils.getFileNameWithoutExtension((java.lang.String)path);
        } else {
            java.lang.String url = JeusMainHelper.getComponentPath(application);
            if (url != null) {
                path = url;
            }
            int index = -1;
            if (path.endsWith(ModuleType.EAR.getModuleExtension())) {
                index = path.lastIndexOf(ModuleType.EAR.getModuleExtension());
            } else if (path.endsWith(ModuleType.EJB.getModuleExtension())) {
                index = path.lastIndexOf(ModuleType.EJB.getModuleExtension());
            } else if (path.endsWith(ModuleType.WAR.getModuleExtension())) {
                index = path.lastIndexOf(ModuleType.WAR.getModuleExtension());
            } else if (path.endsWith(ModuleType.RAR.getModuleExtension())) {
                index = path.lastIndexOf(ModuleType.RAR.getModuleExtension());
            } else if (path.endsWith(ModuleType.CAR.getModuleExtension())) {
                index = path.lastIndexOf(ModuleType.CAR.getModuleExtension());
            }
            appName = index < 0 ? path : path.substring(0, index);
        }
        return appName;
    }

    public static ApplicationType fillApplicationDDFromModuleType(ModuleType moduleType, java.lang.String archivePath, jeus.xml.binding.j2ee.ApplicationType applicationInfo, Map settingMap) throws JAXBException {
        java.lang.String moduleName = archivePath.substring(archivePath.lastIndexOf(File.separator) + 1);
        File test = new File(archivePath);
        if (test.isDirectory() && !archivePath.endsWith(moduleName) && moduleName.indexOf(".") > 0) {
            moduleName = moduleName.substring(0, moduleName.lastIndexOf(46));
        }
        java.lang.String path = moduleName;
        jeus.xml.binding.jeusDD.ObjectFactory jeusObjectFactory = ObjectFactoryHelper.getJeusDDObjectFactory();
        ApplicationType appType = jeusObjectFactory.createApplicationType();
        if (moduleType.equals(ModuleType.EAR)) {
            JeusDeploymentManager.setApplicationPath(appType, path);
            JeusDeploymentManager.setApplicationDeploymentType(appType, "EAR");
            if (applicationInfo != null) {
                List modules = applicationInfo.getModule();
                for (Object module : modules) {
                    java.lang.String fileName;
                    jeus.xml.binding.j2ee.ModuleType moduleInfo = (jeus.xml.binding.j2ee.ModuleType)module;
                    PathType ejbType = moduleInfo.getEjb();
                    PathType clientType = moduleInfo.getJava();
                    WebType webType = moduleInfo.getWeb();
                    PathType rarType = moduleInfo.getConnector();
                    if (ejbType != null) {
                        fileName = ejbType.getValue();
                        EjbComponentType ejbComponent = jeusObjectFactory.createEjbComponentType();
                        ejbComponent.setUri(fileName);
                        appType.getNameAndPathAndDeploymentType().add(jeusObjectFactory.createApplicationTypeEjbComponent(ejbComponent));
                        continue;
                    }
                    if (clientType != null) {
                        fileName = clientType.getValue();
                        ClientComponentType clientComponent = jeusObjectFactory.createClientComponentType();
                        clientComponent.setUri(fileName);
                        appType.getNameAndPathAndDeploymentType().add(jeusObjectFactory.createApplicationTypeClientComponent(clientComponent));
                        continue;
                    }
                    if (webType != null) {
                        PathType webPath = webType.getWebUri();
                        fileName = webPath.getValue();
                        WebComponentType webComponent = jeusObjectFactory.createWebComponentType();
                        webComponent.setUri(fileName);
                        appType.getNameAndPathAndDeploymentType().add(jeusObjectFactory.createApplicationTypeWebComponent(webComponent));
                        continue;
                    }
                    if (rarType == null) continue;
                    fileName = rarType.getValue();
                    ConnectorComponentType conComponent = jeusObjectFactory.createConnectorComponentType();
                    conComponent.setUri(fileName);
                    appType.getNameAndPathAndDeploymentType().add(jeusObjectFactory.createApplicationTypeConnectorComponent(conComponent));
                }
            }
        } else if (moduleType.equals(ModuleType.EJB)) {
            JeusDeploymentManager.setApplicationPath(appType, path);
            JeusDeploymentManager.setApplicationDeploymentType(appType, "COMPONENT");
            EjbComponentType ejbComponent = jeusObjectFactory.createEjbComponentType();
            appType.getNameAndPathAndDeploymentType().add(jeusObjectFactory.createApplicationTypeEjbComponent(ejbComponent));
        } else if (moduleType.equals(ModuleType.WAR)) {
            JeusDeploymentManager.setApplicationPath(appType, path);
            JeusDeploymentManager.setApplicationDeploymentType(appType, "COMPONENT");
            WebComponentType webComponent = jeusObjectFactory.createWebComponentType();
            appType.getNameAndPathAndDeploymentType().add(jeusObjectFactory.createApplicationTypeWebComponent(webComponent));
        } else if (moduleType.equals(ModuleType.CAR)) {
            JeusDeploymentManager.setApplicationPath(appType, path);
            JeusDeploymentManager.setApplicationDeploymentType(appType, "COMPONENT");
            ClientComponentType clientComponent = jeusObjectFactory.createClientComponentType();
            appType.getNameAndPathAndDeploymentType().add(jeusObjectFactory.createApplicationTypeClientComponent(clientComponent));
        } else if (moduleType.equals(ModuleType.RAR)) {
            JeusDeploymentManager.setApplicationDeploymentType(appType, "COMPONENT");
            JeusDeploymentManager.setApplicationPath(appType, path);
            ConnectorComponentType conComponent = jeusObjectFactory.createConnectorComponentType();
            appType.getNameAndPathAndDeploymentType().add(jeusObjectFactory.createApplicationTypeConnectorComponent(conComponent));
        }
        JeusDeploymentManager.setAppFastDeploy(settingMap, appType);
        new ApplicationRuntimeDDFile().postUnmarshal(appType);
        return appType;
    }

    private static void setAppFastDeploy(Map settingMap, ApplicationType appType) {
        Object obj;
        if (settingMap != null && (obj = settingMap.get("fastdeploy")) != null) {
            boolean fastDeploy = (Boolean)settingMap.get("fastdeploy");
            appType.setFastDeploy(Boolean.valueOf(fastDeploy));
        }
    }

    public ProgressObject start(TargetModuleID[] targetModuleIDs) throws IllegalStateException {
        if (!this.isConnected) {
            throw new IllegalStateException("The deployment manager is disconnected");
        }
        JeusProgressObject stProgress = new JeusProgressObject(CommandType.START, targetModuleIDs.length);
        SThread runThread = new SThread(targetModuleIDs, stProgress);
        runThread.start();
        return stProgress;
    }

    public ProgressObject stop(TargetModuleID[] targetModuleIDs) throws IllegalStateException {
        if (!this.isConnected) {
            throw new IllegalStateException("The deployment manager is disconnected");
        }
        JeusProgressObject stProgress = new JeusProgressObject(CommandType.STOP, targetModuleIDs.length);
        SThread runThread = new SThread(targetModuleIDs, stProgress);
        runThread.start();
        return stProgress;
    }

    public ProgressObject undeploy(TargetModuleID[] targetModuleIDs) throws IllegalStateException {
        if (!this.isConnected) {
            throw new IllegalStateException("The deployment manager is disconnected");
        }
        JeusProgressObject stProgress = new JeusProgressObject(CommandType.UNDEPLOY, targetModuleIDs.length);
        SThread runThread = new SThread(targetModuleIDs, stProgress);
        runThread.start();
        return stProgress;
    }

    public ProgressObject handleStatus(CommandType cmd, TargetModuleID[] tmIDs) {
        if (cmd.equals(CommandType.START)) {
            return this.start(tmIDs);
        }
        if (cmd.equals(CommandType.STOP)) {
            return this.stop(tmIDs);
        }
        if (cmd.equals(CommandType.UNDEPLOY)) {
            return this.undeploy(tmIDs);
        }
        return null;
    }

    public boolean isRedeploySupported() {
        return false;
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleIDs, File moduleArchive, File deploymentPlan) throws UnsupportedOperationException, IllegalStateException {
        if (!this.isConnected) {
            throw new IllegalStateException("The deployment manager is disconnected");
        }
        throw new UnsupportedOperationException("redeploy is not supported");
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleIDs, InputStream moduleArchive, InputStream deploymentPlan) throws UnsupportedOperationException, IllegalStateException {
        if (!this.isConnected) {
            throw new IllegalStateException("The deployment manager is disconnected");
        }
        throw new UnsupportedOperationException("redeploy is not supported");
    }

    public void release() {
        if (!this.isConnected) {
            throw new IllegalStateException("The deployment manager is disconnected");
        }
        this.isConnected = false;
        this.jmxUtil = null;
    }

    public Locale getDefaultLocale() {
        return Locale.US;
    }

    public Locale getCurrentLocale() {
        return Locale.US;
    }

    public void setLocale(Locale locale) throws UnsupportedOperationException {
        if (!locale.equals(Locale.US)) {
            throw new UnsupportedOperationException("not supported");
        }
    }

    public Locale[] getSupportedLocales() {
        return new Locale[]{Locale.US};
    }

    public boolean isLocaleSupported(Locale locale) {
        return locale.equals(Locale.US);
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        return DConfigBeanVersionType.V5;
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType dConfigBeanVersionType) {
        return true;
    }

    public void setDConfigBeanVersion(DConfigBeanVersionType dConfigBeanVersionType) throws DConfigBeanVersionUnsupportedException {
    }

    public void setDeploySetting(Map map) {
        this.settingMap = map;
    }

    public DConfigBeanSpecificationSource getDConfigBeanSpecificationSource() {
        if (this.dConfigBeanSpecificationSource == null) {
            this.dConfigBeanSpecificationSource = new DConfigBeanSpecificationSource();
        }
        return this.dConfigBeanSpecificationSource;
    }

    public XMLUIEngine getUIEngine() {
        if (this.uiengine == null) {
            this.uiengine = new XMLUIEngine(UI_RESOURCE_PACKAGE);
        }
        return this.uiengine;
    }

    public static boolean isExploded(ApplicationType appType) {
        java.lang.String path;
        Boolean isSystemApp = (Boolean)appType.getInfoMap().get("isSystemApp");
        if (isSystemApp != null && isSystemApp.booleanValue()) {
            path = JeusProperties.JEUS_HOME + File.separator + "webhome" + File.separator + "system_app" + JeusDeploymentManager.getApplicationPath(appType);
        } else {
            path = (java.lang.String)appType.getInfoMap().get("absolute-path");
            if (path == null) {
                path = JeusDeploymentManager.getApplicationPath(appType);
                java.lang.String absPath = appType.getAbsolutePath();
                if (absPath != null) {
                    if (path != null) {
                        path = absPath.endsWith(File.separator) ? absPath + path : absPath + File.separator + path;
                    } else {
                        throw new RuntimeException("The absolute-path cannot be used for the application's path");
                    }
                }
            }
            if (path == null) {
                throw new JeusRuntimeException("The application does not exists : " + path);
            }
        }
        File file = new File(path);
        if (!file.isAbsolute()) {
            throw new JeusRuntimeException("The application does not exists : " + path);
        }
        return file.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static jeus.xml.binding.j2ee.ApplicationType makeApplicationInfo(AbstractArchive earArchive) {
        ObjectFactory factory = new ObjectFactory();
        jeus.xml.binding.j2ee.ApplicationType applicationInfo = factory.createApplicationType();
        applicationInfo.setVersion("5");
        Enumeration entries = earArchive.entries();
        AbstractArchive subArchive = null;
        while (entries.hasMoreElements()) {
            try {
                ModuleType type;
                java.lang.String entry = (java.lang.String)entries.nextElement();
                subArchive = earArchive.getEmbeddedArchive(entry);
                if (entry.startsWith("lib/") || entry.startsWith("APP-INF/") || (type = ModuleTypeResolver.getModuleType(subArchive)) == null) continue;
                jeus.xml.binding.j2ee.ModuleType moduleType = factory.createModuleType();
                PathType pathType = factory.createPathType();
                if (type.equals(ModuleType.EJB)) {
                    pathType.setValue(entry);
                    moduleType.setEjb(pathType);
                } else if (type.equals(ModuleType.CAR)) {
                    pathType.setValue(entry);
                    moduleType.setJava(pathType);
                } else if (type.equals(ModuleType.WAR)) {
                    WebType webType = factory.createWebType();
                    pathType.setValue(entry);
                    webType.setWebUri(pathType);
                    String contextRoot = factory.createString();
                    contextRoot.setValue(FileUtils.getFileNameWithoutExtension((java.lang.String)entry, (java.lang.String)".war"));
                    webType.setContextRoot(contextRoot);
                    moduleType.setWeb(webType);
                } else if (type.equals(ModuleType.RAR)) {
                    pathType.setValue(entry);
                    moduleType.setConnector(pathType);
                }
                applicationInfo.getModule().add(moduleType);
            }
            catch (IOException ex) {}
            continue;
            finally {
                if (subArchive == null) continue;
                try {
                    subArchive.close();
                }
                catch (IOException ex) {}
            }
        }
        return applicationInfo;
    }

    public static java.lang.String getApplicationPath(ApplicationType applicationType) {
        List nameAndPathList = applicationType.getNameAndPathAndDeploymentType();
        for (JAXBElement obj : nameAndPathList) {
            java.lang.String elementName = obj.getName().getLocalPart();
            if (elementName == null || !elementName.equals("path")) continue;
            return (java.lang.String)obj.getValue();
        }
        return null;
    }

    public static void setApplicationPath(ApplicationType applicationType, java.lang.String applicationPath) {
        List nameAndPathList = applicationType.getNameAndPathAndDeploymentType();
        boolean isExistName = false;
        for (JAXBElement obj : nameAndPathList) {
            java.lang.String elementName = obj.getName().getLocalPart();
            if (elementName.equals("name")) {
                isExistName = true;
                continue;
            }
            if (!elementName.equals("path")) continue;
            obj.setValue((Object)applicationPath);
            return;
        }
        jeus.xml.binding.jeusDD.ObjectFactory objFact = new jeus.xml.binding.jeusDD.ObjectFactory();
        int index = 1;
        if (!isExistName) {
            index = 0;
        }
        applicationType.getNameAndPathAndDeploymentType().add(index, objFact.createApplicationTypePath(applicationPath));
    }

    public static java.lang.String getApplicationName(ApplicationType applicationType) {
        List nameAndPathList = applicationType.getNameAndPathAndDeploymentType();
        for (JAXBElement obj : nameAndPathList) {
            java.lang.String elementName = obj.getName().getLocalPart();
            if (elementName == null || !elementName.equals("name")) continue;
            return (java.lang.String)obj.getValue();
        }
        return null;
    }

    public static void setApplicationName(ApplicationType applicationType, java.lang.String applicationName) {
        List nameAndPathList = applicationType.getNameAndPathAndDeploymentType();
        for (JAXBElement obj : nameAndPathList) {
            java.lang.String elementName = obj.getName().getLocalPart();
            if (!elementName.equals("name")) continue;
            obj.setValue((Object)applicationName);
            return;
        }
        jeus.xml.binding.jeusDD.ObjectFactory objFact = new jeus.xml.binding.jeusDD.ObjectFactory();
        applicationType.getNameAndPathAndDeploymentType().add(0, objFact.createApplicationTypeName(applicationName));
    }

    public static DeploymentTypeType getApplicationDeploymentTypeType(ApplicationType applicationType) {
        List nameAndPathList = applicationType.getNameAndPathAndDeploymentType();
        for (JAXBElement element : nameAndPathList) {
            Object obj = element.getValue();
            if (!(obj instanceof DeploymentTypeType)) continue;
            return (DeploymentTypeType)obj;
        }
        return null;
    }

    public static void setApplicationDeploymentType(ApplicationType applicationType, java.lang.String type) {
        DeploymentTypeType typeObject = DeploymentTypeType.valueOf((java.lang.String)type);
        List nameAndPathList = applicationType.getNameAndPathAndDeploymentType();
        for (JAXBElement element : nameAndPathList) {
            Object obj = element.getValue();
            if (!(obj instanceof DeploymentTypeType)) continue;
            element.setValue((Object)typeObject);
            return;
        }
        jeus.xml.binding.jeusDD.ObjectFactory objFact = new jeus.xml.binding.jeusDD.ObjectFactory();
        applicationType.getNameAndPathAndDeploymentType().add(objFact.createApplicationTypeDeploymentType(typeObject));
    }

    static {
        j2eeDescriptorMap.put(ModuleType.EAR, "META-INF/application.xml");
        j2eeDescriptorMap.put(ModuleType.EJB, "META-INF/ejb-jar.xml");
        j2eeDescriptorMap.put(ModuleType.WAR, "WEB-INF/web.xml");
        j2eeDescriptorMap.put(ModuleType.CAR, "META-INF/application-client.xml");
        j2eeDescriptorMap.put(ModuleType.RAR, "META-INF/ra.xml");
        runtimeDescriptorMap.put(ModuleType.EJB, new java.lang.String[]{"jeus-ejb-dd", "jeus-webservices-dd", "jeus-webservicesclient-dd"});
        runtimeDescriptorMap.put(ModuleType.WAR, new java.lang.String[]{"jeus-web-dd", "jeus-webservices-dd", "jeus-webservicesclient-dd"});
        runtimeDescriptorMap.put(ModuleType.CAR, new java.lang.String[]{"jeus-client-dd", "jeus-webservices-dd", "jeus-webservicesclient-dd"});
        runtimeDescriptorMap.put(ModuleType.RAR, new java.lang.String[]{"jeus-connector-dd"});
    }

    class SThread
    extends Thread {
        TargetModuleID[] sTargets;
        JeusProgressObject po;

        public SThread(TargetModuleID[] targets, JeusProgressObject po) {
            this.sTargets = targets;
            this.po = po;
        }

        public void run() {
            if (this.po.getCommandType().equals(CommandType.START)) {
                JeusDeploymentManager.this.commander.start(this.sTargets, (MBeanServerConnection)JeusDeploymentManager.this.jmxUtil, this.po);
            }
            if (this.po.getCommandType().equals(CommandType.STOP)) {
                JeusDeploymentManager.this.commander.stop(this.sTargets, (MBeanServerConnection)JeusDeploymentManager.this.jmxUtil, this.po);
            }
            if (this.po.getCommandType().equals(CommandType.UNDEPLOY)) {
                JeusDeploymentManager.this.commander.undeploy(this.sTargets, (MBeanServerConnection)JeusDeploymentManager.this.jmxUtil, this.po);
            }
        }
    }

    class DThread
    extends Thread {
        Target[] targets;
        ApplicationType config;
        JeusProgressObject po;
        java.lang.String sourcePath;
        boolean autoSrcDistribute;
        boolean atomic;
        boolean onlyDistribute;

        public DThread(Target[] targets, java.lang.String sourcePath, ApplicationType config, JeusProgressObject po, boolean autoSrcDistribute, boolean atomic, boolean onlyDistribute) {
            this.targets = targets;
            this.config = config;
            this.sourcePath = sourcePath;
            this.po = po;
            this.autoSrcDistribute = autoSrcDistribute;
            this.atomic = atomic;
            this.onlyDistribute = onlyDistribute;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block8: {
                try {
                    Target[] dtargets = this.autoSrcDistribute ? new Target[]{this.targets[0]} : this.targets;
                    if (new File(this.sourcePath).isDirectory()) break block8;
                    for (int i = 0; i < dtargets.length; ++i) {
                        NodeControllerStub nodeController = new NodeControllerStub(JeusDeploymentManager.this.serializedSubject);
                        try {
                            ObjectName targetName = ((TargetImpl)dtargets[i]).getObjectName();
                            Targetable targetable = JMXUtility.getProxy((MBeanServerConnection)JeusDeploymentManager.this.jmxUtil, targetName, Targetable.class, false);
                            java.lang.String ftpDestination = targetable.getFTPDestination(this.config);
                            java.lang.String nodeName = targetable.getNodeName();
                            nodeName = VirtualDNS.getRealNodeName(nodeName);
                            nodeController.connectTo(nodeName);
                            boolean result = nodeController.ftp(this.sourcePath, ftpDestination, false);
                            if (result) continue;
                            this.po.fireProgressEvent(new ProgressEvent((Object)this, null, (DeploymentStatus)new DeploymentStatusImpl(StateType.FAILED, CommandType.DISTRIBUTE, "Distribute Failed : FTP Failed")));
                            return;
                        }
                        finally {
                            nodeController.disconnect();
                        }
                    }
                }
                catch (Exception de) {
                    de.printStackTrace();
                    DeploymentStatusImpl dsi = new DeploymentStatusImpl(StateType.FAILED, CommandType.DISTRIBUTE, "Distribute Failed : FTP Failed");
                    dsi.setFailException(de);
                    this.po.fireProgressEvent(new ProgressEvent((Object)this, null, (DeploymentStatus)dsi));
                    return;
                }
            }
            if (this.po.getCommandType().equals(CommandType.DISTRIBUTE)) {
                JeusDeploymentManager.this.commander.distribute(this.targets, this.config, (MBeanServerConnection)JeusDeploymentManager.this.jmxUtil, this.po, this.autoSrcDistribute);
            } else {
                JeusDeploymentManager.this.deployCommand(this.targets, this.config, this.po, this.autoSrcDistribute, this.onlyDistribute, this.atomic);
            }
        }
    }
}

