/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.command;

import java.util.ArrayList;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.management.ObjectName;
import jeus.deploy.command.ICommand;
import jeus.deploy.status.DeploymentStatusImpl;
import jeus.xml.binding.jeusDD.AllTargetsType;
import jeus.xml.binding.jeusDD.AppTargetType;
import jeus.xml.binding.jeusDD.DeploymentTargetType;

public class CommandUtils {
    public static void fireCompletedEvent(ICommand c) {
        if (c == null || c.getJeusProgressObject() == null) {
            return;
        }
        DeploymentStatusImpl status = new DeploymentStatusImpl(StateType.COMPLETED, c.getCommandType());
        ProgressEvent event = new ProgressEvent((Object)c, c.getTargetModuleID(), (DeploymentStatus)status);
        c.getJeusProgressObject().fireProgressEvent(event);
    }

    public static void fireRunningEvent(ICommand c) {
        if (c == null || c.getJeusProgressObject() == null) {
            return;
        }
        DeploymentStatusImpl status = new DeploymentStatusImpl(StateType.RUNNING, c.getCommandType());
        ProgressEvent event = new ProgressEvent((Object)c, c.getTargetModuleID(), (DeploymentStatus)status);
        c.getJeusProgressObject().fireProgressEvent(event);
    }

    public static void fireFailedEvent(ICommand c, Exception e) {
        if (c == null || c.getJeusProgressObject() == null) {
            return;
        }
        DeploymentStatusImpl status = new DeploymentStatusImpl(StateType.FAILED, c.getCommandType());
        status.setFailException(e);
        status.setTarget(c.getTarget());
        ProgressEvent event = new ProgressEvent((Object)c, c.getTargetModuleID(), (DeploymentStatus)status);
        c.getJeusProgressObject().fireProgressEvent(event);
    }

    public static ModuleType whatType(ObjectName objectName) {
        String j2eeType = objectName.getKeyProperty("j2eeType");
        if (j2eeType.equals("J2EEApplication")) {
            return ModuleType.EAR;
        }
        if (j2eeType.equals("EJBModule")) {
            return ModuleType.EJB;
        }
        if (j2eeType.equals("WebModule")) {
            return ModuleType.WAR;
        }
        if (j2eeType.equals("ResourceAdapterModule")) {
            return ModuleType.RAR;
        }
        if (j2eeType.equals("AppClientModule")) {
            return ModuleType.CAR;
        }
        return null;
    }

    public static String[] getJ2EEServerTargets(String nodeName, String[] j2eeServers, DeploymentTargetType deploymentTarget) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object obj : deploymentTarget.getAllTargetsOrTarget()) {
            if (obj instanceof AllTargetsType) {
                for (int i = 0; i < j2eeServers.length; ++i) {
                    result.add(CommandUtils.getJ2EEServerName(j2eeServers[i]));
                }
                break;
            }
            AppTargetType target = (AppTargetType)obj;
            if (target.isSetNodeName() && target.getNodeName().equals(nodeName)) {
                for (int i = 0; i < j2eeServers.length; ++i) {
                    result.add(CommandUtils.getJ2EEServerName(j2eeServers[i]));
                }
                break;
            }
            if (!target.isSetEngineContainerName() || !target.getEngineContainerName().startsWith(nodeName)) continue;
            result.add(target.getEngineContainerName());
        }
        return result.toArray(new String[result.size()]);
    }

    private static String getJ2EEServerName(String j2eeServer) {
        try {
            ObjectName objectName = new ObjectName(j2eeServer);
            return objectName.getKeyProperty("name");
        }
        catch (Exception e) {
            return null;
        }
    }
}

