/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.Customizer;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jeus.deploy.config.JeusDConfigBean;
import jeus.tool.xmlui.XMLUIDialog;
import jeus.tool.xmlui.XMLUIPanel;
import jeus.tool.xmlui.engine.XMLUIEngine;
import jeus.tool.xmlui.engine.XMLUISession;

public class DConfigBeanCustomizer
extends JPanel
implements Customizer,
WindowListener {
    public static final String DCONFIG_BEAN_ATTRIBUTE_NAME = "jeus.deploy.config.dconfig-bean";
    protected JeusDConfigBean _dconfigBean;
    protected XMLUIPanel _pane;
    private Window window;

    public void invalidate() {
        super.invalidate();
        if (this.window == null) {
            for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof Window)) continue;
                this.window = (Window)parent;
                this.window.addWindowListener(this);
                break;
            }
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        if (this._pane != null) {
            this._pane.getValue();
            Vector message = this._pane.getMessage();
            if (message != null && message.size() > 0) {
                XMLUIDialog dlg = XMLUIDialog.getIgnorableDlg(message);
                if (dlg != null) {
                    dlg.showDialog();
                    if (dlg.getOk()) {
                        this.window.show();
                    }
                }
            } else {
                this.window.removeWindowListener(this);
                this.window = null;
            }
        }
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void setObject(Object bean) {
        this._dconfigBean = (JeusDConfigBean)bean;
        this._pane = this._dconfigBean.getXMLUIPanel();
        if (this._pane == null) {
            XMLUIEngine uiengine = this._dconfigBean.getUIEngine();
            String uiname = this._dconfigBean.getSpecification().getXmluiname();
            String uipath = this._dconfigBean.getSpecification().getXmluipath();
            try {
                this._pane = uiengine.getXMLUIPanel(this._dconfigBean.getNode(), uiname, uipath);
                this._dconfigBean.setXMLUIPanel(this._pane);
                XMLUISession session = this._pane.getSession();
                session.addAttribute(DCONFIG_BEAN_ATTRIBUTE_NAME, this._dconfigBean);
                this.afterCreateXMLUIPanel(this._pane);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this._pane != null) {
            this.setLayout(new BorderLayout());
            this.add((Component)this._pane, "Center");
        } else {
            this.add((Component)new JLabel("Unable to find GUI for " + this._dconfigBean.getXMLUIPath()), "Center");
        }
        this.setPreferredSize(new Dimension(600, 500));
    }

    public void afterCreateXMLUIPanel(XMLUIPanel pane) {
    }
}

