/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.config;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.deploy.shared.ModuleType;
import jeus.deploy.config.DConfigBeanRootSpecification;
import jeus.deploy.config.DConfigBeanSpecificationParser;

public class DConfigBeanSpecificationSource
implements Serializable {
    private static final String DCONFIGBEANS_SERIAL_PATH = "dconfigbeans.ser";
    private static final String DCONFIGBEANS_XML_PATH = "dconfigbeans.xml";
    private Map _dconfigBeanRootMap;

    public DConfigBeanSpecificationSource() {
        try {
            InputStream is = this.getClass().getResourceAsStream(DCONFIGBEANS_SERIAL_PATH);
            if (is != null) {
                ObjectInputStream objIn = new ObjectInputStream(is);
                this._dconfigBeanRootMap = (Map)objIn.readObject();
                objIn.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this._dconfigBeanRootMap == null) {
            DConfigBeanSpecificationParser parser = new DConfigBeanSpecificationParser();
            InputStream is = this.getClass().getResourceAsStream(DCONFIGBEANS_XML_PATH);
            if (is != null) {
                this._dconfigBeanRootMap = parser.parse(is);
            }
        }
        if (this._dconfigBeanRootMap == null) {
            this._dconfigBeanRootMap = new HashMap();
        }
    }

    public DConfigBeanRootSpecification getDConfigBeanRootSpecification(ModuleType moduleType, String filename) {
        String key = DConfigBeanSpecificationSource.buildKey(moduleType, filename);
        return (DConfigBeanRootSpecification)this._dconfigBeanRootMap.get(key);
    }

    public static String buildKey(ModuleType moduleType, String filename) {
        return moduleType.getValue() + filename;
    }

    public void addDConfigBeanRootSpecification(DConfigBeanRootSpecification root) {
        this._dconfigBeanRootMap.put(DConfigBeanSpecificationSource.buildKey(root.getModuleType(), root.getDdbeanFilename()), root);
    }

    public Properties getReferences() {
        return (Properties)this._dconfigBeanRootMap.get("jeus.deploy.config.reference_resource");
    }
}

