/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.XpathEvent;
import javax.enterprise.deploy.spi.DConfigBean;
import javax.enterprise.deploy.spi.exceptions.BeanNotFoundException;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.xml.transform.TransformerException;
import jeus.deploy.config.DConfigBeanSpecification;
import jeus.deploy.config.DDBeanReference;
import jeus.deploy.config.JeusDeploymentConfiguration;
import jeus.tool.xmlui.XMLUIPanel;
import jeus.tool.xmlui.engine.XMLUIEngine;
import jeus.xml.util.IXPathAPI;
import jeus.xml.util.XPathAPIFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class JeusDConfigBean
implements DConfigBean {
    protected DDBean _ddBean;
    protected Node _node;
    protected DConfigBeanSpecification _specification;
    protected XMLUIEngine _uiengine;
    protected XMLUIPanel _pane;
    protected JeusDeploymentConfiguration _deploymentConfiguration;
    protected List _childList = new ArrayList();
    private PropertyChangeSupport _propertyChangeSupport = new PropertyChangeSupport(this);

    public void setDDBean(DDBean _ddBean) {
        this._ddBean = _ddBean;
    }

    public void setDeploymentConfiguration(JeusDeploymentConfiguration _deploymentConfiguration) {
        this._deploymentConfiguration = _deploymentConfiguration;
    }

    public void setNode(Node _node) {
        this._node = _node;
    }

    public void setSpecification(DConfigBeanSpecification _specification) {
        this._specification = _specification;
    }

    public void setUIEngine(XMLUIEngine _uiengine) {
        this._uiengine = _uiengine;
    }

    public DConfigBeanSpecification getSpecification() {
        return this._specification;
    }

    public DConfigBean getDConfigBean(DDBean bean) throws ConfigurationException {
        DConfigBeanSpecification childSpecification = this._specification.getChild(bean);
        if (childSpecification == null) {
            throw new ConfigurationException("Unable to find DConfigBeanSpecification for " + bean.getXpath() + ".");
        }
        Node childNode = this.getChildNode(childSpecification = this.replaceDConfigBeanSpecification(childSpecification, bean), bean);
        if (childNode == null) {
            throw new ConfigurationException("Unable to find  or create child element for " + bean.getXpath() + ".");
        }
        String classname = childSpecification.getClassname();
        try {
            Class<?> clazz = Class.forName(classname);
            JeusDConfigBean dconfigBean = (JeusDConfigBean)clazz.newInstance();
            dconfigBean.setDDBean(bean);
            dconfigBean.setDeploymentConfiguration(this._deploymentConfiguration);
            dconfigBean.setNode(childNode);
            dconfigBean.setSpecification(childSpecification);
            dconfigBean.setUIEngine(this._uiengine);
            this._childList.add(dconfigBean);
            return dconfigBean;
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage());
        }
    }

    protected Node getChildNode(DConfigBeanSpecification specification, DDBean bean) {
        DDBeanReference[] ddbeanRefs = specification.getDDBeanReferences();
        if (ddbeanRefs == null || ddbeanRefs.length == 0) {
            return null;
        }
        String findXPath = ddbeanRefs[0].getRefFindXPath(this._node.getNamespaceURI(), this._node.getPrefix());
        String srcXPath = ddbeanRefs[0].getSrcXPath();
        String[] texts = bean.getText(srcXPath);
        if (texts == null || texts.length == 0) {
            return null;
        }
        String format = null;
        int i = srcXPath.lastIndexOf("/");
        format = i >= 0 ? "\\$\\{" + srcXPath.substring(i + 1) + "\\}" : "\\$\\{" + srcXPath + "\\}";
        String data = texts[0];
        findXPath = "./" + findXPath.replaceAll(format, data);
        IXPathAPI xpathAPI = XPathAPIFactory.createXPathAPI();
        try {
            Node result = xpathAPI.selectSingleNode(this._node, findXPath);
            if (result != null) {
                return result;
            }
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        String xpath = ddbeanRefs[0].getRefXPath(this._node.getNamespaceURI(), this._node.getPrefix());
        String field = ddbeanRefs[0].getRefField(this._node.getNamespaceURI(), this._node.getPrefix());
        StringTokenizer stk = new StringTokenizer(xpath, "/");
        Node parent = this._node;
        while (stk.hasMoreTokens()) {
            String token = stk.nextToken();
            parent = this.findOrCreate(parent, token, !stk.hasMoreTokens());
        }
        Document document = parent.getOwnerDocument();
        Element child = document.createElementNS(parent.getNamespaceURI(), field);
        child.appendChild(document.createTextNode(data));
        parent.appendChild(child);
        this.initNode(specification, bean, parent);
        return parent;
    }

    protected void initNode(DConfigBeanSpecification specification, DDBean ddBean, Node node) {
    }

    private Node findOrCreate(Node parent, String name, boolean leaf) {
        if (!leaf) {
            NodeList nodeList = parent.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!node.getNodeName().equals(name)) continue;
                return node;
            }
        }
        Document document = parent.getOwnerDocument();
        Element child = document.createElementNS(parent.getNamespaceURI(), name);
        parent.appendChild(child);
        return child;
    }

    protected DConfigBeanSpecification replaceDConfigBeanSpecification(DConfigBeanSpecification specification, DDBean bean) {
        return specification;
    }

    public DDBean getDDBean() {
        return this._ddBean;
    }

    public Node getNode() {
        return this._node;
    }

    public String[] getXpaths() {
        return this._specification.getChildXPaths();
    }

    public String getXMLUIPath() {
        return this._specification.getXmluipath();
    }

    public XMLUIEngine getUIEngine() {
        return this._uiengine;
    }

    public void setXMLUIPanel(XMLUIPanel pane) {
        this._pane = pane;
    }

    public XMLUIPanel getXMLUIPanel() {
        return this._pane;
    }

    public void updateConfig() {
        if (this._pane != null && this._node != null) {
            Element config = (Element)this._pane.getValue();
            this._node.getParentNode().replaceChild(config, this._node);
        }
        for (int i = 0; i < this._childList.size(); ++i) {
            JeusDConfigBean dconfigBean = (JeusDConfigBean)this._childList.get(i);
            dconfigBean.updateConfig();
        }
    }

    public void notifyDDChange(XpathEvent event) {
        if (event.isAddEvent()) {
            this.handleDDBeanAdd(event.getBean());
        } else if (event.isChangeEvent()) {
            this.handleDDBeanUpdate(event.getBean());
        } else if (event.isRemoveEvent()) {
            this.handleDDBeanRemove(event.getBean());
        }
    }

    protected void handleDDBeanAdd(DDBean ddBean) {
        DConfigBeanSpecification childSpecification = this._specification.getChild(ddBean);
        if (childSpecification == null) {
            return;
        }
        Node node = this.getChildNode(childSpecification, ddBean);
        if (node != null) {
            this._node.appendChild(node);
            this.updateUI();
        }
    }

    protected void handleDDBeanRemove(DDBean ddBean) {
        JeusDConfigBean dConfigBean = this.findDConfigBean(ddBean);
        if (dConfigBean == null) {
            return;
        }
        try {
            this.removeDConfigBean(dConfigBean);
        }
        catch (BeanNotFoundException beanNotFoundException) {
            // empty catch block
        }
    }

    protected void handleDDBeanUpdate(DDBean ddBean) {
        JeusDConfigBean dConfigBean = this.findDConfigBean(ddBean);
        if (dConfigBean == null) {
            return;
        }
        DConfigBeanSpecification spec = dConfigBean.getSpecification();
        DDBeanReference[] ddBeanRefs = spec.getDDBeanReferences();
        if (ddBeanRefs == null || ddBeanRefs.length == 0) {
            return;
        }
        String[] texts = ddBean.getText(ddBeanRefs[0].getSrcXPath());
        if (texts == null || texts.length == 0) {
            return;
        }
        String data = texts[0];
        String field = ddBeanRefs[0].getRefField(this._node.getNamespaceURI(), this._node.getPrefix());
        NodeList nodeList = this._node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (!child.getNodeName().equals(field)) continue;
            Node oldData = child.getFirstChild();
            Text newData = this._node.getOwnerDocument().createTextNode(data);
            child.replaceChild(newData, oldData);
            this.updateUI();
            break;
        }
    }

    private void updateUI() {
        if (this._pane != null) {
            this._pane.invalidate();
        }
    }

    private JeusDConfigBean findDConfigBean(DDBean ddBean) {
        for (int i = 0; i < this._childList.size(); ++i) {
            JeusDConfigBean dConfigBean = (JeusDConfigBean)this._childList.get(i);
            DDBean refDDBean = dConfigBean.getDDBean();
            if (!refDDBean.equals(ddBean) && ddBean != refDDBean) continue;
            return dConfigBean;
        }
        return null;
    }

    public void removeDConfigBean(DConfigBean bean) throws BeanNotFoundException {
        if (!this._childList.contains(bean)) {
            throw new BeanNotFoundException(bean.getDDBean().getXpath());
        }
        JeusDConfigBean jeusDConfigBean = (JeusDConfigBean)bean;
        this._childList.remove(bean);
        Node node = jeusDConfigBean.getNode();
        node.getParentNode().removeChild(node);
        this.updateUI();
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this._propertyChangeSupport.addPropertyChangeListener(pcl);
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this._propertyChangeSupport.removePropertyChangeListener(pcl);
    }

    protected Element createElement(String name) {
        Document document = this._node.getOwnerDocument();
        String namespaceURI = this._node.getNamespaceURI();
        String prefix = this._node.getPrefix();
        if (prefix == null) {
            prefix = "";
        }
        Element element = document.createElementNS(namespaceURI, prefix + ":" + name);
        return element;
    }

    protected Element createElement(String name, String data) {
        Document document = this._node.getOwnerDocument();
        String namespaceURI = this._node.getNamespaceURI();
        String prefix = this._node.getPrefix();
        if (prefix == null) {
            prefix = "";
        }
        Element element = document.createElementNS(namespaceURI, prefix + ":" + name);
        Text text = document.createTextNode(data);
        element.appendChild(text);
        return element;
    }
}

