/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.config;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DConfigBeanRoot;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.exceptions.BeanNotFoundException;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import jeus.deploy.JeusDeploymentManager;
import jeus.deploy.config.DConfigBeanRootSpecification;
import jeus.deploy.config.DConfigBeanSpecificationSource;
import jeus.deploy.config.DConfigDocumentFactory;
import jeus.deploy.config.JeusDConfigBeanRoot;
import org.w3c.dom.Document;

public class JeusDeploymentConfiguration
implements DeploymentConfiguration {
    private static Map filenameMap = new HashMap();
    private DeployableObject _deployObject;
    private JeusDeploymentManager _deploymentManager;
    private Map _dconfigbeanMap;

    public JeusDeploymentConfiguration(DeployableObject deployObject, JeusDeploymentManager deploymentManager) throws ConfigurationException {
        this._deployObject = deployObject;
        this._deploymentManager = deploymentManager;
        this._dconfigbeanMap = new HashMap();
    }

    public DConfigBeanRoot getDConfigBeanRoot(DDBeanRoot dDBeanRoot) throws ConfigurationException {
        if (dDBeanRoot == null) {
            throw new ConfigurationException("DDBeanRoot must not be null.");
        }
        String filename = this.getFilename(dDBeanRoot);
        String beanKey = DConfigBeanSpecificationSource.buildKey(dDBeanRoot.getType(), filename);
        if (this._dconfigbeanMap.containsKey(beanKey)) {
            return (DConfigBeanRoot)this._dconfigbeanMap.get(beanKey);
        }
        DConfigBeanSpecificationSource source = this._deploymentManager.getDConfigBeanSpecificationSource();
        DConfigBeanRootSpecification specification = source.getDConfigBeanRootSpecification(dDBeanRoot.getType(), filename);
        if (specification == null) {
            throw new ConfigurationException("Unable to find bean specification for " + filename + ".");
        }
        Document document = null;
        try {
            InputStream is = this._deployObject.getEntry(filename);
            if (is == null) {
                throw new RuntimeException();
            }
            document = DConfigDocumentFactory.createDocument(is, specification);
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (document == null) {
            document = DConfigDocumentFactory.createDocument(specification);
        }
        if (document == null) {
            throw new ConfigurationException("Unable to create DConfigBeanRoot for " + filename + ".");
        }
        JeusDConfigBeanRoot dconfigBeanRoot = this.createDConfigBeanRoot(document, dDBeanRoot, specification);
        dconfigBeanRoot.ddInit();
        return dconfigBeanRoot;
    }

    public DeployableObject getDeployableObject() {
        return this._deployObject;
    }

    public void setDeploymentManager(JeusDeploymentManager deploymentManager) {
        this._deploymentManager = deploymentManager;
    }

    public JeusDeploymentManager getDeploymentManager() {
        return this._deploymentManager;
    }

    public void removeDConfigBean(DConfigBeanRoot bean) throws BeanNotFoundException {
        DDBeanRoot ddBeanRoot = null;
        DDBean ddBean = bean.getDDBean();
        ddBeanRoot = ddBean instanceof DDBeanRoot ? (DDBeanRoot)ddBean : ddBean.getRoot();
        String filename = this.getFilename(ddBeanRoot);
        String beanKey = DConfigBeanSpecificationSource.buildKey(ddBeanRoot.getType(), filename);
        this._dconfigbeanMap.remove(beanKey);
    }

    public void restore(InputStream inputArchive) throws ConfigurationException {
        this.restoreDConfigBean(inputArchive, this._deployObject.getDDBeanRoot());
    }

    private String getFilename(DDBeanRoot dDBeanRoot) {
        String filename = null;
        try {
            filename = dDBeanRoot.getFilename();
        }
        catch (Throwable e) {
            filename = (String)filenameMap.get(dDBeanRoot.getType());
        }
        return filename;
    }

    public DConfigBeanRoot restoreDConfigBean(InputStream inputArchive, DDBeanRoot dDBeanRoot) throws ConfigurationException {
        String filename = this.getFilename(dDBeanRoot);
        DConfigBeanSpecificationSource source = this._deploymentManager.getDConfigBeanSpecificationSource();
        DConfigBeanRootSpecification specification = source.getDConfigBeanRootSpecification(dDBeanRoot.getType(), filename);
        Document document = null;
        if (inputArchive != null && (document = DConfigDocumentFactory.createDocument(inputArchive, specification)) == null) {
            throw new ConfigurationException("Unable to restore DConfigBean for " + filename + ".");
        }
        return this.createDConfigBeanRoot(document, dDBeanRoot, specification);
    }

    private JeusDConfigBeanRoot createDConfigBeanRoot(Document document, DDBeanRoot dDBeanRoot, DConfigBeanRootSpecification specification) throws ConfigurationException {
        String classname = specification.getClassname();
        try {
            Class<?> clazz = Class.forName(classname);
            JeusDConfigBeanRoot dconfigBean = (JeusDConfigBeanRoot)clazz.newInstance();
            dconfigBean.setDDBean((DDBean)dDBeanRoot);
            dconfigBean.setDeploymentConfiguration(this);
            if (document != null) {
                dconfigBean.setNode(document.getDocumentElement());
            }
            dconfigBean.setSpecification(specification);
            dconfigBean.setUIEngine(this._deploymentManager.getUIEngine());
            this._dconfigbeanMap.put(DConfigBeanSpecificationSource.buildKey(specification.getModuleType(), specification.getDdbeanFilename()), dconfigBean);
            return dconfigBean;
        }
        catch (Throwable e) {
            throw new ConfigurationException(e.getMessage());
        }
    }

    public void save(OutputStream outputArchive) throws ConfigurationException {
        this.saveDConfigBean(outputArchive, this.getDConfigBeanRoot(this._deployObject.getDDBeanRoot()));
    }

    public void saveDConfigBean(OutputStream outputArchive, DConfigBeanRoot bean) throws ConfigurationException {
        try {
            JeusDConfigBeanRoot jeusDConfigBean = (JeusDConfigBeanRoot)bean;
            jeusDConfigBean.updateConfig();
            DConfigDocumentFactory.saveDocument(outputArchive, jeusDConfigBean);
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage());
        }
    }

    static {
        filenameMap.put(ModuleType.EAR, "META-INF/application.xml");
        filenameMap.put(ModuleType.EJB, "META-INF/ejb-jar.xml");
        filenameMap.put(ModuleType.WAR, "WEB-INF/web.xml");
        filenameMap.put(ModuleType.RAR, "META-INF/ra.xml");
        filenameMap.put(ModuleType.CAR, "META-INF/application-client.xml");
    }
}

