/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.factories;

import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import jeus.deploy.JeusDeploymentManager;
import jeus.server.manager.JeusVersion;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Deploy;

public class DeploymentFactoryImpl
implements DeploymentFactory {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.deploy");
    private static final String DEPLOY_URI = "deployer:Jeus:";
    private static final String DISPLAY_NAME = "JEUS Deployment API Implementation";
    private static final String VERSION = JeusVersion.getVersion();

    public boolean handlesURI(String uri) {
        try {
            if (logger.isLoggable(JeusMessage_Deploy._2_LEVEL)) {
                logger.log(JeusMessage_Deploy._2_LEVEL, JeusMessage_Deploy._2, (Object)uri);
            }
            return uri.startsWith(DEPLOY_URI);
        }
        catch (Exception ex) {
            if (logger.isLoggable(JeusMessage_Deploy._1_LEVEL)) {
                logger.logp(JeusMessage_Deploy._1_LEVEL, "DeploymentFactoryImpl", "handlesURI", JeusMessage_Deploy._1, (Object)uri, (Throwable)ex);
            }
            return false;
        }
    }

    public DeploymentManager getDeploymentManager(String uri, String username, String password) throws DeploymentManagerCreationException {
        return new JeusDeploymentManager(uri, username, password);
    }

    public DeploymentManager getDisconnectedDeploymentManager(String uri) throws DeploymentManagerCreationException {
        return new JeusDeploymentManager(uri);
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getProductVersion() {
        return VERSION;
    }

    static {
        DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)new DeploymentFactoryImpl());
    }
}

