/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.model;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.XpathEvent;
import javax.enterprise.deploy.model.XpathListener;
import javax.xml.transform.TransformerException;
import jeus.deploy.model.JeusDDBeanRoot;
import jeus.xml.util.IXPathAPI;
import jeus.xml.util.XPathAPIFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JeusDDBean
implements DDBean {
    protected static final String ID_ATTRIBUTE = "id";
    protected String xPath;
    protected String id;
    protected String text;
    protected Node node;
    protected JeusDDBeanRoot ddBeanRoot;
    private HashMap xpathListenersTable = new HashMap();

    public JeusDDBean(Node node, String xPath, JeusDDBeanRoot ddBeanRoot) {
        Node first;
        Node idattr;
        this.node = node;
        this.ddBeanRoot = ddBeanRoot;
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null && (idattr = attrs.getNamedItem(ID_ATTRIBUTE)) != null) {
            this.id = idattr.getNodeValue();
            if (this.id != null && this.id.trim().length() == 0) {
                this.id = null;
            }
        }
        this.xPath = xPath;
        if (node.getNodeType() == 1 && (first = node.getFirstChild()) != null && first.getNodeType() == 3) {
            this.text = first.getNodeValue();
        }
    }

    protected JeusDDBean() {
    }

    private String normalizeXPath(String xpath) {
        String prefix = this.node.getPrefix();
        StringBuffer buf = new StringBuffer();
        buf.append("./");
        StringTokenizer stk = new StringTokenizer(xpath, "/");
        while (stk.hasMoreTokens()) {
            String token = stk.nextToken();
            int c = token.indexOf(58);
            if (c > 0) {
                String instancePrefix = token.substring(0, c);
                if (prefix == null || !prefix.equals(instancePrefix)) {
                    throw new IllegalArgumentException("Multiple namespace not supported. [xpath:" + xpath + ", illegal namespace:" + instancePrefix + "]");
                }
            }
            if (c < 0) {
                token = (prefix != null ? prefix : "") + ":" + token;
            }
            buf.append(token + (stk.hasMoreTokens() ? "/" : ""));
        }
        return buf.toString();
    }

    private String guessXPath(Node target, IXPathAPI xpathAPI) {
        Stack<String> xpathStack = new Stack<String>();
        Element documentElement = this.node.getOwnerDocument().getDocumentElement();
        while (target != this.node && target == documentElement) {
            Node parent = target.getParentNode();
            try {
                NodeList nodeList = xpathAPI.selectNodeList(parent, target.getNodeName());
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node != target) continue;
                    xpathStack.push(target.getNodeName() + "[" + (i + 1) + "]");
                }
                xpathStack.push(target.getNodeName());
            }
            catch (Exception e) {
                xpathStack.push(target.getNodeName());
            }
            target = parent;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = xpathStack.size() - 1; i >= 0; --i) {
            buf.append(xpathStack.get(i).toString());
            if (i <= 0) continue;
            buf.append("/");
        }
        return buf.toString();
    }

    public String getXpath() {
        return this.xPath;
    }

    public String getId() {
        return this.id;
    }

    public DDBeanRoot getRoot() {
        return this.ddBeanRoot;
    }

    public DDBean[] getChildBean(String xpath) {
        IXPathAPI xpathAPI = XPathAPIFactory.createXPathAPI();
        try {
            String normalizedXpath = this.normalizeXPath(xpath);
            Node context = null;
            context = normalizedXpath.startsWith("/") ? this.node.getOwnerDocument() : this.node;
            NodeList selectedNodeList = xpathAPI.selectNodeList(context, normalizedXpath);
            DDBean[] ddBeans = new DDBean[selectedNodeList.getLength()];
            for (int i = 0; i < selectedNodeList.getLength(); ++i) {
                Node selectedNode = selectedNodeList.item(i);
                ddBeans[i] = new JeusDDBean(selectedNode, xpath, this.ddBeanRoot);
            }
            return ddBeans;
        }
        catch (TransformerException e) {
            return null;
        }
    }

    public String getText() {
        return this.text;
    }

    public String[] getText(String xpath) {
        String normalizedXpath = this.normalizeXPath(xpath);
        IXPathAPI xpathAPI = XPathAPIFactory.createXPathAPI();
        try {
            NodeList nodeList = xpathAPI.selectNodeList(this.node, normalizedXpath);
            String[] texts = new String[nodeList.getLength()];
            for (int i = 0; i < texts.length; ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() == 2) {
                    texts[i] = node.getNodeValue();
                    continue;
                }
                if (node.getNodeType() == 1) {
                    Node first = node.getFirstChild();
                    if (first.getNodeType() == 3) {
                        texts[i] = first.getNodeValue();
                        continue;
                    }
                    texts[i] = null;
                    continue;
                }
                texts[i] = node.getNodeType() == 3 ? node.getNodeValue() : null;
            }
            return texts;
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void addXpathListener(String xpath, XpathListener xpathlistener) {
        Vector<XpathListener> vector = (Vector<XpathListener>)this.xpathListenersTable.get(xpath);
        if (vector == null) {
            vector = new Vector<XpathListener>();
        }
        vector.addElement(xpathlistener);
        this.xpathListenersTable.put(xpath, vector);
    }

    public void removeXpathListener(String xpath, XpathListener xpathlistener) {
        Vector vector = (Vector)this.xpathListenersTable.get(xpath);
        if (vector != null) {
            vector.removeElement(xpathlistener);
            this.xpathListenersTable.put(xpath, vector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(DDBean ddbean, Object obj) {
        XpathEvent xpathevent = new XpathEvent(ddbean, obj);
        Vector vector = null;
        HashMap hashMap = this.xpathListenersTable;
        synchronized (hashMap) {
            Vector vector1 = (Vector)this.xpathListenersTable.get(obj);
            vector = (Vector)vector1.clone();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            XpathListener xpathlistener = (XpathListener)enumeration.nextElement();
            xpathlistener.fireXpathEvent(xpathevent);
        }
    }

    public String[] getAttributeNames() {
        if (!this.node.hasAttributes()) {
            return null;
        }
        NamedNodeMap map = this.node.getAttributes();
        if (map == null) {
            return null;
        }
        String[] names = new String[map.getLength()];
        for (int i = 0; i < map.getLength(); ++i) {
            names[i] = map.item(i).getNodeName();
        }
        return names;
    }

    public String getAttributeValue(String attrName) {
        if (!this.node.hasAttributes()) {
            return null;
        }
        NamedNodeMap map = this.node.getAttributes();
        if (map == null) {
            return null;
        }
        Node node = map.getNamedItem(attrName);
        if (node == null) {
            return null;
        }
        return node.getNodeValue();
    }
}

