/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.J2eeApplicationObject;
import javax.enterprise.deploy.model.XpathEvent;
import javax.enterprise.deploy.model.XpathListener;
import javax.enterprise.deploy.shared.ModuleType;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.model.JeusDeployableObject;
import jeus.deploy.util.ModuleTypeResolver;

public class JeusJ2eeApplicationObject
extends JeusDeployableObject
implements J2eeApplicationObject {
    private Map uriChildMap = new HashMap();
    private Map typeChildMap = new HashMap();
    private Map typeURIMap = new HashMap();
    private String[] allURIs;
    private JeusDeployableObject[] allDeployableObjects;
    private Hashtable xpathListenersTable = new Hashtable();

    public JeusJ2eeApplicationObject(File appFile) throws Exception {
        super(appFile);
        this.load();
    }

    private void load() throws Exception {
        List list;
        Object key;
        Enumeration archives = this.archive.entries();
        ArrayList<JeusDeployableObject> children = new ArrayList<JeusDeployableObject>();
        ArrayList<String> uris = new ArrayList<String>();
        while (archives.hasMoreElements()) {
            ModuleType archModuleType;
            String entry = (String)archives.nextElement();
            System.err.println(entry);
            AbstractArchive arch = this.archive.getEmbeddedArchive(entry);
            if (arch == null || (archModuleType = ModuleTypeResolver.getModuleType(arch)) == null) continue;
            try {
                JeusDeployableObject deployObj = new JeusDeployableObject(this.archive, arch);
                ArrayList<JeusDeployableObject> childList = (ArrayList<JeusDeployableObject>)this.typeChildMap.get(deployObj.getType());
                if (childList == null) {
                    childList = new ArrayList<JeusDeployableObject>();
                    this.typeChildMap.put(deployObj.getType(), childList);
                }
                childList.add(deployObj);
                children.add(deployObj);
                ArrayList<String> uriList = (ArrayList<String>)this.typeURIMap.get(deployObj.getType());
                if (uriList == null) {
                    uriList = new ArrayList<String>();
                    this.typeURIMap.put(deployObj.getType(), uriList);
                }
                uriList.add(arch.getArchiveUri());
                uris.add(arch.getArchiveUri());
                this.uriChildMap.put(arch.getArchiveUri(), deployObj);
            }
            catch (Exception e) {}
        }
        Set entries = this.typeChildMap.entrySet();
        for (Map.Entry entry : entries) {
            key = entry.getKey();
            list = (List)entry.getValue();
            this.typeChildMap.put(key, list.toArray(new JeusDeployableObject[list.size()]));
        }
        entries = this.typeURIMap.entrySet();
        for (Map.Entry entry : entries) {
            key = entry.getKey();
            list = (List)entry.getValue();
            this.typeURIMap.put(key, list.toArray(new String[list.size()]));
        }
        this.allDeployableObjects = children.toArray(new JeusDeployableObject[children.size()]);
        this.allURIs = uris.toArray(new String[uris.size()]);
    }

    public DeployableObject getDeployableObject(String uri) {
        return (DeployableObject)this.uriChildMap.get(uri);
    }

    public DeployableObject[] getDeployableObjects(ModuleType moduleType) {
        return (DeployableObject[])this.typeChildMap.get(moduleType);
    }

    public DeployableObject[] getDeployableObjects() {
        return this.allDeployableObjects;
    }

    public String[] getModuleUris(ModuleType moduleType) {
        return (String[])this.typeURIMap.get(moduleType);
    }

    public String[] getModuleUris() {
        return this.allURIs;
    }

    public DDBean[] getChildBean(ModuleType moduleType, String xpath) {
        JeusDeployableObject[] deployableObjs = (JeusDeployableObject[])this.typeChildMap.get(moduleType);
        ArrayList<List<DDBean>> ddBeanList = new ArrayList<List<DDBean>>();
        for (int i = 0; i < deployableObjs.length; ++i) {
            DDBeanRoot root = deployableObjs[i].getDDBeanRoot();
            DDBean[] ddBeans = root.getChildBean(xpath);
            ddBeanList.add(Arrays.asList(ddBeans));
        }
        return ddBeanList.toArray(new DDBean[ddBeanList.size()]);
    }

    public String[] getText(ModuleType moduleType, String xpath) {
        JeusDeployableObject[] deployableObjs = (JeusDeployableObject[])this.typeChildMap.get(moduleType);
        ArrayList<List<String>> textList = new ArrayList<List<String>>();
        for (int i = 0; i < deployableObjs.length; ++i) {
            DDBeanRoot root = deployableObjs[i].getDDBeanRoot();
            String[] texts = root.getText(xpath);
            if (texts == null) continue;
            textList.add(Arrays.asList(texts));
        }
        return textList.toArray(new String[textList.size()]);
    }

    public void addXpathListener(ModuleType moduletype, String s, XpathListener xpathlistener) {
        Vector<XpathListener> vector;
        Hashtable<String, Vector<XpathListener>> hashtable = (Hashtable<String, Vector<XpathListener>>)this.xpathListenersTable.get(moduletype.toString());
        if (hashtable == null) {
            hashtable = new Hashtable<String, Vector<XpathListener>>();
        }
        if ((vector = (Vector<XpathListener>)hashtable.get(s)) == null) {
            vector = new Vector<XpathListener>();
        }
        vector.addElement(xpathlistener);
        hashtable.put(s, vector);
        this.xpathListenersTable.put(moduletype.toString(), hashtable);
    }

    public void removeXpathListener(ModuleType moduletype, String s, XpathListener xpathlistener) {
        Hashtable hashtable = (Hashtable)this.xpathListenersTable.get(moduletype.toString());
        if (hashtable != null) {
            Vector vector = (Vector)hashtable.get(s);
            if (vector != null) {
                vector.removeElement(xpathlistener);
                hashtable.put(s, vector);
            }
            this.xpathListenersTable.put(moduletype.toString(), hashtable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(DDBean ddbean, Object obj, String s) {
        XpathEvent xpathevent = new XpathEvent(ddbean, obj);
        Vector vector = null;
        Hashtable hashtable = this.xpathListenersTable;
        synchronized (hashtable) {
            Hashtable hashtable1 = (Hashtable)this.xpathListenersTable.get(((ModuleType)obj).toString());
            Vector vector1 = (Vector)hashtable1.get(s);
            vector = (Vector)vector1.clone();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            XpathListener xpathlistener = (XpathListener)enumeration.nextElement();
            xpathlistener.fireXpathEvent(xpathevent);
        }
    }
}

