/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import jeus.deploy.JeusDeploymentManager;
import jeus.deploy.archivist.FileArchive;
import jeus.deploy.archivist.FileArchiveFactory;
import jeus.deploy.io.ApplicationDeploymentDescriptorFile;
import jeus.deploy.io.DeploymentDescriptorFile;
import jeus.deploy.io.EjbDeploymentDescriptorFile;
import jeus.management.JMXManager;
import jeus.management.JMXUtility;
import jeus.management.j2ee.EJBModule;
import jeus.management.j2ee.J2EEDeployedObject;
import jeus.security.util.LoginUtil;
import jeus.server.enginecontainer.EngineContainer;
import jeus.util.JeusProperties;
import jeus.util.JeusRuntimeException;
import jeus.util.ScheduleTask;
import jeus.xml.binding.jeusDD.ApplicationType;
import jeus.xml.binding.jeusDD.DeploymentTypeType;
import jeus.xml.binding.jeusDD.EjbComponentType;
import jeus.xml.binding.jeusDDHelper.JeusMainHelper;

public class AutoDeployTask
extends ScheduleTask {
    private ApplicationType appType;
    private File file;
    private long lastModifiedTime;
    private J2EEDeployedObject deployedObject;

    public AutoDeployTask(ApplicationType appType) throws IOException, JAXBException {
        this.appType = (ApplicationType)appType.cloneType();
        String deployType = "";
        String appPath = null;
        EjbComponentType ejbComponent = null;
        List appList = appType.getNameAndPathAndDeploymentType();
        for (int i = 0; i < appList.size(); ++i) {
            JAXBElement element = (JAXBElement)appList.get(i);
            Object obj = element.getValue();
            String elementName = element.getName().getLocalPart();
            if (elementName.equals("path")) {
                appPath = (String)element.getValue();
            }
            if (obj instanceof DeploymentTypeType) {
                deployType = ((DeploymentTypeType)obj).value();
            }
            if (!(obj instanceof EjbComponentType)) continue;
            ejbComponent = (EjbComponentType)obj;
        }
        String absolutePath = (String)appType.getInfoMap().get("absolute-path");
        absolutePath = new File(appPath).isAbsolute() ? appPath : (absolutePath != null ? (absolutePath.endsWith(File.separator) ? absolutePath + appPath : absolutePath + File.separator + appPath) : JeusProperties.JEUS_APP_HOME + File.separator + appPath);
        if (absolutePath == null) {
            throw new JeusRuntimeException("The application does not exists : " + JeusDeploymentManager.getApplicationPath(appType));
        }
        this.file = new File(absolutePath);
        if (this.file.isDirectory()) {
            if (deployType.equals("EAR")) {
                FileArchive appHomeArchive = (FileArchive)FileArchiveFactory.openArchiveStatic((String)absolutePath);
                ApplicationDeploymentDescriptorFile desc = new ApplicationDeploymentDescriptorFile();
                this.file = desc.getDeploymentDescriptorFile(appHomeArchive);
            } else if (ejbComponent != null) {
                if (ejbComponent.getEjbJar() != null) {
                    String ejbJarPath = ejbComponent.getEjbJar();
                    this.file = EJBModule.getEjbJarFile(ejbJarPath, "ejb-jar", null, JeusDeploymentManager.getNameFromPath(appType), new EjbDeploymentDescriptorFile());
                } else {
                    this.setJ2EEDescriptorFile(appType, absolutePath);
                }
            } else {
                this.setJ2EEDescriptorFile(appType, absolutePath);
            }
        }
        this.lastModifiedTime = this.file.lastModified();
    }

    private void setJ2EEDescriptorFile(ApplicationType appType, String absolutePath) throws IOException {
        FileArchive appHomeArchive = (FileArchive)FileArchiveFactory.openArchiveStatic((String)absolutePath);
        DeploymentDescriptorFile desc = JeusMainHelper.getComponentDescriptorFile(appType);
        File file = desc.getDeploymentDescriptorFile(appHomeArchive);
        if (file == null) {
            throw new FileNotFoundException("descriptor file " + desc.getDeploymentDescriptorPath() + " is not found");
        }
        this.file = file;
    }

    public void setModifiedTime() {
        this.lastModifiedTime = this.file.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block10: {
            try {
                long newModified = this.file.lastModified();
                if (newModified == this.lastModifiedTime || newModified <= 0L) break block10;
                this.cancel();
                LoginUtil.loginCodeSubjectWithRuntimeException();
                try {
                    this.cancel();
                    try {
                        this.deployedObject.undeploy();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        LoginUtil.logoutWithRuntimeException();
                        return;
                    }
                    try {
                        TargetModuleID moduleId = EngineContainer.serverMBean.deploy(this.appType);
                        JMXUtility.invokeWithTargetModuleID(JMXManager.getMbeanServer(), moduleId, "start", null, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                finally {
                    LoginUtil.logoutWithRuntimeException();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void setDeployedObject(J2EEDeployedObject j2EEDeployedObject) {
        this.deployedObject = j2EEDeployedObject;
    }
}

