/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.InstanceNotFoundException;
import jeus.deploy.JeusDeploymentManager;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.FileArchiveFactory;
import jeus.deploy.archivist.JarArchiveFactory;
import jeus.deploy.util.ModuleTypeResolver;
import jeus.ejb.container.ContainerException;
import jeus.management.JMXManager;
import jeus.management.JMXUtility;
import jeus.security.util.LoginUtil;
import jeus.server.enginecontainer.EngineContainer;
import jeus.util.JeusProperties;
import jeus.util.ScheduleTask;
import jeus.util.file.FileUtils;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JMX;
import jeus.xml.binding.jeusDD.ApplicationType;
import jeus.xml.binding.jeusDD.AutoDeployType;

public class ContainerAutoDeployTask
extends ScheduleTask {
    private File autoDeployPath;
    private HashMap deployedModuleMap = new HashMap();
    private HashMap failedModuleMap = new HashMap();
    private AutoDeployType autoDeployType;
    private boolean fastDeploy;
    public static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.deploy");

    public ContainerAutoDeployTask(ApplicationType autoDeploy) {
        String autoDeployPathString = autoDeploy.getAbsolutePath();
        if (autoDeployPathString == null) {
            autoDeployPathString = JeusProperties.AUTO_DEPLOY_DIR;
        }
        this.autoDeployPath = new File(autoDeployPathString);
        if (!this.autoDeployPath.isAbsolute()) {
            this.autoDeployPath = new File(JeusProperties.JEUS_HOME + File.separator + "webhome" + File.separator + autoDeployPathString);
        }
        this.autoDeployType = autoDeploy.getAutoDeploy();
        this.fastDeploy = autoDeploy.isFastDeploy() != null && autoDeploy.isFastDeploy() != false;
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployAddedFiles(String[] moduleFileList) {
        for (String fileName : moduleFileList) {
            AbstractArchive archive = null;
            LoginUtil.loginCodeSubjectWithRuntimeException();
            try {
                File file = new File(this.autoDeployPath, fileName);
                if (!FileUtils.isExploded((String)this.autoDeployPath.getAbsolutePath(), (String)fileName)) {
                    if (!fileName.endsWith(".ear") && !fileName.endsWith(".jar") && !fileName.endsWith(".war") && !fileName.endsWith(".rar")) continue;
                    archive = JarArchiveFactory.openArchiveStatic((File)file);
                } else {
                    archive = FileArchiveFactory.openArchiveStatic((File)file);
                    ModuleType moduleType = ModuleTypeResolver.getModuleType(archive);
                    if (moduleType == null || !moduleType.equals(ModuleType.EAR) && !moduleType.equals(ModuleType.EJB) && !moduleType.equals(ModuleType.WAR) && !moduleType.equals(ModuleType.RAR) && !moduleType.equals(ModuleType.RAR)) continue;
                }
                ApplicationType appType = JeusDeploymentManager.fillApplicationDDInfoFromArchive(archive, null);
                if (!this.autoDeployPath.getAbsolutePath().equals(JeusProperties.AUTO_DEPLOY_DIR)) {
                    appType.setAbsolutePath(this.autoDeployPath.getAbsolutePath());
                } else {
                    appType.setAbsolutePath(this.autoDeployPath.getAbsolutePath());
                }
                appType.setAutoDeploy(this.autoDeployType);
                appType.setFastDeploy(Boolean.valueOf(this.fastDeploy));
                TargetModuleID moduleId = EngineContainer.serverMBean.deploy(appType);
                this.deployedModuleMap.put(fileName, moduleId);
                JMXUtility.invokeWithTargetModuleID(JMXManager.getMbeanServer(), moduleId, "start", null, null);
            }
            catch (Exception e) {
                if (!(e.getCause() instanceof ContainerException)) {
                    this.deployedModuleMap.remove(fileName);
                }
                File failedModuleFile = new File(this.autoDeployPath, fileName);
                long lastModifedTime = failedModuleFile.lastModified();
                this.failedModuleMap.put(fileName, lastModifedTime);
                e.printStackTrace();
            }
            finally {
                LoginUtil.logoutWithRuntimeException();
                try {
                    if (archive != null) {
                        archive.close();
                        archive = null;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeployRemovedFiles(String[] moduleFileList) {
        LoginUtil.loginCodeSubjectWithRuntimeException();
        try {
            for (String fileName : moduleFileList) {
                try {
                    TargetModuleID moduleId = (TargetModuleID)this.deployedModuleMap.remove(fileName);
                    if (moduleId == null) continue;
                    JMXUtility.invokeWithTargetModuleID(JMXManager.getMbeanServer(), moduleId, "undeploy", null, null);
                }
                catch (InstanceNotFoundException e) {
                    if (!logger.isLoggable(JeusMessage_JMX._77_LEVEL)) continue;
                    logger.log(JeusMessage_JMX._77_LEVEL, JeusMessage_JMX._77, (Object)fileName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    public void run() {
        try {
            String[] moduleFileList = this.autoDeployPath.list();
            if (moduleFileList != null) {
                ArrayList<String> newFiles = new ArrayList<String>();
                ArrayList deployedFiles = new ArrayList(this.deployedModuleMap.keySet());
                for (String modulePath : moduleFileList) {
                    if (this.failedModuleMap.containsKey(modulePath)) {
                        long oldModifiedTime;
                        File failedModeulFile = new File(this.autoDeployPath, modulePath);
                        long newModifiedTime = failedModeulFile.lastModified();
                        if (newModifiedTime == (oldModifiedTime = ((Long)this.failedModuleMap.get(modulePath)).longValue()) || newModifiedTime <= 0L) continue;
                        this.failedModuleMap.remove(modulePath);
                        newFiles.add(modulePath);
                        continue;
                    }
                    if (this.deployedModuleMap.containsKey(modulePath)) {
                        deployedFiles.remove(modulePath);
                        continue;
                    }
                    if (this.failedModuleMap.containsKey(modulePath)) continue;
                    newFiles.add(modulePath);
                }
                if (deployedFiles.size() > 0) {
                    this.undeployRemovedFiles(deployedFiles.toArray(new String[deployedFiles.size()]));
                }
                if (newFiles.size() > 0) {
                    this.deployAddedFiles(newFiles.toArray(new String[newFiles.size()]));
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

