/*
 * Decompiled with CFR 0.152.
 */
package jeus.descriptor.bind;

import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import jeus.descriptor.jeusserver.ConnectorProperty;
import jeus.jdbc.datasource.DBDSBindInfo;
import jeus.servlet.deployment.descriptor.bind.BindedDescriptor;
import jeus.xml.binding.jeusDD.ConnectionTraceType;
import jeus.xml.binding.jeusDD.DatabaseConnectionPoolType;
import jeus.xml.binding.jeusDD.DatabaseType;
import jeus.xml.binding.jeusDD.TypePropertyType;
import jeus.xml.binding.jeusDD.WaitFreeConnectionType;

public class DBDSBindInfoJB
extends DBDSBindInfo
implements Serializable,
BindedDescriptor {
    public static final String PR_DATABASE_NAME = "DatabaseName";
    public static final String PR_DATA_SOURCE_NAME = "DataSourceName";
    public static final String PR_SERVICE_NAME = "ServiceName";
    public static final String PR_DESCRIPTION = "Description";
    public static final String PR_NETWORK_PROTOCOL = "NetworkProtocol";
    public static final String PR_PASSWORD = "Password";
    public static final String PR_PORT_NUMBER = "PortNumber";
    public static final String PR_SERVER_NAME = "ServerName";
    public static final String PR_USER = "User";
    public static final String PR_DRIVER_TYPE = "DriverType";

    public static void setDBPropertyValue(Vector propertyList, String givenName, String value) {
        if (propertyList == null) {
            return;
        }
        if (givenName == null || givenName.trim().equals("")) {
            return;
        }
        if (value == null || value.trim().equals("")) {
            return;
        }
        ConnectorProperty citem = new ConnectorProperty();
        citem.setName(givenName);
        if (givenName.equals(PR_PORT_NUMBER)) {
            citem.setType("java.lang.Integer");
        } else {
            citem.setType("java.lang.String");
        }
        citem.setValue(value);
        propertyList.add(citem);
    }

    public static DBDSBindInfo getDBDSBindInfoDescriptor(DatabaseType dbt) {
        DBDSBindInfo dbInfo = new DBDSBindInfo();
        if (dbt.getVendor() != null) {
            dbInfo.setVendor(dbt.getVendor().value());
        }
        if (dbt.getExportName() != null) {
            dbInfo.setExportName(dbt.getExportName());
        }
        dbInfo.setDataSourceType(dbt.getDataSourceType().value());
        if (dbt.getDataSourceClassName() != null) {
            dbInfo.setDataSourceClassName(dbt.getDataSourceClassName());
        }
        if (dbt.isSetAutoCommit()) {
            dbInfo.setAutoCommitValue(dbt.isAutoCommit());
            dbInfo.setUseAutoCommitSetting(true);
        }
        Vector<ConnectorProperty> newProperty = new Vector<ConnectorProperty>();
        DBDSBindInfoJB.setDBPropertyValue(newProperty, PR_DATABASE_NAME, dbt.getDatabaseName());
        DBDSBindInfoJB.setDBPropertyValue(newProperty, PR_DATA_SOURCE_NAME, dbt.getDataSourceName());
        DBDSBindInfoJB.setDBPropertyValue(newProperty, PR_SERVICE_NAME, dbt.getServiceName());
        DBDSBindInfoJB.setDBPropertyValue(newProperty, PR_DESCRIPTION, dbt.getDescription());
        DBDSBindInfoJB.setDBPropertyValue(newProperty, PR_NETWORK_PROTOCOL, dbt.getNetworkProtocol());
        DBDSBindInfoJB.setDBPropertyValue(newProperty, PR_PASSWORD, dbt.getPassword());
        if (dbt.isSetPortNumber()) {
            DBDSBindInfoJB.setDBPropertyValue(newProperty, PR_PORT_NUMBER, String.valueOf(dbt.getPortNumber()));
        }
        DBDSBindInfoJB.setDBPropertyValue(newProperty, PR_SERVER_NAME, dbt.getServerName());
        DBDSBindInfoJB.setDBPropertyValue(newProperty, PR_USER, dbt.getUser());
        dbInfo.setUser(dbt.getUser());
        DBDSBindInfoJB.setDBPropertyValue(newProperty, PR_DRIVER_TYPE, dbt.getDriverType());
        List pList = dbt.getProperty();
        for (int i = 0; i < pList.size(); ++i) {
            TypePropertyType prop = (TypePropertyType)pList.get(i);
            ConnectorProperty citem = new ConnectorProperty();
            citem.setName(prop.getName());
            citem.setValue(prop.getValue());
            citem.setType(prop.getType());
            newProperty.add(citem);
            if (!prop.getName().equals(PR_USER)) continue;
            dbInfo.setUser(prop.getValue());
        }
        dbInfo.setStmtQueryTimeout(dbt.getStmtQueryTimeout());
        dbInfo.properties = newProperty;
        DatabaseConnectionPoolType cpt = dbt.getConnectionPool();
        if (cpt != null) {
            WaitFreeConnectionType wfct;
            if (cpt.getDelegationDba() != null) {
                if (cpt.getDelegationDba() != null) {
                    dbInfo.setDBADelegate(cpt.getDelegationDba());
                }
                dbInfo.setDBARequired(true);
                dbInfo.setDbaTO(cpt.getDbaTimeout());
            } else {
                dbInfo.setDBARequired(false);
                dbInfo.setDBADelegate("");
                dbInfo.setDbaTO(-1);
            }
            if (cpt.getDelegationDatasource() != null) {
                dbInfo.setDelegationRequired(true);
                if (cpt.getDelegationDatasource() != null) {
                    dbInfo.setNullTxDelegate(cpt.getDelegationDatasource());
                }
            } else {
                dbInfo.setDelegationRequired(false);
                dbInfo.setNullTxDelegate("");
            }
            if (cpt.getPooling() != null) {
                dbInfo.setMax(cpt.getPooling().getMax());
                dbInfo.setMin(cpt.getPooling().getMin());
                dbInfo.setResizingPeriod(cpt.getPooling().getPeriod());
                dbInfo.setStep(cpt.getPooling().getStep());
            }
            if ((wfct = cpt.getWaitFreeConnection()) != null) {
                dbInfo.setWaiting(wfct.isEnableWait());
                dbInfo.setWaitingTime(wfct.getWaitTime());
            } else {
                dbInfo.setWaiting(false);
            }
            dbInfo.setMaxUseCount(cpt.getMaxUseCount());
            dbInfo.setCheckQuery(cpt.getCheckQuery());
            dbInfo.setCheckQueryClassName(cpt.getCheckQueryClass());
            dbInfo.setCheckQueryPeriod(cpt.getCheckQueryPeriod());
            dbInfo.setStmtCachingSize(cpt.getStmtCachingSize());
            dbInfo.setFetchSize(cpt.getStmtFetchSize());
            if (cpt.isSetConnectionTrace()) {
                ConnectionTraceType traceType = cpt.getConnectionTrace();
                dbInfo.setUseConnectionTrace(traceType.isEnabled());
            }
            dbInfo.setNonValidationInterval(cpt.getNonValidationInterval());
            dbInfo.setKeepConnectionHandleOpen(cpt.isKeepConnectionHandleOpen());
        }
        return dbInfo;
    }
}

