/*
 * Decompiled with CFR 0.152.
 */
package jeus.descriptor.bind;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.enterprise.deploy.shared.ModuleType;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import jeus.deploy.ApplicationNameToRemove;
import jeus.deploy.JeusDeploymentException;
import jeus.deploy.JeusDeploymentManager;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.FileArchiveFactory;
import jeus.deploy.archivist.JarArchiveFactory;
import jeus.deploy.util.ModuleTypeResolver;
import jeus.descriptor.bind.DBDSBindInfoJB;
import jeus.descriptor.bind.EngineContainerDescriptorJB;
import jeus.descriptor.bind.JMSSourceDescriptorJB;
import jeus.descriptor.bind.JMXManagerDescriptorJB;
import jeus.descriptor.bind.JNDIServerDescriptorJB;
import jeus.descriptor.bind.JobDescriptorJB;
import jeus.descriptor.extresource.JMSSourceDescriptor;
import jeus.descriptor.jeusserver.EngineContainerDescriptor;
import jeus.descriptor.jeusserver.JMXManagerDescriptor;
import jeus.descriptor.jeusserver.JNDIServerDescriptor;
import jeus.descriptor.jeusserver.JeusMainDescriptor;
import jeus.descriptor.jeusserver.MailSessionDescriptor;
import jeus.descriptor.jeusserver.URLDescriptor;
import jeus.jdbc.datasource.ClusterDSBindInfo;
import jeus.jdbc.datasource.DBDSBindInfo;
import jeus.server.ConfigFile;
import jeus.server.service.ContainerManagerService;
import jeus.service.descriptor.JeusMainDescriptorFile;
import jeus.servlet.deployment.descriptor.bind.BindedDescriptor;
import jeus.tool.common.xml.XMLConverterException;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusPort;
import jeus.util.JeusProperties;
import jeus.util.JeusRuntimeException;
import jeus.util.Runner;
import jeus.util.StringUtil;
import jeus.util.VirtualDNS;
import jeus.util.file.FileUtils;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Manager;
import jeus.util.message.JeusMessage_Manager1;
import jeus.util.properties.JeusManagerProperties;
import jeus.util.properties.JeusManagerPropertyValues;
import jeus.util.properties.JeusPropertyValues;
import jeus.xml.binding.jeusDD.AllTargetsType;
import jeus.xml.binding.jeusDD.AppTargetType;
import jeus.xml.binding.jeusDD.ApplicationType;
import jeus.xml.binding.jeusDD.AutoDeployType;
import jeus.xml.binding.jeusDD.ClientComponentType;
import jeus.xml.binding.jeusDD.ClusterDsType;
import jeus.xml.binding.jeusDD.ConnectorComponentType;
import jeus.xml.binding.jeusDD.DataSourceType;
import jeus.xml.binding.jeusDD.DatabaseType;
import jeus.xml.binding.jeusDD.DeploymentTargetType;
import jeus.xml.binding.jeusDD.DeploymentTypeType;
import jeus.xml.binding.jeusDD.EjbComponentType;
import jeus.xml.binding.jeusDD.EngineContainerType;
import jeus.xml.binding.jeusDD.ExternalSourceType;
import jeus.xml.binding.jeusDD.JeusNodeType;
import jeus.xml.binding.jeusDD.JeusSystemType;
import jeus.xml.binding.jeusDD.JmsSourceType;
import jeus.xml.binding.jeusDD.MailEntryType;
import jeus.xml.binding.jeusDD.MailPropertyType;
import jeus.xml.binding.jeusDD.MailSourceType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.ResourceType;
import jeus.xml.binding.jeusDD.UrlEntryType;
import jeus.xml.binding.jeusDD.UrlSourceType;
import jeus.xml.binding.jeusDD.WebComponentType;
import jeus.xml.binding.jeusDD.WebContextGroupType;
import jeus.xml.binding.jeusDD.WebadminConfigType;
import jeus.xml.binding.util.JeusBindingInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JeusMainDescriptorJB
extends JeusMainDescriptor
implements Serializable,
BindedDescriptor {
    private static JeusSystemType _jeusSystemElem;
    private static ConfigFile configFile;
    private static JeusMainDescriptorFile descFile;
    private static Hashtable descMap;
    private static final JeusLogger logger;
    private static final Object DEFAULT_CONTAINER_NAME;

    public static JeusSystemType getJeusMainDescriptor() throws IOException {
        try {
            JeusMainDescriptorJB.checkJeusSystemJAXB();
            return _jeusSystemElem;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new XMLConverterException(e.getMessage());
        }
    }

    public static JeusMainDescriptor getLocalJeusMainDescriptor() {
        try {
            return JeusMainDescriptorJB.getJeusMainDescriptor(VirtualDNS.LOCAL_VIRTUALNAME);
        }
        catch (Exception e) {
            throw new JeusRuntimeException((Throwable)e);
        }
    }

    public static JeusMainDescriptor getJeusMainDescriptor(String myNodeName) throws IOException, JAXBException {
        try {
            JeusMainDescriptorJB.checkJeusSystemJAXB();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new XMLConverterException(e.getMessage());
        }
        JeusMainDescriptor _mainDesc = (JeusMainDescriptor)descMap.get(myNodeName);
        if (_mainDesc != null) {
            return _mainDesc;
        }
        _mainDesc = new JeusMainDescriptor();
        _mainDesc.setJeusMainRoot(_jeusSystemElem);
        List nodeList = _jeusSystemElem.getNode();
        Vector<String> nodeNameOnly = new Vector<String>();
        for (Object node : nodeList) {
            JeusNodeType oneNode = (JeusNodeType)node;
            String nodeName = oneNode.getName();
            nodeNameOnly.add(nodeName);
        }
        JNDIServerDescriptor nsTmpDesc = JNDIServerDescriptorJB.getJNDIServerDescriptor(_jeusSystemElem.getNamingServer());
        if (nsTmpDesc != null) {
            nsTmpDesc.primarys = nodeNameOnly;
            _mainDesc.setJNDIServerDescriptor(nsTmpDesc);
        }
        if (Runner.getLicenseType() == Runner.LIC_TYPE_ACADEMIC && nodeList.size() > 2) {
            if (logger.isLoggable(JeusMessage_Manager1._506_LEVEL)) {
                logger.log(JeusMessage_Manager1._506_LEVEL, JeusMessage_Manager1._506);
            }
            System.exit(1);
        }
        for (Object node : nodeList) {
            WebadminConfigType webadminConfigType;
            JeusNodeType oneNode = (JeusNodeType)node;
            _mainDesc.primarys.add(oneNode.getName());
            if (oneNode.getBackupNode() == null) {
                _mainDesc.backups.add("");
            } else {
                _mainDesc.backups.add(oneNode.getBackupNode());
            }
            if (!myNodeName.equals(oneNode.getName())) continue;
            _mainDesc.setJeusNode(oneNode);
            _mainDesc.setClassFTP(oneNode.isSetClassFtp() && oneNode.isClassFtp() != false);
            _mainDesc.setSerialStart(oneNode.isSetSequentialStart() && oneNode.isSequentialStart() != false);
            boolean setScheduler = oneNode.isSetScheduler();
            if (setScheduler) {
                _mainDesc.setSchedulerEnabled(oneNode.getScheduler().isEnabled());
                _mainDesc.setSchedulerThreadPool(oneNode.getScheduler().getThreadPool());
                _mainDesc.setJobDescriptor(JobDescriptorJB.getJobDescriptor(oneNode.getScheduler().getJobList(), oneNode.getName()));
            }
            if (oneNode.isSetEnableWebadmin()) {
                _mainDesc.setEnableWA(oneNode.isEnableWebadmin());
            }
            if ((webadminConfigType = oneNode.getWebadminConfig()) != null) {
                _mainDesc.setAllowedServer(webadminConfigType.getAllowedServer());
            }
            JMXManagerDescriptor _jmxDesc = JMXManagerDescriptorJB.getJMSManagerDescriptor(oneNode.getJmxManager());
            _mainDesc.setJMXManagerDescriptor(_jmxDesc);
            List ecList = oneNode.getEngineContainer();
            if (Runner.getLicenseType() == Runner.LIC_TYPE_ACADEMIC && ecList.size() > 2) {
                if (logger.isLoggable(JeusMessage_Manager1._507_LEVEL)) {
                    logger.log(JeusMessage_Manager1._507_LEVEL, JeusMessage_Manager1._507);
                }
                System.exit(1);
            }
            HashMap<Integer, String> conIdList = new HashMap<Integer, String>();
            HashMap<Integer, String> conBasePortList = new HashMap<Integer, String>();
            boolean useListenPortPerContainer = JeusManagerProperties.USE_LISTEN_PORT_PER_CONTAINER;
            if (logger.isLoggable(JeusMessage_Manager1._503_LEVEL)) {
                logger.log(JeusMessage_Manager1._503_LEVEL, JeusMessage_Manager1._503, new Object[]{useListenPortPerContainer, useListenPortPerContainer ? "" : ", actually all containers use jeus baseport " + JeusPort.JeusBase});
            }
            for (Object e : ecList) {
                int basePort;
                String anotherContainerName;
                Integer id;
                EngineContainerType ecConfig = (EngineContainerType)e;
                EngineContainerDescriptor ecDesc = EngineContainerDescriptorJB.getEngineContainerDescriptor(ecConfig, oneNode.getName());
                ecDesc.setJNDIServerDescriptor(nsTmpDesc);
                ecDesc.setEngineContainerRoot(ecConfig);
                String containerName = ecDesc.getName();
                if (containerName.endsWith("_default") && JeusPropertyValues.JEUS_CATEGORY == 1) {
                    JeusManagerPropertyValues.containerName = containerName;
                }
                if (ecConfig.isSetId()) {
                    id = ecDesc.getEngineContainerRoot().getId();
                } else {
                    id = JeusMainDescriptorJB.makeContainerID(containerName);
                    ecConfig.setId(id);
                }
                if (ecConfig.getBasePort() == null || ecConfig.getBasePort() <= 0) {
                    ecConfig.setBasePort(Integer.valueOf(JeusMainDescriptorJB.makeBasePort(id)));
                }
                if ((anotherContainerName = conIdList.put(id, containerName)) != null) {
                    throw new JeusRuntimeException("the container ID generated is duplicated with another container " + anotherContainerName + " : " + containerName + ", set container ID for the positive ID less than 128");
                }
                if (logger.isLoggable(JeusMessage_Manager1._504_LEVEL)) {
                    logger.log(JeusMessage_Manager1._504_LEVEL, JeusMessage_Manager1._504, new Object[]{containerName, id});
                }
                if ((anotherContainerName = conBasePortList.put(basePort = ecConfig.getBasePort().intValue(), containerName)) != null) {
                    throw new JeusRuntimeException("the container base port is duplicated with another container " + anotherContainerName + " : " + containerName);
                }
                if (logger.isLoggable(JeusMessage_Manager1._505_LEVEL)) {
                    logger.log(JeusMessage_Manager1._505_LEVEL, JeusMessage_Manager1._505, new Object[]{containerName, basePort});
                }
                if (containerName.equals(JeusManagerPropertyValues.containerName)) {
                    JeusManagerPropertyValues.containerBasePort = ecConfig.getBasePort();
                    JeusManagerPropertyValues.containerID = ecConfig.getId();
                }
                _mainDesc.engineContainers.put(ecDesc.getName(), ecDesc);
            }
            for (Object object : _mainDesc.engineContainers.entrySet()) {
                Map.Entry entry = (Map.Entry)object;
                JeusMainDescriptorJB.setApplicationsForContainer(_mainDesc, (EngineContainerDescriptor)entry.getValue());
            }
        }
        ResourceType rt = _jeusSystemElem.getResource();
        if (rt != null) {
            ExternalSourceType extst;
            UrlSourceType urlSources;
            MailSourceType mailSources;
            DataSourceType dst = rt.getDataSource();
            if (dst != null) {
                Vector<DBDSBindInfo> dataSources = new Vector<DBDSBindInfo>();
                List dbList = dst.getDatabase();
                for (DatabaseType dbt : dbList) {
                    DBDSBindInfo dbInfo = DBDSBindInfoJB.getDBDSBindInfoDescriptor(dbt);
                    dataSources.add(dbInfo);
                }
                _mainDesc.dbDataSource = dataSources;
                List clusterList = dst.getClusterDs();
                Vector<ClusterDSBindInfo> cdSources = new Vector<ClusterDSBindInfo>();
                for (Object aClusterList : clusterList) {
                    ClusterDsType cdsType = (ClusterDsType)aClusterList;
                    ClusterDSBindInfo cdsInfo = JeusMainDescriptorJB.getClusterDBDSInfo(cdsType);
                    cdSources.add(cdsInfo);
                }
                _mainDesc.clusterDataSource = cdSources;
            }
            if ((mailSources = rt.getMailSource()) != null) {
                List mailEntryList = mailSources.getMailEntry();
                Vector<MailSessionDescriptor> mailEntrys = new Vector<MailSessionDescriptor>();
                for (Object aMailEntryList : mailEntryList) {
                    MailEntryType mailType = (MailEntryType)aMailEntryList;
                    MailSessionDescriptor descriptor = JeusMainDescriptorJB.getMailSessionDescriptor(mailType);
                    mailEntrys.add(descriptor);
                }
                _mainDesc.mailSession = mailEntrys;
            }
            if ((urlSources = rt.getUrlSource()) != null) {
                Vector<URLDescriptor> urlEntrys = new Vector<URLDescriptor>();
                List urlEntryList = urlSources.getUrlEntry();
                for (Object anUrlEntryList : urlEntryList) {
                    URLDescriptor desc = new URLDescriptor();
                    UrlEntryType urlType = (UrlEntryType)anUrlEntryList;
                    if (urlType.getExportName() != null) {
                        desc.setExportName(urlType.getExportName());
                    }
                    if (urlType.getUrl() != null) {
                        desc.setURL(urlType.getUrl());
                    }
                    urlEntrys.add(desc);
                }
                _mainDesc.urls = urlEntrys;
            }
            if ((extst = rt.getExternalSource()) != null) {
                List jmsList = extst.getJmsSource();
                for (Object aJmsList : jmsList) {
                    JmsSourceType jmsObject = (JmsSourceType)aJmsList;
                    JMSSourceDescriptor jmsDesc = JMSSourceDescriptorJB.getJMSDescriptor(jmsObject);
                    _mainDesc.extResources.add(jmsDesc);
                }
            }
        }
        descMap.put(myNodeName, _mainDesc);
        _mainDesc.validate();
        return _mainDesc;
    }

    public static int makeContainerID(String containerName) {
        int value = containerName.hashCode();
        if (value < 0) {
            value = -value;
        }
        return value % 128;
    }

    public static MailSessionDescriptor getMailSessionDescriptor(MailEntryType mailType) {
        MailSessionDescriptor mailDesc = new MailSessionDescriptor();
        if (mailType.getExportName() != null) {
            mailDesc.setExportName(mailType.getExportName());
        }
        if (mailType.getMailProperty() != null) {
            List list = mailType.getMailProperty();
            Hashtable<String, String> env = new Hashtable<String, String>();
            for (Object aList : list) {
                MailPropertyType type = (MailPropertyType)aList;
                env.put(type.getName(), type.getValue());
            }
            mailDesc.properties = env;
        }
        return mailDesc;
    }

    public static ClusterDSBindInfo getClusterDBDSInfo(ClusterDsType cdsType) {
        ClusterDSBindInfo cdsInfo = new ClusterDSBindInfo();
        if (cdsType.getExportName() != null) {
            cdsInfo.setExportName(cdsType.getExportName());
        }
        if (cdsType.getDataSource() != null) {
            cdsInfo.setDataSourceList(cdsType.getDataSource());
        }
        if (cdsType.isSetIsPreConn()) {
            cdsInfo.setPreMakeBackupConnection(cdsType.isIsPreConn());
        }
        if (cdsType.isSetUseFailback()) {
            cdsInfo.setUseFailback(cdsType.isUseFailback());
        }
        return cdsInfo;
    }

    public static boolean checkJeusSystemJAXB() throws IOException, JAXBException {
        _jeusSystemElem = (JeusSystemType)descFile.getConfigDescriptor(_jeusSystemElem);
        boolean isModified = configFile.isModified();
        if (isModified) {
            descMap.clear();
            List applicationList = _jeusSystemElem.getApplication();
            for (Object application : applicationList) {
                ApplicationType applicationType = (ApplicationType)application;
                JeusMainDescriptorJB.validate(applicationType);
            }
        }
        return isModified;
    }

    public static synchronized void addApplication(ApplicationType appType) throws IOException, JAXBException {
        String appName = JeusDeploymentManager.getNameFromPath(appType);
        List applications = _jeusSystemElem.getApplication();
        JeusMainDescriptorJB.checkDuplicateApplicationType(applications, appName);
        ObjectFactory objFact = new ObjectFactory();
        appType = appType.cloneType(objFact.createApplicationType());
        _jeusSystemElem.getApplication().add(appType);
        JeusMainDescriptorJB.marshalJeusMain();
    }

    private static void checkDuplicateApplicationType(List applications, String appName) {
        for (Object application : applications) {
            ApplicationType applicationType = (ApplicationType)application;
            List<String> appNameList = JeusDeploymentManager.getNamesFromPaths(applicationType);
            if (!appNameList.contains(appName)) continue;
            throw new JeusRuntimeException("The application already exists in JeusMain.xml : " + appName);
        }
    }

    public static void marshalJeusMain() throws IOException, JAXBException {
        ObjectFactory fac = new ObjectFactory();
        descFile.marshalConfigDescriptor(fac.createJeusSystem(_jeusSystemElem));
    }

    public static void removeApplication(String[] appName) throws IOException, JAXBException {
        List applications = _jeusSystemElem.getApplication();
        Iterator appItr = applications.iterator();
        while (appItr.hasNext()) {
            ApplicationType applicationType = (ApplicationType)appItr.next();
            List nameList = JeusDeploymentManager.getNamesToRemove(applicationType);
            List appList = applicationType.getNameAndPathAndDeploymentType();
            for (Object name : nameList) {
                ApplicationNameToRemove namesToRemove = (ApplicationNameToRemove)name;
                if (!StringUtil.isMemberOf((String)namesToRemove.getAppName(), (String[])appName)) continue;
                int beginIndex = namesToRemove.getBeginIndex();
                int lastIndex = namesToRemove.getLastIndex();
                for (int k = beginIndex; k <= lastIndex; ++k) {
                    appList.remove(beginIndex);
                }
            }
            if (!appList.isEmpty()) continue;
            appItr.remove();
        }
        JeusMainDescriptorJB.marshalJeusMain();
    }

    private static void validate(ApplicationType applicationType) {
        File absolutePath;
        String path = applicationType.getAbsolutePath();
        boolean needCheckAppPath = false;
        if (path != null) {
            absolutePath = new File(path);
            JeusMainDescriptorJB.checkAbsolute(absolutePath, path, "absolute-path");
        } else {
            needCheckAppPath = true;
        }
        path = applicationType.getAbsoluteEjbJar();
        if (path != null) {
            absolutePath = new File(path);
            JeusMainDescriptorJB.checkAbsolute(absolutePath, path, "absolute-ejb-jar");
        }
        if ((path = applicationType.getAbsoluteJeusEjbDd()) != null) {
            absolutePath = new File(path);
            JeusMainDescriptorJB.checkAbsolute(absolutePath, path, "absolute-jeus-ejb-jar");
        }
        if (needCheckAppPath) {
            List appList = applicationType.getNameAndPathAndDeploymentType();
            for (JAXBElement app : appList) {
                String elementName = app.getName().getLocalPart();
                if (!elementName.equals("path")) continue;
                String appPath = (String)app.getValue();
                JeusMainDescriptorJB.checkApplicationPath(appPath);
            }
        }
    }

    private static void checkApplicationPath(String applicationPath) {
        if (applicationPath == null) {
            throw new JeusRuntimeException(JeusMessage_Manager.MGR_54);
        }
    }

    private static void checkAbsolute(File absolutePath, String path, String elementName) {
        if (!absolutePath.isAbsolute()) {
            throw new JeusRuntimeException(JeusMessage_Manager.MGR_55, (Object[])new String[]{elementName, path});
        }
    }

    private static void setApplicationsForContainer(JeusMainDescriptor mdesc, EngineContainerDescriptor tdesc) throws JAXBException, IOException {
        DeploymentTargetType targetType;
        List appsTypeList = mdesc.getApplication();
        boolean addDeployHomeApps = true;
        for (Object appsType : appsTypeList) {
            ApplicationType applicationType = (ApplicationType)appsType;
            targetType = applicationType.getDeploymentTarget();
            try {
                JeusMainDescriptorJB.validateTargetName(targetType);
            }
            catch (JeusRuntimeException jru) {
                jru.printStackTrace();
            }
            List namePathList = applicationType.getNameAndPathAndDeploymentType();
            String absolutePathOfApplications = applicationType.getAbsolutePath();
            AutoDeployType autoDeploy = applicationType.getAutoDeploy();
            if (absolutePathOfApplications != null) {
                File absPathFile = new File(absolutePathOfApplications);
                if (!absPathFile.isAbsolute()) {
                    throw new JeusRuntimeException(JeusMessage_Manager.MGR_55, (Object[])new String[]{"<absolute-path>", absolutePathOfApplications});
                }
                if (!absPathFile.isDirectory()) {
                    throw new JeusRuntimeException(JeusMessage_Manager.MGR_398);
                }
                if (autoDeploy != null) {
                    boolean isCheckAbsPath = autoDeploy.isCheckAbsolutePath();
                    if (absolutePathOfApplications.equals(JeusProperties.AUTO_DEPLOY_DIR)) {
                        if (JeusMainDescriptorJB.isTargetContainer(applicationType.getDeploymentTarget())) {
                            addDeployHomeApps = false;
                            JeusMainDescriptorJB.setDeploymentType(applicationType);
                            tdesc.addApplication(applicationType, null);
                            continue;
                        }
                        if (!isCheckAbsPath) continue;
                        addDeployHomeApps = false;
                        continue;
                    }
                    if (!JeusMainDescriptorJB.isTargetContainer(applicationType.getDeploymentTarget())) continue;
                    JeusMainDescriptorJB.setDeploymentType(applicationType);
                    tdesc.addApplication(applicationType, null);
                    continue;
                }
            }
            JeusMainDescriptorJB.setDeploymentType(applicationType);
            ApplicationType cloneApplication = applicationType.cloneApplicationType();
            boolean isExistPath = false;
            List destNameAndPathAndDeploymentTypeList = cloneApplication.getNameAndPathAndDeploymentType();
            destNameAndPathAndDeploymentTypeList.clear();
            for (int j = 0; j < namePathList.size(); ++j) {
                JAXBElement nextNameAndPath;
                JAXBElement nameAndPath = (JAXBElement)namePathList.get(j);
                String elementName = nameAndPath.getName().getLocalPart();
                JeusMainDescriptorJB.setNameAndPathAndDeploymentType(nameAndPath, destNameAndPathAndDeploymentTypeList);
                if (!elementName.equals("path")) continue;
                isExistPath = true;
                if (JeusMainDescriptorJB.isNextDeploymentType(namePathList, j)) {
                    nextNameAndPath = (JAXBElement)namePathList.get(++j);
                    JeusMainDescriptorJB.setNameAndPathAndDeploymentType(nextNameAndPath, destNameAndPathAndDeploymentTypeList);
                }
                while (JeusMainDescriptorJB.isNextComponentType(namePathList, j)) {
                    nextNameAndPath = (JAXBElement)namePathList.get(++j);
                    JeusMainDescriptorJB.setNameAndPathAndDeploymentType(nextNameAndPath, destNameAndPathAndDeploymentTypeList);
                }
                JeusMainDescriptorJB.setDeploymentType(cloneApplication);
                ApplicationType deployableApplicationType = JeusMainDescriptorJB.checkDeployableApplication(cloneApplication, tdesc);
                if (deployableApplicationType != null) {
                    String absPathOfApplications = absolutePathOfApplications == null ? JeusProperties.JEUS_APP_HOME : absolutePathOfApplications;
                    String applicationPath = (String)nameAndPath.getValue();
                    if (applicationPath == null) {
                        throw new JeusRuntimeException(JeusMessage_Manager.MGR_54);
                    }
                    if (!new File(applicationPath).isAbsolute()) {
                        if (absPathOfApplications.endsWith(File.separator)) {
                            JeusDeploymentManager.setApplicationPath(deployableApplicationType, absPathOfApplications + applicationPath);
                        } else {
                            JeusDeploymentManager.setApplicationPath(deployableApplicationType, absPathOfApplications + File.separator + applicationPath);
                        }
                    }
                    List appList = deployableApplicationType.getNameAndPathAndDeploymentType();
                    for (Object app : appList) {
                        if (app instanceof JAXBElement) {
                            app = ((JAXBElement)app).getValue();
                        }
                        if (!(app instanceof EjbComponentType)) continue;
                        EjbComponentType ejbComponentType = (EjbComponentType)app;
                        if (ejbComponentType.getEjbJar() == null) {
                            ejbComponentType.setEjbJar(applicationType.getAbsoluteEjbJar());
                        }
                        if (ejbComponentType.getJeusEjbDd() != null) continue;
                        ejbComponentType.setJeusEjbDd(applicationType.getAbsoluteJeusEjbDd());
                    }
                    if (autoDeploy != null) {
                        deployableApplicationType.setAutoDeploy(autoDeploy);
                    }
                }
                destNameAndPathAndDeploymentTypeList.clear();
            }
            if (isExistPath) continue;
            if (absolutePathOfApplications == null) {
                throw new JeusRuntimeException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Manager.MGR_54) + StringUtil.lineSeparator + applicationType.strip2());
            }
            if (autoDeploy != null) continue;
            throw new JeusRuntimeException(JeusMessage_Manager.MGR_399);
        }
        if (addDeployHomeApps) {
            ObjectFactory objFact = new ObjectFactory();
            ApplicationType addApplicationType = objFact.createApplicationType();
            AutoDeployType autoDeployType = objFact.createAutoDeployType();
            targetType = objFact.createDeploymentTargetType();
            AllTargetsType allTarget = objFact.createAllTargetsType();
            addApplicationType.setAbsolutePath(JeusProperties.AUTO_DEPLOY_DIR);
            autoDeployType.setCheckAbsolutePath(Boolean.valueOf(true));
            autoDeployType.setAutoDeployCheckInterval(Long.valueOf(autoDeployType.getDefaultAutoDeployCheckInterval()));
            addApplicationType.setAutoDeploy(autoDeployType);
            targetType.getAllTargetsOrTarget().add(allTarget);
            addApplicationType.setDeploymentTarget(targetType);
            tdesc.addApplication(addApplicationType, null);
        }
    }

    private static void validateTargetName(DeploymentTargetType targetType) {
        List targetList = targetType.getAllTargetsOrTarget();
        for (Object target : targetList) {
            int index;
            AppTargetType appTarget;
            String containerName;
            if (!(target instanceof AppTargetType) || (containerName = (appTarget = (AppTargetType)target).getEngineContainerName()) == null || (index = containerName.lastIndexOf(95)) != -1) continue;
            throw new JeusRuntimeException("The engine container name is not correct : " + containerName + " is not JEUS container name format because of not including a '_'");
        }
    }

    private static void setNameAndPathAndDeploymentType(JAXBElement nameAndPathElement, List<JAXBElement<?>> destNameAndPathAndDeploymentTypeList) throws JAXBException {
        ObjectFactory objFact = new ObjectFactory();
        Object nameAndPath = nameAndPathElement.getValue();
        String elementName = nameAndPathElement.getName().getLocalPart();
        if (elementName.equals("name") || elementName.equals("path")) {
            destNameAndPathAndDeploymentTypeList.add(nameAndPathElement);
        } else if (nameAndPath instanceof DeploymentTypeType) {
            JAXBElement nested = objFact.createApplicationTypeDeploymentType((DeploymentTypeType)nameAndPath);
            DeploymentTypeType srcnested = (DeploymentTypeType)nameAndPath;
            nested.setValue((Object)srcnested);
            destNameAndPathAndDeploymentTypeList.add(nested);
        } else if (nameAndPath instanceof ClientComponentType) {
            ClientComponentType type = (ClientComponentType)nameAndPath;
            destNameAndPathAndDeploymentTypeList.add(objFact.createApplicationTypeClientComponent((ClientComponentType)type.cloneType()));
        } else if (nameAndPath instanceof ConnectorComponentType) {
            ConnectorComponentType type = (ConnectorComponentType)nameAndPath;
            destNameAndPathAndDeploymentTypeList.add(objFact.createApplicationTypeConnectorComponent((ConnectorComponentType)type.cloneType()));
        } else if (nameAndPath instanceof EjbComponentType) {
            EjbComponentType type = (EjbComponentType)nameAndPath;
            destNameAndPathAndDeploymentTypeList.add(objFact.createApplicationTypeEjbComponent((EjbComponentType)type.cloneType()));
        } else if (nameAndPath instanceof WebComponentType) {
            WebComponentType type = (WebComponentType)nameAndPath;
            destNameAndPathAndDeploymentTypeList.add(objFact.createApplicationTypeWebComponent((WebComponentType)type.cloneType()));
        }
    }

    private static boolean isNextComponentType(List<JAXBElement<?>> namePathList, int j) {
        if (j + 1 < namePathList.size()) {
            Object nextNameAndPath = namePathList.get(j + 1).getValue();
            return nextNameAndPath instanceof EjbComponentType || nextNameAndPath instanceof WebComponentType || nextNameAndPath instanceof ClientComponentType || nextNameAndPath instanceof ConnectorComponentType;
        }
        return false;
    }

    private static boolean isNextDeploymentType(List<JAXBElement<?>> namePathList, int j) {
        if (j + 1 < namePathList.size()) {
            JAXBElement<?> nextNameAndPath = namePathList.get(j + 1);
            return nextNameAndPath.getValue() instanceof DeploymentTypeType;
        }
        return false;
    }

    private static ApplicationType checkDeployableApplication(ApplicationType descApp, EngineContainerDescriptor tdesc) throws JAXBException {
        DeploymentTargetType target = descApp.getDeploymentTarget();
        ApplicationType applicationType = (ApplicationType)descApp.cloneType();
        WebContextGroupType contextGroup = JeusMainDescriptorJB.getContextGroupName(target);
        int isDeployable = JeusMainDescriptorJB.checkDeployableModules(applicationType);
        if (isDeployable > 0) {
            if (!JeusMainDescriptorJB.isTargetContainer(target)) {
                JeusMainDescriptorJB.removeNotTargettedComponents(applicationType);
            } else {
                tdesc.addApplication(applicationType, contextGroup);
            }
            return applicationType;
        }
        return null;
    }

    public static WebContextGroupType getContextGroupName(DeploymentTargetType commonDeploymentType) {
        if (commonDeploymentType == null) {
            return null;
        }
        List targets = commonDeploymentType.getAllTargetsOrTarget();
        for (JeusBindingInterface target : targets) {
            String nodeName;
            if (target instanceof AllTargetsType) {
                return ((AllTargetsType)target).getWebContextGroup();
            }
            AppTargetType t = (AppTargetType)target;
            String containerName = t.getEngineContainerName();
            if (containerName != null) {
                if (JeusPropertyValues.JEUS_CATEGORY == 1 && containerName.equals(DEFAULT_CONTAINER_NAME)) {
                    return t.getWebContextGroup();
                }
                if (containerName.equals(JeusManagerPropertyValues.containerName)) {
                    return t.getWebContextGroup();
                }
            }
            if ((nodeName = t.getNodeName()) == null || !nodeName.equals(VirtualDNS.LOCAL_VIRTUALNAME)) continue;
            return t.getWebContextGroup();
        }
        return null;
    }

    private static int checkDeployableModules(ApplicationType applicationType) {
        List appList = applicationType.getNameAndPathAndDeploymentType();
        boolean isDeployable = false;
        int numDeployModules = 0;
        int numModules = 0;
        for (int i = 0; i < appList.size(); ++i) {
            DeploymentTargetType deployType;
            JAXBElement element = (JAXBElement)appList.get(i);
            String elementName = element.getName().getLocalPart();
            Object obj = element.getValue();
            if (elementName.equals("path")) {
                ++numDeployModules;
                ++numModules;
            }
            if (obj instanceof ClientComponentType) {
                ClientComponentType clientComponentType = (ClientComponentType)obj;
                deployType = clientComponentType.getDeploymentTarget();
                if (deployType == null) {
                    deployType = applicationType.getDeploymentTarget();
                }
                if (deployType == null) continue;
                if (JeusMainDescriptorJB.isTargetContainer(deployType)) {
                    isDeployable = true;
                    continue;
                }
                --numDeployModules;
                appList.remove(i);
                continue;
            }
            if (obj instanceof EjbComponentType) {
                EjbComponentType ejbComponentType = (EjbComponentType)obj;
                deployType = ejbComponentType.getDeploymentTarget();
                if (deployType == null) {
                    deployType = applicationType.getDeploymentTarget();
                }
                if (deployType == null) continue;
                if (JeusMainDescriptorJB.isTargetContainer(deployType)) {
                    isDeployable = true;
                    continue;
                }
                --numDeployModules;
                appList.remove(i);
                continue;
            }
            if (obj instanceof WebComponentType) {
                WebComponentType webComponentType = (WebComponentType)obj;
                deployType = webComponentType.getDeploymentTarget();
                if (deployType == null) {
                    deployType = applicationType.getDeploymentTarget();
                }
                if (deployType == null) continue;
                if (JeusMainDescriptorJB.isTargetContainer(deployType)) {
                    isDeployable = true;
                    continue;
                }
                --numDeployModules;
                appList.remove(i);
                continue;
            }
            if (!(obj instanceof ConnectorComponentType)) continue;
        }
        if (numModules > 0) {
            if (numDeployModules == 0) {
                return 0;
            }
            if (!isDeployable) {
                isDeployable = JeusMainDescriptorJB.setDeploymentType(applicationType);
            }
        }
        if (isDeployable) {
            return 1;
        }
        return -1;
    }

    public static boolean setDeploymentType(ApplicationType applicationType) {
        boolean result = false;
        boolean isCompleted = false;
        boolean deploymentTypeExist = false;
        boolean componentTypeExist = false;
        ObjectFactory objFact = new ObjectFactory();
        String absolutePath = applicationType.getAbsolutePath() == null ? JeusProperties.JEUS_APP_HOME : applicationType.getAbsolutePath();
        List appList = applicationType.getNameAndPathAndDeploymentType();
        for (int i = 0; i < appList.size(); ++i) {
            JAXBElement obj = (JAXBElement)appList.get(i);
            String elementName = obj.getName().getLocalPart();
            if (!elementName.equals("path")) continue;
            if (JeusMainDescriptorJB.isNextDeploymentType(appList, i)) {
                deploymentTypeExist = true;
                if (JeusMainDescriptorJB.isNextComponentType(appList, i + 1)) {
                    componentTypeExist = true;
                    isCompleted = true;
                    result = true;
                }
            } else if (JeusMainDescriptorJB.isNextComponentType(appList, i)) {
                componentTypeExist = true;
            }
            if (isCompleted) continue;
            String modulePath = (String)obj.getValue();
            String applicationPath = new File(modulePath).isAbsolute() ? modulePath : (absolutePath.endsWith(File.separator) ? absolutePath + modulePath : absolutePath + File.separator + modulePath);
            try {
                AbstractArchive moduleArchive = FileUtils.isExploded((String)applicationPath) ? FileArchiveFactory.openArchiveStatic((String)applicationPath) : JarArchiveFactory.openArchiveStatic((String)applicationPath);
                ModuleType moduleType = ModuleTypeResolver.getModuleType(moduleArchive);
                if (moduleType == null) {
                    throw new JeusDeploymentException("Unable to determine module type of '" + applicationPath + "'.");
                }
                int index = i + 1;
                if (moduleType.equals(ModuleType.EAR)) {
                    appList.add(index, objFact.createApplicationTypeDeploymentType(DeploymentTypeType.valueOf((String)"EAR")));
                    result = true;
                    continue;
                }
                if (moduleType.equals(ModuleType.CAR)) {
                    if (!deploymentTypeExist) {
                        appList.add(index, objFact.createApplicationTypeDeploymentType(DeploymentTypeType.valueOf((String)"COMPONENT")));
                        ++index;
                    }
                    if (!componentTypeExist) {
                        appList.add(index, objFact.createApplicationTypeClientComponent(objFact.createClientComponentType()));
                    }
                    result = true;
                    continue;
                }
                if (moduleType.equals(ModuleType.RAR)) {
                    if (!deploymentTypeExist) {
                        appList.add(index, objFact.createApplicationTypeDeploymentType(DeploymentTypeType.valueOf((String)"COMPONENT")));
                        ++index;
                    }
                    if (!componentTypeExist) {
                        appList.add(index, objFact.createApplicationTypeConnectorComponent(objFact.createConnectorComponentType()));
                    }
                    result = true;
                    continue;
                }
                if (moduleType.equals(ModuleType.EJB)) {
                    if (!deploymentTypeExist) {
                        appList.add(index, objFact.createApplicationTypeDeploymentType(DeploymentTypeType.valueOf((String)"COMPONENT")));
                        ++index;
                    }
                    if (!componentTypeExist) {
                        appList.add(index, objFact.createApplicationTypeEjbComponent(objFact.createEjbComponentType()));
                    }
                    result = true;
                    continue;
                }
                if (!moduleType.equals(ModuleType.WAR)) continue;
                if (!deploymentTypeExist) {
                    appList.add(index, objFact.createApplicationTypeDeploymentType(DeploymentTypeType.valueOf((String)"COMPONENT")));
                    ++index;
                }
                if (!componentTypeExist) {
                    appList.add(index, objFact.createApplicationTypeWebComponent(objFact.createWebComponentType()));
                }
                result = true;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static void removeNotTargettedComponents(ApplicationType applicationType) {
        List appList = applicationType.getNameAndPathAndDeploymentType();
        for (int i = 0; i < appList.size(); ++i) {
            DeploymentTargetType deployType;
            JAXBElement element = (JAXBElement)appList.get(i);
            Object obj = element.getValue();
            if (obj instanceof ClientComponentType) {
                ClientComponentType clientComponentType = (ClientComponentType)obj;
                deployType = clientComponentType.getDeploymentTarget();
                if (deployType != null) continue;
                appList.remove(i);
                continue;
            }
            if (obj instanceof EjbComponentType) {
                EjbComponentType ejbComponentType = (EjbComponentType)obj;
                deployType = ejbComponentType.getDeploymentTarget();
                if (deployType != null) continue;
                appList.remove(i);
                continue;
            }
            if (obj instanceof WebComponentType) {
                WebComponentType webComponentType = (WebComponentType)obj;
                deployType = webComponentType.getDeploymentTarget();
                if (deployType != null) continue;
                appList.remove(i);
                continue;
            }
            if (!(obj instanceof ConnectorComponentType)) continue;
        }
    }

    private static boolean isTargetContainer(DeploymentTargetType deployTargets) {
        if (deployTargets == null) {
            return false;
        }
        List targets = deployTargets.getAllTargetsOrTarget();
        for (Object target : targets) {
            if (target instanceof AppTargetType) {
                String nodeName;
                AppTargetType t = (AppTargetType)target;
                String containerName = t.getEngineContainerName();
                if (containerName != null) {
                    if (JeusPropertyValues.JEUS_CATEGORY == 1 && containerName.equals(DEFAULT_CONTAINER_NAME)) {
                        return true;
                    }
                    if (containerName.equals(JeusManagerPropertyValues.containerName)) {
                        return true;
                    }
                }
                if ((nodeName = t.getNodeName()) == null || !nodeName.equals(VirtualDNS.LOCAL_VIRTUALNAME)) continue;
                return true;
            }
            if (!(target instanceof AllTargetsType)) continue;
            return true;
        }
        return false;
    }

    public static int getContainerBasePort(String containerName) throws JAXBException, IOException {
        if (!JeusManagerProperties.USE_LISTEN_PORT_PER_CONTAINER || StringUtil.isDefaultContainerName((String)containerName)) {
            return JeusPort.JeusBase;
        }
        JeusMainDescriptor desc = JeusMainDescriptorJB.getJeusMainDescriptor(VirtualDNS.LOCAL_VIRTUALNAME);
        EngineContainerDescriptor cdesc = (EngineContainerDescriptor)desc.engineContainers.get(containerName);
        return cdesc.getEngineContainerRoot().getBasePort();
    }

    public static int getContainerBasePortFromEngineName(String engineName) throws JAXBException, IOException {
        return JeusMainDescriptorJB.getContainerBasePortFromEngineName(null, engineName);
    }

    public static int getContainerBasePortFromEngineName(String nodeName, String engineName) throws JAXBException, IOException {
        int jeusBasePort;
        if (nodeName == null) {
            nodeName = VirtualDNS.LOCAL_VIRTUALNAME;
        }
        if (VirtualDNS.LOCAL_VIRTUALNAME.equals(nodeName)) {
            jeusBasePort = JeusPort.JeusBase;
        } else {
            String hostInfo = VirtualDNS.getRealNodeName(nodeName);
            int index = hostInfo.lastIndexOf(":");
            try {
                jeusBasePort = Integer.parseInt(hostInfo.substring(index + 1));
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
                jeusBasePort = JeusPort.JeusBase;
            }
        }
        if (!JeusManagerProperties.USE_LISTEN_PORT_PER_CONTAINER) {
            return jeusBasePort;
        }
        JeusMainDescriptor desc = JeusMainDescriptorJB.getJeusMainDescriptor(nodeName);
        EngineContainerDescriptor cdesc = ContainerManagerService.getEngineContainerDescriptorFromEngineName(desc, engineName);
        if (StringUtil.isDefaultContainerName((String)cdesc.getName())) {
            return jeusBasePort;
        }
        return cdesc.getEngineContainerRoot().getBasePort();
    }

    public static int makeBasePort(int id) {
        return JeusPort.JeusBase + 15 + id * 10;
    }

    static {
        configFile = new ConfigFile();
        descFile = new JeusMainDescriptorFile(VirtualDNS.LOCAL_VIRTUALNAME, configFile);
        descMap = new Hashtable();
        logger = (JeusLogger)JeusLogger.getLogger((String)"jeus");
        DEFAULT_CONTAINER_NAME = VirtualDNS.LOCAL_VIRTUALNAME + "_default";
    }
}

