/*
 * Decompiled with CFR 0.152.
 */
package jeus.descriptor.jeusserver;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jeus.descriptor.jeusserver.ConnectorProperty;
import jeus.util.JeusException;

public class ConnectorDescriptor
implements Serializable {
    public static final int NoTransaction = 0;
    public static final int LocalTransaction = 1;
    public static final int XATransaction = 2;
    private boolean isFastDeploy = false;
    private String exportName = new String("");
    private String managedConnectionFactoryClassName = new String("");
    private String connectionIntClassName = new String("");
    private int transactionSupport = 0;
    public Vector properties = new Vector();
    private boolean reauthenticationSupport = false;
    public Hashtable authenticationInfo = new Hashtable();
    private String userName = new String("");
    private String password = new String("");
    private int max = 10;
    private long resizingPeriod = 1800000L;
    private boolean waiting = false;
    private long waitingTime = 10000L;
    private String rarName;
    private String resourceAdapterClassName = new String("");
    public Vector raProperties = new Vector();
    public Vector msgLstnrDescs = new Vector();

    public void validate() throws JeusException {
        if (this.exportName.equals("")) {
            throw new JeusException(14001);
        }
        if (this.managedConnectionFactoryClassName.equals("")) {
            throw new JeusException(14002, (Object)this.exportName);
        }
        if (this.connectionIntClassName.equals("")) {
            throw new JeusException(14003, (Object)this.exportName);
        }
        Enumeration e = this.properties.elements();
        while (e.hasMoreElements()) {
            ((ConnectorProperty)e.nextElement()).validate();
        }
        if (this.max < 1) {
            throw new JeusException(14004, (Object[])new String[]{this.exportName, Integer.toString(this.max)});
        }
        if (this.resizingPeriod < 0L) {
            throw new JeusException(14005, (Object[])new String[]{this.exportName, Long.toString(this.resizingPeriod)});
        }
        if (this.waiting && this.waitingTime < 0L) {
            throw new JeusException(14006, (Object[])new String[]{this.exportName, Long.toString(this.waitingTime)});
        }
        if (this.transactionSupport == 2 && (this.userName.equals("") || this.password.equals(""))) {
            throw new JeusException(14007, (Object)this.exportName);
        }
    }

    public boolean isFastDeploy() {
        return this.isFastDeploy;
    }

    public void setFastDeploy(boolean b) {
        this.isFastDeploy = b;
    }

    public String getExportName() {
        return this.exportName;
    }

    public void setExportName(String s) {
        this.exportName = s;
    }

    public String getManagedConnectionFactoryClassName() {
        return this.managedConnectionFactoryClassName;
    }

    public void setManagedConnectionFactoryClassName(String s) {
        this.managedConnectionFactoryClassName = s;
    }

    public String getConnectionIntClassName() {
        return this.connectionIntClassName;
    }

    public void setConnectionIntClassName(String s) {
        this.connectionIntClassName = s;
    }

    public int getTransactionSupport() {
        return this.transactionSupport;
    }

    public void setTransactionSupport(int i) {
        this.transactionSupport = i;
    }

    public boolean isReauthenticationSupport() {
        return this.reauthenticationSupport;
    }

    public void setReauthenticationSupport(boolean b) {
        this.reauthenticationSupport = b;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String s) {
        this.userName = s;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassWord(String s) {
        this.password = s;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int i) {
        this.max = i;
    }

    public long getResizingPeriod() {
        return this.resizingPeriod;
    }

    public void setResizingPeriod(long l) {
        this.resizingPeriod = l;
    }

    public boolean getWaiting() {
        return this.waiting;
    }

    public void setWaiting(boolean b) {
        this.waiting = b;
    }

    public long getWaitingTime() {
        return this.waitingTime;
    }

    public void setWaitingTime(long l) {
        this.waitingTime = l;
    }

    public String getRarName() {
        return this.rarName;
    }

    public void setRarName(String s) {
        this.rarName = s;
    }

    public void setResourceAdapterClass(String name) {
        this.resourceAdapterClassName = name;
    }

    public String getResourceAdapterClass() {
        return this.resourceAdapterClassName;
    }

    public String toString() {
        return new String("" + this.exportName + "(" + this.managedConnectionFactoryClassName + ")");
    }

    public void setTransactionSupport(String value) {
        if (value != null && value.equalsIgnoreCase("XATransaction")) {
            this.transactionSupport = 2;
        } else if (value != null && value.equalsIgnoreCase("LocalTransaction")) {
            this.transactionSupport = 1;
        } else if (value != null && value.equalsIgnoreCase("NoTransaction")) {
            this.transactionSupport = 0;
        }
    }
}

