/*
 * Decompiled with CFR 0.152.
 */
package jeus.descriptor.jms;

import java.io.Serializable;
import jeus.descriptor.jms.JMSDescriptorClass;
import jeus.descriptor.jms.LoggerDescriptor;
import jeus.jms.server.mbean.JMSConnectionFactoryResource;
import jeus.xml.binding.jeusDD.ConnectionFactoryType;

public class ConnectionFactoryDescriptor
implements Serializable,
JMSDescriptorClass {
    public String name;
    public String JNDIname;
    public String clientID;
    public static final int DEFAULT_CONNECTION = 1;
    public static final int DEFAULT_MAX_SESSION = 5;
    public static final int DEFAULT_TYPE = 1;
    public int connectionNumber = 1;
    public int type = 1;
    public LoggerDescriptor logger = new LoggerDescriptor();
    public int maxSessionThread = 5;
    public transient JMSConnectionFactoryResource jmsConnectionFactoryResourceMBean;

    public ConnectionFactoryDescriptor() {
    }

    public ConnectionFactoryDescriptor(ConnectionFactoryType c) {
        String _type = c.getType().value();
        if (_type.equalsIgnoreCase("queue")) {
            this.type = 1;
        } else if (_type.equalsIgnoreCase("topic")) {
            this.type = 2;
        }
        this.name = c.getName();
        String _exportName = c.getExportName();
        this.JNDIname = _exportName != null ? _exportName : this.name;
        if (this.type == 2) {
            this.clientID = c.getClientId();
        }
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setName(String name) {
        this.name = name;
        this.JNDIname = name;
    }

    public String getName() {
        return this.name;
    }

    public void setJNDIName(String name) {
        this.JNDIname = name;
    }

    public String getJNDIName() {
        return this.JNDIname;
    }

    public void setClientID(String name) {
        this.clientID = name;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setConnectionNumber(int connectionNumber) {
        this.connectionNumber = connectionNumber;
    }

    public int getConnectionNumber() {
        return this.connectionNumber;
    }

    public String toString() {
        return this.name;
    }

    public void setLoggerDescriptor(LoggerDescriptor logger) {
        this.logger = logger;
    }

    public LoggerDescriptor getLoggerDescriptor() {
        return this.logger;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConnectionFactoryDescriptor) {
            return this.name.equals(((ConnectionFactoryDescriptor)obj).name);
        }
        return false;
    }

    public void setMaxSessionThread(int maxThread) {
        this.maxSessionThread = maxThread;
    }

    public int getMaxSessionThread() {
        return this.maxSessionThread;
    }
}

