/*
 * Decompiled with CFR 0.152.
 */
package jeus.descriptor.sessionmanager;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.bind.JAXBException;
import jeus.descriptor.bind.JeusMainDescriptorJB;
import jeus.sessionmanager.Constants;
import jeus.sessionmanager.distributed.BackupSelector;
import jeus.sessionmanager.distributed.DistributedManagerConfig;
import jeus.sessionmanager.distributed.ManagerInfo;
import jeus.util.VirtualDNS;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Session3;
import jeus.util.properties.JeusManagerPropertyValues;
import jeus.util.properties.JeusNetPropertyValues;
import jeus.xml.binding.ObjectFactoryHelper;
import jeus.xml.binding.jeusDD.CheckLevelType;
import jeus.xml.binding.jeusDD.FileDbType;
import jeus.xml.binding.jeusDD.JeusNodeType;
import jeus.xml.binding.jeusDD.JeusSystemType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.PoolingType;
import jeus.xml.binding.jeusDD.SessionRouterConfigType;
import jeus.xml.binding.jeusDD.SessionRouterType;

public class DistributedSessionManagerDescriptor
implements Serializable,
DistributedManagerConfig {
    private static final JeusLogger logger = Constants.DISTRIBUTED_SESSION_LOGGER;
    private static final int DEFAULT_PORT = JeusManagerPropertyValues.getBasePort();
    private static final ConcurrentHashMap ROUTING_TABLE = new ConcurrentHashMap();
    private static final BackupSelector BACKUP_SELECTOR = new BackupSelector();
    private static final AtomicBoolean MAKEUP_BACKUP_TABLE = new AtomicBoolean(false);
    private static final int UNDEFINED_DEFAULT_FILE_DB_PASSIVATION_TO = Integer.MIN_VALUE;
    private SessionRouterConfigType sessionRouterConfig = null;
    private int checkLevelInt = 0;
    private String serverName = null;
    private String backupServerName = null;
    private String networkScope = null;
    private boolean stopWithPassivation = true;
    private boolean defaultConfiguration = false;

    public void setConnectTimeout(long value) {
        this.sessionRouterConfig.setConnectTimeout(Long.valueOf(value));
    }

    public long getConnectTimeout() {
        return this.sessionRouterConfig.getConnectTimeout();
    }

    public void setReadTimeout(long value) {
        this.sessionRouterConfig.setReadTimeout(Long.valueOf(value));
    }

    public long getReadTimeout() {
        return this.sessionRouterConfig.getReadTimeout();
    }

    public void setBackupCheckTo(long checkTo) {
        this.sessionRouterConfig.setCheckTo(Long.valueOf(checkTo));
    }

    public long getBackupCheckTo() {
        return this.sessionRouterConfig.getCheckTo();
    }

    public void setBackupTrigger(int value) {
        this.sessionRouterConfig.setBackupTrigger(Integer.valueOf(value));
    }

    public int getBackupTrigger() {
        return this.sessionRouterConfig.getBackupTrigger();
    }

    public void setUseNio(boolean value) {
    }

    public boolean isUseNio() {
        return true;
    }

    public void setPoolMin(int poolMin) {
        this.sessionRouterConfig.getThreadPool().setMin(Integer.valueOf(poolMin));
    }

    public int getPoolMin() {
        return this.sessionRouterConfig.getThreadPool().getMin();
    }

    public void setPoolMax(int poolMax) {
        this.sessionRouterConfig.getThreadPool().setMax(Integer.valueOf(poolMax));
    }

    public int getPoolMax() {
        return this.sessionRouterConfig.getThreadPool().getMax();
    }

    public void setPoolPeriod(long poolPeriod) {
        this.sessionRouterConfig.getThreadPool().setPeriod(Long.valueOf(poolPeriod));
    }

    public long getPoolPeriod() {
        return this.sessionRouterConfig.getThreadPool().getPeriod();
    }

    public String getFilePath() {
        FileDbType fileDb = this.getFileDB();
        if (fileDb != null) {
            return fileDb.getPath();
        }
        return null;
    }

    public long getFileStartupClearTo() {
        FileDbType fileDb = this.getFileDB();
        if (fileDb != null) {
            return fileDb.getStartupClearTo();
        }
        return -1L;
    }

    public float getFilePackingRate() {
        FileDbType fileDb = this.getFileDB();
        if (fileDb != null) {
            return fileDb.getPackingRate().floatValue();
        }
        return -1.0f;
    }

    public int getFileMinHole() {
        FileDbType fileDb = this.getFileDB();
        if (fileDb != null) {
            return fileDb.getMinHole();
        }
        return -1;
    }

    public void setFilePassivationTo(long passivationTo) {
        FileDbType fileDb = this.getFileDB();
        if (fileDb != null) {
            fileDb.setPassivationTo(Long.valueOf(passivationTo));
        }
    }

    public long getFilePassivationTo() {
        FileDbType fileDb = this.getFileDB();
        if (fileDb != null) {
            return fileDb.getPassivationTo();
        }
        return -1L;
    }

    public boolean useFile() {
        return this.getFileDB() != null;
    }

    public void setCheckLevelInt(int checkLevelInt) {
        this.checkLevelInt = checkLevelInt;
    }

    public int getCheckLevelInt() {
        return this.checkLevelInt;
    }

    public void setBackupName(String backupName) {
        this.backupServerName = backupName;
    }

    public String getBackupName() {
        return this.backupServerName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setNetworkScope(String scope) {
        this.networkScope = scope;
    }

    public boolean isStopWithPassivation() {
        return this.stopWithPassivation;
    }

    public void setStopWithPassivation(boolean stopWithPassivation) {
        this.stopWithPassivation = stopWithPassivation;
    }

    public String getNetworkScope() {
        return this.networkScope;
    }

    public static String getHostInfoFromFullEngineName(String fullEngineName) throws JAXBException, IOException {
        if (fullEngineName == null) {
            return null;
        }
        String hostInfo = (String)ROUTING_TABLE.get(fullEngineName);
        if (hostInfo != null) {
            return hostInfo;
        }
        String nodeName = DistributedSessionManagerDescriptor.getNodeNameFromFullEngineName(fullEngineName);
        if (nodeName == null) {
            logger.log(JeusMessage_Session3._39308_LEVEL, JeusMessage_Session3._39308, (Object)fullEngineName);
            return null;
        }
        hostInfo = VirtualDNS.getRealNodeName(nodeName);
        int index = hostInfo.lastIndexOf(":");
        int managerBasePort = Integer.parseInt(hostInfo.substring(index + 1));
        int baseport = JeusMainDescriptorJB.getContainerBasePortFromEngineName(nodeName, fullEngineName);
        if (baseport <= 0) {
            baseport = managerBasePort;
        }
        hostInfo = hostInfo.substring(0, index + 1) + baseport;
        ROUTING_TABLE.put(fullEngineName, hostInfo);
        return hostInfo;
    }

    public static String getBackupEngine(String primaryEngine) throws IOException {
        if (primaryEngine == null) {
            return null;
        }
        DistributedSessionManagerDescriptor.makeupBackupTable();
        return BACKUP_SELECTOR.getBackupEngine(primaryEngine);
    }

    public static String normalizeSessionName(String name) {
        if (name != null) {
            name = name.replace('/', '_');
            name = name.replace('.', '_');
            name = name.replace(':', '_');
            name = name.replace('&', '_');
            name = name.replace('-', '_');
        }
        return name;
    }

    public static DistributedSessionManagerDescriptor getJeusManagerConfig(String fullEngineName) throws IOException {
        return DistributedSessionManagerDescriptor.getJeusManagerConfig(fullEngineName, false, Integer.MIN_VALUE);
    }

    public static DistributedSessionManagerDescriptor getJeusManagerConfig(String fullEngineName, boolean enableDefaultFileStorage, long passivationTO) throws IOException {
        FileDbType fileDB;
        PoolingType threadPoolDesc;
        JeusSystemType jeusSystem = JeusMainDescriptorJB.getJeusMainDescriptor();
        List nodeList = jeusSystem.getNode();
        JeusNodeType myNode = null;
        for (int i = 0; i < nodeList.size(); ++i) {
            JeusNodeType oneNode = (JeusNodeType)nodeList.get(i);
            String nodeName = oneNode.getName();
            if (!nodeName.equals(VirtualDNS.LOCAL_VIRTUALNAME)) continue;
            myNode = oneNode;
            break;
        }
        if (myNode == null) {
            return null;
        }
        DistributedSessionManagerDescriptor desc = DistributedSessionManagerDescriptor.getJeusDefaultManagerConfig(fullEngineName, enableDefaultFileStorage, passivationTO);
        if (desc == null) {
            return null;
        }
        SessionRouterConfigType sessionRouterConfig = myNode.getSessionRouterConfig();
        if (sessionRouterConfig == null) {
            return desc;
        }
        List sessionRouters = sessionRouterConfig.getSessionRouter();
        SessionRouterType mySrouter = null;
        for (int i = 0; i < sessionRouters.size(); ++i) {
            SessionRouterType srouter = (SessionRouterType)sessionRouters.get(i);
            String ename = srouter.getEngineName();
            if (ename == null || !fullEngineName.equals(ename)) continue;
            mySrouter = srouter;
            break;
        }
        if (mySrouter == null) {
            return desc;
        }
        desc.setDefaultConfiguration(false);
        if (sessionRouterConfig.isSetConnectTimeout()) {
            desc.setConnectTimeout(sessionRouterConfig.getConnectTimeout());
        }
        if (sessionRouterConfig.isSetReadTimeout()) {
            desc.setReadTimeout(sessionRouterConfig.getReadTimeout());
        }
        if (sessionRouterConfig.isSetBackupTrigger()) {
            desc.setBackupTrigger(sessionRouterConfig.getBackupTrigger());
        }
        if (sessionRouterConfig.isSetCheckTo()) {
            desc.setBackupCheckTo(sessionRouterConfig.getCheckTo());
        }
        if (sessionRouterConfig.isSetCheckLevel()) {
            desc.setCheckLevel(sessionRouterConfig.getCheckLevel());
        }
        if (sessionRouterConfig.isSetDefaultFileDb()) {
            desc.setDefaultFileDB(sessionRouterConfig.getDefaultFileDb());
        }
        if ((threadPoolDesc = sessionRouterConfig.getThreadPool()) != null) {
            desc.setPoolMin(threadPoolDesc.getMin());
            desc.setPoolMax(threadPoolDesc.getMax());
            desc.setPoolPeriod(threadPoolDesc.getPeriod());
        }
        if ((fileDB = mySrouter.getFileDb()) == null) {
            fileDB = desc.getDefaultFileDB();
        }
        desc.setFileDB(fileDB);
        String backupEngine = DistributedSessionManagerDescriptor.getBackupEngine(fullEngineName);
        if (backupEngine != null) {
            String backupHost = null;
            try {
                backupHost = DistributedSessionManagerDescriptor.getHostInfoFromFullEngineName(backupEngine);
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
            if (backupHost != null) {
                desc.setBackupName(backupEngine, backupHost);
            }
        }
        return desc;
    }

    public static DistributedSessionManagerDescriptor getJeusDefaultManagerConfig(String fullEngineName, boolean enableDefaultFileStorage) {
        return DistributedSessionManagerDescriptor.getJeusDefaultManagerConfig(fullEngineName, enableDefaultFileStorage, Integer.MIN_VALUE);
    }

    public static DistributedSessionManagerDescriptor getJeusDefaultManagerConfig(String fullEngineName, boolean enableDefaultFileStorage, long passivationTO) {
        DistributedSessionManagerDescriptor desc = new DistributedSessionManagerDescriptor();
        try {
            desc.fillDefaultDescriptor(fullEngineName, enableDefaultFileStorage, passivationTO);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return null;
        }
        return desc;
    }

    public void setServerName(String ename, String nname) {
        if (ename == null) {
            return;
        }
        if (nname == null) {
            nname = JeusNetPropertyValues.LOCAL_HOSTNAME + ":" + DEFAULT_PORT;
        }
        this.setServerName(ename + ":" + nname);
    }

    public void setBackupName(String ename, String nname) {
        if (ename != null && nname != null) {
            this.setBackupName(ename + ":" + nname);
        }
    }

    public void setFileDB(FileDbType fileDB) {
        ((SessionRouterType)this.sessionRouterConfig.getSessionRouter().get(0)).setFileDb(fileDB);
    }

    public FileDbType getFileDB() {
        return ((SessionRouterType)this.sessionRouterConfig.getSessionRouter().get(0)).getFileDb();
    }

    public void setCheckLevel(String level) {
        if (level == null) {
            this.setCheckLevel(CheckLevelType.SET);
            return;
        }
        if (level.equalsIgnoreCase("set")) {
            this.setCheckLevel(CheckLevelType.SET);
        } else if (level.equalsIgnoreCase("get")) {
            this.setCheckLevel(CheckLevelType.GET);
        } else if (level.equalsIgnoreCase("all")) {
            this.setCheckLevel(CheckLevelType.ALL);
        } else {
            this.setCheckLevel(CheckLevelType.SET);
        }
    }

    public boolean isDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    public int getPort() {
        return DEFAULT_PORT;
    }

    public String getNodeName() {
        return JeusNetPropertyValues.LOCAL_HOSTNAME;
    }

    public void setNodeName(String nodeName) {
    }

    public void printDescriptor() {
        StringBuffer buf = new StringBuffer(1280);
        buf.append("\n    <<< Distributed Session Manager Information >>>\n");
        buf.append("        - port                         : " + DEFAULT_PORT + "\n");
        buf.append("        - connect timeout              : " + this.getConnectTimeout() + "\n");
        buf.append("        - read timeout                 : " + this.getReadTimeout() + "\n");
        buf.append("        - backup-check-level           : " + this.getCheckLevel() + "\n");
        buf.append("        - use nonblocking io           : " + this.isUseNio() + "\n");
        buf.append("        - version                      : 1\n");
        buf.append("        - <worker-pool>\n");
        buf.append("            - min                 : " + this.getPoolMin() + "\n");
        buf.append("            - max                 : " + this.getPoolMax() + "\n");
        buf.append("            - period              : " + this.getPoolPeriod() + "\n");
        if (this.useFile()) {
            buf.append("        - <filedb>\n");
            buf.append("            - path                : " + this.getFilePath() + "\n");
            buf.append("            - passivation-to      : " + this.getFilePassivationTo() + "\n");
            buf.append("            - startup-clear-to    : " + this.getFileStartupClearTo() + "\n");
            buf.append("            - min-hole            : " + this.getFileMinHole() + "\n");
            buf.append("            - packing-rate        : " + this.getFilePackingRate() + "\n");
        }
        if (this.getBackupName() != null) {
            buf.append("        - <backup>\n");
            buf.append("            - name                : " + this.getBackupName() + "\n");
            buf.append("            - trigger             : " + this.getBackupTrigger() + "\n");
            buf.append("            - checkto             : " + this.getBackupCheckTo() + "\n");
        }
        if (logger.isLoggable(JeusMessage_Session3._31000_LEVEL)) {
            logger.log(JeusMessage_Session3._31000_LEVEL, JeusMessage_Session3._31000, (Object)buf.toString());
        }
    }

    private static String getNodeNameFromFullEngineName(String fullEngineName) {
        if (fullEngineName == null) {
            return null;
        }
        int index = fullEngineName.indexOf(95);
        if (index < 0) {
            return null;
        }
        return fullEngineName.substring(0, index);
    }

    private static void makeupBackupTable() throws IOException {
        if (!MAKEUP_BACKUP_TABLE.compareAndSet(false, true)) {
            return;
        }
        ArrayList<ManagerInfo> managerInfos = new ArrayList<ManagerInfo>();
        List nodeList = JeusMainDescriptorJB.getJeusMainDescriptor().getNode();
        for (int i = 0; i < nodeList.size(); ++i) {
            JeusNodeType oneNode = (JeusNodeType)nodeList.get(i);
            SessionRouterConfigType sessionRouterConfig = oneNode.getSessionRouterConfig();
            if (sessionRouterConfig == null) continue;
            List sessionRouters = sessionRouterConfig.getSessionRouter();
            for (int j = 0; j < sessionRouters.size(); ++j) {
                String replicationGroup;
                SessionRouterType sessionRouter = (SessionRouterType)sessionRouters.get(j);
                String engine = sessionRouter.getEngineName();
                String machine = sessionRouter.getLocation();
                if (machine == null) {
                    machine = VirtualDNS.getHostName(DistributedSessionManagerDescriptor.getNodeNameFromFullEngineName(engine));
                }
                if ((replicationGroup = sessionRouter.getReplicationGroup()) == null) {
                    replicationGroup = DistributedSessionManagerDescriptor.getNodeNameFromFullEngineName(engine);
                }
                String preferredBackupGroup = sessionRouter.getBackupGroup();
                managerInfos.add(new ManagerInfo(engine, machine, replicationGroup, preferredBackupGroup));
            }
        }
        BACKUP_SELECTOR.makeupBackupTable(managerInfos);
        managerInfos.clear();
        if (logger.isLoggable(JeusMessage_Session3._31000_LEVEL)) {
            logger.log(JeusMessage_Session3._31000_LEVEL, JeusMessage_Session3._31000, (Object)BACKUP_SELECTOR);
        }
    }

    private void fillDefaultDescriptor(String name, boolean enableDefaultFileStorage, long passivationTO) throws JAXBException {
        ObjectFactory objFac = ObjectFactoryHelper.getJeusDDObjectFactory();
        FileDbType fileDb = null;
        if (enableDefaultFileStorage) {
            fileDb = objFac.createFileDbType();
            fileDb.fillDefault();
            if (passivationTO != Integer.MIN_VALUE) {
                fileDb.setPassivationTo(Long.valueOf(passivationTO));
            }
        }
        PoolingType threadPool = objFac.createPoolingType();
        threadPool.fillDefault();
        SessionRouterType sessionRouter = objFac.createSessionRouterType();
        sessionRouter.fillDefault();
        sessionRouter.setFileDb(fileDb);
        sessionRouter.setEngineName(name);
        this.sessionRouterConfig = objFac.createSessionRouterConfigType();
        this.sessionRouterConfig.fillDefault();
        this.sessionRouterConfig.setDefaultFileDb(fileDb);
        this.sessionRouterConfig.setThreadPool(threadPool);
        this.sessionRouterConfig.getSessionRouter().add(sessionRouter);
        if (this.sessionRouterConfig.getCheckLevel() == null) {
            this.setCheckLevel(CheckLevelType.SET);
        } else {
            this.setCheckLevel(this.sessionRouterConfig.getCheckLevel());
        }
        this.setServerName(name, JeusNetPropertyValues.LOCAL_HOSTNAME + ":" + DEFAULT_PORT);
        this.setNetworkScope(null);
        this.setStopWithPassivation(true);
        this.setDefaultConfiguration(true);
    }

    private void setDefaultFileDB(FileDbType fileDB) {
        this.sessionRouterConfig.setDefaultFileDb(fileDB);
    }

    private FileDbType getDefaultFileDB() {
        return this.sessionRouterConfig.getDefaultFileDb();
    }

    private void setCheckLevel(CheckLevelType level) {
        if (level == CheckLevelType.SET) {
            this.setCheckLevelInt(1);
        } else if (level == CheckLevelType.GET) {
            this.setCheckLevelInt(2);
        } else if (level == CheckLevelType.ALL) {
            this.setCheckLevelInt(3);
        } else {
            this.setCheckLevelInt(1);
            level = CheckLevelType.SET;
        }
        this.sessionRouterConfig.setCheckLevel(level);
    }

    private String getCheckLevel() {
        if (this.sessionRouterConfig.getCheckLevel() == null) {
            this.setCheckLevel(CheckLevelType.SET);
            return CheckLevelType.SET.value();
        }
        return this.sessionRouterConfig.getCheckLevel().value();
    }

    private void setDefaultConfiguration(boolean defaultConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
    }
}

