/*
 * Decompiled with CFR 0.152.
 */
package jeus.descriptor.tmonitor;

import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.ObjectName;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import jeus.security.util.LoginUtil;
import jeus.server.ConfigFile;
import jeus.server.NodeControllerStub;
import jeus.util.JeusProperties;
import jeus.util.VirtualDNS;
import jeus.xml.binding.jeusDD.MbeanType;
import jeus.xml.binding.jeusDD.PropertyType;
import jeus.xml.binding.jeusDD.TroubleMonitorType;
import jeus.xml.binding.util.JAXBContextFactory;

public class TroubleMonitorDescriptor {
    public static final String TROUBLE_MONITOR_FILE = JeusProperties.JEUS_CONFIG_HOME + File.separator + "tmonitor.xml";
    private static TroubleMonitorDescriptor instance;
    private Hashtable mbeanList = new Hashtable();
    private ObjectName[] queryPatterns;
    private String node;

    public static TroubleMonitorDescriptor getLocal() {
        if (instance == null) {
            instance = new TroubleMonitorDescriptor();
        }
        return instance;
    }

    private TroubleMonitorDescriptor() {
        this.node = VirtualDNS.LOCAL_VIRTUALNAME;
        this.readLocal();
    }

    public TroubleMonitorDescriptor(String node) {
        this.node = node;
        this.readRemote(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRemote(String node) {
        LoginUtil.loginCodeSubjectWithRuntimeException();
        NodeControllerStub ncStub = new NodeControllerStub();
        try {
            ncStub.connectTo(VirtualDNS.getRealNodeName(node));
            String path = "config://tmonitor.xml";
            ConfigFile config = new ConfigFile(null, path, 0L);
            config = ncStub.getConfigDescriptor(config);
            String xml = config.getContent();
            JAXBContext jc = JAXBContextFactory.getContext("jeus.xml.binding.jeusDD");
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            StreamSource source = new StreamSource(new StringReader(xml));
            TroubleMonitorType tmonitor = (TroubleMonitorType)((JAXBElement)unmarshaller.unmarshal((Source)source)).getValue();
            this.parse(tmonitor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ncStub.disconnect();
            LoginUtil.logoutWithRuntimeException();
        }
    }

    private void readLocal() {
        try {
            JAXBContext jc = JAXBContextFactory.getContext("jeus.xml.binding.jeusDD");
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            TroubleMonitorType tmonitor = (TroubleMonitorType)((JAXBElement)unmarshaller.unmarshal(new File(TROUBLE_MONITOR_FILE))).getValue();
            this.parse(tmonitor);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parse(TroubleMonitorType tmonitor) {
        List mbeans = tmonitor.getMbean();
        for (MbeanType mbean : mbeans) {
            Hashtable<String, String> keyPropertyList = new Hashtable<String, String>();
            keyPropertyList.put("j2eeType", mbean.getJ2EeType());
            if (mbean.isSetJeusType()) {
                keyPropertyList.put("jeusType", mbean.getJeusType());
            }
            List additional = mbean.getProperty();
            for (PropertyType p : additional) {
                if (p.getKey().equals("j2eeType") || p.getKey().equals("jeusType")) continue;
                keyPropertyList.put(p.getKey(), p.getValue());
            }
            Properties constraintList = new Properties();
            List constraints = mbean.getConstraint();
            for (PropertyType c : constraints) {
                constraintList.put(c.getKey(), c.getValue());
            }
            this.mbeanList.put(keyPropertyList, constraintList);
        }
    }

    public Properties _getConstraints(ObjectName objectName) {
        Hashtable<String, String> keyPropertyList = objectName.getKeyPropertyList();
        for (Hashtable props : this.mbeanList.keySet()) {
            Iterator ip = props.keySet().iterator();
            boolean wholeMatch = true;
            while (ip.hasNext()) {
                String key = (String)ip.next();
                String value = (String)props.get(key);
                if (keyPropertyList.get(key) != null && keyPropertyList.get(key).equals(value)) continue;
                wholeMatch = false;
                break;
            }
            if (!wholeMatch) continue;
            return (Properties)this.mbeanList.get(props);
        }
        return new Properties();
    }

    public String _getConstraint(ObjectName objectName, String key) {
        return this._getConstraints(objectName).getProperty(key);
    }

    public ObjectName[] _getAllQueryPatterns() {
        if (this.queryPatterns != null) {
            return this.queryPatterns;
        }
        ArrayList<ObjectName> patterns = new ArrayList<ObjectName>();
        Iterator i = this.mbeanList.keySet().iterator();
        while (i.hasNext()) {
            try {
                Hashtable props = (Hashtable)i.next();
                StringBuffer buf = new StringBuffer();
                boolean jmOccurred = false;
                buf.append("JEUS:");
                for (String key : props.keySet()) {
                    if (key.equals("JeusManager")) {
                        jmOccurred = true;
                    }
                    String value = (String)props.get(key);
                    if (key.equals("j2eeType") && value.equals("JeusManager")) {
                        jmOccurred = true;
                    }
                    buf.append(key).append("=").append(value).append(",");
                }
                if (!jmOccurred) {
                    buf.append("JeusManager").append("=").append(this.node).append(",");
                }
                buf.append("*");
                ObjectName pattern = new ObjectName(buf.toString());
                patterns.add(pattern);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.queryPatterns = patterns.toArray(new ObjectName[patterns.size()]);
        return this.queryPatterns;
    }

    public static Properties getConstraints(ObjectName objectName) {
        return TroubleMonitorDescriptor.getLocal()._getConstraints(objectName);
    }

    public static String getConstraint(ObjectName objectName, String key) {
        return TroubleMonitorDescriptor.getLocal()._getConstraint(objectName, key);
    }

    public static ObjectName[] getAllQueryPatterns() {
        return TroubleMonitorDescriptor.getLocal()._getAllQueryPatterns();
    }
}

