/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb;

import javax.ejb.EJBContext;
import javax.ejb.TimerService;
import javax.persistence.EntityManager;
import jeus.ejb.baseimpl.EJBContextImpl;
import jeus.ejb.baseimpl.EJBUserTransactionImpl;
import jeus.ejb.baseimpl.SessionContextImpl;
import jeus.ejb.container.AbstractContainer;
import jeus.ejb.metadata.BeanInfo;
import jeus.ejb.metadata.SessionBeanInfo;
import jeus.persistence.container.PersistenceUnit;
import jeus.util.properties.JeusEJBProperties;
import jeus.util.properties.JeusNetPropertyValues;

public class EJBServerUtils {
    public static final Object[] null_objects = new Object[0];
    public static final Class[] null_classes = new Class[0];

    public static String getRemoteViewJndiName(BeanInfo beanInfo) {
        String jndiName = beanInfo.getExportName();
        if (jndiName == null && (jndiName = beanInfo.getMappedJndiName()) == null) {
            if (beanInfo instanceof SessionBeanInfo) {
                if (((SessionBeanInfo)beanInfo).hasSingleRemoteBusinessView()) {
                    jndiName = ((SessionBeanInfo)beanInfo).getRemoteBusinessInterfaces()[0].getName();
                } else if (!((SessionBeanInfo)beanInfo).hasRemoteBusinessView() && beanInfo.hasRemoteView()) {
                    jndiName = beanInfo.getEJBHomeClassName();
                }
            } else {
                jndiName = beanInfo.getEJBHomeClassName();
            }
        }
        return jndiName;
    }

    public static String getLocalViewJndiName(BeanInfo beanInfo) {
        String jndiName = beanInfo.getLocalExportName();
        if (jndiName == null) {
            jndiName = beanInfo.getMappedJndiName();
            if (jndiName == null) {
                if (beanInfo instanceof SessionBeanInfo) {
                    if (((SessionBeanInfo)beanInfo).hasSingleLocalBusinessView()) {
                        jndiName = ((SessionBeanInfo)beanInfo).getLocalBusinessInterfaces()[0].getName();
                    } else if (!((SessionBeanInfo)beanInfo).hasLocalBusinessView() && beanInfo.hasLocalView()) {
                        jndiName = beanInfo.getEJBLocalHomeClassName();
                    }
                } else {
                    jndiName = beanInfo.getEJBLocalHomeClassName();
                }
            } else if (beanInfo.hasRemoteView()) {
                jndiName = jndiName + "_Local";
            }
        }
        return jndiName;
    }

    public static EJBContext getCurrentEJBContext() {
        return AbstractContainer.getCurrentEJBContext();
    }

    public static TimerService getCurrentTimerService() {
        EJBContextImpl context = AbstractContainer.getCurrentEJBContext();
        if (context != null) {
            return context.getTimerServiceInternal();
        }
        return null;
    }

    public static EJBUserTransactionImpl getEJBUserTransaction() {
        return EJBUserTransactionImpl.getInstance();
    }

    public static EntityManager getCurrentExtendedPersistenceContext(PersistenceUnit pu) throws IllegalStateException {
        SessionContextImpl sc;
        EJBContextImpl context = AbstractContainer.getCurrentEJBContext();
        if (context != null && context instanceof SessionContextImpl && (sc = (SessionContextImpl)context).isStateful()) {
            return sc.getExtendedPersistenceContext(pu);
        }
        throw new IllegalStateException("Extended Persistence Context is not supported in this context");
    }

    public static String getJndiUrl() {
        return JeusEJBProperties.USE_IP_FOR_DYNAMIC_REF ? JeusNetPropertyValues.LOCAL_HOSTADDRESS : JeusNetPropertyValues.LOCAL_HOSTNAME;
    }
}

