/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.baseimpl;

import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Stack;
import javax.ejb.EJBObject;
import javax.ejb.RemoveException;
import javax.rmi.CORBA.Stub;
import javax.rmi.PortableRemoteObject;
import javax.transaction.Transaction;
import jeus.ejb.baseimpl.EJBLocalObjectBase;
import jeus.ejb.baseimpl.EJBStatefulSessionObjectBase;
import jeus.ejb.baseimpl.EJBStatelessSessionObjectBase;
import jeus.ejb.bean.objectbase.EJBEntityObjectImpl;
import jeus.ejb.bean.objectbase.IIOPObject;
import jeus.ejb.bean.rmi.EJBServerInterceptor;
import jeus.ejb.bean.rmi.JEUSRMIStub;
import jeus.ejb.bean.rmi.JeusRMIInterceptorProvider;
import jeus.ejb.bean.rmi.RMIInterceptorProvider;
import jeus.ejb.bean.rmi.RMIStub;
import jeus.ejb.bean.rmi.StubClusterSupport;
import jeus.ejb.container.AbstractContainer;
import jeus.ejb.container.ActiveResourceManagable;
import jeus.ejb.container.ContainerException;
import jeus.rmi.spec.ClientInterceptor;
import jeus.rmi.spec.ServerInterceptor;
import jeus.rmi.spec.server.RemoteObjectInvocationHandler;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB1;

public abstract class AbstractEJBObject
implements EJBObject,
Serializable,
ActiveResourceManagable,
RMIInterceptorProvider {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.bean.object");
    protected static final Object[] empty_objects = new Object[0];
    public static final int LocalOnly = 0;
    public static final int RemoteOnly = 1;
    public static final int Both = 2;
    public static final int ServiceEndpoint = 3;
    private transient AbstractContainer container;
    protected transient boolean useJeusRmi;
    protected transient long lastAccessTime;
    public transient Object sync = new Object();
    protected transient boolean isRemoved = true;
    protected transient int isInvoking;
    protected transient EJBObject rmiStub;
    public transient EJBObject iiopStub;
    protected transient IIOPObject iiopObj;
    protected transient EJBServerInterceptor rmiServerInterceptor;
    protected transient Transaction tx;
    protected transient boolean isCommitting;
    public transient EJBLocalObjectBase localObjectImpl;
    public static transient ThreadLocal isInContainerMethod = new ThreadLocal();

    protected AbstractEJBObject() {
    }

    public void _setContainer(AbstractContainer container) {
        this.container = container;
    }

    protected void checkState() throws NoSuchObjectException {
        if (this.container.isSuspended()) {
            throw new NoSuchObjectException("suspended object");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EJBObject getRMIStub() throws ContainerException {
        try {
            if (this.rmiStub == null) {
                Object object = this.sync;
                synchronized (object) {
                    if (this.rmiStub == null) {
                        this.rmiStub = (EJBObject)this.container.export((Remote)((Object)this));
                        int clusterType = -1;
                        if (this instanceof EJBStatelessSessionObjectBase) {
                            clusterType = 1;
                        } else if (this instanceof EJBStatefulSessionObjectBase) {
                            clusterType = 2;
                        } else if (this instanceof EJBEntityObjectImpl) {
                            clusterType = 3;
                        } else assert (false) : "should be never reached";
                        if (this.useJeusRmi) {
                            if (this.rmiStub instanceof JEUSRMIStub) {
                                ((JEUSRMIStub)this.rmiStub).setClientInterceptor(this.getClientInterceptor());
                                if (this.container.isClustered) {
                                    ((JEUSRMIStub)this.rmiStub).__setClusterSupport(StubClusterSupport.createStubClusterSupport(clusterType, this.rmiStub));
                                }
                            } else if (this.rmiStub instanceof Proxy) {
                                ((RemoteObjectInvocationHandler)Proxy.getInvocationHandler(this.rmiStub)).setClientInterceptor(this.getClientInterceptor());
                            }
                        } else {
                            ((RMIStub)this.rmiStub).setClientInterceptor(this.getClientInterceptor());
                            if (this.container.isClustered) {
                                ((RMIStub)this.rmiStub).__setClusterSupport(StubClusterSupport.createStubClusterSupport(clusterType, this.rmiStub));
                            }
                        }
                        if (this.container.isClustered) {
                            this.setKey(this.rmiStub);
                            if (logger.isLoggable(JeusMessage_EJB1._1761_LEVEL)) {
                                logger.logp(JeusMessage_EJB1._1761_LEVEL, "EJBObjectImpl", "getRMIStub", JeusMessage_EJB1._1761);
                            }
                        }
                    }
                }
            }
            return this.rmiStub;
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_EJB1._1763_LEVEL)) {
                logger.logp(JeusMessage_EJB1._1763_LEVEL, "EJBObjectImpl", "getRMIStub", JeusMessage_EJB1._1763, ex);
            }
            throw new ContainerException(JeusMessage_EJB1._1763, ex);
        }
    }

    protected abstract void setKey(EJBObject var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EJBObject getIIOPStub() throws ContainerException {
        Thread t = Thread.currentThread();
        ClassLoader prevLoader = t.getContextClassLoader();
        t.setContextClassLoader(this.container.getClassLoader());
        try {
            Object object;
            if (this.iiopStub == null) {
                object = this.sync;
                synchronized (object) {
                    if (this.iiopStub == null) {
                        this.iiopObj.export();
                        this.iiopStub = this.iiopObj.getIIOPStub();
                        if (logger.isLoggable(JeusMessage_EJB1._1767_LEVEL)) {
                            logger.logp(JeusMessage_EJB1._1767_LEVEL, "EJBObjectImpl", "getIIOPStub", JeusMessage_EJB1._1767);
                        }
                    }
                }
            }
            object = this.iiopStub;
            return object;
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_EJB1._1769_LEVEL)) {
                logger.logp(JeusMessage_EJB1._1769_LEVEL, "EJBObjectImpl", "getIIOPStub", JeusMessage_EJB1._1769, ex);
            }
            throw new ContainerException(JeusMessage_EJB1._1769, ex);
        }
        finally {
            t.setContextClassLoader(prevLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unexport() {
        if (this.rmiStub != null) {
            try {
                this.container.unexport((Remote)((Object)this), true);
                if (logger.isLoggable(JeusMessage_EJB1._1772_LEVEL)) {
                    logger.logp(JeusMessage_EJB1._1772_LEVEL, "EJBObjectImpl", "unexport", JeusMessage_EJB1._1772);
                }
            }
            catch (Throwable t) {
                if (logger.isLoggable(JeusMessage_EJB1._1773_LEVEL)) {
                    logger.logp(JeusMessage_EJB1._1773_LEVEL, "EJBObjectImpl", "unexport", JeusMessage_EJB1._1773, t);
                }
            }
            finally {
                this.rmiStub = null;
            }
        }
        Object object = this.sync;
        synchronized (object) {
            if (this.iiopStub != null) {
                try {
                    this.iiopObj.unexport();
                }
                catch (Throwable t) {
                    if (logger.isLoggable(JeusMessage_EJB1._1775_LEVEL)) {
                        logger.logp(JeusMessage_EJB1._1775_LEVEL, "EJBObjectImpl", "unexport", JeusMessage_EJB1._1775, t);
                    }
                }
                finally {
                    this.iiopStub = null;
                }
            }
        }
        this.localObjectImpl = null;
        if (logger.isLoggable(JeusMessage_EJB1._1776_LEVEL)) {
            logger.logp(JeusMessage_EJB1._1776_LEVEL, "EJBObjectImpl", "unexport", JeusMessage_EJB1._1776);
        }
    }

    public void remove() throws RemoveException, RemoteException {
    }

    public final boolean isRemoved() {
        return this.isRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastAccessTime() {
        Object object = this.sync;
        synchronized (object) {
            if (logger.isLoggable(JeusMessage_EJB1._1834_LEVEL)) {
                logger.logp(JeusMessage_EJB1._1834_LEVEL, "EJBObjectImpl", "getLastAccessTime", JeusMessage_EJB1._1834, (Object)new Long(this.lastAccessTime));
            }
            return this.lastAccessTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastAccessTime(long l) {
        Object object = this.sync;
        synchronized (object) {
            this.lastAccessTime = l;
            if (logger.isLoggable(JeusMessage_EJB1._1835_LEVEL)) {
                logger.logp(JeusMessage_EJB1._1835_LEVEL, "EJBObjectImpl", "setLastAccessTime", JeusMessage_EJB1._1835, (Object)new Long(this.lastAccessTime));
            }
        }
    }

    public boolean isInvoking() {
        if (logger.isLoggable(JeusMessage_EJB1._1837_LEVEL)) {
            logger.logp(JeusMessage_EJB1._1837_LEVEL, "EJBObjectImpl", "isInvoking", JeusMessage_EJB1._1837, (Object)new Integer(this.isInvoking));
        }
        return this.isInvoking > 0;
    }

    public void setIsInvoking(boolean b) {
        if (b) {
            if (logger.isLoggable(JeusMessage_EJB1._1838_LEVEL)) {
                logger.logp(JeusMessage_EJB1._1838_LEVEL, "EJBObjectImpl", "setIsInvoking", JeusMessage_EJB1._1838);
            }
            ++this.isInvoking;
        } else {
            if (logger.isLoggable(JeusMessage_EJB1._1839_LEVEL)) {
                logger.logp(JeusMessage_EJB1._1839_LEVEL, "EJBObjectImpl", "setIsInvoking", JeusMessage_EJB1._1839);
            }
            --this.isInvoking;
        }
    }

    public void resetIsInvoking() {
        if (logger.isLoggable(JeusMessage_EJB1._1840_LEVEL)) {
            logger.logp(JeusMessage_EJB1._1840_LEVEL, "EJBObjectImpl", "resetIsInvoking", JeusMessage_EJB1._1840);
        }
        this.isInvoking = 0;
    }

    public Transaction getTransaction() {
        return this.tx;
    }

    public void setTransaction(Transaction tx) {
        this.tx = tx;
    }

    public boolean inTx() {
        boolean result;
        boolean bl = result = this.tx != null;
        if (logger.isLoggable(JeusMessage_EJB1._1844_LEVEL)) {
            logger.logp(JeusMessage_EJB1._1844_LEVEL, "EJBObjectImpl", "inTx", JeusMessage_EJB1._1844, new Object[]{result ? "" : "not ", Thread.currentThread(), this});
        }
        return result;
    }

    public void setCommitting(boolean b) {
        if (logger.isLoggable(JeusMessage_EJB1._1845_LEVEL)) {
            logger.logp(JeusMessage_EJB1._1845_LEVEL, "EJBObjectImpl", "setCommitting", JeusMessage_EJB1._1845, (Object)(b ? "about to commit" : "completed to commit"));
        }
        this.isCommitting = b;
    }

    public boolean isCommitting() {
        if (logger.isLoggable(JeusMessage_EJB1._1846_LEVEL)) {
            logger.logp(JeusMessage_EJB1._1846_LEVEL, "EJBObjectImpl", "isCommitting", JeusMessage_EJB1._1846, (Object)(this.isCommitting ? "" : "not "));
        }
        return this.isCommitting;
    }

    public Object getIdentity() {
        return null;
    }

    public boolean isSame(Object identity) {
        return false;
    }

    public int getHashCode() {
        return 0;
    }

    public static void setInContainerMethod(Object target) {
        Stack<Object> stack;
        Object obj = isInContainerMethod.get();
        if (obj == null) {
            stack = new Stack<Object>();
            isInContainerMethod.set(stack);
        } else {
            stack = (Stack<Object>)obj;
        }
        stack.push(target);
    }

    public static void clearInContainerMethod() {
        Object obj = isInContainerMethod.get();
        if (obj != null) {
            Stack stack = (Stack)obj;
            stack.pop();
            if (stack.size() == 0) {
                isInContainerMethod.set(null);
            }
        }
    }

    public Stub getStubForNonInterop() throws NoSuchObjectException {
        return (Stub)PortableRemoteObject.toStub((Remote)((Object)this));
    }

    public void setIIOPObjectImpl(IIOPObject iiop) {
        this.iiopObj = iiop;
    }

    public ServerInterceptor getServerInterceptor() {
        return this.container.getEjbServerInterceptor();
    }

    public ClientInterceptor getClientInterceptor() {
        return JeusRMIInterceptorProvider.EJB_CLIENT_INTERCEPTOR;
    }
}

