/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.baseimpl;

import java.rmi.RemoteException;
import java.util.logging.Level;
import javax.ejb.EJBException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import jeus.ejb.EJBLoggers;
import jeus.ejb.baseimpl.BusinessObjectHandler;
import jeus.ejb.baseimpl.EJBIfObjectType;
import jeus.ejb.baseimpl.RemoteInvokerHandler;
import jeus.ejb.baseimpl.RemoteInvokerServer;
import jeus.ejb.bean.rmi.StubClusterSupport;
import jeus.ejb.client.BusinessHome;
import jeus.ejb.client.BusinessObjectFactory;
import jeus.ejb.client.RemoteBusinessHomeClientHandler;
import jeus.ejb.container3.SessionContainer;
import jeus.ejb.container3.StatefulSessionContainer;
import jeus.jndi.objectfactory.ObjectRefAddr;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB12;

public class BusinessHomeImpl
implements BusinessHome,
RemoteInvokerHandler {
    protected static JeusLogger logger = EJBLoggers.logger;
    protected boolean remote;
    protected SessionContainer container;
    protected String jndiName;
    protected RemoteInvokerServer remoteInvoker;
    protected RemoteBusinessHomeClientHandler handler;
    protected boolean isExported;

    public BusinessHomeImpl(SessionContainer container, boolean remote, String jndiName) {
        this.container = container;
        this.remote = remote;
        this.jndiName = jndiName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public Object invoke(String interfaze, String signature, Object[] args) throws Exception {
        if (signature.equals(RemoteBusinessHomeClientHandler.createMethodSig)) {
            return this.create((String)args[0]);
        }
        if (signature.equals(RemoteBusinessHomeClientHandler.findByInstanceKeyMethodSig)) {
            return this.findByInstanceKey((String)args[0], (String)args[1]);
        }
        if (signature.equals(RemoteBusinessHomeClientHandler.pingMethodSig)) {
            this.ping();
            return null;
        }
        throw new RuntimeException("Invalid call - there is no such method " + signature);
    }

    public Object create(String interfaze) {
        try {
            BusinessObjectHandler handler = (BusinessObjectHandler)this.container.createObject(EJBIfObjectType.BUSINESSOBJECT, null, null);
            return handler.getClientProxy(interfaze);
        }
        catch (Exception ex) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Exception when creating a new business object", (Throwable)ex);
            }
            if (ex instanceof EJBException) {
                throw (EJBException)ex;
            }
            throw new EJBException(ex.getMessage());
        }
    }

    public Object findByInstanceKey(String interfaze, String sessionID) {
        try {
            BusinessObjectHandler handler = (BusinessObjectHandler)((StatefulSessionContainer)this.container).findByInstanceKey(EJBIfObjectType.BUSINESSOBJECT, sessionID);
            return handler.getClientProxy(interfaze);
        }
        catch (Exception ex) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Exception when finding a business object", (Throwable)ex);
            }
            if (ex instanceof EJBException) {
                throw (EJBException)ex;
            }
            throw new EJBException(ex.getMessage());
        }
    }

    public void ping() {
    }

    public synchronized Object export() throws RemoteException {
        if (this.remoteInvoker == null) {
            this.remoteInvoker = new RemoteInvokerServer(this, this.container.getRemoteInvocationManager(), this.container.getRemoteExporter());
        }
        if (!this.remoteInvoker.isExported()) {
            this.remoteInvoker.export();
            if (logger.isLoggable(JeusMessage_EJB12._9002_LEVEL)) {
                logger.log(JeusMessage_EJB12._9002_LEVEL, JeusMessage_EJB12._9002, (Object)this.toString());
            }
            this.handler = new RemoteBusinessHomeClientHandler(this.remoteInvoker.getStub());
            if (this.container.isClustered()) {
                this.handler.setStubClusterSupport(StubClusterSupport.createStubClusterSupport(0, this.handler), this.container.getBeanInfo().getHomeIdempotentMethods());
            }
        }
        return this.handler;
    }

    public synchronized void unexport() {
        if (this.remoteInvoker != null) {
            this.remoteInvoker.unexport(true);
            if (logger.isLoggable(JeusMessage_EJB12._9003_LEVEL)) {
                logger.log(JeusMessage_EJB12._9003_LEVEL, JeusMessage_EJB12._9003, (Object)this.toString());
            }
        }
    }

    public Reference getReference(String interfaze) throws NamingException, ClassNotFoundException {
        String className = BusinessHome.class.getName();
        String factory = BusinessObjectFactory.class.getName();
        String factoryLocation = null;
        Reference ref = new Reference(className, factory, factoryLocation);
        ref.add(new StringRefAddr("home.jndiname", this.jndiName));
        ref.add(new StringRefAddr("interface", interfaze));
        Class<?> interfaceClass = this.container.getClassLoader().loadClass(interfaze);
        ref.add(new ObjectRefAddr("interface.class", interfaceClass));
        return ref;
    }
}

