/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.baseimpl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.rmi.Remote;

public class BusinessInterfaceInfo {
    protected boolean remote;
    protected Class interfaze;
    protected boolean isRmiRemote;
    protected Class proxyClass;
    protected Constructor constructor;

    public BusinessInterfaceInfo(Class interfaze, boolean remote, Class proxyClass) {
        try {
            this.remote = remote;
            this.interfaze = interfaze;
            this.isRmiRemote = Remote.class.isAssignableFrom(interfaze);
            this.proxyClass = proxyClass;
            this.constructor = proxyClass.getConstructor(InvocationHandler.class);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public boolean isRemote() {
        return this.remote;
    }

    public Class getInterfaze() {
        return this.interfaze;
    }

    public boolean isRmiRemote() {
        return this.isRmiRemote;
    }

    public Object newProxyInstance(InvocationHandler handler) {
        try {
            return this.constructor.newInstance(handler);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BusinessInterfaceInfo that = (BusinessInterfaceInfo)o;
        return this.remote != that.remote && this.interfaze.equals(that.interfaze);
    }

    public int hashCode() {
        int result = this.remote ? 1 : 0;
        result = 29 * result + this.interfaze.hashCode();
        return result;
    }
}

